/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.TreeUtils;
import org.apache.commons.lang3.StringUtils;

public class PermissionUtils {
    public static HasPermOrgResult getAllPermOrgs(IFormView view) {
        return PermissionUtils.getAllPermOrgs(view, "47150e89000000ac");
    }

    public static HasPermOrgResult getAllPermOrgs(String appNumber, String entityid, String perm) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        return PermissionUtils.getAllPermOrgsByUserId(appNumber, entityid, perm, userId);
    }

    public static HasPermOrgResult getAllPermOrgsByUserId(String appNumber, String entityid, String perm, Long userId) {
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        userId = EmptyCheckUtils.isEmpty(userId) ? Long.valueOf(RequestContext.get().getUserId()) : userId;
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        String entityid = view.getEntityId();
        if (view instanceof ListView) {
            entityid = ((ListView)view).getBillFormId();
        }
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityid, (String)perm);
        return hasPermOrgResult;
    }

    public static HasPermOrgResult getAllPermOrgs(IFormView view, String entityId, String perm) {
        String appNumber = view.getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception ex) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
                appid = mainEntityType.getAppId();
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appid, (String)entityId, (String)perm);
        return hasPermOrgResult;
    }

    public static Long getDefaultOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        QFilter filter = new QFilter("id", "=", (Object)orgId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"2");
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(16);
        TreeUtils.convertParam("id", orgId, map);
        TreeUtils.convertParam("status", "1", map);
        DynamicObjectCollection orgCollection = TreeUtils.queryOrgListByCondition(map);
        if (orgCollection != null && orgCollection.size() > 0) {
            return orgId;
        }
        DynamicObjectCollection orgCollection1 = TreeUtils.queryOrgListByCondition(TreeUtils.convertParam("status", "1"));
        if (orgCollection1 != null && orgCollection1.size() > 0) {
            return ((DynamicObject)orgCollection1.get(0)).getLong("id");
        }
        return 0L;
    }
}

