/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.util.BigDecimalUtil;

public class RiskScoreSchemeValidatorUtils {
    private static Log logger = LogFactory.getLog(RiskScoreSchemeValidatorUtils.class);
    private static final String TCTRC_RISK_SCORE_SCHEME = "tctrc_risk_score_scheme";
    private static final String tabLine = "\t\n";

    public static void saveValid(Object o, StringBuilder errorsMsg) {
        RiskScoreSchemeValidatorUtils.checkValid(o, errorsMsg);
    }

    private static void checkValid(Object objects, StringBuilder errorsMsg) {
        String msg;
        Boolean flag = Boolean.TRUE;
        if (objects instanceof DynamicObject) {
            flag = RiskScoreSchemeValidatorUtils.compareDate(objects);
        }
        if (!flag.booleanValue()) {
            msg = String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"RiskScoreSchemeValidatorUtils_1", (String)"taxc-tctrc-common", (Object[])new Object[0]), new Object[0]);
            errorsMsg.append(msg).append(tabLine);
        }
        if (!(flag = RiskScoreSchemeValidatorUtils.compareScore(objects)).booleanValue()) {
            msg = String.format(ResManager.loadKDString((String)"\u201c\u5206\u503c\u95f4\u9694\u201d\u5e94\u5c0f\u4e8e\u201c\u98ce\u9669\u6700\u5927\u5206\u503c\u201d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_14", (String)"taxc-tctrc-common", (Object[])new Object[0]), new Object[0]);
            errorsMsg.append(msg).append(tabLine);
        }
        RiskScoreSchemeValidatorUtils.compareResetDjt(objects, errorsMsg);
        RiskScoreSchemeValidatorUtils.compareJCDjt(objects, errorsMsg);
        RiskScoreSchemeValidatorUtils.compareCrossDate(objects, errorsMsg);
    }

    private static void compareJCDjt(Object objects, StringBuilder errorsMsg) {
        if (objects instanceof DynamicObject) {
            DynamicObjectCollection dynamicCollection = ((DynamicObject)objects).getDynamicObjectCollection("entryentity");
            int i = 1;
            BigDecimal scoreinterval = ((DynamicObject)objects).getBigDecimal("scoreinterval");
            for (DynamicObject o : dynamicCollection) {
                BigDecimal defaultscore = o.getBigDecimal("defaultscore");
                if (scoreinterval != null && scoreinterval.compareTo(BigDecimal.ZERO) != 0) {
                    List<BigDecimal> defaultList = RiskScoreSchemeValidatorUtils.getScoresByLevelId(o, scoreinterval);
                    if (defaultscore != null && !defaultList.contains(defaultscore.setScale(1, 4))) {
                        String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u9ed8\u8ba4\u5f97\u5206\u4e0d\u5728\u5f97\u5206\u4ece\u5230\u5f97\u5206\u6b62\u7684\u5206\u503c\u95f4\u9694\u7cfb\u5217\u4e2d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_13", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                        errorsMsg.append(msg).append(tabLine);
                    }
                }
                ++i;
            }
        }
    }

    private static void compareCrossDate(Object objects, StringBuilder errorsMsg) {
        Date startdate = ((DynamicObject)objects).getDate("effectdate");
        Date enddate = ((DynamicObject)objects).getDate("invaliddate");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter = qFilter.and(new QFilter("id", "!=", (Object)((DynamicObject)objects).getLong("id")));
        QFilter qfilter1 = new QFilter("invaliddate", ">=", (Object)startdate);
        qfilter1 = qfilter1.and(new QFilter("invaliddate", "<=", (Object)enddate));
        QFilter qfilter2 = new QFilter("effectdate", ">=", (Object)startdate);
        qfilter2 = qfilter2.and(new QFilter("invaliddate", "<=", (Object)enddate));
        QFilter qfilter3 = new QFilter("effectdate", "<=", (Object)startdate);
        qfilter3 = qfilter3.and(new QFilter("invaliddate", ">=", (Object)enddate));
        QFilter qfilter4 = new QFilter("effectdate", ">=", (Object)startdate);
        qfilter4 = qfilter4.and(new QFilter("effectdate", "<=", (Object)enddate));
        QFilter q = qfilter1.or(qfilter2).or(qfilter3).or(qfilter4);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCTRC_RISK_SCORE_SCHEME, (String)"id,name", (QFilter[])new QFilter[]{qFilter = qFilter.and(q)});
        if (collection != null && !collection.isEmpty()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\uff0c\u5df2\u6709\u542f\u7528\u72b6\u6001\u7684\u98ce\u9669\u5206\u7ea7\u65b9\u6848\u3002\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_6", (String)"taxc-tctrc-common", (Object[])new Object[0]), new Object[0]);
            errorsMsg.append(msg).append(tabLine);
        }
    }

    private static void compareResetDjt(Object objects, StringBuilder errorsMsg) {
        if (objects instanceof DynamicObject) {
            Boolean flag;
            String msg;
            DynamicObjectCollection dynamicCollection = ((DynamicObject)objects).getDynamicObjectCollection("entryentity");
            int i = 1;
            BigDecimal maxscore = ((DynamicObject)objects).getBigDecimal("maxscore");
            BigDecimal scoreinterval = ((DynamicObject)objects).getBigDecimal("scoreinterval");
            ArrayList<String> djtScoreList = new ArrayList<String>(16);
            ArrayList<String> defaultScoreList = new ArrayList<String>(16);
            ArrayList<Long> riskIdList = new ArrayList<Long>(16);
            for (DynamicObject o : dynamicCollection) {
                String msg2;
                riskIdList.add(o.getLong("risklevel.id"));
                BigDecimal scorestart = o.getBigDecimal("scorestart");
                BigDecimal scoreend = o.getBigDecimal("scoreend");
                BigDecimal defaultscore = o.getBigDecimal("defaultscore");
                if (scorestart != null && scorestart.compareTo(BigDecimal.ZERO) <= 0 || scoreend != null && scoreend.compareTo(BigDecimal.ZERO) <= 0) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u201c\u5f97\u5206\u4ece\u6216\u5f97\u5206\u6b62\u201d\u5e94\u5927\u4e8e0\u3002", (String)"RiskScoreSchemeValidatorUtils_8", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (scorestart == null && scoreend != null || scorestart != null && scoreend == null) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u5f97\u5206\u4ece\u4e0e\u5f97\u5206\u6b62\u5fc5\u987b\u540c\u65f6\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_15", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (scorestart != null && scoreend != null && (scorestart.compareTo(defaultscore) > 0 || defaultscore.compareTo(scoreend) > 0)) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u9ed8\u8ba4\u5f97\u5206\u503c\u5fc5\u987b\u5728\u5f97\u5206\u4ece\u5230\u5f97\u5206\u6b62\u4e4b\u95f4\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_3", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (scorestart != null && scoreend != null && (scorestart.compareTo(maxscore) > 0 || scoreend.compareTo(maxscore) > 0)) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u201c\u5f97\u5206\u5f55\u5165\u201d\u4e0d\u5f97\u5927\u4e8e\u98ce\u9669\u6700\u5927\u5206\u503c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_7", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (defaultscore.compareTo(maxscore) > 0) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u201c\u9ed8\u8ba4\u5f97\u5206\u503c\u201d\u5e94\u2264\u98ce\u9669\u6700\u5927\u5206\u503c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_16", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (scorestart != null && scoreend != null && BigDecimalUtil.subtractObject(scoreend, scorestart).compareTo(scoreinterval) < 0) {
                    msg2 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u5f97\u5206\u8d77\u6b62\u7684\u5f97\u5206\u8303\u56f4\u5e94\u2265\u5206\u503c\u95f4\u9694\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_9", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                    errorsMsg.append(msg2).append(tabLine);
                }
                if (scorestart != null && scoreend != null) {
                    djtScoreList.add(scorestart.toString() + "-" + scoreend.toString());
                }
                if (defaultscore != null) {
                    defaultScoreList.add(defaultscore.toString());
                }
                ++i;
            }
            List distList = riskIdList.stream().distinct().collect(Collectors.toList());
            List distDefaultScoreList = defaultScoreList.stream().distinct().collect(Collectors.toList());
            if (riskIdList.size() > distList.size()) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u5185\u540c\u4e00\u4e2a\u98ce\u9669\u7b49\u7ea7\u4e0d\u80fd\u91cd\u590d\u5f55\u5165\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_10", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                errorsMsg.append(msg).append(tabLine);
            }
            if (djtScoreList.size() > 0 && (flag = Boolean.valueOf(RiskScoreSchemeValidatorUtils.checkOverlap(djtScoreList))).booleanValue()) {
                String msg3 = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e4b\u95f4\u5f97\u5206\u8d77\u6b62\u4e0d\u80fd\u5b58\u5728\u4ea4\u53c9\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_11", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                errorsMsg.append(msg3).append(tabLine);
            }
            if (defaultScoreList.size() > distDefaultScoreList.size()) {
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u4e4b\u95f4\u9ed8\u8ba4\u5f97\u5206\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"RiskScoreSchemeValidatorUtils_12", (String)"taxc-tctrc-common", (Object[])new Object[0]), i);
                errorsMsg.append(msg).append(tabLine);
            }
        }
    }

    private static Boolean compareScore(Object objects) {
        String maxscore = ((DynamicObject)objects).getString("maxscore");
        BigDecimal scoreinterval = ((DynamicObject)objects).getBigDecimal("scoreinterval");
        if (scoreinterval.compareTo(new BigDecimal(maxscore)) >= 0) {
            return false;
        }
        return true;
    }

    private static Boolean compareDate(Object objects) {
        Date startdate = ((DynamicObject)objects).getDate("effectdate");
        Date enddate = ((DynamicObject)objects).getDate("invaliddate");
        if (enddate != null && startdate != null && startdate.compareTo(enddate) >= 0) {
            return false;
        }
        return true;
    }

    public static boolean checkOverlap(List<String> list) {
        Collections.sort(list);
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                String[] itime = list.get(i).split("-");
                for (int j = 0; j < list.size(); ++j) {
                    String[] jtime;
                    int compare;
                    if (j == i || j > i || (compare = new BigDecimal(itime[0]).compareTo(new BigDecimal((jtime = list.get(j).split("-"))[1]))) > 0) continue;
                    flag = true;
                    break;
                }
            }
            if (flag) break;
        }
        return flag;
    }

    public static List<BigDecimal> getScoresByLevelId(DynamicObject object, BigDecimal scoreinterval) {
        ArrayList<BigDecimal> scoreList = new ArrayList<BigDecimal>();
        if (object != null) {
            BigDecimal scorestart = object.getBigDecimal("scorestart");
            BigDecimal scoreend = object.getBigDecimal("scoreend");
            BigDecimal defaultscore = object.getBigDecimal("defaultscore");
            if (scorestart == null || scoreend == null) {
                scoreList.add(defaultscore.setScale(1, 4));
                return scoreList;
            }
            BigDecimal score = scorestart;
            while (score.compareTo(scoreend) <= 0) {
                scoreList.add(score.setScale(1, 4));
                score = score.add(scoreinterval);
            }
        }
        return scoreList;
    }
}

