/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoCollBean;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.StringUtil;

public class RiskScoreViewUtils {
    private static final String RISK_SCORE_SCHEME = "tctrc_risk_score_scheme";
    private static final String RISK_ANALYSIS_SCHEME = "tctrc_analysis_scheme";
    private static final String LEVEL_NO = "5";
    private static final String LEVEL_HIGHT = "1";
    private static final String LEVEL_MID = "2";
    private static final String LEVEL_LOW = "3";
    private static final int RISKLEVELCOUNT = 10;

    public static Map<Long, BigDecimal> getAnalysisSchemePercent(Date enddate) {
        QFilter enableFilter;
        Date date = DateUtils.getDayFirst(enddate);
        HashMap<Long, BigDecimal> percentmap = new HashMap<Long, BigDecimal>();
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)date).and(new QFilter("enddate", ">=", (Object)date));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)RISK_ANALYSIS_SCHEME, (String)"id,entryentity.riskdefinition,entryentity.percent", (QFilter[])new QFilter[]{dateFilter, enableFilter = new QFilter("enable", "=", (Object)LEVEL_HIGHT)});
        if (colls != null && colls.size() > 0) {
            for (DynamicObject col : colls) {
                percentmap.put(col.getLong("entryentity.riskdefinition"), col.getBigDecimal("entryentity.percent"));
            }
        }
        return percentmap;
    }

    public static String getCurrentMaxScore(Date enddate) {
        Date date = DateUtils.getDayFirst(enddate);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date).and(new QFilter("invaliddate", ">=", (Object)date));
        QFilter enableFilter = new QFilter("enable", "=", (Object)LEVEL_HIGHT);
        DynamicObject object = QueryServiceHelper.queryOne((String)RISK_SCORE_SCHEME, (String)"id,maxscore", (QFilter[])new QFilter[]{dateFilter, enableFilter});
        if (object == null) {
            return null;
        }
        return object.getString("maxscore");
    }

    public static List<RiskScoreInfoBean> getRiskScoreInfoList(DynamicObjectCollection collection, Map<Long, List<DynamicObject>> taxinfos, Map<Long, BigDecimal> percentMap) {
        ArrayList<RiskScoreInfoBean> infoBeans = new ArrayList<RiskScoreInfoBean>(collection.size());
        for (DynamicObject coll : collection) {
            RiskScoreInfoBean info = new RiskScoreInfoBean();
            Long orgid = coll.getLong("runorg");
            Long id = coll.getLong("id");
            Long riskid = coll.getLong("risk");
            String riskscore = coll.getString("riskscore");
            String area = "";
            String industry = "";
            if (taxinfos.containsKey(orgid)) {
                List<DynamicObject> taxinfo = taxinfos.get(orgid);
                for (int i = 0; i < taxinfo.size(); ++i) {
                    DynamicObject taxobj = taxinfo.get(i);
                    if (i == 0) {
                        industry = taxobj.getString("codeandname");
                    }
                    if (taxobj.get("number") == null || !"regulated_areas".equalsIgnoreCase(taxobj.getString("number"))) continue;
                    area = taxobj.getString("name");
                }
            }
            BigDecimal percent = BigDecimal.ZERO;
            if (percentMap.containsKey(riskid)) {
                percent = percentMap.get(riskid);
            }
            BigDecimal totalScore = BigDecimal.ZERO;
            if (StringUtil.isNotBlank((CharSequence)riskscore)) {
                BigDecimal scorevalue = new BigDecimal(riskscore);
                totalScore = percent.multiply(scorevalue).setScale(2, 4);
            }
            info.setOrg(orgid);
            info.setRiskId(id);
            info.setRisklevel(coll.getString("rlevel"));
            info.setArea(area);
            info.setIndustry(industry);
            info.setRiskscore(riskscore);
            info.setPercent(percent);
            info.setTotalscore(totalScore);
            info.setStartdate(coll.getDate("startdate"));
            info.setEnddate(coll.getDate("enddate"));
            infoBeans.add(info);
        }
        return infoBeans;
    }

    public static RiskScoreResultInfoBean createNewBean(List<RiskScoreInfoBean> beanList, String maxscore, List<Long> rlevelIds) {
        RiskScoreInfoBean info = beanList.get(0);
        String[] riskLevelIds = new String[10];
        int[] riskLevelTotal = new int[10];
        int risktotal = beanList.size();
        String totalids = "";
        List totallist = beanList.stream().map(e -> e.getRiskId().toString()).collect(Collectors.toList());
        if (totallist.size() > 0) {
            totalids = String.join((CharSequence)",", totallist);
        }
        Map<String, List<RiskScoreInfoBean>> datalist = beanList.stream().collect(Collectors.groupingBy(s -> s.getRisklevel()));
        Integer sumcount = 10;
        if (rlevelIds.size() < 10) {
            sumcount = rlevelIds.size();
        }
        for (int i = 0; i < sumcount; ++i) {
            String id = String.valueOf(rlevelIds.get(i));
            if (!datalist.containsKey(id)) continue;
            riskLevelTotal[i] = datalist.get(id).size();
            List risklevetotal = datalist.get(id).stream().map(e -> e.getRiskId().toString()).collect(Collectors.toList());
            if (risklevetotal.size() <= 0) continue;
            riskLevelIds[i] = String.join((CharSequence)",", risklevetotal);
        }
        BigDecimal score = BigDecimal.ZERO;
        BigDecimal maxvalue = new BigDecimal(maxscore);
        for (RiskScoreInfoBean obj : beanList) {
            score = score.add(obj.getTotalscore());
        }
        score = score.divide(maxvalue, 2, 4);
        return new RiskScoreResultInfoBean(info.getArea(), info.getIndustry(), score.toString(), risktotal, riskLevelTotal != null ? riskLevelTotal[0] : 0, riskLevelTotal != null ? riskLevelTotal[1] : 0, riskLevelTotal != null ? riskLevelTotal[2] : 0, riskLevelTotal != null ? riskLevelTotal[3] : 0, riskLevelTotal != null ? riskLevelTotal[4] : 0, riskLevelTotal != null ? riskLevelTotal[5] : 0, riskLevelTotal != null ? riskLevelTotal[6] : 0, riskLevelTotal != null ? riskLevelTotal[7] : 0, riskLevelTotal != null ? riskLevelTotal[8] : 0, riskLevelTotal != null ? riskLevelTotal[9] : 0, totalids, riskLevelIds != null && riskLevelIds[0] != null ? riskLevelIds[0] : "", riskLevelIds != null && riskLevelIds[1] != null ? riskLevelIds[1] : "", riskLevelIds != null && riskLevelIds[2] != null ? riskLevelIds[2] : "", riskLevelIds != null && riskLevelIds[3] != null ? riskLevelIds[3] : "", riskLevelIds != null && riskLevelIds[4] != null ? riskLevelIds[4] : "", riskLevelIds != null && riskLevelIds[5] != null ? riskLevelIds[5] : "", riskLevelIds != null && riskLevelIds[6] != null ? riskLevelIds[6] : "", riskLevelIds != null && riskLevelIds[7] != null ? riskLevelIds[7] : "", riskLevelIds != null && riskLevelIds[8] != null ? riskLevelIds[8] : "", riskLevelIds != null && riskLevelIds[9] != null ? riskLevelIds[9] : "", info.getOrg());
    }

    public static void setRiskScoreResultInfoBeanList(Map<String, List<RiskScoreInfoBean>> groupByAreaList, List<RiskScoreResultInfoCollBean> riskScoreResultInfoCollBeanList, String maxscore, List<Long> rlevelIds) {
        for (Map.Entry<String, List<RiskScoreInfoBean>> entry : groupByAreaList.entrySet()) {
            List<RiskScoreInfoBean> beanList = entry.getValue();
            RiskScoreResultInfoCollBean bean = RiskScoreViewUtils.createNewCollBean(beanList, maxscore, rlevelIds);
            riskScoreResultInfoCollBeanList.add(bean);
        }
    }

    public static RiskScoreResultInfoCollBean createNewCollBean(List<RiskScoreInfoBean> beanList, String maxscore, List<Long> rlevelIds) {
        RiskScoreInfoBean info = beanList.get(0);
        String[] riskLevelIds = new String[10];
        int[] riskLevelTotal = new int[10];
        int risktotal = beanList.size();
        String totalids = "";
        List totallist = beanList.stream().map(e -> e.getRiskId().toString()).collect(Collectors.toList());
        if (totallist.size() > 0) {
            totalids = String.join((CharSequence)",", totallist);
        }
        Map<String, List<RiskScoreInfoBean>> datalist = beanList.stream().collect(Collectors.groupingBy(s -> s.getRisklevel()));
        Integer sumcount = 10;
        if (rlevelIds.size() < 10) {
            sumcount = rlevelIds.size();
        }
        for (int i = 0; i < sumcount; ++i) {
            String id = String.valueOf(rlevelIds.get(i));
            if (!datalist.containsKey(id)) continue;
            riskLevelTotal[i] = datalist.get(id).size();
            List risklevetotal = datalist.get(id).stream().map(e -> e.getRiskId().toString()).collect(Collectors.toList());
            if (risklevetotal.size() <= 0) continue;
            riskLevelIds[i] = String.join((CharSequence)",", risklevetotal);
        }
        BigDecimal score = BigDecimal.ZERO;
        BigDecimal maxvalue = new BigDecimal(maxscore);
        for (RiskScoreInfoBean obj : beanList) {
            score = score.add(obj.getTotalscore());
        }
        score = score.divide(maxvalue, 2, 4);
        Map<Long, List<RiskScoreInfoBean>> groupByOrgList = beanList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
        BigDecimal newScore = score.divide(BigDecimal.valueOf(groupByOrgList.size()), 2, 4);
        return new RiskScoreResultInfoCollBean(info.getArea(), info.getIndustry(), newScore.toString(), risktotal, riskLevelTotal != null ? riskLevelTotal[0] : 0, riskLevelTotal != null ? riskLevelTotal[1] : 0, riskLevelTotal != null ? riskLevelTotal[2] : 0, riskLevelTotal != null ? riskLevelTotal[3] : 0, riskLevelTotal != null ? riskLevelTotal[4] : 0, riskLevelTotal != null ? riskLevelTotal[5] : 0, riskLevelTotal != null ? riskLevelTotal[6] : 0, riskLevelTotal != null ? riskLevelTotal[7] : 0, riskLevelTotal != null ? riskLevelTotal[8] : 0, riskLevelTotal != null ? riskLevelTotal[9] : 0, totalids, riskLevelIds != null && riskLevelIds[0] != null ? riskLevelIds[0] : "", riskLevelIds != null && riskLevelIds[1] != null ? riskLevelIds[1] : "", riskLevelIds != null && riskLevelIds[2] != null ? riskLevelIds[2] : "", riskLevelIds != null && riskLevelIds[3] != null ? riskLevelIds[3] : "", riskLevelIds != null && riskLevelIds[4] != null ? riskLevelIds[4] : "", riskLevelIds != null && riskLevelIds[5] != null ? riskLevelIds[5] : "", riskLevelIds != null && riskLevelIds[6] != null ? riskLevelIds[6] : "", riskLevelIds != null && riskLevelIds[7] != null ? riskLevelIds[7] : "", riskLevelIds != null && riskLevelIds[8] != null ? riskLevelIds[8] : "", riskLevelIds != null && riskLevelIds[9] != null ? riskLevelIds[9] : "", new ArrayList<Long>(groupByOrgList.keySet()));
    }

    public static DynamicObjectCollection getRiskLevelList(String isneed) {
        QFilter[] qFilterArray;
        QFilter enableFilter = new QFilter("enable", "=", (Object)LEVEL_HIGHT);
        QFilter nameFilter = new QFilter("id", "!=", (Object)4);
        if (Boolean.TRUE.toString().equals(isneed)) {
            QFilter[] qFilterArray2 = new QFilter[2];
            qFilterArray2[0] = enableFilter;
            qFilterArray = qFilterArray2;
            qFilterArray2[1] = nameFilter;
        } else {
            QFilter[] qFilterArray3 = new QFilter[1];
            qFilterArray = qFilterArray3;
            qFilterArray3[0] = nameFilter;
        }
        return QueryServiceHelper.query((String)"tctrc_risk_level", (String)"id,name,number", (QFilter[])qFilterArray, (String)"number asc");
    }
}

