/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.taxc.tctrc.common.entity.EntityField;

public class TemplateUtils {
    public static final Pattern FIELDNAME_Pattern = Pattern.compile("[\\[\\]()\uff08\uff09\"\u201c\u201d/]");
    public static final String DECIMAL_INIT_FORMAT = "#####0";

    public static String getDecimalFormatByMetadataScale(EntityField fieldType, String initFormat, String defaultDecimalFormat) {
        if (null != fieldType) {
            StringBuilder format = new StringBuilder(initFormat);
            int scale = fieldType.getScale();
            for (int i = 0; i < scale; ++i) {
                if (i == 0) {
                    format.append('.');
                }
                format.append('0');
            }
            return format.toString();
        }
        return defaultDecimalFormat;
    }

    public static String getFieldName(String fieldName) {
        if (fieldName == null) {
            return fieldName;
        }
        Matcher matcher = FIELDNAME_Pattern.matcher(fieldName);
        return matcher.replaceAll("").trim();
    }

    public static String formatMicrometer(String text) {
        DecimalFormat df = null;
        df = text.indexOf(46) > 0 ? (text.length() - text.indexOf(46) - 1 == 0 ? new DecimalFormat("###,##0.") : (text.length() - text.indexOf(46) - 1 == 1 ? new DecimalFormat("###,##0.0") : (text.length() - text.indexOf(46) - 1 == 4 ? new DecimalFormat("###,##0.0000") : new DecimalFormat("###,##0.00")))) : new DecimalFormat("###,##0");
        double number = 0.0;
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }
}

