/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util.biz;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.oversea.MessageSceneType;
import kd.taxc.tctrc.common.entity.EleUpdateBean;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.StringUtil;

public class EleAutoUpdateUtil {
    private static final DeclareMQEvent[] NEED_AUTO_EVENTS = new DeclareMQEvent[]{DeclareMQEvent.AUDIT, DeclareMQEvent.DELETE, DeclareMQEvent.IMPORT};
    private static final String TCRET_CCXWS_ZB_HB = "tcret_ccxws_zb_hb";
    private static final String SELECTED_FIELDS = "startdate,enddate";
    private static final String CONDITION_FIELDS = "sbbid";
    public static final String SPLIT = "#";
    private static final List<String> SCENE_LIST = Arrays.asList(MessageSceneType.OVERSEADRAFT.name(), MessageSceneType.ACCRUALDRAFT.name(), MessageSceneType.PROVISTONCOMPARE.name());

    public static String transformStartDate(String startDate) {
        return DateUtils.format(DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(startDate)));
    }

    public static String transformEndDate(String endDate) {
        return DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.stringToDate(endDate)));
    }

    public static boolean checkHandleMessage(String event, String topic) {
        return StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.DECLARE.name()) && Arrays.stream(NEED_AUTO_EVENTS).anyMatch(v -> StringUtil.equals((CharSequence)v.name(), (CharSequence)event)) || StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.PAY.name());
    }

    public static HashSet<String> mergePeriods(EleUpdateBean v) {
        QFilter sbbidFilter = new QFilter(CONDITION_FIELDS, "=", (Object)v.getMaindataid());
        HashSet resultSet = Sets.newHashSet();
        DynamicObjectCollection tcretCcxwszbHb = QueryServiceHelper.query((String)TCRET_CCXWS_ZB_HB, (String)SELECTED_FIELDS, (QFilter[])new QFilter[]{sbbidFilter});
        if (EmptyCheckUtils.isNotEmpty(tcretCcxwszbHb)) {
            tcretCcxwszbHb.stream().filter(o -> o.get("startdate") != null && o.get("enddate") != null).forEach(p -> {
                String enddate;
                String startdate = DateUtils.format(p.getDate("startdate"));
                if (StringUtil.equals((CharSequence)startdate, (CharSequence)(enddate = DateUtils.format(p.getDate("enddate"))))) {
                    startdate = EleAutoUpdateUtil.transformStartDate(startdate);
                    enddate = EleAutoUpdateUtil.transformEndDate(enddate);
                }
                resultSet.add(startdate + SPLIT + enddate);
            });
        }
        return resultSet;
    }

    public static boolean checkHandleMessageOverSea(String event, String topic) {
        return SCENE_LIST.contains(topic) && Arrays.stream(NEED_AUTO_EVENTS).anyMatch(v -> StringUtil.equalsIgnoreCase((CharSequence)v.name(), (CharSequence)event));
    }
}

