/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.common.util.biz;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.OrgCheckUtil;

public class TctrcRiskCalUtil {
    private static final String ENTITY_RUN_RESULT = "tctrc_risk_run_result";

    public static final void riskReCal(List<Long> resultids, IFormView view) {
        QFilter qFilter = new QFilter("id", "in", resultids);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit,runorg,startdate,enddate,lastupdateby,runtime,risklevel,rlevel,riskdesc,result,isdenominatorzero,isemptyfield,dealresult,json", (QFilter[])new QFilter[]{qFilter});
        if (null == collection || collection.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u91cd\u65b0\u8ba1\u7b97\u7684\u64cd\u4f5c\u3002", (String)"TctrcRiskCalUtil_0", (String)"taxc-tctrc-common", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> checkedOrgs = new ArrayList<String>(10);
        for (DynamicObject dynamicObject : collection) {
            String enable;
            DynamicObject risk;
            if ("1".equalsIgnoreCase(dynamicObject.getString("status"))) continue;
            String orgid = dynamicObject.getString("runorg.id");
            if (checkedOrgs.contains(orgid)) {
                risk = dynamicObject.getDynamicObject("risk");
                enable = risk.getString("enable");
                if (!enable.equalsIgnoreCase(BooleanEnum.YES.getCode())) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"TctrcRiskCalUtil_1", (String)"taxc-tctrc-common", (Object[])new Object[0]));
                    return;
                }
                TctrcRiskCalUtil.doRiskReCal(orgid, dynamicObject);
                continue;
            }
            checkedOrgs.add(orgid);
            if (OrgCheckUtil.checkById(view, collection[0].getString("runorg.id"), "tctrc", ENTITY_RUN_RESULT)) {
                return;
            }
            risk = dynamicObject.getDynamicObject("risk");
            enable = risk.getString("enable");
            if (!enable.equalsIgnoreCase(BooleanEnum.YES.getCode())) {
                view.showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"TctrcRiskCalUtil_1", (String)"taxc-tctrc-common", (Object[])new Object[0]));
                return;
            }
            TctrcRiskCalUtil.doRiskReCal(orgid, dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])collection);
    }

    private static void doRiskReCal(String orgid, DynamicObject resultObj) {
        long resultId = resultObj.getLong("id");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        Map<String, Object> olderResultMap = TctrcRiskCalUtil.getOlderResultMap(dynamicObject);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctrc_handle_entity");
        DynamicObject riskHandleDynmicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        riskHandleDynmicObject.set("result", (Object)4);
        riskHandleDynmicObject.set("riskresult", olderResultMap.get("json"));
        riskHandleDynmicObject.set("type", (Object)"rgcl");
        riskHandleDynmicObject.set("time", (Object)new Date());
        riskHandleDynmicObject.set("handler", (Object)RequestContext.get().getUserId());
        riskHandleDynmicObject.set("resultid", (Object)resultId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskHandleDynmicObject});
        DynamicObject risk = resultObj.getDynamicObject("risk");
        String risknumber = risk.getString("number");
        String risktype = risk.getString("risktype");
        String startdate = resultObj.getString("startdate");
        String enddate = resultObj.getString("enddate");
        Map<String, String> map = RiskCalSerivce.calRisk(String.valueOf(resultId), ElementSqlService.queryAllEnableEleInfoMap(), risktype, orgid, risknumber, startdate, startdate, enddate);
        resultObj.set("json", (Object)map.get("json"));
        resultObj.set("lastupdateby", (Object)RequestContext.get().getUserId());
        resultObj.set("runtime", (Object)new Date());
        resultObj.set("rlevel", (Object)map.get("risklevel"));
        resultObj.set("riskdesc", (Object)map.get("riskdesc"));
        resultObj.set("result", (Object)map.get("result"));
        if ("true".equals(map.get("isDenominatorZero"))) {
            resultObj.set("isdenominatorzero", (Object)Boolean.TRUE);
            resultObj.set("rlevel", (Object)"4");
            resultObj.set("riskdesc", (Object)"");
        } else {
            resultObj.set("isdenominatorzero", (Object)Boolean.FALSE);
        }
        if ("true".equals(map.get("isEmptyField"))) {
            resultObj.set("isemptyfield", (Object)Boolean.TRUE);
            resultObj.set("rlevel", (Object)"4");
            resultObj.set("riskdesc", (Object)"");
        } else {
            resultObj.set("isemptyfield", (Object)Boolean.FALSE);
        }
        List<String> filterFieldValueList = ListUtils.stringToList(map.get("filterFieldValueList"));
        if (filterFieldValueList != null) {
            for (String filterFieldValue : filterFieldValueList) {
                if (!StringUtils.isEmpty((CharSequence)filterFieldValue)) continue;
                resultObj.set("isemptyfield", (Object)Boolean.TRUE);
                break;
            }
        }
        if (!DealStatusEnum.CHANING.getCode().equalsIgnoreCase(resultObj.getString("status"))) {
            resultObj.set("status", (Object)DealStatusEnum.TO_DO.getCode());
        }
        resultObj.set("dealresult", (Object)"1");
    }

    private static Map<String, Object> getOlderResultMap(DynamicObject dynamicObject) {
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        DynamicObject risk = dynamicObject.getDynamicObject("risk");
        if (null != risk) {
            String riskType = risk.getString("risktype");
            if ("1".equals(riskType)) {
                BigDecimal bmValue = BigDecimalUtil.toBigDecimal(risk.getBigDecimal("bmvalue"));
                String resultshow = dynamicObject.getDynamicObject("risk").getString("resultshow");
                if ("2".equals(resultshow)) {
                    bmValue = BigDecimalUtil.divideObject(bmValue, 100, 2);
                }
                BigDecimal riskResult = BigDecimalUtil.toBigDecimal(dynamicObject.getString("result"));
                int numResult = riskResult.compareTo(bmValue);
                customMap.put("numriskresulttype", String.valueOf(numResult));
                customMap.put("json", dynamicObject.getString("result"));
            } else {
                customMap.put("json", dynamicObject.getString("json"));
            }
            customMap.put("runorg", dynamicObject.getLong("runorg.id"));
        }
        return customMap;
    }
}

