/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.risk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tctrc.business.element.ElementResultBusiness;
import kd.taxc.tctrc.business.resultrecords.ResultRecordsBusiness;
import kd.taxc.tctrc.business.riskcontrol.RiskControlBusiness;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.business.templatetype.TemplateTypeBusiness;
import kd.taxc.tctrc.common.entity.FilterElement;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.mservice.api.risk.RiskService;
import kd.taxc.tctrc.mservice.common.CommonService;
import org.apache.commons.collections4.MapUtils;

public class RiskServiceImpl
implements RiskService {
    public Map<String, Object> getRiskMetricsResult(String templateTypeNumber, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId) {
        DynamicObject[] riskResults = RiskResultBusiness.getDeclareDraftOrReportRelationRiskResult((String)templateTypeNumber, (String)skssqq, (String)skssqz, (Long)orgId, (String)draftPurpose, (Long)taxTypeId);
        ArrayList maps = new ArrayList(riskResults.length);
        if (riskResults.length == 0) {
            return CommonService.createReturnResultObject(maps);
        }
        Map<Long, DynamicObject> verifyRiskMap = Arrays.stream(riskResults).filter(p -> RiskTypeEnum.VERIFY.getKey().equals(p.getString("risk.risktype"))).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        DynamicObjectCollection resultRecords = ResultRecordsBusiness.getResultRecordsJsonTagByResultId(verifyRiskMap.keySet());
        Map<Long, List<DynamicObject>> resultIdRecordsMap = resultRecords.stream().collect(Collectors.groupingBy(k -> k.getLong("resultid")));
        Map<Long, List<FilterElement>> resultIdElementMap = resultIdRecordsMap.entrySet().stream().collect(Collectors.toMap(k -> (Long)k.getKey(), v -> ((List)v.getValue()).stream().flatMap(p -> SerializationUtils.fromJsonStringToList((String)p.getString("json_tag"), FilterElement.class).stream()).collect(Collectors.toList())));
        DynamicObjectCollection elementResults = new DynamicObjectCollection();
        if (MapUtils.isNotEmpty(verifyRiskMap)) {
            QFilter queryVerifyRiskResultElementResultFilter = this.getQueryVerifyRiskResultElementResultFilter(verifyRiskMap, resultIdElementMap);
            elementResults = ElementResultBusiness.queryDataCompareRiskElementResult((QFilter[])new QFilter[]{new QFilter("usetype", "=", (Object)"0"), queryVerifyRiskResultElementResultFilter}, (String)"id,element,elementdef,name,value,isemptyfield,isdenominatorzero,startdata,enddata,org");
        }
        for (DynamicObject riskResult : riskResults) {
            HashMap<String, String> mapResult = new HashMap<String, String>(10);
            mapResult.put("id", riskResult.getString("id"));
            mapResult.put("title", String.format(ResManager.loadKDString((String)"%s\u5f02\u5e38", (String)"RiskServiceImpl_0", (String)"taxc-tctrc-mservice", (Object[])new Object[0]), riskResult.getString("risk.name")));
            mapResult.put("tip", riskResult.getString("riskdesc"));
            mapResult.put("metricsType", riskResult.getString("risk.risktype"));
            mapResult.put("indexValue", riskResult.getString("result"));
            if (riskResult.getString("risk.risktype").equals(RiskTypeEnum.NUMBER.getKey())) {
                mapResult.put("targetValue", RiskResultBusiness.getRiskResultTargetValue((DynamicObject)riskResult).toString());
            }
            if (!RiskTypeEnum.VERIFY.getKey().equals(riskResult.getString("risk.risktype"))) {
                maps.add(mapResult);
                continue;
            }
            List<FilterElement> filterElements = resultIdElementMap.get(riskResult.getLong("id"));
            List<Map<String, String>> verifyRiskInvolvingData = this.getVerifyRiskInvolvingData(riskResult, filterElements, elementResults);
            mapResult.put("involvingData", SerializationUtils.toJsonString(verifyRiskInvolvingData));
            maps.add(mapResult);
        }
        Map<String, Object> result = CommonService.createReturnResultObject(maps);
        return result;
    }

    public Map<String, Object> getRiskControlResult(String templateTypeNumber, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId, String operateType) {
        String templateTypeId = TemplateTypeBusiness.queryTemplateTypeIdByNumber((String)templateTypeNumber);
        DynamicObject riskControl = RiskControlBusiness.getDeclareReportMatchRiskControl((String)templateTypeId, (Long)orgId, (String)draftPurpose, (Long)taxTypeId, (String)operateType, (String)"filterjson_tag");
        HashMap<String, String> data = new HashMap<String, String>(2);
        if (riskControl == null) {
            data.put("verifyResult", "1");
            return CommonService.createReturnResultObject(data);
        }
        DynamicObjectCollection riskResults = RiskResultBusiness.getDeclareReportRiskResultWithRiskControl((String)riskControl.getString("filterjson_tag"), (String)templateTypeId, (String)skssqq, (String)skssqz, (Long)orgId, (String)draftPurpose, (Long)taxTypeId, (String)"risk.name");
        if (CollectionUtils.isEmpty((Collection)riskResults)) {
            data.put("verifyResult", "1");
            return CommonService.createReturnResultObject(data);
        }
        data.put("verifyResult", "0");
        List riskNames = riskResults.stream().map(p -> p.getString("risk.name")).collect(Collectors.toList());
        if ("submit".equals(operateType)) {
            data.put("tipMsg", String.format(ResManager.loadKDString((String)"\u98ce\u9669\u6307\u6807\u201c%1$s\u201d\u5f02\u5e38\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u98ce\u9669\u7ed3\u679c\u5904\u7406\u3002", (String)"RiskServiceImpl_1", (String)"taxc-tctrc-mservice", (Object[])new Object[0]), String.join((CharSequence)"\u3001", riskNames)));
        } else {
            data.put("tipMsg", String.format(ResManager.loadKDString((String)"\u98ce\u9669\u6307\u6807\u201c%1$s\u201d\u5f02\u5e38\uff0c\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u98ce\u9669\u7ed3\u679c\u5904\u7406\u3002", (String)"RiskServiceImpl_2", (String)"taxc-tctrc-mservice", (Object[])new Object[0]), String.join((CharSequence)"\u3001", riskNames)));
        }
        return CommonService.createReturnResultObject(data);
    }

    public Map<String, Object> getRiskControlResults(List<Map<String, Object>> parameters) {
        HashMap<String, String> mapData;
        List templateTypeNumbers = parameters.stream().map(p -> p.get("templateTypeNumber").toString()).collect(Collectors.toList());
        Map sbbNumberIdMap = TemplateTypeBusiness.queryTemplateTypeNumberIdMapByNumber(templateTypeNumbers);
        DynamicObjectCollection riskControls = RiskControlBusiness.getDeclareReportMatchRiskControl((Map)sbbNumberIdMap, parameters, (String)"sbbtype.fbasedataid.id,draftpurpose,taxtype.fbasedataid.id,entryentity.org.id,isallorg,filterjson_tag");
        ArrayList data = new ArrayList(parameters.size());
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>(16);
        for (Map<String, Object> parameter : parameters) {
            DynamicObject riskControl = this.getDeclareReportMatchRiskControl(parameter, (String)sbbNumberIdMap.get(parameter.get("templateTypeNumber").toString()), riskControls);
            if (riskControl == null) {
                mapData = new HashMap<String, String>(3);
                mapData.put("id", parameter.get("id").toString());
                mapData.put("number", parameter.get("number").toString());
                mapData.put("verifyResult", "1");
                data.add(mapData);
                continue;
            }
            parameter.put("filterJson", riskControl.getString("filterjson_tag"));
            parameterList.add(parameter);
        }
        for (Map map : parameterList) {
            DynamicObjectCollection riskResults = RiskResultBusiness.getDeclareReportRiskResultWithRiskControl((String)map.get("filterJson").toString(), (String)((String)sbbNumberIdMap.get(map.get("templateTypeNumber").toString())), (String)map.get("skssqq").toString(), (String)map.get("skssqz").toString(), (Long)((Long)map.get("orgId")), (String)map.get("draftPurpose").toString(), (Long)((Long)map.get("taxTypeId")), (String)"risk.name");
            mapData = new HashMap(4);
            if (CollectionUtils.isEmpty((Collection)riskResults)) {
                mapData.put("id", map.get("id").toString());
                mapData.put("number", map.get("number").toString());
                mapData.put("verifyResult", "1");
                data.add(mapData);
                continue;
            }
            mapData.put("id", map.get("id").toString());
            mapData.put("number", map.get("number").toString());
            mapData.put("verifyResult", "0");
            String operateType = map.get("operateType").toString();
            List riskNames = riskResults.stream().map(p -> p.getString("risk.name")).collect(Collectors.toList());
            if ("submit".equals(operateType)) {
                mapData.put("tipMsg", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u98ce\u9669\u6307\u6807\u201c%2$s\u201d\u5f02\u5e38\uff0c\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u98ce\u9669\u7ed3\u679c\u5904\u7406\u3002", (String)"RiskServiceImpl_3", (String)"taxc-tctrc-mservice", (Object[])new Object[0]), map.get("number").toString(), String.join((CharSequence)"\u3001", riskNames)));
            } else {
                mapData.put("tipMsg", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u98ce\u9669\u6307\u6807\u201c%2$s\u201d\u5f02\u5e38\uff0c\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u98ce\u9669\u7ed3\u679c\u5904\u7406\u3002", (String)"RiskServiceImpl_4", (String)"taxc-tctrc-mservice", (Object[])new Object[0]), map.get("number").toString(), String.join((CharSequence)"\u3001", riskNames)));
            }
            data.add(mapData);
        }
        return CommonService.createReturnResultObject(data);
    }

    private DynamicObject getDeclareReportMatchRiskControl(Map<String, Object> parameter, String templateTypeId, DynamicObjectCollection riskControls) {
        DynamicObject riskControl;
        Long taxTypeId;
        Predicate<DynamicObject> predicate = p -> p.getString("sbbtype.fbasedataid.id").equals(templateTypeId);
        String draftPurpose = parameter.get("draftPurpose").toString();
        if (StringUtils.isNotEmpty((CharSequence)draftPurpose)) {
            predicate = predicate.and(p -> p.getString("draftpurpose").contains("," + draftPurpose + ","));
        }
        Long l = taxTypeId = parameter.get("taxTypeId") == null ? null : (Long)parameter.get("taxTypeId");
        if (taxTypeId != null && taxTypeId != 0L) {
            predicate = predicate.and(p -> p.getLong("taxtype.fbasedataid.id") == taxTypeId.longValue());
        }
        if ((riskControl = (DynamicObject)riskControls.stream().filter(predicate.and(p -> p.getLong("entryentity.org.id") == ((Long)parameter.get("orgId")).longValue())).findFirst().orElse(null)) == null) {
            riskControl = riskControls.stream().filter(predicate.and(p -> p.getBoolean("isallorg"))).findFirst().orElse(null);
        }
        return riskControl;
    }

    private QFilter getQueryVerifyRiskResultElementResultFilter(Map<Long, DynamicObject> verifyRiskMap, Map<Long, List<FilterElement>> resultIdElementMap) {
        QFilter filter = null;
        for (Map.Entry<Long, DynamicObject> verifyRiskEntry : verifyRiskMap.entrySet()) {
            QFilter filter1 = new QFilter("org", "=", verifyRiskEntry.getValue().get("runorg.id")).and("startdata", "=", (Object)DateUtils.getFirstDateOfDay((Date)verifyRiskEntry.getValue().getDate("startdate"))).and("enddata", "=", (Object)DateUtils.getFirstDateOfDay((Date)verifyRiskEntry.getValue().getDate("enddate")));
            List<FilterElement> filterElements = resultIdElementMap.get(verifyRiskEntry.getKey());
            List elementIds = filterElements.stream().map(p -> Long.parseLong(p.getElement().getId())).collect(Collectors.toList());
            filter1 = filter1.and("elementdef", "in", elementIds);
            if (filter == null) {
                filter = filter1;
                continue;
            }
            filter = filter.or(filter1);
        }
        return filter;
    }

    private List<Map<String, String>> getVerifyRiskInvolvingData(DynamicObject riskResult, List<FilterElement> filterElements, DynamicObjectCollection elementResults) {
        if (CollectionUtils.isEmpty(filterElements)) {
            return new ArrayList<Map<String, String>>(0);
        }
        List elementIds = filterElements.stream().map(p -> p.getElement().getId()).collect(Collectors.toList());
        Predicate<DynamicObject> predicate = p -> p.getLong("org") == riskResult.getLong("runorg.id") && elementIds.contains(p.getString("elementdef")) && p.getDate("startdata").compareTo(DateUtils.getFirstDateOfDay((Date)riskResult.getDate("startdate"))) == 0 && p.getDate("enddata").compareTo(DateUtils.getFirstDateOfDay((Date)riskResult.getDate("enddate"))) == 0;
        List riskElementResults = elementResults.stream().filter(predicate).collect(Collectors.toList());
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(riskElementResults.size());
        for (DynamicObject riskElementResult : riskElementResults) {
            HashMap<String, String> resultMap = new HashMap<String, String>(5);
            resultMap.put("elementCode", riskElementResult.getString("element"));
            resultMap.put("elementName", riskElementResult.getString("name"));
            resultMap.put("value", riskElementResult.getString("value"));
            resultMap.put("isDenominatorZero", riskElementResult.getString("isdenominatorzero"));
            resultMap.put("isEmptyField", riskElementResult.getString("isemptyfield"));
            result.add(resultMap);
        }
        return result;
    }
}

