/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.skill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.taxc.tctrc.business.service.riskrun.RiskRunService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.mservice.constant.RiskSkillEnum;

public class RiskSkillAPI
implements ISkillRunnable {
    private static String SKILL_NUMBER = "fxjkjqr";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        if (SKILL_NUMBER.equalsIgnoreCase(skillNum)) {
            ArrayList list = new ArrayList(3);
            Date now = new Date();
            Date startDate = DateUtils.getFirstDateOfMonth((Date)now);
            Date endDate = DateUtils.getLastDateOfMonth((Date)now);
            for (RiskSkillEnum riskSkillEnum : RiskSkillEnum.values()) {
                String number = riskSkillEnum.getNumber();
                long count = this.getCountByNumber(number, startDate, endDate);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("number", number);
                paramMap.put("name", riskSkillEnum.getName());
                paramMap.put("valueType", riskSkillEnum.getValueType());
                paramMap.put("value", String.valueOf(count));
                list.add(paramMap);
            }
            long totalCount = this.getCountByNumber("fxfxs", startTime, endTime);
            skillResult.setData(list);
            skillResult.setDate(skillRunContext.getStartTime());
            skillResult.setSkillNum(skillNum);
            skillResult.setFailCount(Integer.valueOf(0));
            skillResult.setTotalCount(Integer.valueOf(Integer.parseInt(String.valueOf(totalCount))));
        }
        return skillResult;
    }

    private long getCountByNumber(String number, Date startTime, Date endTime) {
        switch (number) {
            case "yxfxs": {
                DynamicObjectCollection riskRunList = RiskRunService.getRiskRunList((Date)startTime, (Date)endTime, (String)"B");
                return EmptyCheckUtils.isEmpty((Object)riskRunList) ? 0L : riskRunList.stream().count();
            }
            case "fxfxs": {
                DynamicObjectCollection riskRunResult = RiskRunService.getRiskRunResult((Date)startTime, (Date)endTime);
                return EmptyCheckUtils.isEmpty((Object)riskRunResult) ? 0L : riskRunResult.stream().count();
            }
            case "dclfxsl": {
                DynamicObjectCollection handleList = RiskRunService.getHandleListByStatus(Arrays.asList("0", "2"));
                return EmptyCheckUtils.isEmpty((Object)handleList) ? 0L : handleList.stream().count();
            }
        }
        return 0L;
    }
}

