/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tctrc.common.util.DBUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RiskOffetUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(RiskOffetUpgradeService.class);
    private static final String ALGOKEY = "RiskOffetUpgradeService";
    private static final String DBKEY_TAX = "taxc";

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult up = new UpgradeResult();
        up.setSuccess(true);
        up.setLog(ResManager.loadKDString((String)"\u6570\u636e\u6307\u6807\uff0c\u5bf9\u6807\u503c\u5b57\u6bb5\u5347\u7ea7\u6210\u529f\u3002", (String)"RiskOffetUpgradeService_0", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
        LOGGER.info("RiskOffetUpgradeService\u6570\u636e\u6307\u6807\uff0c\u5bf9\u6807\u503c\u5b57\u6bb5\u5347\u7ea7\uff0c\u5f00\u59cb\u5347\u7ea7");
        try {
            List<Map<String, Object>> list = this.queryNeedUpgrade();
            LOGGER.info("\u9700\u8981\u5347\u7ea7\u7684\u6570\u91cf" + list.size());
            this.batchSave(list);
            LOGGER.info("\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            up.setSuccess(true);
            up.setLog(ResManager.loadKDString((String)"\u6570\u636e\u6307\u6807\uff0c\u5bf9\u6807\u503c\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25\u3002", (String)"RiskOffetUpgradeService_1", (String)"taxc-tctrc-mservice", (Object[])new Object[]{ExceptionUtil.toString((Throwable)e)}));
            LOGGER.error("\u6570\u636e\u6307\u6807\uff0c\u5bf9\u6807\u503c\u5b57\u6bb5\u5347\u7ea7\u5931\u8d25\uff1a" + ExceptionUtil.toString((Throwable)e));
        }
        return up;
    }

    private List<Map<String, Object>> queryNeedUpgrade() {
        ArrayList<Map<String, Object>> target = new ArrayList<Map<String, Object>>(8);
        StringBuilder sql = new StringBuilder("select fid,fentryid, fbmvalue1 from t_tctrc_risk_offset    where  fbmvalue2  =0 ");
        DataSet datas = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)DBKEY_TAX), (String)sql.toString());
        while (datas.hasNext()) {
            Row row = datas.next();
            String fbmvalue1 = row.getString("fbmvalue1");
            HashMap<String, Number> sbpz = new HashMap<String, Number>(8);
            sbpz.put("id", row.getLong("fid"));
            sbpz.put("fentryid", row.getLong("fentryid"));
            if (NumberUtils.isCreatable((String)fbmvalue1)) {
                sbpz.put("fbmvalue1", new BigDecimal(fbmvalue1));
            } else {
                sbpz.put("fbmvalue1", BigDecimal.ZERO);
            }
            target.add(sbpz);
        }
        datas.close();
        return target;
    }

    private void batchSave(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List partition = Lists.partition(list, (int)300);
        for (List maps : partition) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(4);
            for (Map item : maps) {
                Object[] objs = new Object[]{item.get("fbmvalue1"), item.get("id"), item.get("fentryid")};
                params.add(objs);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("update t_tctrc_risk_offset set fbmvalue2= ? where fid= ?    and  fentryid = ? ");
            DBUtils.executeBatch((String)DBKEY_TAX, (String)sql.toString(), params);
        }
    }
}

