/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.upgrade;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tctrc.common.util.ElementUtil;
import org.apache.commons.lang3.StringUtils;

public class TctrcDefinitionUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TctrcDefinitionUpgradeService.class);
    private static final String TDM_ELEMENT_INFO_TABLE = "t_tdm_element_info";
    private static final String TCTRC_RISK_DEFINITION_TABLE = "t_tctrc_risk_definition";
    private static final String TCTRC_RISK_RUN_RESULT_TABLE = "t_tctrc_risk_run_result";
    private static final String QUERY_ELEMENT_SQL = "select a.fid,a.fnumber,b.fname,a.fjson_tag,a.fformula from t_tdm_element_info a inner join t_tdm_element_info_l b  on a.fid=b.fid where a.fbottom=? and b.flocaleid='zh_CN';";
    private static final String QUERY_ELEMENT_ALL = "select a.fnumber,b.fname from t_tdm_element_info a inner join t_tdm_element_info_l b  on a.fid=b.fid where b.flocaleid='zh_CN';";
    private static final String UPDATE_ELEMENT_SQL = "update t_tdm_element_info set fjson_tag=?,fformula=? where fid=?;";
    private static final String QUERY_RISK_DEFINITION = "select fid,fjson from t_tctrc_risk_definition;";
    private static final String QUERY_RISK_RESULT_BY_DEFINITION_TYPE = "select a.fid,a.fjson from t_tctrc_risk_run_result a inner join t_tctrc_risk_definition  b on a.frisk=b.fid where b.frisktype =?;";
    private static final String UPDATE_RISK_RESULT_SQL = "update t_tctrc_risk_run_result set fjson=? where fid=?;";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u5143\u7d20\u8868\u8fbe\u5f0f\u6570\u636e\u5347\u7ea7\u5904\u7406\u6210\u529f\u3002", (String)"TctrcDefinitionUpgradeService_0", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
        try {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u5143\u7d20\u8868\u8fbe\u5f0f\u6570\u636e\u5347\u7ea7\u5904\u7406===>>>>>>");
            ArrayList<String> tables = new ArrayList<String>(Arrays.asList(TDM_ELEMENT_INFO_TABLE, TCTRC_RISK_DEFINITION_TABLE, TCTRC_RISK_RUN_RESULT_TABLE));
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.updateElementFormula();
            LOGGER.info(">>>>>>\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u5143\u7d20\u8868\u8fbe\u5f0f\u6570\u636e\u5347\u7ea7\u5904\u7406\u5931\u8d25\u3002", (String)"TctrcDefinitionUpgradeService_1", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
            LOGGER.error("TctrcDefinitionUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void updateElementFormula() {
        DataSet queryRiskResult;
        DataSet queryRiskDefinitionAll;
        DataSet element = DBUtils.queryDataSet((String)"TctrcDefinitionUpgradeService_queryElement", (String)QUERY_ELEMENT_SQL, (Object[])new Object[]{"0"});
        if (element.isEmpty()) {
            element.close();
            return;
        }
        HashMap<String, String> elementGroup = new HashMap<String, String>();
        HashMap elementNumberNameGroup = new HashMap();
        element.forEach(v -> elementGroup.put(v.getLong("FID") + "|" + v.getString("FNUMBER"), v.getString("FJSON_TAG")));
        DataSet elementAll = DBUtils.queryDataSet((String)"TctrcDefinitionUpgradeService_queryElementAll", (String)QUERY_ELEMENT_ALL, null);
        if (elementAll.isEmpty()) {
            elementAll.close();
            return;
        }
        elementAll.forEach(v -> elementNumberNameGroup.put(v.getString("FNUMBER"), v.getString("FNAME")));
        ArrayList paramList = new ArrayList(32);
        elementGroup.forEach((key, json) -> {
            String target = "";
            String targetFormula = "";
            String[] idnumber = key.split("\\|");
            long id = Long.parseLong(idnumber[0]);
            String number = idnumber[1];
            if (EmptyCheckUtils.isNotEmpty((Object)json)) {
                String formulajson = (String)((Map)SerializationUtils.fromJsonString((String)json, Map.class)).get("formula");
                formulajson = this.getTargetString(elementNumberNameGroup, formulajson);
                target = SerializationUtils.toJsonString((Object)ImmutableBiMap.of((Object)"formula", (Object)formulajson));
                targetFormula = formulajson;
            }
            if (EmptyCheckUtils.isNotEmpty((Object)target)) {
                paramList.add(new Object[]{target, targetFormula, id});
            }
        });
        element.close();
        elementAll.close();
        if (EmptyCheckUtils.isNotEmpty(paramList)) {
            DBUtils.executeBatch((String)UPDATE_ELEMENT_SQL, paramList);
        }
        if ((queryRiskDefinitionAll = DBUtils.queryDataSet((String)"TctrcDefinitionUpgradeService_queryRiskDefinitionAll", (String)QUERY_RISK_DEFINITION, null)).isEmpty()) {
            queryRiskDefinitionAll.close();
            return;
        }
        HashMap<Long, String> riskDefinitionGroup = new HashMap<Long, String>();
        queryRiskDefinitionAll.forEach(v -> riskDefinitionGroup.put(v.getLong("FID"), v.getString("FJSON")));
        String updateRiskDefinitionSql = "update t_tctrc_risk_definition set fjson=? where fid=?;";
        ArrayList paramListRisk = new ArrayList(32);
        riskDefinitionGroup.forEach((key, json) -> {
            if (EmptyCheckUtils.isNotEmpty((Object)json) && EmptyCheckUtils.isNotEmpty((Object)(json = this.getTargetString(elementNumberNameGroup, (String)json)))) {
                paramListRisk.add(new Object[]{json, key});
            }
        });
        queryRiskDefinitionAll.close();
        if (EmptyCheckUtils.isNotEmpty(paramListRisk)) {
            DBUtils.executeBatch((String)updateRiskDefinitionSql, paramListRisk);
        }
        if ((queryRiskResult = DBUtils.queryDataSet((String)"TctrcDefinitionUpgradeService_queryRiskResultByDefinitionType", (String)QUERY_RISK_RESULT_BY_DEFINITION_TYPE, (Object[])new Object[]{"1"})).isEmpty()) {
            queryRiskResult.close();
            return;
        }
        HashMap<Long, String> riskResultGroup = new HashMap<Long, String>();
        queryRiskResult.forEach(v -> riskResultGroup.put(v.getLong("FID"), v.getString("FJSON")));
        ArrayList paramListRiskResult = new ArrayList(32);
        riskResultGroup.forEach((key, json) -> {
            if (EmptyCheckUtils.isNotEmpty((Object)(json = this.getTargetString(elementNumberNameGroup, (String)json)))) {
                paramListRiskResult.add(new Object[]{json, key});
            }
        });
        queryRiskResult.close();
        if (EmptyCheckUtils.isNotEmpty(paramListRiskResult)) {
            DBUtils.executeBatch((String)UPDATE_RISK_RESULT_SQL, paramListRiskResult);
        }
    }

    private String getTargetString(Map<String, String> elementNumberNameGroup, String json) {
        String[] formula;
        String target = "";
        if (EmptyCheckUtils.isEmpty((Object)json)) {
            return target;
        }
        for (String content : formula = json.split(" ")) {
            if (StringUtils.isEmpty((CharSequence)content) || content.contains("${") && content.contains("}") || "+-*/()<><=>=abs(".contains(content) || ElementUtil.isConstantNumberNew((String)content, elementNumberNameGroup)) continue;
            String name = elementNumberNameGroup.get(content);
            if (EmptyCheckUtils.isNotEmpty((Object)name)) {
                if (json.contains("${" + name + "|" + content + "}")) continue;
                json = json.replace(content, "${" + name + "|" + content + "}");
                continue;
            }
            LOGGER.info(">>>>>>\u5f53\u524d\u672a\u67e5\u627e\u5230\u5143\u7d20name" + content + "\u53ef\u80fd\u662f\u5f53\u524d\u5143\u7d20\u88ab\u5220\u9664\u6216\u8005\u6307\u6807\u914d\u7f6e\u4e4b\u540e\u6539\u4e86\u5143\u7d20\u7f16\u7801\u6216\u8005\u5386\u53f2\u4e0a\u5176\u4ed6\u539f\u56e0<<<<");
        }
        return json;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

