/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.upgrade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tctrc.common.util.ElementUtil;

public class TctrcRiskConvertToElementUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String TCTRC_RISK_DEFINITION = "t_tctrc_risk_definition";
    private static final String TCTRC_RISK_DEFINITION_L = "t_tctrc_risk_definition_l";
    private static final String TCTRC_TAXTYPEMUL = "t_tctrc_taxtypemul";
    private static final String TDM_ELEMENT_INFO = "t_tdm_element_info";
    private static final String TDM_ELEMENT_INFO_L = "t_tdm_element_info_l";
    private static final Long NUMERIC_METRICS_ID = 1999957449376901120L;
    private static int currentSerialNumber = 0;
    private Log LOGGER = LogFactory.getLog(TctrcRiskConvertToElementUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u98ce\u9669\u6570\u503c\u6307\u6807\u6570\u636e\u5347\u7ea7\u5904\u7406\u6210\u529f\u3002", (String)"TctrcRiskConvertToElementUpgradeService_0", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
        try {
            this.LOGGER.info("\u5f00\u59cb\u6267\u884c\u98ce\u9669\u6570\u503c\u6307\u6807\u6570\u636e\u5347\u7ea7\u5904\u7406===>>>>>>");
            List tables = Stream.of(TCTRC_RISK_DEFINITION, TCTRC_RISK_DEFINITION_L, TCTRC_TAXTYPEMUL, TDM_ELEMENT_INFO, TDM_ELEMENT_INFO_L).collect(Collectors.toList());
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            this.LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.UpgradeRiskNumericMetrics();
            this.LOGGER.info(">>>>>>\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u98ce\u9669\u6570\u503c\u6307\u6807\u6570\u636e\u5347\u7ea7\u5904\u7406\u5931\u8d25\u3002", (String)"TctrcRiskConvertToElementUpgradeService_1", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
            this.LOGGER.error("TctrcDefinitionUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void UpgradeRiskNumericMetrics() {
        String queryRiskNumericMetricsSql = "select fid,fnumber,fcreatorid,fcreatetime,fmodifytime,fmodifierid,fcaltype,fresultshow,fisvariable,fdescribe,fpreset,fjson from t_tctrc_risk_definition where frisktype = '1' and (felement = 0 or felement is null);";
        DataSet numericMetricsDataSet = DBUtils.queryDataSet((String)"TctrcRiskConvertToElementUpgradeService_queryRisk", (String)queryRiskNumericMetricsSql, (Object[])new Object[0]);
        if (numericMetricsDataSet.isEmpty()) {
            return;
        }
        Map<Long, String> elementCalculationCycleMap = this.getElementCalculationCycle(numericMetricsDataSet.copy().select("fid,fjson"));
        ArrayList ids = new ArrayList(numericMetricsDataSet.copy().count("fid", false));
        numericMetricsDataSet.copy().select("fid").forEach(row -> ids.add(row.getLong("fid")));
        StringJoiner idJoiner = new StringJoiner(",");
        ids.forEach(id -> idJoiner.add(id.toString()));
        String queryRiskNumericMetricsLanguageSql = "select fid,flocaleid,fname from t_tctrc_risk_definition_l where fid in (" + idJoiner + ")";
        DataSet numericMetricsLanguageDataSet = DBUtils.queryDataSet((String)"TctrcRiskConvertToElementUpgradeService_queryRiskL", (String)queryRiskNumericMetricsLanguageSql, (Object[])new Object[0]);
        String queryRiskNumericMetricsTaxTypeSql = "select fid,fbasedataid from t_tctrc_taxtypemul where fid in (" + idJoiner + ")";
        DataSet numericMetricsTaxTypeDataSet = DBUtils.queryDataSet((String)"TctrcRiskConvertToElementUpgradeService_queryRiskTaxType", (String)queryRiskNumericMetricsTaxTypeSql, (Object[])new Object[0]);
        String insertElementSql = "insert into t_tdm_element_info (fid,fnumber,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,ftype,fbottom,fpreset,fjson_tag,fdescribe,ftimedeviationtype,ftypevalue,fisvariable,fformula,ftaxtype,frisktimedeviationtype,fautorefresh) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        String insertElementLanguageSql = "insert into t_tdm_element_info_l(fpkid,fid,flocaleid,fname) values (?,?,?,?);";
        String updateRiskNumericMetricsSql = "update t_tctrc_risk_definition set felement = ? where fid = ?;";
        long[] elementIds = DB.genLongIds((String)TDM_ELEMENT_INFO, (int)ids.size());
        int numericMetricsLanguageCount = numericMetricsLanguageDataSet.copy().count("fid", false);
        String[] elementLanguageIds = DB.genStringIds((String)TDM_ELEMENT_INFO_L, (int)numericMetricsLanguageCount);
        ArrayList<Object[]> insertElementParams = new ArrayList<Object[]>(ids.size());
        ArrayList<Object[]> insertElementLanguageParams = new ArrayList<Object[]>(numericMetricsLanguageCount);
        ArrayList<Object[]> updateRiskNumericMetricsParams = new ArrayList<Object[]>(ids.size());
        int elementIndex = 0;
        int elementLanguageIndex = 0;
        for (Row numericMetricsRow : numericMetricsDataSet) {
            DataSet numericMetricsTaxTypeFilterDataSet = numericMetricsTaxTypeDataSet.copy().filter("fid = " + numericMetricsRow.getString("fid"));
            Long taxTypeId = 0L;
            if (!numericMetricsTaxTypeFilterDataSet.isEmpty()) {
                taxTypeId = numericMetricsTaxTypeFilterDataSet.next().getLong("fbasedataid");
            }
            numericMetricsTaxTypeFilterDataSet.close();
            long id2 = elementIds[elementIndex++];
            String serialNumber = this.generateSerialNumber();
            String calculationCycle = elementCalculationCycleMap.get(numericMetricsRow.getLong("fid"));
            insertElementParams.add(new Object[]{id2, numericMetricsRow.getString("fnumber") + serialNumber, "C", numericMetricsRow.getLong("fcreatorid"), numericMetricsRow.getLong("fmodifierid"), "1", numericMetricsRow.getDate("fcreatetime"), numericMetricsRow.getDate("fmodifytime"), id2, NUMERIC_METRICS_ID, "0", numericMetricsRow.getString("fpreset"), this.getFormulaJson(numericMetricsRow), numericMetricsRow.getString("fdescribe"), calculationCycle == null ? "" : calculationCycle, this.getRateTypeValue(numericMetricsRow), numericMetricsRow.getString("fisvariable"), numericMetricsRow.getString("fjson"), taxTypeId, "0", "1"});
            DataSet numericMetricsLanguageFilterDataSet = numericMetricsLanguageDataSet.copy().filter("fid = " + numericMetricsRow.getString("fid"));
            for (Row row2 : numericMetricsLanguageFilterDataSet) {
                insertElementLanguageParams.add(new Object[]{elementLanguageIds[elementLanguageIndex++], id2, row2.getString("flocaleid"), row2.getString("fname") + serialNumber});
            }
            updateRiskNumericMetricsParams.add(new Object[]{id2, numericMetricsRow.getLong("fid")});
        }
        numericMetricsDataSet.close();
        numericMetricsTaxTypeDataSet.close();
        numericMetricsLanguageDataSet.close();
        if (!(CollectionUtils.isEmpty(insertElementParams) || CollectionUtils.isEmpty(insertElementLanguageParams) || CollectionUtils.isEmpty(updateRiskNumericMetricsParams))) {
            DBUtils.executeBatch((String)insertElementSql, insertElementParams);
            DBUtils.executeBatch((String)insertElementLanguageSql, insertElementLanguageParams);
            DBUtils.executeBatch((String)updateRiskNumericMetricsSql, updateRiskNumericMetricsParams);
        }
    }

    private Map<Long, String> getElementCalculationCycle(DataSet metricsDataSet) {
        HashMap dependencyElementCodeMap = new HashMap(16);
        for (Row row2 : metricsDataSet) {
            List dependencyElementList = ElementUtil.getFormulaElementInfo((String)row2.getString("fjson"));
            dependencyElementCodeMap.put(row2.getLong("fid"), dependencyElementList.stream().map(p -> p.split("\\|")[1]).collect(Collectors.toList()));
        }
        List<String> elementCodes = dependencyElementCodeMap.values().stream().flatMap(p -> p.stream()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(elementCodes)) {
            return new HashMap<Long, String>(0);
        }
        StringBuilder sqlBuilder = new StringBuilder("select fnumber,ftimedeviationtype from t_tdm_element_info where fnumber in (");
        elementCodes.forEach(p -> sqlBuilder.append("?,"));
        String sql = sqlBuilder.substring(0, sqlBuilder.length() - 1);
        DataSet elementDataSet = DBUtils.queryDataSet((String)"TctrcRiskConvertToElementUpgradeService_queryElement", (String)(sql + ")"), (Object[])elementCodes.toArray());
        HashMap elementCodeCalculationCycleMap = new HashMap(16);
        elementDataSet.forEach(row -> elementCodeCalculationCycleMap.put(row.getString("fnumber"), row.getInteger("ftimedeviationtype")));
        HashMap<Long, String> result = new HashMap<Long, String>(dependencyElementCodeMap.size());
        for (Map.Entry dependencyElementCodeEntry : dependencyElementCodeMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)dependencyElementCodeEntry.getValue()))) continue;
            Integer calculationCycle = (Integer)elementCodeCalculationCycleMap.get(((List)dependencyElementCodeEntry.getValue()).get(0));
            for (int i = 1; i < ((List)dependencyElementCodeEntry.getValue()).size(); ++i) {
                if ((Integer)elementCodeCalculationCycleMap.get(((List)dependencyElementCodeEntry.getValue()).get(i)) >= calculationCycle) continue;
                calculationCycle = (Integer)elementCodeCalculationCycleMap.get(((List)dependencyElementCodeEntry.getValue()).get(i));
            }
            result.put((Long)dependencyElementCodeEntry.getKey(), calculationCycle == null ? "" : calculationCycle.toString());
        }
        return result;
    }

    private String generateSerialNumber() {
        currentSerialNumber = currentSerialNumber >= 1000 ? 1 : ++currentSerialNumber;
        return String.format("%03d", currentSerialNumber);
    }

    private String getFormulaJson(Row numericMetricsRow) {
        HashMap<String, String> formulaMap = new HashMap<String, String>(1);
        formulaMap.put("formula", numericMetricsRow.getString("fjson"));
        return SerializationUtils.toJsonString(formulaMap);
    }

    private int getRateTypeValue(Row numericMetricsRow) {
        return "2".equals(numericMetricsRow.getString("fresultshow")) ? 1 : 0;
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return this.LOGGER;
    }
}

