/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.mservice.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.tctrc.common.enums.RiskHandleResultEnum;

public class TctrcRiskResulHandleOptionUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TctrcRiskResulHandleOptionUpgradeService.class);
    private static final String TABLE_HANDLE_SUGGESTION = "t_tctrc_handle_suggestion";
    private static final String TABLE_HANDLE_ENTITY = "t_tctrc_handle_entity";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u98ce\u9669\u7ed3\u679c\u5904\u7406\u610f\u89c1\u6570\u636e\u5347\u7ea7\u5904\u7406\u6210\u529f\u3002", (String)"TctrcRiskResulHandleOptionUpgradeService_0", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
        try {
            LOGGER.info("\u5f00\u59cb\u6267\u884c\u98ce\u9669\u7ed3\u679c\u5904\u7406\u610f\u89c1\u6570\u636e\u5347\u7ea7\u5904\u7406===>>>>>>");
            List tables = Stream.of(TABLE_HANDLE_SUGGESTION, TABLE_HANDLE_ENTITY).collect(Collectors.toList());
            for (String table : tables) {
                if (DB.exitsTable((DBRoute)DBRoute.of((String)TAXC), (String)table)) continue;
                result.setLog("Not exist table,no run process," + JsonUtil.toJson(tables));
                return result;
            }
            LOGGER.info(">>>>>>\u5f00\u59cb\u5347\u7ea7");
            this.UpgradeRiskResultHandleOption();
            LOGGER.info(">>>>>>\u5347\u7ea7\u7ed3\u675f");
        }
        catch (Exception e) {
            result.setLog(ResManager.loadKDString((String)"\u98ce\u9669\u7ed3\u679c\u5904\u7406\u610f\u89c1\u6570\u636e\u5347\u7ea7\u5904\u7406\u5931\u8d25\u3002", (String)"TctrcRiskResulHandleOptionUpgradeService_1", (String)"taxc-tctrc-mservice", (Object[])new Object[0]));
            LOGGER.error("TctrcRiskResulHandleOptionUpgradeService FAILURE", (Throwable)e);
            result.setSuccess(false);
            result.setErrorInfo(this.getStackTraceMessage(e));
        }
        return result;
    }

    private void UpgradeRiskResultHandleOption() {
        String queryHandleEntitySql = "select fid,fresult from t_tctrc_handle_entity where fhandleoption = ' ' or fhandleoption is null;";
        DataSet handleEntityDataSet = DBUtils.queryDataSet((String)"TctrcRiskResulHandleOptionUpgradeService_queryHandleEntity", (String)queryHandleEntitySql, (Object[])new Object[0]);
        if (handleEntityDataSet.isEmpty()) {
            handleEntityDataSet.close();
            return;
        }
        ArrayList ids = new ArrayList(handleEntityDataSet.copy().count("fid", false));
        ArrayList<Object[]> updateHandleEntityParams = new ArrayList<Object[]>(ids.size());
        List idList = Lists.partition(ids, (int)100000);
        for (List idCollection : idList) {
            this.setUpdateHandleEntityParams(handleEntityDataSet.copy(), new HashSet<Long>(idCollection), updateHandleEntityParams);
        }
        handleEntityDataSet.close();
        String updateHandleEntitySql = "update t_tctrc_handle_entity set fhandleoption = ? where fid = ?;";
        if (CollectionUtils.isEmpty(updateHandleEntityParams)) {
            return;
        }
        List partitions = Lists.partition(updateHandleEntityParams, (int)5000);
        for (List partition : partitions) {
            DBUtils.executeBatch((String)updateHandleEntitySql, (List)partition);
        }
    }

    public void setUpdateHandleEntityParams(DataSet handleEntityDataSet, Set<Long> ids, List<Object[]> updateHandleEntityParams) {
        StringJoiner idJoiner = new StringJoiner(",");
        ids.forEach(id -> idJoiner.add(id.toString()));
        String queryHandleSuggestionSql = "select fid,fsuggestion from t_tctrc_handle_suggestion where fid in (" + idJoiner + ")";
        DataSet handleSuggestionDataSet = DBUtils.queryDataSet((String)"TctrcRiskResulHandleOptionUpgradeService_queryHandleSuggestion", (String)queryHandleSuggestionSql, (Object[])new Object[0]);
        for (Row row : handleEntityDataSet) {
            Long handleEntityId = row.getLong("fid");
            if (!ids.contains(handleEntityId)) continue;
            DataSet handleEntitySuggestionDataSet = handleSuggestionDataSet.copy().filter("fid = " + handleEntityId);
            if (handleEntitySuggestionDataSet.isEmpty()) {
                handleEntitySuggestionDataSet.close();
                continue;
            }
            String result = row.getString("fresult");
            boolean isNormalOrRisk = RiskHandleResultEnum.NORMAL.getCode().equals(result) || RiskHandleResultEnum.RISK.getCode().equals(result);
            StringJoiner suggestionJoiner = new StringJoiner("\r\n");
            int index = 1;
            for (Row row1 : handleEntitySuggestionDataSet) {
                suggestionJoiner.add(isNormalOrRisk ? index++ + "." + row1.getString("fsuggestion") : row1.getString("fsuggestion"));
            }
            updateHandleEntityParams.add(new Object[]{suggestionJoiner.toString(), handleEntityId});
        }
        handleSuggestionDataSet.close();
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

