/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.report.riskscore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.biz.RiskLevelUtils;

public class RiskScoreDetailRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final String LABLES = "lables";
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String REPORT_LIST = "reportlistap";
    private static final String REPORT_FILTERAP = "reportfilterap";

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("ids") && customParams.containsKey(END_DATE)) {
            this.getPageCache().put("initsearch", "true");
            Date enddate = (Date)customParams.get(END_DATE);
            this.setDefaultDate(enddate);
            ReportFilter reportFilter = (ReportFilter)this.getView().getControl(REPORT_FILTERAP);
            reportFilter.search();
        } else {
            this.setDefaultDate(null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("reset".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.setDefaultDate(null);
        }
    }

    private void setDefaultDate(Date enddate) {
        Date startdate;
        if (enddate == null) {
            Date now = new Date();
            Date predate = DateUtils.addMonth((Date)now, (int)-1);
            startdate = DateUtils.getFirstDateOfMonth((Date)predate);
            enddate = DateUtils.getLastDateOfMonth((Date)predate);
        } else {
            startdate = DateUtils.getFirstDateOfMonth((Date)enddate);
        }
        this.getView().getModel().setValue(START_DATE, (Object)startdate);
        this.getView().getModel().setValue(END_DATE, (Object)enddate);
    }

    public void registerListener(EventObject e) {
        MulBasedataEdit lables = (MulBasedataEdit)this.getView().getControl(LABLES);
        lables.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit orgs = (MulBasedataEdit)this.getView().getControl(ORGS);
        orgs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportlist = (ReportList)this.getView().getControl(REPORT_LIST);
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (LABLES.equalsIgnoreCase(key)) {
            String groupnumber = "regulated_areas";
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("number", "=", (Object)groupnumber));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.number", "=", (Object)groupnumber));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        } else if (ORGS.equalsIgnoreCase(key)) {
            List<Long> orgs = this.getOrgList();
            QFilter filters = new QFilter("id", "in", orgs);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(filters);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        if (this.getPageCache().get("initsearch") != null && "true".equals(this.getPageCache().get("initsearch"))) {
            this.setInitQueryFilter(queryParam);
        }
        List<Long> orgs = this.getOrgList();
        for (FilterItemInfo items : itemInfos) {
            if (!ORGS.equals(items.getPropName())) continue;
            if (items.getValue() == null) {
                items.setValue(orgs);
                continue;
            }
            Object value = items.getValue();
            if (!(value instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection orgcolls = (DynamicObjectCollection)items.getValue();
            List selectedorgs = orgcolls.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            List selectedallorgs = OrgUtils.getChildrenIds(selectedorgs);
            List ids = selectedallorgs.stream().filter(orgs::contains).collect(Collectors.toList());
            items.setValue(ids);
        }
        super.beforeQuery(queryParam);
    }

    public void setInitQueryFilter(ReportQueryParam queryParam) {
        this.getPageCache().put("initsearch", "false");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List ids = (List)customParams.get("ids");
        FilterItemInfo idfilter = new FilterItemInfo();
        idfilter.setPropName("ids");
        idfilter.setValue((Object)ids);
        queryParam.getFilter().getFilterItems().add(idfilter);
    }

    private List<Long> getOrgList() {
        MulBasedataDynamicObjectCollection lables = (MulBasedataDynamicObjectCollection)this.getModel().getValue(LABLES);
        List orgs = OrgUtils.getTaxPermOrgs((IFormView)this.getView());
        return orgs;
    }

    private List<Long> getOrgsByLableId(MulBasedataDynamicObjectCollection lables, List<Long> orgs) {
        if (lables == null || lables.size() <= 0) {
            return orgs;
        }
        List lableids = lables.stream().map(s -> s.getLong("fbasedataid.id")).collect(Collectors.toList());
        List orglist = TaxcMainServiceHelper.queryTaxcMainOrgIdsByOrgIdsAndOrgAttrIds(orgs, lableids);
        return orglist;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject object = hyperLinkClickEvent.getRowData();
        String orgid = object.getString("org.id");
        String key = hyperLinkClickEvent.getFieldName();
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        List<String> idlist = this.getRowRiskIds(key, object);
        ListShowParameter param = new ListShowParameter();
        if (StringUtil.isBlank((CharSequence)orgid)) {
            orgid = "all";
        }
        customParams.put("orgid", orgid);
        if (idlist == null || idlist.size() == 0) {
            idlist = new ArrayList<String>(1);
            idlist.add("0");
        }
        customParams.put("risklist", idlist);
        param.setBillFormId("tctrc_risk_run_result");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private List<String> getRowRiskIds(String key, DynamicObject object) {
        List<String> idlist = null;
        if (key.equalsIgnoreCase("risktotal")) {
            String totalids = object.getString("totalids");
            if (StringUtil.isNotBlank((CharSequence)totalids)) {
                idlist = Arrays.asList(totalids.split(","));
            }
        } else if (key.contains("risklevel")) {
            Integer no = Integer.parseInt(key.replaceAll("risklevel", ""));
            String lowids = object.getString("riskids" + no);
            if (StringUtil.isNotBlank((CharSequence)lowids)) {
                idlist = Arrays.asList(lowids.split(","));
            }
        }
        return idlist;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        String dimension = (String)this.getModel().getValue("dimension");
        Set<String> visibleFields = this.getVisibleFields(dimension);
        Set<String> unVisbleField = this.getUnVisibleFields(dimension);
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            if (!(abstractReportColumn instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            String field = reportColumn.getFieldKey();
            LocaleString caption = reportColumn.getCaption();
            if (caption.getLocaleValue().startsWith(RiskLevelUtils.getRiskLevel())) {
                unVisbleField.add(field);
            }
            if (visibleFields.remove(field)) {
                reportColumn.setHide(false);
                continue;
            }
            if (!unVisbleField.remove(field)) continue;
            reportColumn.setHide(true);
        }
    }

    private Set<String> getVisibleFields(String dimension) {
        HashSet<String> result = new HashSet<String>();
        switch (dimension) {
            case "2": {
                result.addAll(Arrays.asList("area1", "industry"));
                break;
            }
            case "3": {
                result.addAll(Arrays.asList("industry1", "area"));
                break;
            }
            default: {
                result.addAll(Arrays.asList("area", "industry"));
            }
        }
        return result;
    }

    private Set<String> getUnVisibleFields(String dimension) {
        HashSet<String> result = new HashSet<String>();
        switch (dimension) {
            case "2": {
                result.addAll(Arrays.asList("industry1", "area"));
                break;
            }
            case "3": {
                result.addAll(Arrays.asList("area1", "industry"));
                break;
            }
            default: {
                result.addAll(Arrays.asList("area1", "industry1"));
            }
        }
        return result;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object startdate = this.getModel().getValue(START_DATE);
        Object enddate = this.getModel().getValue(END_DATE);
        if ((this.getPageCache().get("initsearch") == null || "false".equals(this.getPageCache().get("initsearch"))) && (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RiskScoreDetailRptPlugin_0", (String)"taxc-tctrc-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }
}

