/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.report.riskscore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.tctrc.common.constant.RiskScoreDimensionEnum;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.biz.RiskLevelUtils;

public class RiskScoreDetailRptQueryPlugin
extends AbstractReportListDataPlugin {
    public static final Integer RISKLEVEL_NO = 10;
    private static final String NUMBER = "number";
    private static final String RISKIDS = "riskids";
    private static final String ENABLE = "enable";
    public static final String ORDERBY_FIELD = "issumline";
    private static final String RISK_RUN_RESULT = "tctrc_risk_run_result";
    private static final String RISK_SCORE_SCHEME = "tctrc_risk_score_scheme";
    private static final String RISK_ANALYSIS_SCHEME = "tctrc_analysis_scheme";
    private static final String SELECT_FIELD = "id,risk,rlevel.id,runorg,riskscore";
    private static final String[] FIELDS = new String[]{"area1", "industry1", "org", "riskscore", "risktotal", "totalids", "risklevel0", "riskids0", "risklevel1", "riskids1", "risklevel2", "riskids2", "risklevel3", "riskids3", "risklevel4", "riskids4", "risklevel5", "riskids5", "risklevel6", "riskids6", "risklevel7", "riskids7", "risklevel8", "riskids8", "risklevel9", "riskids9", "area", "industry", "issumline"};
    private static final DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
    private static RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        return this.collectDateSet(filterInfo);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columnList = super.getColumns(columns);
        DynamicObjectCollection list = RiskLevelUtils.getRiskLevelDb();
        for (int i = 0; i < columnList.size(); ++i) {
            Integer no;
            AbstractReportColumn arc = (AbstractReportColumn)columnList.get(i);
            String str = arc.getCaption().toString();
            if (!str.contains(RiskLevelUtils.getRiskLevel()) || (no = Integer.valueOf(Integer.parseInt(str.replaceAll(RiskLevelUtils.getRiskLevel(), "").trim()))) >= list.size()) continue;
            arc.setCaption(new LocaleString(((DynamicObject)list.get(no.intValue())).getString("name") + RiskLevelUtils.getStringRiskNumber()));
        }
        return columnList;
    }

    private DataSet collectDateSet(FilterInfo filterInfo) {
        String dimension = filterInfo.getString("dimension");
        Date enddate = filterInfo.getDate("enddate");
        if (enddate == null) {
            return this.getEmptyResult();
        }
        Map<Long, BigDecimal> percentMap = this.getAnalysisSchemePercent(enddate);
        String maxscore = this.getCurrentMaxScore(enddate);
        if (percentMap.size() == 0 || StringUtil.isBlank((CharSequence)maxscore)) {
            return this.getEmptyResult();
        }
        DynamicObjectCollection list = RiskLevelUtils.getRiskLevelDb();
        List<Long> riskLevelId = list.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        List<QFilter> filters = this.getFilter(filterInfo, riskLevelId);
        Set<Long> ids = percentMap.keySet();
        filters.add(new QFilter("risk.id", "in", ids));
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)RISK_RUN_RESULT, (String)SELECT_FIELD, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        return this.doCollectDateSet(dimension, colls, percentMap, maxscore, riskLevelId);
    }

    private DataSet doCollectDateSet(String dimension, DynamicObject[] colls, Map<Long, BigDecimal> percentMap, String maxscore, List<Long> riskLevelId) {
        Map<Long, List<DynamicObject>> orgGroups = Arrays.stream(colls).filter(v -> !ObjectUtils.isEmpty((Object)v.getDynamicObject("risk"))).collect(Collectors.groupingBy(s -> s.getLong("runorg.id")));
        Map<Long, List<DynamicObject>> taxinfos = this.queryTaxMainInfo(orgGroups.keySet());
        List<RiskScoreInfoBean> riskScoreInfoList = this.createRowDataList(colls, taxinfos, percentMap);
        return this.createAllData(dimension, riskScoreInfoList, maxscore, riskLevelId);
    }

    private List<RiskScoreInfoBean> createRowDataList(DynamicObject[] colls, Map<Long, List<DynamicObject>> taxinfos, Map<Long, BigDecimal> percentMap) {
        ArrayList<RiskScoreInfoBean> infoBeans = new ArrayList<RiskScoreInfoBean>(colls.length);
        for (DynamicObject col : colls) {
            RiskScoreInfoBean info = new RiskScoreInfoBean();
            Long orgid = col.getLong("runorg.id");
            Long id = col.getLong("id");
            Long riskid = col.getLong("risk.id");
            String riskscore = col.getString("riskscore");
            String area = "";
            String industry = "";
            if (taxinfos.containsKey(orgid)) {
                List<DynamicObject> taxinfo = taxinfos.get(orgid);
                for (int i = 0; i < taxinfo.size(); ++i) {
                    DynamicObject taxobj = taxinfo.get(i);
                    if (i == 0) {
                        industry = taxobj.getString("codeandname.name");
                    }
                    if (kd.bos.orm.util.CollectionUtils.isEmpty((Collection)taxobj.getDynamicObjectCollection("orgattr"))) continue;
                    for (DynamicObject orgattrObj : taxobj.getDynamicObjectCollection("orgattr")) {
                        if (!"regulated_areas".equalsIgnoreCase(orgattrObj.getString("fbasedataid.group.number"))) continue;
                        area = orgattrObj.getString("fbasedataid.name");
                    }
                }
            }
            BigDecimal percent = BigDecimal.ZERO;
            if (percentMap.containsKey(riskid)) {
                percent = percentMap.get(riskid);
            }
            BigDecimal totalScore = BigDecimal.ZERO;
            if (StringUtil.isNotBlank((CharSequence)riskscore)) {
                BigDecimal scorevalue = new BigDecimal(riskscore);
                totalScore = percent.multiply(scorevalue).setScale(2, 4);
            }
            info.setOrg(orgid);
            info.setRiskId(id);
            info.setRisklevel(col.getString("rlevel.id"));
            info.setArea(area);
            info.setIndustry(industry);
            info.setRiskscore(riskscore);
            info.setPercent(percent);
            info.setTotalscore(totalScore);
            infoBeans.add(info);
        }
        return infoBeans;
    }

    private Map<Long, List<DynamicObject>> queryTaxMainInfo(Set<Long> orgs) {
        ArrayList<Long> id = new ArrayList<Long>();
        id.addAll(orgs);
        List labels = TaxcMainServiceHelper.getTaxcMain(id, null);
        Map<Long, List<DynamicObject>> orglabelmap = labels.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid.id")));
        return orglabelmap;
    }

    private DataSet createAllData(String dimension, List<RiskScoreInfoBean> riskScoreInfoList, String maxscore, List<Long> riskLevelId) {
        Map<Long, List<RiskScoreInfoBean>> datalist = riskScoreInfoList.stream().collect(Collectors.groupingBy(s -> s.getOrg()));
        ArrayList<Object[]> result = new ArrayList<Object[]>(datalist.size());
        for (Map.Entry<Long, List<RiskScoreInfoBean>> entry : datalist.entrySet()) {
            List<RiskScoreInfoBean> values = entry.getValue();
            Object[] resRow = this.createRow(values, maxscore, riskLevelId);
            result.add(resRow);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        DataSet dataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        String field = RiskScoreDimensionEnum.getField((String)dimension);
        if (null != result && result.size() != 0 && !"1".equalsIgnoreCase(dimension)) {
            DataSet sumLine = this.createSumLines(dataSet, field);
            dataSet = dataSet.union(sumLine);
        }
        return dataSet.orderBy(new String[]{field, ORDERBY_FIELD});
    }

    private DataSet createSumLines(DataSet dateSet, String field) {
        dateSet = dateSet.copy().orderBy(new String[]{field});
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        String currentDimensionValue = null;
        BigDecimal totalScore = BigDecimal.ZERO;
        int totalNum = 0;
        int risktotal = 0;
        ArrayList<String> totalids = new ArrayList<String>();
        int[] riskLevelTotal = new int[RISKLEVEL_NO.intValue()];
        HashMap<Integer, List<String>> riskLevelIdsMap = new HashMap<Integer, List<String>>();
        for (Row row : dateSet) {
            int i;
            if (currentDimensionValue == null || row.getString(field).equalsIgnoreCase(currentDimensionValue)) {
                totalids.add(row.getString("totalids"));
                for (int i2 = 0; i2 < RISKLEVEL_NO; ++i2) {
                    if (CollectionUtils.isEmpty((Collection)((Collection)riskLevelIdsMap.get(i2)))) {
                        riskLevelIdsMap.put(i2, new ArrayList());
                    }
                    if (!kd.bos.entity.earlywarn.kit.StringUtil.isNotEmpty((CharSequence)row.getString(RISKIDS + i2))) continue;
                    ((List)riskLevelIdsMap.get(i2)).add(row.getString(RISKIDS + i2));
                }
                currentDimensionValue = row.getString(field);
                String riskscore = row.getString("riskscore");
                totalScore = totalScore.add(new BigDecimal(riskscore));
                risktotal += row.getInteger("risktotal").intValue();
                for (i = 0; i < RISKLEVEL_NO; ++i) {
                    riskLevelTotal[i] = riskLevelTotal[i] + row.getInteger("risklevel" + i);
                }
                ++totalNum;
                continue;
            }
            String average = totalScore.divide(new BigDecimal(totalNum), 2, 4).toString();
            coll.add(this.createSumLine(average, risktotal, field, currentDimensionValue, totalids, riskLevelTotal, riskLevelIdsMap));
            currentDimensionValue = row.getString(field);
            totalNum = 1;
            totalids.clear();
            riskLevelIdsMap = new HashMap();
            totalids.add(row.getString("totalids"));
            for (i = 0; i < RISKLEVEL_NO; ++i) {
                if (CollectionUtils.isEmpty((Collection)((Collection)riskLevelIdsMap.get(i)))) {
                    riskLevelIdsMap.put(i, new ArrayList());
                }
                if (!kd.bos.entity.earlywarn.kit.StringUtil.isNotEmpty((CharSequence)row.getString(RISKIDS + i))) continue;
                ((List)riskLevelIdsMap.get(i)).add(row.getString(RISKIDS + i));
            }
            String riskscore = row.getString("riskscore");
            totalScore = new BigDecimal(riskscore);
            risktotal = row.getInteger("risktotal");
            for (int i3 = 0; i3 < RISKLEVEL_NO; ++i3) {
                riskLevelTotal[i3] = row.getInteger("risklevel" + i3);
            }
        }
        String average = totalScore.divide(new BigDecimal(totalNum), 2, 4).toString();
        coll.add(this.createSumLine(average, risktotal, field, currentDimensionValue, totalids, riskLevelTotal, riskLevelIdsMap));
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Object[] createSumLine(String totalScore, int risktotal, String currentDimensionField, String currentDimensionValue, List<String> totalids, int[] riskLevelTotal, Map<Integer, List<String>> riskLevelIds) {
        totalids = totalids.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        String totalidstr = String.join((CharSequence)",", totalids);
        if (currentDimensionField.equalsIgnoreCase("area")) {
            return new Object[]{currentDimensionValue, "", "", totalScore, risktotal, totalidstr, riskLevelTotal != null ? riskLevelTotal[0] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(0)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(0)), riskLevelTotal != null ? riskLevelTotal[1] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(1)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(1)), riskLevelTotal != null ? riskLevelTotal[2] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(2)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(2)), riskLevelTotal != null ? riskLevelTotal[3] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(3)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(3)), riskLevelTotal != null ? riskLevelTotal[4] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(4)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(4)), riskLevelTotal != null ? riskLevelTotal[5] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(5)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(5)), riskLevelTotal != null ? riskLevelTotal[6] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(6)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(6)), riskLevelTotal != null ? riskLevelTotal[7] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(7)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(7)), riskLevelTotal != null ? riskLevelTotal[8] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(8)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(8)), riskLevelTotal != null ? riskLevelTotal[9] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(9)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(9)), currentDimensionValue, "", "1"};
        }
        return new Object[]{"", currentDimensionValue, "", totalScore, risktotal, totalidstr, riskLevelTotal != null ? riskLevelTotal[0] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(0)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(0)), riskLevelTotal != null ? riskLevelTotal[1] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(1)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(1)), riskLevelTotal != null ? riskLevelTotal[2] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(2)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(2)), riskLevelTotal != null ? riskLevelTotal[3] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(3)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(3)), riskLevelTotal != null ? riskLevelTotal[4] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(4)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(4)), riskLevelTotal != null ? riskLevelTotal[5] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(5)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(5)), riskLevelTotal != null ? riskLevelTotal[6] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(6)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(6)), riskLevelTotal != null ? riskLevelTotal[7] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(7)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(7)), riskLevelTotal != null ? riskLevelTotal[8] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(8)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(8)), riskLevelTotal != null ? riskLevelTotal[9] : 0, CollectionUtils.isEmpty((Collection)riskLevelIds.get(9)) ? "" : String.join((CharSequence)",", (Iterable<? extends CharSequence>)riskLevelIds.get(9)), "", currentDimensionValue, "1"};
    }

    private Object[] createRow(List<RiskScoreInfoBean> infolist, String maxscore, List<Long> riskLevelId) {
        RiskScoreInfoBean info = infolist.get(0);
        String[] riskLevelIds = new String[RISKLEVEL_NO.intValue()];
        int[] riskLevelTotal = new int[RISKLEVEL_NO.intValue()];
        ArrayList totalidlist = new ArrayList(infolist.size());
        Map<String, List<RiskScoreInfoBean>> datalist = infolist.stream().collect(Collectors.groupingBy(s -> s.getRisklevel()));
        Integer sumcount = RISKLEVEL_NO;
        if (riskLevelId.size() < RISKLEVEL_NO) {
            sumcount = riskLevelId.size();
        }
        for (int i = 0; i < sumcount; ++i) {
            String id = String.valueOf(riskLevelId.get(i));
            if (datalist.get(id) == null) continue;
            riskLevelTotal[i] = datalist.get(id).size();
            List risklevetotal = datalist.get(id).stream().map(e -> e.getRiskId().toString()).collect(Collectors.toList());
            if (risklevetotal.size() <= 0) continue;
            totalidlist.addAll(risklevetotal);
            riskLevelIds[i] = String.join((CharSequence)",", risklevetotal);
        }
        int risktotal = 0;
        for (int i = 0; i < riskLevelTotal.length - 1; ++i) {
            risktotal += riskLevelTotal[i];
        }
        String totalids = String.join((CharSequence)",", totalidlist);
        BigDecimal score = BigDecimal.ZERO;
        BigDecimal maxvalue = new BigDecimal(maxscore);
        for (RiskScoreInfoBean obj : infolist) {
            score = score.add(obj.getTotalscore());
        }
        score = score.divide(maxvalue, 2, 4);
        Object[] result = new Object[]{info.getArea(), info.getIndustry(), info.getOrg(), score.toString(), risktotal, totalids, riskLevelTotal != null ? riskLevelTotal[0] : 0, riskLevelIds != null && riskLevelIds[0] != null ? riskLevelIds[0] : "", riskLevelTotal != null ? riskLevelTotal[1] : 0, riskLevelIds != null && riskLevelIds[1] != null ? riskLevelIds[1] : "", riskLevelTotal != null ? riskLevelTotal[2] : 0, riskLevelIds != null && riskLevelIds[2] != null ? riskLevelIds[2] : "", riskLevelTotal != null ? riskLevelTotal[3] : 0, riskLevelIds != null && riskLevelIds[3] != null ? riskLevelIds[3] : "", riskLevelTotal != null ? riskLevelTotal[4] : 0, riskLevelIds != null && riskLevelIds[4] != null ? riskLevelIds[4] : "", riskLevelTotal != null ? riskLevelTotal[5] : 0, riskLevelIds != null && riskLevelIds[5] != null ? riskLevelIds[5] : "", riskLevelTotal != null ? riskLevelTotal[6] : 0, riskLevelIds != null && riskLevelIds[6] != null ? riskLevelIds[6] : "", riskLevelTotal != null ? riskLevelTotal[7] : 0, riskLevelIds != null && riskLevelIds[7] != null ? riskLevelIds[7] : "", riskLevelTotal != null ? riskLevelTotal[8] : 0, riskLevelIds != null && riskLevelIds[8] != null ? riskLevelIds[8] : "", riskLevelTotal != null ? riskLevelTotal[9] : 0, riskLevelIds != null && riskLevelIds[9] != null ? riskLevelIds[9] : "", info.getArea(), info.getIndustry(), "0"};
        return result;
    }

    private Map<Long, BigDecimal> getAnalysisSchemePercent(Date enddate) {
        QFilter enableFilter;
        Date date = DateUtils.getDayFirst((Date)enddate);
        HashMap<Long, BigDecimal> percentmap = new HashMap<Long, BigDecimal>();
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)date).and(new QFilter("enddate", ">=", (Object)date));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)RISK_ANALYSIS_SCHEME, (String)"id,entryentity.riskdefinition,entryentity.percent", (QFilter[])new QFilter[]{dateFilter, enableFilter = new QFilter(ENABLE, "=", (Object)"1")});
        if (colls != null && colls.size() > 0) {
            for (DynamicObject col : colls) {
                percentmap.put(col.getLong("entryentity.riskdefinition"), col.getBigDecimal("entryentity.percent"));
            }
        }
        return percentmap;
    }

    private String getCurrentMaxScore(Date enddate) {
        Date date = DateUtils.getDayFirst((Date)enddate);
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date).and(new QFilter("invaliddate", ">=", (Object)date));
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        DynamicObject object = QueryServiceHelper.queryOne((String)RISK_SCORE_SCHEME, (String)"id,maxscore", (QFilter[])new QFilter[]{dateFilter, enableFilter});
        if (object == null) {
            return null;
        }
        return object.getString("maxscore");
    }

    private List<QFilter> getFilter(FilterInfo filterInfo, List<Long> riskLevelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List list = filterInfo.getFilterItems();
        if (CollectionUtils.isNotEmpty(riskLevelId)) {
            qFilters.add(new QFilter("rlevel.id", "in", riskLevelId));
        }
        for (FilterItemInfo filter : list) {
            if (null == filter || null == filter.getValue()) continue;
            QFilter qFilter = null;
            String name = filter.getPropName();
            if ("ids".equalsIgnoreCase(name)) {
                qFilters.clear();
                qFilters.add(new QFilter("id", "in", filter.getValue()));
                return qFilters;
            }
            switch (name) {
                case "orgs": {
                    List orglist = (List)filter.getValue();
                    qFilter = new QFilter("runorg", "in", (Object)orglist);
                    break;
                }
                case "startdate": {
                    qFilter = new QFilter("enddate", ">=", filter.getValue());
                    break;
                }
                case "enddate": {
                    qFilter = new QFilter("enddate", "<=", filter.getValue());
                    break;
                }
            }
            if (qFilter == null) continue;
            qFilters.add(qFilter);
        }
        return qFilters;
    }

    private DataSet getEmptyResult() {
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }
}

