/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.servicehelper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.instance.Instance;
import kd.taxc.tctrc.common.element.ElementCalculateService;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.task.ElementDoCalTask;
import kd.taxc.tctrc.common.task.ElementThreadTaskService;
import kd.taxc.tctrc.common.task.helper.EleCheckPlanHelper;
import kd.taxc.tctrc.common.task.helper.TdmEleCalDailogHelper;
import kd.taxc.tctrc.common.task.helper.TdmEleCheckPlanHelper;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new ConcurrentHashMap<String, String>();

    private static String getCanonicalName(Class clz) {
        return clz.getCanonicalName();
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%1$s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u5728%2$s: %3$s\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-tctrc-servicehelper", (Object[])new Object[0]), serviceName, Instance.getClusterName(), Instance.getAppName()));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("InvoiceTypeUpgradeServiceTctrc", "kd.taxc.tctrc.formplugin.upgrade.InvoiceTypeUpgradeService");
        serviceMap.put("TaxTypeUpgradeServiceTctrc", "kd.taxc.tctrc.formplugin.upgrade.TaxTypeUpgradeService");
        serviceMap.put("TctrcRiskSharingUpgradeService", "kd.taxc.tctrc.formplugin.upgrade.TctrcRiskSharingUpgradeService");
        serviceMap.put("TctrcRiskReCal", "kd.taxc.tctrc.common.util.biz.TctrcRiskCalUtil");
        serviceMap.put("TctrcRiskSharingReCal", "kd.taxc.tctrc.interfaces.TctrcRiskSharingTask");
        serviceMap.put("EleAutoUpdate", "kd.taxc.tctrc.common.task.ElementThreadTaskService");
        serviceMap.put("ElementSqlService", ServiceFactory.getCanonicalName(ElementSqlService.class));
        serviceMap.put("EleCheckPlanHelper", ServiceFactory.getCanonicalName(EleCheckPlanHelper.class));
        serviceMap.put("ElementThreadTaskService", ServiceFactory.getCanonicalName(ElementThreadTaskService.class));
        serviceMap.put("ElementDoCalTask", ServiceFactory.getCanonicalName(ElementDoCalTask.class));
        serviceMap.put("TdmEleCheckPlanHelper", ServiceFactory.getCanonicalName(TdmEleCheckPlanHelper.class));
        serviceMap.put("TdmEleCalDailogHelper", ServiceFactory.getCanonicalName(TdmEleCalDailogHelper.class));
        serviceMap.put("RiskOffetUpgradeService", "kd.taxc.tctrc.mservice.upgrade.RiskOffetUpgradeService");
        serviceMap.put("TctrcDefinitionUpgradeService", "kd.taxc.tctrc.mservice.upgrade.TctrcDefinitionUpgradeService");
        serviceMap.put("TctrcRiskResulHandleOptionUpgradeService", "kd.taxc.tctrc.mservice.upgrade.TctrcRiskResulHandleOptionUpgradeService");
        serviceMap.put("ElementCalculateService", ServiceFactory.getCanonicalName(ElementCalculateService.class));
        serviceMap.put("TctrcRiskConvertToElementUpgradeService", "kd.taxc.tctrc.mservice.upgrade.TctrcRiskConvertToElementUpgradeService");
        serviceMap.put("RiskService", "kd.taxc.tctrc.mservice.risk.RiskServiceImpl");
        serviceMap.put("RiskCalculateService", "kd.taxc.tctrc.mservice.risk.RiskCalculateServiceImpl");
    }
}

