/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class RiskCalTask
extends AbstractTask {
    private Log logger = LogFactory.getLog(RiskCalTask.class);
    public static final String RISK_RUN_LIST = "tctrc_risk_run_list";

    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        this.task(this.getRunIdList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void task(List<Long> list) {
        if (EmptyCheckUtils.isEmpty(list)) {
            return;
        }
        Map eleCode2InfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        try (TXHandle txHandle = TX.required();){
            this.logger.info("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u3002");
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)RISK_RUN_LIST);
            int month = Calendar.getInstance().get(2) + 1;
            ArrayList<Long> hasRightOrgIds = new ArrayList<Long>(10);
            ArrayList<Long> noRightOrgIds = new ArrayList<Long>(10);
            Long count = 0L;
            for (Long id : list) {
                Date endDate;
                Date startdate;
                DynamicObject objArray = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
                Long orgid = objArray.getLong("runorg.id");
                if (noRightOrgIds.contains(orgid)) {
                    this.logger.info("\u8df3\u8fc7\u8bb0\u5f55 fid [" + id + "] ,\u8bb0\u5f55\u7684\u8fd0\u884c\u7ec4\u7ec7\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
                    continue;
                }
                if (!hasRightOrgIds.contains(orgid)) {
                    if (this.licenseCheck(objArray)) {
                        noRightOrgIds.add(orgid);
                        this.logger.info("\u8df3\u8fc7\u8bb0\u5f55 fid [" + id + "] ,\u8bb0\u5f55\u7684\u8fd0\u884c\u7ec4\u7ec7\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743");
                        continue;
                    }
                    hasRightOrgIds.add(orgid);
                }
                ArrayList resultList = new ArrayList(10);
                DynamicObject risk = objArray.getDynamicObject("risk");
                String caltype = risk.getString("caltype");
                String runmonth = objArray.getString("month");
                String desc = ResManager.loadKDString((String)"\u5b9a\u65f6\u8ba1\u7b97\u8fd0\u884c", (String)"RiskCalTask_0", (String)"taxc-tctrc-business", (Object[])new Object[0]);
                if (caltype.equals(TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType())) {
                    RiskService.cal(null, resultList, (DynamicObject[])new DynamicObject[]{objArray}, (Date)DateUtils.getFirstDateOfMonth((Date)new Date()), (Date)DateUtils.getLastDateOfMonth((Date)new Date()), (String)desc, (Boolean)Boolean.TRUE, (Map)eleCode2InfoMap);
                } else if (caltype.equals(TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType())) {
                    if (runmonth.equals(month % 3 + "") || runmonth.equals("3") && month % 3 == 0) {
                        startdate = DateUtils.getFirstDateOfSeason((Date)new Date());
                        endDate = DateUtils.getLastDateOfSeason((Date)new Date());
                        RiskService.cal(null, resultList, (DynamicObject[])new DynamicObject[]{objArray}, (Date)startdate, (Date)endDate, (String)desc, (Boolean)Boolean.TRUE, (Map)eleCode2InfoMap);
                    }
                } else if (caltype.equals(TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType())) {
                    if (runmonth.equals(month + "")) {
                        startdate = DateUtils.getFirstDateOfYear((Date)new Date());
                        Date endData = DateUtils.getLastDateOfYear((Date)new Date());
                        RiskService.cal(null, resultList, (DynamicObject[])new DynamicObject[]{objArray}, (Date)startdate, (Date)endData, (String)desc, (Boolean)Boolean.TRUE, (Map)eleCode2InfoMap);
                    }
                } else if (caltype.equals(TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType()) && (runmonth.equals(month % 6 + "") || runmonth.equals("6") && month % 6 == 0)) {
                    startdate = DateUtils.getFirstDateOfHalfYear((Date)new Date());
                    endDate = DateUtils.getLastDateOfHalfYear((Date)new Date());
                    RiskService.cal(null, resultList, (DynamicObject[])new DynamicObject[]{objArray}, (Date)startdate, (Date)endDate, (String)ResManager.loadKDString((String)"\u5b9a\u65f6\u8ba1\u7b97\u8fd0\u884c", (String)"RiskCalTask_0", (String)"taxc-tctrc-business", (Object[])new Object[0]), (Boolean)Boolean.TRUE, (Map)eleCode2InfoMap);
                }
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
            }
            this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f : \u4e00\u5171\u6267\u884c\u3010" + count + "\u3011\u6761,\u8df3\u8fc7\u3010" + ((long)list.size() - count) + "\u3011\u6761\u3002\u5171\u8ba1\u3010" + list.size() + "\u3011\u6761");
            this.logger.info("\u7ed3\u675f");
        }
    }

    private boolean licenseCheck(DynamicObject object) {
        if (LicenseCheckServiceHelper.check((Object)object.getString("runorg.id"), null, (String)"tctrc")) {
            return true;
        }
        this.logger.info("license\u6821\u9a8c\u901a\u8fc7 orgid" + object.getString("runorg.id"));
        return false;
    }

    private List<Long> getRunIdList() {
        Calendar cale = Calendar.getInstance();
        int day = cale.get(5);
        QFilter enrollFilter = new QFilter("day", "=", (Object)(day + ""));
        QFilter issbshowFilter = new QFilter("risk.issbshow", "=", (Object)BooleanEnum.NO.getCode());
        List list = QueryServiceHelper.queryPrimaryKeys((String)RISK_RUN_LIST, (QFilter[])new QFilter[]{enrollFilter, issbshowFilter}, null, (int)-1);
        return list.stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
    }
}

