/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.checkup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.tctrc.business.checkup.TctrcImportBuiness;
import kd.taxc.tctrc.business.org.TaxOrgTakeRelationBussiness;
import kd.taxc.tctrc.common.enums.MultiLangEnumBridge;

public enum ImportDeclareReportEnum {
    CWBB_ZCFZB("zcfzb", new MultiLangEnumBridge("\u8d44\u4ea7\u8d1f\u503a\u8868", "ImportDeclareReportEnum_0", "taxc-tctrc-business"), "tdm_finance_import", "tcvvt_main_declare_list", null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            HashSet typelist = new HashSet(2);
            if (orgId != null && orgId != 0L) {
                Map<Long, List<Long>> orgRelationMapByTaxOrgs = TaxOrgTakeRelationBussiness.getOrgRelationMapByTaxOrgsAndView(Collections.singletonList(orgId), start, end, "10");
                List<Long> orgIdList = orgRelationMapByTaxOrgs.get(orgId);
                orgIdList.stream().forEach(o -> {
                    List<Long> ids = TctrcImportBuiness.queryBaseData(orgId, new QFilter("templatetype", "=", (Object)"zcfzb"));
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(ids)) {
                        typelist.addAll(ids);
                    }
                });
            } else {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"tdm_finance_template", (String)"id", (QFilter[])new QFilter[]{new QFilter("templatetype", "=", (Object)"zcfzb")});
                List ids = Arrays.asList(load).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(ids)) {
                    typelist.addAll(ids);
                }
            }
            map.put("templatetypelist", typelist);
            return map;
        }
    }
    ,
    CWBB_LRB("lrb", new MultiLangEnumBridge("\u5229\u6da6\u8868", "ImportDeclareReportEnum_1", "taxc-tctrc-business"), "tdm_finance_import", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            HashSet typelist = new HashSet(2);
            if (orgId != null && orgId != 0L) {
                Map<Long, List<Long>> orgRelationMapByTaxOrgs = TaxOrgTakeRelationBussiness.getOrgRelationMapByTaxOrgsAndView(Collections.singletonList(orgId), start, end, "10");
                List<Long> orgIdList = orgRelationMapByTaxOrgs.get(orgId);
                orgIdList.stream().forEach(o -> {
                    List<Long> ids = TctrcImportBuiness.queryBaseData(orgId, new QFilter("templatetype", "=", (Object)"lrb"));
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(ids)) {
                        typelist.addAll(ids);
                    }
                });
            } else {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"tdm_finance_template", (String)"id", (QFilter[])new QFilter[]{new QFilter("templatetype", "=", (Object)"lrb")});
                List ids = Arrays.asList(load).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(ids)) {
                    typelist.addAll(ids);
                }
            }
            map.put("templatetypelist", typelist);
            return map;
        }
    }
    ,
    TCVVT_CWBB("tcvvt_cwbb", new MultiLangEnumBridge("\u7a0e\u5c40\u7248\u8d22\u52a1\u62a5\u8868", "ImportDeclareReportEnum_2", "taxc-tctrc-business"), "bdtaxr_import_dialog_new", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            ArrayList<String> typelist = new ArrayList<String>(2);
            typelist.add("FR0001");
            typelist.add("FR0002");
            typelist.add("FR0003");
            typelist.add("FR0004");
            typelist.add("FR0011");
            map.put("templatetypelist", typelist);
            return map;
        }
    }
    ,
    ZZSSBB("zzssbb", new MultiLangEnumBridge("\u589e\u503c\u7a0e\u7533\u62a5\u8868", "ImportDeclareReportEnum_3", "taxc-tctrc-business"), "bdtaxr_import_dialog_new", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            return this.getCustomParamByTaxTypeEnum("tcvat");
        }
    }
    ,
    TCCITYJ("tccit_yj", new MultiLangEnumBridge("\u4f01\u4e1a\u6240\u5f97\u7a0e\u9884\u7f34\u7533\u62a5\u8868", "ImportDeclareReportEnum_4", "taxc-tctrc-business"), "bdtaxr_import_dialog_new", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            return this.getCustomParamByTaxTypeEnum("tccit_yj");
        }
    }
    ,
    TCCITHJ("tccit_hj", new MultiLangEnumBridge("\u4f01\u4e1a\u6240\u5f97\u7a0e\u6c47\u7b97\u6e05\u7f34", "ImportDeclareReportEnum_5", "taxc-tctrc-business"), "bdtaxr_import_dialog_new", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            return this.getCustomParamByTaxTypeEnum("tccit_hj");
        }
    }
    ,
    TCRET_CXS("tcret_cxs", new MultiLangEnumBridge("\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e\u7533\u62a5\u8868", "ImportDeclareReportEnum_6", "taxc-tctrc-business"), "bdtaxr_import_dialog_new", null, null){

        @Override
        public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            ArrayList<String> typelist = new ArrayList<String>(2);
            typelist.add("ccxws");
            map.put("templatetypelist", typelist);
            return map;
        }
    };

    private String number;
    private MultiLangEnumBridge name;
    private String importDialog;
    private String table;
    private MultiLangEnumBridge description;

    public Map<String, Object> getCustomParamByTaxTypeEnum(String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        TaxTypeEnum taxTypeEnum = TaxTypeEnum.valueOfAppId((String)type);
        List<Object> typelist = new ArrayList(2);
        if (!ObjectUtils.isEmpty((Object)taxTypeEnum)) {
            typelist = Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        map.put("templatetypelist", typelist);
        return map;
    }

    public Map<String, Object> getCustomParam(Long orgId, Date start, Date end) {
        return new HashMap<String, Object>(2);
    }

    public static ImportDeclareReportEnum getImportDeclareReportEnumByNumber(String number) {
        ImportDeclareReportEnum[] importDeclareReportEnums;
        for (ImportDeclareReportEnum importDeclareReportEnum : importDeclareReportEnums = ImportDeclareReportEnum.values()) {
            if (!importDeclareReportEnum.number.equalsIgnoreCase(number)) continue;
            return importDeclareReportEnum;
        }
        return null;
    }

    private ImportDeclareReportEnum(String number, MultiLangEnumBridge name, String importDialog, String table, MultiLangEnumBridge description) {
        this.number = number;
        this.name = name;
        this.importDialog = importDialog;
        this.table = table;
        this.description = description;
    }

    public String getNumber() {
        return this.number;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public String getImportDialog() {
        return this.importDialog;
    }

    public String getTable() {
        return this.table;
    }

    public MultiLangEnumBridge getDescription() {
        return this.description;
    }
}

