/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.checkup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.business.riskdefinition.ElementVerifyBusiness;
import kd.taxc.tctrc.business.riskdefinition.RiskNumberBusiness;
import kd.taxc.tctrc.business.riskdefinition.RiskSamplingBusiness;
import kd.taxc.tctrc.business.tctrc.TctrcResultRecordsBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.helper.RiskNumberHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TctrcRiskIndexBusiness {
    private static final String ENTRYENTITY = "entryentity";

    public static Map<String, Object> selectData(Long org, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("entryentity1.orgid", "=", (Object)org);
        QFilter startdateFilter = new QFilter("startdate", "<=", (Object)startDate);
        QFilter enddateFilter = new QFilter("enddate", ">=", (Object)endDate);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isShowFilter = new QFilter("entryentity.isshow", "=", (Object)"1");
        DynamicObjectCollection object = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition,entryentity1.orgid", (QFilter[])new QFilter[]{qFilter.and(startdateFilter).and(enddateFilter).and(enableFilter).and(isShowFilter)});
        if (CollectionUtils.isEmpty((Collection)object)) {
            object = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition,entryentity1.orgid", (QFilter[])new QFilter[]{new QFilter("entryentity1.orgid", "is null", null).and(startdateFilter).and(enddateFilter).and(enableFilter).and(isShowFilter)});
        }
        Set riskcheckSet = object.stream().map(v -> v.getLong("entryentity.riskdefinition")).collect(Collectors.toSet());
        DynamicObjectCollection runobject = QueryServiceHelper.query((String)"tctrc_risk_run_list", (String)"id,risk,runorg", (QFilter[])new QFilter[]{new QFilter("runorg", "=", (Object)org), new QFilter("risk", "in", riskcheckSet)});
        Set riskSet = runobject.stream().map(v -> v.getLong("risk")).collect(Collectors.toSet());
        DynamicObjectCollection resultObject = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id,risk,risk.resultshow,risk.bmvalue,datestring,rlevel.name,rlevel.id,startdate,result", (QFilter[])new QFilter[]{new QFilter("risk", "in", riskSet), new QFilter("runorg", "=", (Object)org), new QFilter("rlevel.id", "not in", Arrays.asList(5, 4)), new QFilter("startdate", ">=", (Object)startDate), new QFilter("enddate", "<=", (Object)endDate)});
        Map<Long, List<DynamicObject>> riskGroup = resultObject.stream().sorted(Comparator.comparing(v -> v.getDate("startdate"))).collect(Collectors.groupingBy(s -> s.getLong("risk")));
        Set<Long> resultRiskSet = resultObject.stream().map(v -> v.getLong("risk")).collect(Collectors.toSet());
        Set<Long> resultIdSet = resultObject.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] numberObject = RiskNumberBusiness.getRiskNumber(resultRiskSet);
        DynamicObject[] verifyObject = ElementVerifyBusiness.getElementVerify(resultRiskSet);
        DynamicObject[] samplingObject = RiskSamplingBusiness.getRiskSampling(resultRiskSet);
        HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
        Map<Long, String> recordMap = TctrcRiskIndexBusiness.getRecords(resultIdSet);
        returnMap.put("recordMap", recordMap);
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        TctrcRiskIndexBusiness.getMap(numberObject, riskGroup, resultMap);
        TctrcRiskIndexBusiness.getMap(verifyObject, riskGroup, resultMap);
        TctrcRiskIndexBusiness.getMap(samplingObject, riskGroup, resultMap);
        returnMap.put("resultMap", resultMap);
        return returnMap;
    }

    private static Map<Long, String> getRecords(Set<Long> resultIdSet) {
        DynamicObject[] recordsLoad = TctrcResultRecordsBusiness.getTctrcResultRecordsBus4(new QFilter("resultid", "in", resultIdSet));
        Map<Long, List<DynamicObject>> recordsGroup = Arrays.stream(recordsLoad).collect(Collectors.groupingBy(s -> s.getLong("resultid")));
        HashMap<Long, String> records = new HashMap<Long, String>(10);
        for (Map.Entry<Long, List<DynamicObject>> map : recordsGroup.entrySet()) {
            List existSet = map.getValue().stream().map(v -> v.getString("exist")).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(existSet) || existSet.size() != 1) continue;
            records.put(map.getKey(), (String)existSet.get(0));
        }
        return records;
    }

    private static void getMap(DynamicObject[] numberObject, Map<Long, List<DynamicObject>> riskGroup, Map<Long, Map<String, Object>> resultMap) {
        if (numberObject != null && numberObject.length > 0) {
            DynamicObjectCollection tdmobj = TdmElementGroupBusiness.getTdmElementGroupQuery(new QFilter("enable", "!=", (Object)"0"));
            for (DynamicObject dynamicObject : numberObject) {
                if (CollectionUtils.isEmpty((Collection)riskGroup.get(dynamicObject.getLong("id")))) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (RiskTypeEnum.NUMBER.getKey().equals(dynamicObject.getString("risktype"))) {
                    map.put("expression", RiskNumberHelper.transformNumberToName((String)dynamicObject.getString("json"), (Long)dynamicObject.getLong("id"), (DynamicObjectCollection)tdmobj));
                } else if (RiskTypeEnum.VERIFY.getKey().equals(dynamicObject.getString("risktype"))) {
                    map.put("expression", dynamicObject.getDynamicObjectCollection(ENTRYENTITY).stream().map(v -> v.getString("text")).collect(Collectors.joining(HealthUtil.getAnd())));
                } else if (RiskTypeEnum.SAMPLING.getKey().equals(dynamicObject.getString("risktype"))) {
                    map.put("expression", dynamicObject.getDynamicObjectCollection(ENTRYENTITY).stream().map(v -> v.getString("tableid.bizname") + " : " + v.get("text")).collect(Collectors.joining(HealthUtil.getAnd())));
                }
                map.put("name", dynamicObject.getString("name"));
                if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("describe"))) {
                    map.put("describe", dynamicObject.getString("describe"));
                }
                map.put("detail", riskGroup.get(dynamicObject.getLong("id")));
                map.put("risktype", dynamicObject.getString("risktype"));
                map.put("guideentity2", dynamicObject.getDynamicObjectCollection("guideentity2"));
                map.put("guideentity21", dynamicObject.getDynamicObjectCollection("guideentity21"));
                resultMap.put(dynamicObject.getLong("id"), map);
            }
        }
    }
}

