/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.integrate;

import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tctrc.business.integrate.ExternalSystemIntegrateService;
import kd.taxc.tctrc.business.integrate.xinke.XinkeIntegrateServiceImpl;

public class ExternalSystemIntegrateServiceFactory {
    public static ExternalSystemIntegrateService getExternalSystemIntegrateServiceByConfig(DynamicObject externalSysConfig) {
        String systemCode = externalSysConfig.getString("number");
        ExternalSystemEnum externalSystemEnum = ExternalSystemEnum.getEnumBySystemCode(systemCode);
        if (externalSystemEnum == null) {
            return null;
        }
        return externalSystemEnum.getServiceFunc().apply(externalSysConfig);
    }

    static enum ExternalSystemEnum {
        XIN_KE("xinke", config -> new XinkeIntegrateServiceImpl((DynamicObject)config));

        private String systemCode;
        private Function<DynamicObject, ExternalSystemIntegrateService> serviceFunc;

        private ExternalSystemEnum(String systemCode, Function<DynamicObject, ExternalSystemIntegrateService> serviceFunc) {
            this.systemCode = systemCode;
            this.serviceFunc = serviceFunc;
        }

        public String getSystemCode() {
            return this.systemCode;
        }

        public Function<DynamicObject, ExternalSystemIntegrateService> getServiceFunc() {
            return this.serviceFunc;
        }

        public static ExternalSystemEnum getEnumBySystemCode(String systemCode) {
            for (ExternalSystemEnum value : ExternalSystemEnum.values()) {
                if (!value.getSystemCode().equals(systemCode)) continue;
                return value;
            }
            return null;
        }
    }
}

