/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.integrate.xinke;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.fintech.client.DefaultKdClient;
import com.kingdee.fintech.request.base.DefaultKdRequest;
import com.kingdee.fintech.request.base.KdRequest;
import com.kingdee.fintech.request.info.RequestInfo;
import com.kingdee.fintech.response.api.KdResponse;
import com.kingdee.fintech.support.app.AppConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.tctrc.business.integrate.ExternalSystemIntegrateService;
import kd.taxc.tctrc.business.integrate.xinke.XinkeRequest;
import kd.taxc.tctrc.common.entity.integrate.XinkeConfigJsonObject;
import kd.taxc.tctrc.common.entity.integrate.XinkeTokenResponse;

public class XinkeIntegrateServiceImpl
implements ExternalSystemIntegrateService {
    private Log log = LogFactory.getLog(XinkeIntegrateServiceImpl.class);
    private XinkeConfigJsonObject configJsonObject;

    public XinkeIntegrateServiceImpl(DynamicObject configObject) {
        String json = configObject.getString("configjson_tag");
        this.configJsonObject = (XinkeConfigJsonObject)JSONObject.parseObject((String)json, XinkeConfigJsonObject.class);
    }

    @Override
    public String getPageUrl() {
        String token = this.getToken();
        String finalTaskId = UUID.randomUUID().replace("-", "");
        String openId = finalTaskId.substring(3, 31);
        String returnUrl = this.getReturnUrl(token, openId);
        try {
            returnUrl = URLEncoder.encode(this.configJsonObject.getDomain() + returnUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("kd.taxc.tctrc.business.integrate.xinke.XinkeIntegrateServiceImpl.getPageUrl===error:{}", (Object)e.getMessage());
        }
        String taxInvoiceCollectionUrl = this.configJsonObject.getTaxInvoiceCollectionUrl();
        taxInvoiceCollectionUrl = taxInvoiceCollectionUrl.replace("${clientId}", this.configJsonObject.getClientId()).replace("${token}", token).replace("${openId}", openId).replace("${finTaskId}", finalTaskId).replace("${phone}", "").replace("${returnUrl}", returnUrl);
        return this.configJsonObject.getDomain() + taxInvoiceCollectionUrl;
    }

    @Override
    public String getToken() {
        KdResponse response;
        DefaultKdClient defaultKdClient = new DefaultKdClient(this.getAppConfig());
        XinkeRequest request = new XinkeRequest(this.configJsonObject);
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("client_id", this.configJsonObject.getClientId());
        params.put("client_secret", this.configJsonObject.getClientSecret());
        DefaultKdRequest kdRequest = new DefaultKdRequest((RequestInfo)request, params);
        try {
            response = defaultKdClient.execute((KdRequest)kdRequest);
            this.log.info("====kd.taxc.tctrc.business.integrate.xinke.XinkeIntegrateServiceImpl.getToken===response:{}", (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.log.error("====kd.taxc.tctrc.business.integrate.xinke.XinkeIntegrateServiceImpl.getToken===error:{}", (Object)e.getMessage());
            return "";
        }
        if (response.getStatus().equals("200")) {
            XinkeTokenResponse responseData = (XinkeTokenResponse)response.getData();
            return responseData.getToken();
        }
        return "";
    }

    private AppConfig getAppConfig() {
        AppConfig appConfig = new AppConfig();
        appConfig.setAppId(this.configJsonObject.getClientId());
        appConfig.setAppPassword(this.configJsonObject.getClientSecret());
        appConfig.setAppPrivateKey(this.configJsonObject.getClientPrivateKey());
        appConfig.setAppPublicKey(this.configJsonObject.getClientPublicKey());
        appConfig.setDomain(this.configJsonObject.getDomain());
        appConfig.setKdPublicKey(this.configJsonObject.getPublicKey());
        appConfig.setVersion(this.configJsonObject.getVersion());
        return appConfig;
    }

    private String getReturnUrl(String token, String openId) {
        String returnUrl = this.configJsonObject.getReturnUrl();
        return returnUrl.replace("${clientId}", this.configJsonObject.getClientId()).replace("${token}", token).replace("${openId}", openId).replace("${hideAccess}", "");
    }
}

