/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.mq.consumer;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.taxc.bdtaxr.common.enums.TableTypeMapTemplateTypeEnum;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.oversea.MessageSceneType;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessage;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessageData;
import kd.taxc.tctrc.common.entity.EleUpdateBean;
import kd.taxc.tctrc.common.task.ElementThreadTaskService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.biz.EleAutoUpdateUtil;

public class EleAutoUpdateConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(EleAutoUpdateConsumer.class);

    private static EleUpdateBean applyConvertOverSeaDraftBean(OverSeaDraftMQMessageData v) {
        return new EleUpdateBean(v.getTableType(), v.getOrg(), EleAutoUpdateUtil.transformStartDate((String)DateUtils.format((Date)v.getSkssqq())), EleAutoUpdateUtil.transformEndDate((String)DateUtils.format((Date)v.getSkssqz())), String.valueOf(v.getId()), v.getDraftpurpose());
    }

    private static EleUpdateBean applyConvertBean(DeclareMQMessageData v) {
        return new EleUpdateBean(v.getTableType(), v.getOrg(), EleAutoUpdateUtil.transformStartDate((String)v.getSkssqq()), EleAutoUpdateUtil.transformEndDate((String)v.getSkssqz()), v.getSbbid(), null);
    }

    public String getRouteKey() {
        return null;
    }

    public void onMessage(Object body, String messageId, boolean b, MessageAcker acker) {
        try {
            logger.info("enter EleAutoUpdateConsumer onMessage");
            String str = (String)body;
            logger.info(str);
            if (str.contains(MessageSceneType.OVERSEADRAFT.name()) || str.contains(MessageSceneType.ACCRUALDRAFT.name())) {
                String topic;
                OverSeaDraftMQMessage message = (OverSeaDraftMQMessage)SerializationUtils.fromJsonString((String)str, OverSeaDraftMQMessage.class);
                String event = message.getEvent();
                if (EleAutoUpdateUtil.checkHandleMessageOverSea((String)event, (String)(topic = message.getTopic())) && EmptyCheckUtils.isNotEmpty((Object)message.getOverSeaDraftMQMessageData())) {
                    message.getOverSeaDraftMQMessageData().stream().map(EleAutoUpdateConsumer::applyConvertOverSeaDraftBean).distinct().forEach(v -> EleAutoUpdateConsumer.acceptEleAutoUpdateBean(v, topic));
                }
            } else {
                String topic;
                DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)str, DeclareMQMessage.class);
                String event = declareMQMessage.getEvent();
                if (EleAutoUpdateUtil.checkHandleMessage((String)event, (String)(topic = declareMQMessage.getTopic())) && EmptyCheckUtils.isNotEmpty((Object)declareMQMessage.getData())) {
                    declareMQMessage.getData().stream().map(EleAutoUpdateConsumer::applyConvertBean).distinct().forEach(v -> EleAutoUpdateConsumer.acceptEleAutoUpdateBean(v, topic));
                }
            }
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            }
            acker.deny(messageId);
        }
    }

    private static void acceptEleAutoUpdateBean(EleUpdateBean v, String topic) {
        if (EmptyCheckUtils.isNotEmpty((Object)v)) {
            if (StringUtil.equals((CharSequence)v.getTableType(), (CharSequence)TableTypeMapTemplateTypeEnum.CCXWS.getTableType())) {
                if (StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.PAY.name())) {
                    ElementThreadTaskService.executorElement((String)String.valueOf(v.getOrg()), (String)v.getSkssqq(), (String)v.getSkssqq(), (String)v.getSkssqz(), (String)v.getTableType(), (String)v.getDraftpurpose());
                } else {
                    HashSet resultSet = EleAutoUpdateUtil.mergePeriods((EleUpdateBean)v);
                    for (String result : resultSet) {
                        String[] split = result.split("#");
                        ElementThreadTaskService.executorElement((String)String.valueOf(v.getOrg()), (String)split[0], (String)split[0], (String)split[1], (String)v.getTableType(), (String)v.getDraftpurpose());
                    }
                }
            } else {
                ElementThreadTaskService.executorElement((String)String.valueOf(v.getOrg()), (String)v.getSkssqq(), (String)v.getSkssqq(), (String)v.getSkssqz(), (String)v.getTableType(), (String)v.getDraftpurpose());
            }
        }
    }
}

