/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.tctrc.business.license.TctrcLicenseCheckBusiness;

public class TctrcTaxorgCommonBusiness {
    public static final String allFlagOne = "1";

    public static Boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        TaxResult taxResult = PermDataServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)entityNum, (String)permItemId);
        boolean hasSpecificPerm = false;
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            hasSpecificPerm = (Boolean)taxResult.getData();
        }
        return hasSpecificPerm;
    }

    public static TaxResult<List<Long>> getAllOrg() {
        return TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber(), (boolean)true);
    }

    public static TaxResult<Boolean> isOrg(Long orgId) {
        return TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)orgId);
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayerWithPerm() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), null, (boolean)false);
        if (taxResult != null && taxResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResult.getData()))) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static void fseven(BeforeF7SelectEvent event, Boolean multiSelect, String allFlag) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"TctrcTaxorgCommonBusiness_0", (String)"taxc-tctrc-business", (Object[])new Object[0]));
        List<Long> orgIds = org.apache.commons.lang3.StringUtils.equals((CharSequence)allFlag, (CharSequence)allFlagOne) ? TctrcTaxorgCommonBusiness.getOrgTaxpayerAllLists() : TctrcTaxorgCommonBusiness.getOrgTaxpayerLists();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        if (TctrcLicenseCheckBusiness.isCheckLicense()) {
            Map<Long, Boolean> licenseBatchCheck = TctrcLicenseCheckBusiness.orgLicenseBatchCheck(orgIds);
            ArrayList<Long> filterOrgIds = new ArrayList<Long>(12);
            if (!ObjectUtils.isEmpty(licenseBatchCheck)) {
                for (Long orgId : orgIds) {
                    if (!licenseBatchCheck.containsKey(orgId) || licenseBatchCheck.get(orgId).booleanValue()) continue;
                    filterOrgIds.add(orgId);
                }
                QFilter orgIdsFilter = new QFilter("id", "in", filterOrgIds);
                formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
            }
        } else {
            QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
            formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        }
        if (multiSelect != null) {
            formShowParameter.setMultiSelect(multiSelect.booleanValue());
        }
    }

    public static List<Long> getOrgTaxpayerAllLists() {
        TaxResult result = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdsByTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return new ArrayList<Long>();
        }
        return (List)result.getData();
    }

    public static List<Long> getOrgTaxpayerLists() {
        TaxResult result = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)RequestContext.get().getCurrUserId(), (String)OrgFuncEnum.TAX.getNumber());
        TaxResult nszt = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId());
        if (!result.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)result.getData())) || !nszt.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)nszt.getData()))) {
            return new ArrayList<Long>();
        }
        ((List)result.getData()).retainAll((Collection)nszt.getData());
        return (List)result.getData();
    }
}

