/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.riskcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.tctrc.business.riskcontrol.RiskControlDao;
import kd.taxc.tctrc.common.entity.riskcontrol.RiskControlVerifyEntity;

public class RiskControlBusiness {
    public static DynamicObjectCollection getEnableDataByOrgTaxTypeSbbType(Long riskControlId, boolean isAllOrg, List<Long> orgIds, List<Long> taxTypeIds, List<String> sbbTypeIds, String selectFields) {
        return RiskControlDao.queryByOrgTaxTypeSbbType(riskControlId, isAllOrg, orgIds, taxTypeIds, sbbTypeIds, selectFields);
    }

    public static DynamicObject[] getDataByIds(List<Long> ids, Boolean enable, String selectFields) {
        return RiskControlDao.loadDataByIds(ids, enable, selectFields);
    }

    public static DynamicObjectCollection getDisableDataByIds(List<Long> ids, String selectFields) {
        return RiskControlDao.queryDisableDataByIds(ids, selectFields);
    }

    public static DynamicObjectCollection getEnableDataByDataOrgTaxTypeSbbType(Collection<DynamicObject> riskControls, String selectFields) {
        return RiskControlDao.queryByDataOrgTaxTypeSbbType(riskControls, selectFields);
    }

    public static DynamicObject getDeclareReportMatchRiskControl(String templateTypeId, Long orgId, String draftPurpose, Long taxTypeId, String operateType, String selectFields) {
        return RiskControlDao.queryDeclareReportMatchRiskControl(templateTypeId, orgId, draftPurpose, taxTypeId, operateType, selectFields);
    }

    public static DynamicObjectCollection getDeclareReportMatchRiskControl(Map<String, String> sbbNumberIdMap, List<Map<String, Object>> parameters, String selectFields) {
        Map<String, Object> param = parameters.get(0);
        QFilter filter = RiskControlDao.buildDeclareReportMatchRiskControlFilter(sbbNumberIdMap.get(param.get("templateTypeNumber").toString()), (Long)param.get("orgId"), param.get("draftPurpose").toString(), param.get("taxTypeId") == null ? null : (Long)param.get("taxTypeId"));
        for (int i = 1; i < parameters.size(); ++i) {
            Map<String, Object> parameter = parameters.get(i);
            filter = filter.or(RiskControlDao.buildDeclareReportMatchRiskControlFilter(sbbNumberIdMap.get(parameter.get("templateTypeNumber").toString()), (Long)parameter.get("orgId"), parameter.get("draftPurpose").toString(), parameter.get("taxTypeId") == null ? null : (Long)parameter.get("taxTypeId")));
        }
        return RiskControlDao.queryData(selectFields, new QFilter[]{new QFilter("enable", "=", (Object)"1").and("controlnode", "=", (Object)param.get("operateType").toString()), filter});
    }

    public static DynamicObjectCollection getEnableRiskControl(String selectFields) {
        return RiskControlDao.queryEnableData(selectFields);
    }

    public static List<RiskControlVerifyEntity> getRiskControlVerifyResult(List<Long> orgIds, boolean isAllOrg, Map<String, String> sbbTypeIdNumberMap, Map<String, ModelVersionEnum> sbbTypeNumberVersionMap, List<Long> taxTypeIds, String draftPurpose, Collection<DynamicObject> riskControls) {
        ArrayList<RiskControlVerifyEntity> result = new ArrayList<RiskControlVerifyEntity>(16);
        HashSet<String> draftPurposeSet = new HashSet(0);
        if (StringUtils.isNotEmpty((CharSequence)draftPurpose)) {
            draftPurposeSet = Arrays.stream(draftPurpose.substring(1, draftPurpose.length() - 1).split(",")).collect(Collectors.toSet());
        }
        for (Map.Entry<String, String> sbbTypeIdNumberEntry : sbbTypeIdNumberMap.entrySet()) {
            ModelVersionEnum sbbVersionEnum = sbbTypeNumberVersionMap.get(sbbTypeIdNumberEntry.getValue());
            if (sbbVersionEnum == ModelVersionEnum.MODEL2) {
                result.addAll(RiskControlBusiness.getRiskControlVerifyResultWithVersion2(orgIds, isAllOrg, sbbTypeIdNumberEntry.getKey(), riskControls));
                continue;
            }
            for (Long taxTypeId : taxTypeIds) {
                result.addAll(RiskControlBusiness.getRiskControlVerifyResultWithVersion3(orgIds, isAllOrg, sbbTypeIdNumberEntry.getKey(), taxTypeId, riskControls, draftPurposeSet));
            }
        }
        return result;
    }

    private static List<RiskControlVerifyEntity> getRiskControlVerifyResultWithVersion2(List<Long> orgIds, boolean isAllOrg, String sbbTypeId, Collection<DynamicObject> riskControls) {
        if (isAllOrg) {
            Predicate<DynamicObject> predicate = p -> p.getString("sbbtype.fbasedataid.id").equals(sbbTypeId) && p.getBoolean("isallorg") == isAllOrg;
            DynamicObject riskControl = riskControls.stream().filter(predicate).findFirst().orElse(null);
            if (riskControl != null) {
                RiskControlVerifyEntity riskControlVerifyEntity = new RiskControlVerifyEntity(Long.valueOf(0L), "", Boolean.valueOf(true), sbbTypeId, riskControl.getString("sbbtype.fbasedataid.name"), Long.valueOf(0L), "", "2");
                ArrayList<RiskControlVerifyEntity> result = new ArrayList<RiskControlVerifyEntity>(1);
                result.add(riskControlVerifyEntity);
                return result;
            }
            return new ArrayList<RiskControlVerifyEntity>(0);
        }
        ArrayList<RiskControlVerifyEntity> result = new ArrayList<RiskControlVerifyEntity>(16);
        for (Long orgId : orgIds) {
            Predicate<DynamicObject> predicate = p -> p.getLong("entryentity.org.id") == orgId.longValue() && p.getString("sbbtype.fbasedataid.id").equals(sbbTypeId);
            DynamicObject riskControl = riskControls.stream().filter(predicate).findFirst().orElse(null);
            if (riskControl == null) continue;
            result.add(new RiskControlVerifyEntity(orgId, riskControl.getString("entryentity.org.name"), Boolean.valueOf(false), sbbTypeId, riskControl.getString("sbbtype.fbasedataid.name"), Long.valueOf(0L), "", "2"));
        }
        return result;
    }

    private static List<RiskControlVerifyEntity> getRiskControlVerifyResultWithVersion3(List<Long> orgIds, boolean isAllOrg, String sbbTypeId, Long taxTypeId, Collection<DynamicObject> riskControls, Set<String> draftPurposeSet) {
        if (isAllOrg) {
            Predicate<DynamicObject> predicate = p -> p.getString("sbbtype.fbasedataid.id").equals(sbbTypeId) && p.getBoolean("isallorg") == isAllOrg && p.getLong("taxtype.fbasedataid.id") == taxTypeId.longValue() && Arrays.stream(p.getString("draftpurpose").substring(1, p.getString("draftpurpose").length() - 1).split(",")).anyMatch(t -> draftPurposeSet.contains(t));
            DynamicObject riskControl = riskControls.stream().filter(predicate).findFirst().orElse(null);
            if (riskControl != null) {
                RiskControlVerifyEntity riskControlVerifyEntity = new RiskControlVerifyEntity(Long.valueOf(0L), "", Boolean.valueOf(true), sbbTypeId, riskControl.getString("sbbtype.fbasedataid.name"), taxTypeId, riskControl.getString("taxtype.fbasedataid.name"), "3");
                ArrayList<RiskControlVerifyEntity> result = new ArrayList<RiskControlVerifyEntity>(1);
                result.add(riskControlVerifyEntity);
                return result;
            }
            return new ArrayList<RiskControlVerifyEntity>(0);
        }
        ArrayList<RiskControlVerifyEntity> result = new ArrayList<RiskControlVerifyEntity>(16);
        for (Long orgId : orgIds) {
            Predicate<DynamicObject> predicate = p -> p.getLong("entryentity.org.id") == orgId.longValue() && p.getString("sbbtype.fbasedataid.id").equals(sbbTypeId) && p.getLong("taxtype.fbasedataid.id") == taxTypeId.longValue() && Arrays.stream(p.getString("draftpurpose").substring(1, p.getString("draftpurpose").length() - 1).split(",")).anyMatch(t -> draftPurposeSet.contains(t));
            DynamicObject riskControl = riskControls.stream().filter(predicate).findFirst().orElse(null);
            if (riskControl == null) continue;
            result.add(new RiskControlVerifyEntity(orgId, riskControl.getString("entryentity.org.name"), Boolean.valueOf(false), sbbTypeId, riskControl.getString("sbbtype.fbasedataid.name"), taxTypeId, riskControl.getString("taxtype.fbasedataid.name"), "3"));
        }
        return result;
    }

    public static String buildRiskControlVerifyEntityMsg(List<RiskControlVerifyEntity> riskControlVerifyResults) {
        StringJoiner errorMsgJoiner = new StringJoiner("\r\n");
        for (RiskControlVerifyEntity riskControlVerifyResult : riskControlVerifyResults) {
            if (riskControlVerifyResult.getSbbVersion().equals(ModelVersionEnum.MODEL2.getVersion())) {
                if (riskControlVerifyResult.getAllOrg().booleanValue()) {
                    errorMsgJoiner.add(String.format(ResManager.loadKDString((String)"\u9002\u7528\u6240\u6709\u7a0e\u52a1\u7ec4\u7ec7\u201c%1$s\u201d\u7533\u62a5\u8868\u7c7b\u578b\u5df2\u7ef4\u62a4\u98ce\u9669\u63a7\u5236\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskControlBusiness_0", (String)"taxc-tctrc-business", (Object[])new Object[0]), riskControlVerifyResult.getSbbTypeName()));
                    continue;
                }
                errorMsgJoiner.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7a0e\u52a1\u7ec4\u7ec7\u201c%2$s\u201d\u7533\u62a5\u8868\u7c7b\u578b\u5df2\u7ef4\u62a4\u98ce\u9669\u63a7\u5236\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskControlEditPlugin_1", (String)"taxc-tctrc-business", (Object[])new Object[0]), riskControlVerifyResult.getOrgName(), riskControlVerifyResult.getSbbTypeName()));
                continue;
            }
            if (riskControlVerifyResult.getAllOrg().booleanValue()) {
                errorMsgJoiner.add(String.format(ResManager.loadKDString((String)"\u9002\u7528\u6240\u6709\u7a0e\u52a1\u7ec4\u7ec7\u201c%1$s\u201d\u7a0e\u79cd\u201c%2$s\u201d\u7533\u62a5\u8868\u7c7b\u578b\u5df2\u7ef4\u62a4\u98ce\u9669\u63a7\u5236\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskControlEditPlugin_2", (String)"taxc-tctrc-business", (Object[])new Object[0]), riskControlVerifyResult.getTaxTypeName(), riskControlVerifyResult.getSbbTypeName()));
                continue;
            }
            errorMsgJoiner.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7a0e\u52a1\u7ec4\u7ec7\u201c%2$s\u201d\u7a0e\u79cd\u201c%3$s\u201d\u7533\u62a5\u8868\u7c7b\u578b\u5df2\u7ef4\u62a4\u98ce\u9669\u63a7\u5236\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskControlEditPlugin_3", (String)"taxc-tctrc-business", (Object[])new Object[0]), riskControlVerifyResult.getOrgName(), riskControlVerifyResult.getTaxTypeName(), riskControlVerifyResult.getSbbTypeName()));
        }
        return errorMsgJoiner.toString();
    }
}

