/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.riskcontrol;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class RiskControlDao {
    public static final String RISK_CONTROL_ENTITY_NAME = "tctrc_risk_control";

    public static DynamicObjectCollection queryByOrgTaxTypeSbbType(Long riskControlId, boolean isAllOrg, List<Long> orgIds, List<Long> taxTypeIds, List<String> sbbTypeIds, String selectFields) {
        QFilter filter = RiskControlDao.buildFilterByOrgTaxTypeSbbType(riskControlId, isAllOrg, orgIds, taxTypeIds, sbbTypeIds);
        return RiskControlDao.queryData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObject[] loadDataByIds(List<Long> ids, Boolean enable, String selectFields) {
        QFilter filter = new QFilter("id", "in", ids).and("enable", "=", (Object)(enable != false ? "1" : "0"));
        return RiskControlDao.loadData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryDisableDataByIds(List<Long> ids, String selectFields) {
        QFilter filter = new QFilter("id", "in", ids).and("enable", "=", (Object)"0");
        return RiskControlDao.queryData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryByDataOrgTaxTypeSbbType(Collection<DynamicObject> riskControls, String selectFields) {
        List ids = riskControls.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "not in", ids);
        QFilter filter1 = null;
        for (DynamicObject riskControl : riskControls) {
            boolean isAllOrg = riskControl.getBoolean("isallorg");
            List<Long> orgIds = riskControl.getDynamicObjectCollection("entryentity").stream().map(p -> p.getLong("org.id")).collect(Collectors.toList());
            List<Long> taxTypeIds = riskControl.getDynamicObjectCollection("taxtype").stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList());
            List<String> sbbTypeIds = riskControl.getDynamicObjectCollection("sbbtype").stream().map(p -> p.getString("fbasedataid.id")).collect(Collectors.toList());
            if (filter1 == null) {
                filter1 = RiskControlDao.buildFilterByOrgTaxTypeSbbType(0L, isAllOrg, orgIds, taxTypeIds, sbbTypeIds);
                continue;
            }
            filter1 = filter1.or(RiskControlDao.buildFilterByOrgTaxTypeSbbType(0L, isAllOrg, orgIds, taxTypeIds, sbbTypeIds));
        }
        if (filter1 != null) {
            filter = filter.and(filter1);
        }
        return RiskControlDao.queryData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObject queryDeclareReportMatchRiskControl(String templateTypeId, Long orgId, String draftPurpose, Long taxTypeId, String operateType, String selectFields) {
        QFilter orgFilter;
        DynamicObject result;
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("sbbtype.fbasedataid.id", "=", (Object)templateTypeId).and("controlnode", "=", (Object)operateType);
        if (StringUtils.isNotEmpty((CharSequence)draftPurpose)) {
            filter = filter.and("draftpurpose", "like", (Object)("%," + draftPurpose + ",%"));
        }
        if (taxTypeId != null && taxTypeId != 0L) {
            filter = filter.and("taxtype.fbasedataid.id", "=", (Object)taxTypeId);
        }
        if ((result = RiskControlDao.queryOneData(selectFields, new QFilter[]{filter, orgFilter = new QFilter("entryentity.org.id", "=", (Object)orgId)})) == null) {
            filter = filter.and("isallorg", "=", (Object)"1");
            result = RiskControlDao.queryOneData(selectFields, new QFilter[]{filter});
        }
        return result;
    }

    public static QFilter buildDeclareReportMatchRiskControlFilter(String templateTypeId, Long orgId, String draftPurpose, Long taxTypeId) {
        QFilter filter = new QFilter("sbbtype.fbasedataid.id", "=", (Object)templateTypeId);
        if (StringUtils.isNotEmpty((CharSequence)draftPurpose)) {
            filter = filter.and("draftpurpose", "like", (Object)("%," + draftPurpose + ",%"));
        }
        if (taxTypeId != null && taxTypeId != 0L) {
            filter = filter.and("taxtype.fbasedataid.id", "=", (Object)taxTypeId);
        }
        QFilter orgFilter = new QFilter("entryentity.org.id", "=", (Object)orgId).or("isallorg", "=", (Object)"1");
        return filter.and(orgFilter);
    }

    public static QFilter buildFilterByOrgTaxTypeSbbType(Long riskControlId, boolean isAllOrg, List<Long> orgIds, List<Long> taxTypeIds, List<String> sbbTypeIds) {
        QFilter filter = new QFilter("isallorg", "=", (Object)(isAllOrg ? "1" : "0")).and("enable", "=", (Object)"1");
        if (riskControlId != 0L) {
            filter = filter.and("id", "!=", (Object)riskControlId);
        }
        if (!isAllOrg) {
            filter = filter.and("entryentity.org.id", "in", orgIds);
        }
        if (CollectionUtils.isNotEmpty(taxTypeIds)) {
            filter = filter.and("taxtype.fbasedataid.id", "in", taxTypeIds);
        }
        filter = filter.and("sbbtype.fbasedataid.id", "in", sbbTypeIds);
        return filter;
    }

    public static DynamicObjectCollection queryEnableData(String selectFields) {
        return RiskControlDao.queryData(selectFields, new QFilter[]{new QFilter("enable", "=", (Object)"1")});
    }

    public static DynamicObject[] loadData(String selectFields, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)RISK_CONTROL_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject[] loadDataById(Object[] ids) {
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)RISK_CONTROL_ENTITY_NAME));
    }

    public static DynamicObjectCollection queryData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)RISK_CONTROL_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject queryOneData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)RISK_CONTROL_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }
}

