/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.riskresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctrc.business.riskresult.RiskResultDao;
import kd.taxc.tctrc.business.templatetype.TemplateTypeBusiness;
import kd.taxc.tctrc.common.util.FilterBuilderUtils;
import org.apache.commons.collections4.CollectionUtils;

public class RiskResultBusiness {
    public static DynamicObject[] getDeclareDraftOrReportRelationRiskResult(String templateTypeNumber, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId) {
        String templateTypeId = TemplateTypeBusiness.queryTemplateTypeIdByNumber(templateTypeNumber);
        return RiskResultDao.loadDeclareDraftOrReportRelationRiskResult(templateTypeId, skssqq, skssqz, orgId, draftPurpose, taxTypeId, "id,risk,runorg,result,riskdesc,startdate,enddate");
    }

    public static DynamicObjectCollection getDeclareReportRiskResultWithRiskControl(String filterJson, String templateTypeId, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId, String selectFields) {
        QFilter riskControlFilter = FilterBuilderUtils.buildFilter((String)filterJson, (String)"tctrc_risk_run_result");
        return RiskResultDao.queryDeclareReportRiskResultWithRiskControl(riskControlFilter, templateTypeId, skssqq, skssqz, orgId, draftPurpose, taxTypeId, selectFields);
    }

    public static BigDecimal getRiskResultTargetValue(DynamicObject riskResultObject) {
        DynamicObject riskDefinitionObject = riskResultObject.getDynamicObject("risk");
        DynamicObjectCollection riskDefinitionEntryEntities = riskDefinitionObject.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)riskDefinitionEntryEntities)) {
            return BigDecimal.ZERO;
        }
        String orgId = riskResultObject.getString("runorg.id");
        ArrayList<DynamicObject> defaultDeviations = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> customDeviations = new ArrayList<DynamicObject>(16);
        for (DynamicObject riskDefinitionEntryEntity : riskDefinitionEntryEntities) {
            String itemId = riskDefinitionEntryEntity.getString("itemid");
            String orgStr = riskDefinitionEntryEntity.getString("orgs1");
            if (StringUtils.isEmpty((CharSequence)itemId) || "0".equals(itemId) || StringUtils.isEmpty((CharSequence)orgStr)) {
                defaultDeviations.add(riskDefinitionEntryEntity);
                continue;
            }
            if (orgStr.indexOf(orgId) <= -1) continue;
            customDeviations.add(riskDefinitionEntryEntity);
        }
        if (CollectionUtils.isNotEmpty(customDeviations)) {
            return ((DynamicObject)customDeviations.get(0)).getBigDecimal("bmvalue1").setScale(4);
        }
        if (CollectionUtils.isNotEmpty(defaultDeviations)) {
            return ((DynamicObject)defaultDeviations.get(0)).getBigDecimal("bmvalue1").setScale(4);
        }
        return BigDecimal.ZERO;
    }

    public static DynamicObject getDataById(Long id) {
        return RiskResultDao.loadDataById(id);
    }

    public static DynamicObject getDataById(Long id, String selectFields) {
        return RiskResultDao.loadOneDataById(id, selectFields);
    }

    public static DynamicObject queryDataById(Long id, String selectFields) {
        return RiskResultDao.queryDataById(id, selectFields);
    }
}

