/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.riskresult;

import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.tctrc.common.util.DateUtils;

public class RiskResultDao {
    public static final String RISK_RESULT_ENTITY_NAME = "tctrc_risk_run_result";

    public static DynamicObject[] loadDeclareDraftOrReportRelationRiskResult(String templateTypeId, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId, String selectFields) {
        QFilter filter = RiskResultDao.buildDeclareDraftOrReportFilter(templateTypeId, skssqq, skssqz, orgId, draftPurpose, taxTypeId);
        return RiskResultDao.loadData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryDeclareReportRiskResultWithRiskControl(QFilter riskControlFilter, String templateTypeId, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId, String selectFields) {
        QFilter filter = RiskResultDao.buildDeclareDraftOrReportFilter(templateTypeId, skssqq, skssqz, orgId, draftPurpose, taxTypeId);
        return RiskResultDao.queryData(selectFields, new QFilter[]{riskControlFilter, filter});
    }

    public static QFilter buildDeclareDraftOrReportFilter(String templateTypeId, String skssqq, String skssqz, Long orgId, String draftPurpose, Long taxTypeId) {
        QFilter statusFilter = new QFilter("status", "in", Arrays.asList("0", "2")).or(new QFilter("status", "=", (Object)"1").and(new QFilter("dealresult", "=", (Object)"3")));
        QFilter filter = new QFilter("risk.sbbtype.fbasedataid", "=", (Object)templateTypeId).and(new QFilter("risk.issbshow", "=", (Object)BooleanEnum.YES.getCode())).and(new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)skssqq)))).and(new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)skssqz)))).and(new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3))).and(statusFilter).and(new QFilter("runorg.id", "=", (Object)orgId));
        if (StringUtils.isNotEmpty((CharSequence)draftPurpose)) {
            filter = filter.and(new QFilter("risk.draftpurpose", "=", (Object)draftPurpose));
        }
        if (taxTypeId != null && taxTypeId != 0L) {
            filter = filter.and(new QFilter("risk.taxtypemul.fbasedataid.id", "=", (Object)taxTypeId));
        }
        return filter;
    }

    public static DynamicObject[] loadData(String selectFields, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)RISK_RESULT_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject loadDataById(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)RISK_RESULT_ENTITY_NAME);
    }

    public static DynamicObject loadOneDataById(Long id, String selectFields) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)RISK_RESULT_ENTITY_NAME, (String)selectFields);
    }

    public static DynamicObject queryDataById(Long id, String selectFields) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return RiskResultDao.queryOneData(selectFields, new QFilter[]{filter});
    }

    public static DynamicObjectCollection queryData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)RISK_RESULT_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }

    public static DynamicObject queryOneData(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)RISK_RESULT_ENTITY_NAME, (String)selectFields, (QFilter[])filters);
    }
}

