/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.business.service.riskrun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.enums.LicenseTaxEnum;
import kd.taxc.tctrc.common.helper.LicenseCheckServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.StringUtil;

public class RiskRunService {
    private static final String STATUS = "status";
    private static final String RUNTIME = "runtime";
    private static final String LASTRUNTIME = "lastruntime";
    private static final String RUNORG = "runorg";
    private static final String RISKLEVEL_ID = "rlevel.id";
    private static final String RISK_RUN_LIST = "tctrc_risk_run_list";
    private static final String RISK_RUN_RESULT = "tctrc_risk_run_result";
    private static final String RISK_HANDLE_LIST = "tctrc_handle_list";

    public static DynamicObjectCollection getRiskRunList(Date startTime, Date endTime, String licenseStatus) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(LASTRUNTIME, ">=", (Object)startTime));
        filters.add(new QFilter(LASTRUNTIME, "<=", (Object)endTime));
        if (StringUtil.isNotBlank((CharSequence)licenseStatus)) {
            List<Long> orgids = LicenseCheckServiceHelper.getOrgByAppId((String)LicenseTaxEnum.TCTRC.getAppid(), (String)licenseStatus);
            orgids = EmptyCheckUtils.isEmpty((Object)orgids) ? Collections.singletonList(-1L) : orgids;
            filters.add(new QFilter(RUNORG, "in", orgids));
        }
        return QueryServiceHelper.query((String)RISK_RUN_LIST, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public static DynamicObjectCollection getRiskRunResult(Date startTime, Date endTime) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(RUNTIME, ">=", (Object)startTime));
        filters.add(new QFilter(RUNTIME, "<", (Object)endTime));
        filters.add(new QFilter(RISKLEVEL_ID, "not in", Arrays.asList(4, 5)));
        return QueryServiceHelper.query((String)RISK_RUN_RESULT, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }

    public static DynamicObjectCollection getHandleListByStatus(List<String> status) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(STATUS, "in", status));
        filters.add(new QFilter(RISKLEVEL_ID, "not in", Arrays.asList(4, 5)));
        return QueryServiceHelper.query((String)RISK_HANDLE_LIST, (String)"id", (QFilter[])filters.toArray(new QFilter[filters.size()]));
    }
}

