/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctsa.business.statistics.TaxStatisticsRptHelper;
import kd.taxc.tctsa.common.helper.OpenAllDeclareHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.rpt.RptUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class TaxrateDetailQueryRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TaxrateDetailQueryRptPlugin.class);

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit tablefield = (MulBasedataEdit)this.getControl("orgs");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit taxtypes = (MulBasedataEdit)this.getControl("taxtypes");
        taxtypes.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("orgs".equalsIgnoreCase(name)) {
            MulBasedataDynamicObjectCollection taxsystems = (MulBasedataDynamicObjectCollection)this.getModel().getValue("taxsystems");
            List<Long> allPermOrgs = TaxrateDetailQueryRptPlugin.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
            if (CollectionUtils.isNotEmpty((Collection)taxsystems)) {
                DynamicObject[] dynamicObjects;
                Set taxsystemIds = taxsystems.stream().map(m -> m.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                HashSet<Long> ids = new HashSet<Long>(8);
                block0: for (DynamicObject bastaxTaxorg : dynamicObjects = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org.id,entryentity,entry_taxationsys.id", (QFilter[])new QFilter[]{new QFilter("org", "in", allPermOrgs)})) {
                    DynamicObjectCollection entryEntity = bastaxTaxorg.getDynamicObjectCollection("entryentity");
                    Set taxtionsysIds = entryEntity.stream().map(m -> m.getLong("entry_taxationsys.id")).collect(Collectors.toSet());
                    for (Long taxtionsysId : taxtionsysIds) {
                        if (!taxsystemIds.contains(taxtionsysId)) continue;
                        ids.add(bastaxTaxorg.getLong("org.id"));
                        continue block0;
                    }
                }
                allPermOrgs.retainAll(ids);
            }
            QFilter qFilter = new QFilter("id", "in", allPermOrgs);
            evt.addCustomQFilter(qFilter);
        } else if ("taxtypes".equalsIgnoreCase(name)) {
            List<Long> ids = Arrays.asList(1L, 3L, 7L);
            formShowParameter.setMultiSelect(true);
            QFilter qFilter = new QFilter("id", "in", ids).or("taxationsysid", "!=", (Object)1L);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String taxsystemcol;
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        String id = rowData.getString("sbbid");
        String string = taxsystemcol = rowData.get("taxsystemcol") == null ? null : rowData.getString("taxsystemcol.id");
        if ("1".equals(taxsystemcol)) {
            String sbbnocol = rowData.getString("sbbnocol");
            OpenAllDeclareHelper.openTjsjb((IFormView)this.getView(), (String)id, (String)sbbnocol);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6d77\u5916\u7a0e\u8d85\u94fe\u63a5\u3002", (String)"TaxrateDetailQueryRptPlugin_6", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        List filterItems = queryParam.getFilter().getFilterItems();
        List taxsystems = RptUtils.getFilterValueIds((List)filterItems, (String)"taxsystems");
        List orgs = RptUtils.getFilterValueIds((List)filterItems, (String)"orgs");
        List taxtypes = RptUtils.getFilterValueIds((List)filterItems, (String)"taxtypes");
        if (CollectionUtils.isEmpty((Collection)taxsystems)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxrateDetailQueryRptPlugin_7", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)orgs)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TaxrateDetailQueryRptPlugin_8", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)taxtypes)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxrateDetailQueryRptPlugin_14", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)startDate) || EmptyCheckUtils.isEmpty((Object)endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u5fc5\u987b\u540c\u65f6\u7ef4\u62a4\u3002", (String)"TaxrateDetailQueryRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        boolean result = this.validateDate(startDate, endDate);
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxrateDetailQueryRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        boolean isSame = this.validateSameDateYear(startDate, endDate);
        if (!isSame) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u8de8\u5e74\u5ea6\u67e5\u8be2\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u67e5\u8be2\u8303\u56f4\u3002", (String)"TaxrateDetailQueryRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam reportQueryParam) {
        Map customParam = reportQueryParam.getCustomParam();
        String dimension = (String)this.getModel().getValue("dimension");
        customParam.put("dimension", dimension);
        boolean showsntq = (Boolean)this.getModel().getValue("showsntq");
        boolean showcksfl = (Boolean)this.getModel().getValue("showcksfl");
        boolean showtotal = (Boolean)this.getModel().getValue("showtotal");
        customParam.put("showsntq", showsntq);
        customParam.put("showcksfl", showcksfl);
        customParam.put("showtotal", showtotal);
    }

    private boolean validateSameDateYear(Date date, Date dateend) {
        if (null != date && null != dateend) {
            int dateendYear;
            int dateYear = DateUtils.getYearOfDate((Date)date);
            return dateYear == (dateendYear = DateUtils.getYearOfDate((Date)dateend));
        }
        return true;
    }

    private boolean validateDate(Date start, Date end) {
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        if (null != enddate) {
            Date startdate = DateUtils.getFirstDateOfMonth((Date)start);
            return !startdate.after(enddate);
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        MulBasedataDynamicObjectCollection newValue;
        String name = e.getProperty().getName();
        if ("dimension".equals(name)) {
            this.getView().refresh();
        } else if ("taxsystems".equals(name) && CollectionUtils.isEmpty((Collection)(newValue = (MulBasedataDynamicObjectCollection)e.getChangeSet()[0].getNewValue()))) {
            this.getModel().getDataEntity().set("orgs", null);
            this.getView().updateView("orgs");
        }
    }

    public void afterCreateNewData(EventObject e) {
        Date now = new Date();
        Date startdate = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)now, (int)-1));
        Date enddate = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)now, (int)-1)));
        this.getView().getModel().setValue("startdate", (Object)startdate);
        this.getView().getModel().setValue("enddate", (Object)enddate);
        Long defultOrg = RequestContext.get().getOrgId();
        List<Long> allPermOrgs = TaxrateDetailQueryRptPlugin.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
        if (CollectionUtils.isNotEmpty(allPermOrgs)) {
            if (!allPermOrgs.contains(defultOrg)) {
                defultOrg = allPermOrgs.get(0);
            }
        } else {
            return;
        }
        logger.info("\u83b7\u53d6\u9ed8\u8ba4\u7ec4\u7ec7id\uff1a", (Object)defultOrg);
        if (defultOrg != null) {
            this.getModel().setValue("orgs", (Object)new Long[]{defultOrg});
            DynamicObject bastaxTaxorg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"entryentity,entry_taxationsys.id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)defultOrg)});
            if (bastaxTaxorg == null) {
                return;
            }
            DynamicObjectCollection entryEntity = bastaxTaxorg.getDynamicObjectCollection("entryentity");
            List taxtionsysIds = entryEntity.stream().map(m -> m.getLong("entry_taxationsys.id")).collect(Collectors.toList());
            if (taxtionsysIds.contains(1L)) {
                this.getModel().setValue("taxsystems", (Object)new Long[]{1L});
            } else {
                this.getModel().setValue("taxsystems", (Object)new Long[]{(Long)taxtionsysIds.get(0)});
            }
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = TaxStatisticsRptHelper.formatShowFilterString((List)showFieldList, (IDataModel)iDataModel, (IReportView)this.getView());
            evt.setFormatedFilterString(msg);
        }
    }

    public static List<Long> queryTaxOrgWithPerm(long userId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)"40", (boolean)true);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }
}

