/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.business.taxmain.TctsaTaxOrgBusiness;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.rpt.RptDataSetFacility;
import kd.taxc.tctsa.common.rpt.RptUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class TaxrateDetailQueryRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(TaxrateDetailQueryRptQueryPlugin.class);
    private static final String SELECT_STR = "id,type,org,skssqq,skssqz,taxtype,yssr,bqybtse,jmse,fsl,ynse,sbbid,formno,taxationsys,taxareagroup";
    private static final String[] FIELDS = new String[]{"orgcol", "taxpayer", "taxsystemcol", "taxareagroupcol", "taxtypecol", "skssqqzcol", "ynsecol", "jnsecol", "ynsrcol", "sflcol", "sntqynsecol", "sntqjmsecol", "sntqsrcol", "sntqsflcol", "tbbdlcol", "pjsflcol", "pcfdcol", "ckqjcol", "managareascol", "industrynamecol", "sbbnocol", "tabletype", "sbbid"};
    private static final DataType[] TYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
    private static final RowMeta ROW_META = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])TYPES);

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        String fieldKey;
        ArrayList<AbstractReportColumn> tempList = new ArrayList<AbstractReportColumn>(8);
        Map customParam = this.getQueryParam().getCustomParam();
        boolean showsntq = (Boolean)customParam.get("showsntq");
        boolean showcksfl = (Boolean)customParam.get("showcksfl");
        List<String> sntqFileds = Arrays.asList("sntqynsecol", "sntqjmsecol", "sntqsrcol", "sntqsflcol", "tbbdlcol");
        List<String> sflFileds = Arrays.asList("pjsflcol", "pcfdcol", "ckqjcol");
        String dimension = (String)customParam.get("dimension");
        List taxtypes = RptUtils.getFilterValueIds((List)this.getQueryParam().getFilter().getFilterItems(), (String)"taxtypes");
        boolean hasFcsBol = CollectionUtils.isNotEmpty((Collection)taxtypes) && taxtypes.size() == 1 && (Long)taxtypes.get(0) == 7L;
        for (AbstractReportColumn column : columns) {
            String fieldKey2 = ((ReportColumn)column).getFieldKey();
            if (!showsntq && sntqFileds.contains(fieldKey2) || !showcksfl && sflFileds.contains(fieldKey2)) continue;
            tempList.add(column);
        }
        String groupKey = this.getGroupKey(dimension);
        ArrayList<AbstractReportColumn> reportColumns = new ArrayList<AbstractReportColumn>(8);
        for (AbstractReportColumn column : tempList) {
            fieldKey = ((ReportColumn)column).getFieldKey();
            if (!fieldKey.equals(groupKey)) continue;
            reportColumns.add(column);
        }
        for (AbstractReportColumn column : tempList) {
            fieldKey = ((ReportColumn)column).getFieldKey();
            if (fieldKey.equals(groupKey) || !hasFcsBol && ("jnsecol".equals(fieldKey) || "sntqjmsecol".equals(fieldKey))) continue;
            reportColumns.add(column);
        }
        return reportColumns;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        try {
            Map customParam = reportQueryParam.getCustomParam();
            String dimension = (String)customParam.get("dimension");
            boolean showtotal = (Boolean)customParam.get("showtotal");
            FilterInfo filterInfo = reportQueryParam.getFilter();
            List filterItemInfos = filterInfo.getFilterItems();
            if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
                return this.emptyResultDataSet();
            }
            List taxareagroups = RptUtils.getFilterValueIds((List)filterInfo.getFilterItems(), (String)"taxareagroups");
            List industrys = RptUtils.getFilterValueIds((List)filterInfo.getFilterItems(), (String)"industryname");
            List taxTypes = RptUtils.getFilterValueIds((List)filterInfo.getFilterItems(), (String)"taxtypes");
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("taxsystems", "taxationsys");
            map.put("orgs", "org");
            map.put("taxtypes", "taxtype");
            Map<String, List<QFilter>> nuOverseasMap = this.getFilters(filterInfo, map, "tjsjb");
            List<QFilter> jtsjbFilters = nuOverseasMap.get("year");
            List<QFilter> jtsjbLastFilters = nuOverseasMap.get("lastyear");
            HashMap<String, String> hwsMap = new HashMap<String, String>(8);
            hwsMap.put("taxsystems", "taxsystem");
            hwsMap.put("orgs", "org");
            Map<String, List<QFilter>> qFiltersMap = this.getFilters(filterInfo, hwsMap, "dataset");
            List<QFilter> hwsFilters = qFiltersMap.get("year");
            List<QFilter> hwsLastqFilters = qFiltersMap.get("lastyear");
            return this.getDataSet(dimension, showtotal, taxareagroups, industrys, taxTypes, jtsjbFilters, jtsjbLastFilters, hwsFilters, hwsLastqFilters);
        }
        catch (Exception ex) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u6570\u636e\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            return this.emptyResultDataSet();
        }
    }

    public DataSet getDataSet(String dimension, boolean showtotal, List<Long> taxareagroups, List<Long> industrys, List<Long> taxTypes, List<QFilter> jtsjbFilters, List<QFilter> jtsjbLastFilters, List<QFilter> hwsFilters, List<QFilter> hwsLastqFilters) {
        DataSet nuOverseasDataset = this.calNuOverseas(jtsjbFilters, jtsjbLastFilters);
        DataSet overseasDataset = this.calOverseas(hwsFilters, hwsLastqFilters);
        DataSet result = nuOverseasDataset;
        result = result == null || result.isEmpty() ? overseasDataset : result.copy().union(overseasDataset.copy());
        result = this.handleAdditionalFilter(taxareagroups, industrys, taxTypes, result);
        String groupKey = this.getGroupKey(dimension);
        DataSet[] groupDataSet = result.copy().splitByGroup(new String[]{groupKey});
        DataSet hz = this.getTotal(result.copy(), "hj", groupKey);
        if (showtotal) {
            result = this.emptyResultDataSet();
            for (DataSet dataSet : groupDataSet) {
                DataSet totaldataSet = this.getTotal(dataSet.copy(), "xj", groupKey);
                result = result.copy().union(dataSet).union(totaldataSet);
            }
        }
        if (!result.isEmpty()) {
            result = result.copy().union(hz.copy());
        }
        return result;
    }

    private DataSet handleAdditionalFilter(List<Long> taxareagroups, List<Long> industrys, List<Long> taxTypes, DataSet result) {
        QFilter idFilter;
        DynamicObjectCollection tcvatIndustrycode;
        List names;
        QFilter additionalFilter = null;
        if (CollectionUtils.isNotEmpty(taxareagroups)) {
            additionalFilter = new QFilter("taxareagroupcol", "in", taxareagroups);
        }
        if (CollectionUtils.isNotEmpty(industrys) && CollectionUtils.isNotEmpty(names = (tcvatIndustrycode = QueryServiceHelper.query((String)"tpo_tcvat_industrycode", (String)"id,name", (QFilter[])(idFilter = new QFilter("id", "in", industrys)).toArray())).stream().map(m -> m.getString("name")).distinct().collect(Collectors.toList()))) {
            idFilter = new QFilter("industrynamecol", "in", names);
            QFilter qFilter = additionalFilter = additionalFilter == null ? idFilter : additionalFilter.and(idFilter);
        }
        if (CollectionUtils.isNotEmpty(taxTypes)) {
            QFilter qFilter = new QFilter("taxtypecol", "in", taxTypes);
            QFilter qFilter2 = additionalFilter = additionalFilter == null ? qFilter : additionalFilter.and(qFilter);
        }
        if (additionalFilter != null) {
            result = result.copy().filter(additionalFilter.toString());
        }
        return result.copy().orderBy(new String[]{"skssqqzcol asc"});
    }

    private String getGroupKey(String dimension) {
        if ("01".equals(dimension)) {
            return "orgcol";
        }
        if ("02".equals(dimension)) {
            return "managareascol";
        }
        if ("03".equals(dimension)) {
            return "industrynamecol";
        }
        if ("04".equals(dimension)) {
            return "tabletype";
        }
        return "orgcol";
    }

    private DataSet getTotal(DataSet dataSet, String type, String groupKey) {
        if (!"hj".equals(type) && !"xj".equals(type)) {
            return this.emptyResultDataSet();
        }
        ArrayList<Object[]> totalResult = new ArrayList<Object[]>(12);
        List orgColValues = this.getValue(dataSet.copy(), "orgcol", true, true);
        String orgcol = (String)this.mergeValue(orgColValues);
        if ("hj".equals(type) && "orgcol".equals(groupKey)) {
            orgcol = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxrateDetailQueryRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        }
        Object taxsystemcol = null;
        Object taxareagroupcolValue = null;
        Object taxtypecolValue = null;
        Object skssqqzcol = null;
        List ynsecolValues = this.getValue(dataSet.copy(), "ynsecol", true, false);
        BigDecimal ynsecol = CollectionUtils.isEmpty(ynsecolValues) ? null : ynsecolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<BigDecimal> jnsecolValues = new ArrayList<BigDecimal>(8);
        for (Row row : dataSet.copy()) {
            if (7L != row.getLong("taxtypecol")) continue;
            jnsecolValues.add(row.getBigDecimal("jnsecol"));
        }
        BigDecimal jmsecol = CollectionUtils.isEmpty(jnsecolValues) ? null : jnsecolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        List ynsrcolValues = this.getValue(dataSet.copy(), "ynsrcol", true, false);
        BigDecimal ynsrcol = CollectionUtils.isEmpty(ynsrcolValues) ? null : ynsrcolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sflRate = RptUtils.getSflRate((BigDecimal)ynsecol, (BigDecimal)ynsrcol, (BigDecimal)jmsecol, (int)4, (int)2);
        String sflcol = sflRate == null ? null : sflRate + "%";
        List qntqynsecolValues = this.getValue(dataSet.copy(), "sntqynsecol", true, false);
        BigDecimal qntqynsecol = CollectionUtils.isEmpty(qntqynsecolValues) ? null : qntqynsecolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<BigDecimal> sntqjmsecolValues = new ArrayList<BigDecimal>(8);
        for (Row row : dataSet.copy()) {
            if (7L != row.getLong("taxtypecol")) continue;
            sntqjmsecolValues.add(row.getBigDecimal("sntqjmsecol"));
        }
        BigDecimal sntqjmsecol = CollectionUtils.isEmpty(sntqjmsecolValues) ? null : sntqjmsecolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        List smtqsrcolValues = this.getValue(dataSet.copy(), "sntqsrcol", true, false);
        BigDecimal sntqsrcol = CollectionUtils.isEmpty(smtqsrcolValues) ? null : smtqsrcolValues.stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sntqsflRate = RptUtils.getSflRate((BigDecimal)qntqynsecol, (BigDecimal)sntqsrcol, (BigDecimal)sntqjmsecol, (int)4, (int)2);
        String sntqsflcol = sntqsflRate == null ? null : sntqsflRate + "%";
        BigDecimal tbbdl = RptUtils.getTbbdl((BigDecimal)ynsecol, (BigDecimal)ynsrcol, (BigDecimal)jmsecol, (BigDecimal)qntqynsecol, (BigDecimal)sntqsrcol, (BigDecimal)sntqjmsecol);
        String tbbdlcol = tbbdl == null ? null : tbbdl + "%";
        List glqycolValues = this.getValue(dataSet.copy(), "managareascol", false, true);
        String glqycol = (String)this.mergeValue(glqycolValues);
        if ("hj".equals(type) && "managareascol".equals(groupKey)) {
            glqycol = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxrateDetailQueryRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        }
        List ssyhcolValues = this.getValue(dataSet.copy(), "industrynamecol", false, true);
        String ssyhcol = (String)this.mergeValue(ssyhcolValues);
        if ("hj".equals(type) && "industrynamecol".equals(groupKey)) {
            ssyhcol = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxrateDetailQueryRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        }
        List templatetypecolValues = this.getValue(dataSet.copy(), "tabletype", true, true);
        String templatetypecol = (String)this.mergeValue(templatetypecolValues);
        if ("hj".equals(type) && "tabletype".equals(groupKey)) {
            templatetypecol = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxrateDetailQueryRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        }
        String sbbidcol = "hj".equals(type) ? "-1" : "0";
        Object[] rowData = new Object[]{orgcol, "", taxsystemcol, taxareagroupcolValue, taxtypecolValue, skssqqzcol, ynsecol, jmsecol, ynsrcol, sflcol, qntqynsecol, sntqjmsecol, sntqsrcol, sntqsflcol, tbbdlcol, null, null, null, glqycol, ssyhcol, null, templatetypecol, sbbidcol};
        totalResult.add(rowData);
        CollectionInput inputs = new CollectionInput(ROW_META, totalResult);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private <T> T mergeValue(List<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return null;
    }

    private <T> List<T> getValue(DataSet orgcolDataSet, String field, boolean ignoreNull, boolean idFindDistinct) {
        ArrayList<Object> result = new ArrayList<Object>(8);
        if (orgcolDataSet == null || orgcolDataSet.isEmpty()) {
            return result;
        }
        for (Row row : orgcolDataSet) {
            Object t = row.get(field);
            if (ignoreNull && t == null) continue;
            result.add(t);
        }
        if (idFindDistinct) {
            return result.stream().distinct().collect(Collectors.toList());
        }
        return result;
    }

    private DataSet calNuOverseas(List<QFilter> qFilters, List<QFilter> lastFilters) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        QFilter taxationsysQ = new QFilter("taxationsys", "=", (Object)1L);
        qFilters.add(taxationsysQ);
        lastFilters.add(taxationsysQ);
        DynamicObjectCollection collection = TjsjbBusiness.queryTjsjbDataWithOrder(qFilters, (String)SELECT_STR, (String)"skssqq asc");
        DynamicObjectCollection lastcollection = TjsjbBusiness.queryTjsjbData(lastFilters, (String)SELECT_STR);
        if (collection == null || collection.isEmpty()) {
            return this.emptyResultDataSet();
        }
        HashMap<String, BigDecimal> srMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> seMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> jmMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> sntqSrMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> sntqSeMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> sntqJmMap = new HashMap<String, BigDecimal>(8);
        this.calAmount(collection, srMap, seMap, jmMap);
        this.calAmount(lastcollection, sntqSrMap, sntqSeMap, sntqJmMap);
        List<Long> orgIds = collection.stream().map(m -> m.getLong("org")).distinct().collect(Collectors.toList());
        QFilter authFilter = new QFilter("id", "in", orgIds);
        DynamicObjectCollection bastaxTaxorg = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name", (QFilter[])authFilter.toArray());
        Map<Long, List<DynamicObject>> bastaxTaxorgMap = bastaxTaxorg.stream().collect(Collectors.groupingBy(m -> m.getLong("id")));
        Map taxpayerMap = TctsaTaxOrgBusiness.getTaxOrgTaxpayerChina(orgIds);
        Map<Long, List<DynamicObject>> taxinfosMap = this.queryTaxMainInfo(orgIds);
        QFilter filter = new QFilter("id", "!=", (Object)0L);
        DynamicObjectCollection tdmRefTaxrates = QueryServiceHelper.query((String)"tdm_ref_taxrate", (String)"taxationsys,taxareagroup,taxcategory,activedate,expdate,avgrate,minrate,maxrate,industrycode,industrycode.name", (QFilter[])filter.toArray());
        HashSet<String> keys = new HashSet<String>(8);
        for (DynamicObject dyo : collection) {
            String id = dyo.getString("sbbid");
            String org = dyo.getString("org");
            List<DynamicObject> list = bastaxTaxorgMap.get(Long.parseLong(String.valueOf(org)));
            List<DynamicObject> taxinfos = taxinfosMap.get(Long.parseLong(String.valueOf(org)));
            if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(taxinfos)) continue;
            String orgname = list.get(0).getString("name");
            String taxpayer = "";
            if (taxpayerMap.containsKey(org + "_1")) {
                taxpayer = (String)taxpayerMap.get(org + "_1");
            }
            long taxareagroup = Long.parseLong(dyo.getString("taxareagroup"));
            long taxsystem = 1L;
            long taxtype = Long.parseLong(dyo.getString("taxtype"));
            Date skssqq = dyo.getDate("skssqq");
            Date skssqz = dyo.getDate("skssqz");
            String skssqqz = DateUtils.format((Date)skssqq, (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)skssqz, (String)TctsaConstant.FORMAT);
            String templatetype = dyo.getString("type");
            String nowKey = org.concat("#").concat(String.valueOf(taxsystem)).concat("#").concat(String.valueOf(taxtype)).concat("#").concat(String.valueOf(taxareagroup)).concat("#").concat(String.valueOf(templatetype)).concat("#").concat(DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd")).concat("#").concat(DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            if (keys.contains(nowKey)) continue;
            keys.add(nowKey);
            BigDecimal ynse = (BigDecimal)seMap.get(nowKey);
            BigDecimal ynsr = (BigDecimal)srMap.get(nowKey);
            BigDecimal jmse = (BigDecimal)jmMap.get(nowKey);
            BigDecimal sflRate = RptUtils.getSflRate((BigDecimal)ynse, (BigDecimal)ynsr, (BigDecimal)(7L == taxtype ? jmse : BigDecimal.ZERO), (int)4, (int)2);
            String sfl = sflRate == null ? null : sflRate + "%";
            String lastYearKey = org.concat("#").concat(String.valueOf(taxsystem)).concat("#").concat(String.valueOf(taxtype)).concat("#").concat(String.valueOf(taxareagroup)).concat("#").concat(String.valueOf(templatetype)).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqq, (int)-1), (String)"yyyy-MM-dd")).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqz, (int)-1), (String)"yyyy-MM-dd"));
            BigDecimal sntqynsr = (BigDecimal)sntqSrMap.get(lastYearKey);
            BigDecimal sntqynse = (BigDecimal)sntqSeMap.get(lastYearKey);
            BigDecimal sntqjmse = (BigDecimal)sntqJmMap.get(lastYearKey);
            BigDecimal sntqSflRate = RptUtils.getSflRate((BigDecimal)sntqynse, (BigDecimal)sntqynsr, (BigDecimal)(7L == taxtype ? sntqjmse : BigDecimal.ZERO), (int)4, (int)2);
            String sntqsfl = sntqSflRate == null ? null : sntqSflRate + "%";
            BigDecimal sntqtbbdl = RptUtils.getTbbdl((BigDecimal)ynse, (BigDecimal)ynsr, (BigDecimal)(7L == taxtype ? jmse : BigDecimal.ZERO), (BigDecimal)sntqynse, (BigDecimal)sntqynsr, (BigDecimal)(7L == taxtype ? sntqjmse : BigDecimal.ZERO));
            String tbbdl = sntqtbbdl == null ? null : sntqtbbdl + "%";
            String glqy = RptDataSetFacility.getGlqy(taxinfos);
            String sshy = RptDataSetFacility.getSshyName(taxinfos);
            Long sshyId = RptDataSetFacility.getSshyId(taxinfos);
            String billno = dyo.getString("formno");
            Triple<String, String, String> refRate = this.getRefRate(taxsystem, taxareagroup, taxtype, sshyId, null, skssqq, skssqz, sflRate, (List<DynamicObject>)tdmRefTaxrates);
            Object[] rowData = new Object[]{orgname, taxpayer, taxsystem, taxareagroup, taxtype, skssqqz, ynse, jmse, ynsr, sfl, sntqynse, sntqjmse, sntqynsr, sntqsfl, tbbdl, refRate.getLeft(), refRate.getMiddle(), refRate.getRight(), glqy, sshy, billno, templatetype, id};
            result.add(rowData);
        }
        CollectionInput inputs = new CollectionInput(ROW_META, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private void calAmount(DynamicObjectCollection lastcollection, Map<String, BigDecimal> sntqSrMap, Map<String, BigDecimal> sntqSeMap, Map<String, BigDecimal> sntqJmMap) {
        for (DynamicObject dyo : lastcollection) {
            String org = dyo.getString("org");
            String taxsystem = "1";
            String taxtype = dyo.getString("taxtype");
            String taxareagroup = dyo.getString("taxareagroup");
            String skssqq = DateUtils.format((Date)dyo.getDate("skssqq"), (String)"yyyy-MM-dd");
            String skssqz = DateUtils.format((Date)dyo.getDate("skssqz"), (String)"yyyy-MM-dd");
            String templatetype = dyo.getString("type");
            String key = org.concat("#").concat(taxsystem).concat("#").concat(taxtype).concat("#").concat(taxareagroup).concat("#").concat(templatetype).concat("#").concat(skssqq).concat("#").concat(skssqz);
            sntqSrMap.put(key, sntqSrMap.getOrDefault(key, BigDecimal.ZERO).add(dyo.getBigDecimal("yssr")));
            sntqSeMap.put(key, sntqSeMap.getOrDefault(key, BigDecimal.ZERO).add(dyo.getBigDecimal("ynse")));
            sntqJmMap.put(key, sntqJmMap.getOrDefault(key, BigDecimal.ZERO).add(dyo.getBigDecimal("jmse")));
        }
    }

    private Triple<String, String, String> getRefRate(long taxsystem, long taxareagroup, long taxtype, Long sshyId, String sshyName, Date skssqq, Date skssqz, BigDecimal sflRate, List<DynamicObject> rateList) {
        Optional<DynamicObject> refRateOptional;
        DynamicObject dyo2;
        if (CollectionUtils.isEmpty(rateList)) {
            return Triple.of(null, null, null);
        }
        ArrayList<DynamicObject> dyoList = new ArrayList<DynamicObject>(2);
        for (DynamicObject dyo2 : rateList) {
            long rateTaxsystem = dyo2.getLong("taxationsys");
            long rateTaxareagroup = dyo2.getLong("taxareagroup");
            long rateTaxtype = dyo2.getLong("taxcategory");
            Date activedate = dyo2.getDate("activedate");
            Date expdate = dyo2.getDate("expdate");
            if (rateTaxsystem != taxsystem || taxareagroup != rateTaxareagroup || rateTaxtype != taxtype || activedate.compareTo(skssqq) > 0 || expdate.compareTo(skssqz) < 0) continue;
            dyoList.add(dyo2);
        }
        if (CollectionUtils.isEmpty(dyoList)) {
            return Triple.of(null, null, null);
        }
        Optional<DynamicObject> optional = refRateOptional = sshyId != null ? dyoList.stream().filter(m -> m.getLong("industrycode") == sshyId.longValue()).findFirst() : dyoList.stream().filter(m -> StringUtils.equals((CharSequence)m.getString("industrycode.name"), (CharSequence)sshyName)).findFirst();
        if (!refRateOptional.isPresent()) {
            return Triple.of(null, null, null);
        }
        dyo2 = refRateOptional.get();
        BigDecimal avgrate = dyo2.getBigDecimal("avgrate");
        BigDecimal minrate = dyo2.getBigDecimal("minrate");
        BigDecimal maxrate = dyo2.getBigDecimal("maxrate");
        String avgrateStr = avgrate == null ? null : avgrate.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String minrateStr = minrate == null ? null : minrate.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        String maxrateStr = maxrate == null ? null : maxrate.multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        BigDecimal pcfdRate = sflRate == null || avgrate == null || avgrate.compareTo(BigDecimal.ZERO) == 0 ? null : sflRate.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP).subtract(avgrate).divide(avgrate, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
        String pcfd = pcfdRate == null ? null : pcfdRate + "%";
        return Triple.of((Object)avgrateStr, (Object)pcfd, (Object)(minrateStr + "~" + maxrateStr));
    }

    private DataSet calOverseas(List<QFilter> hwsFilters, List<QFilter> hwsLastqFilters) {
        ArrayList<String> types = new ArrayList<String>(8);
        types.add("OVERSEAS-CIT-01");
        types.add("OVERSEAS-VAT-01");
        types.add("USA-CIT-01");
        QFilter filter = new QFilter("sbbthreetype.number", "in", types).and("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C");
        DynamicObjectCollection rptDataList = QueryServiceHelper.query((String)"tctsa_rpt_data", (String)"id,number,sbbthreetype.number,sbbthreetype.id", (QFilter[])filter.toArray());
        List ids = rptDataList.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return this.emptyResultDataSet();
        }
        DataSet result = null;
        DataSet lastresult = null;
        try {
            QFilter qFilter;
            List value;
            Optional<QFilter> filterOptional = hwsFilters.stream().filter(m -> "levytype".equals(m.getProperty())).findFirst();
            if (filterOptional.isPresent() && !(value = (List)(qFilter = filterOptional.get()).getValue()).contains("zxsb")) {
                return this.emptyResultDataSet();
            }
            hwsFilters = hwsFilters.stream().filter(m -> !"levytype".equals(m.getProperty())).collect(Collectors.toList());
            hwsLastqFilters = hwsLastqFilters.stream().filter(m -> !"levytype".equals(m.getProperty())).collect(Collectors.toList());
            QFilter and = new QFilter("billstatus", "=", (Object)"C").and("draftpurpose", "=", (Object)"sjjt");
            hwsFilters.add(and);
            hwsLastqFilters.add(and);
            for (DynamicObject rptConfig : rptDataList) {
                ArrayList<Object> filters = new ArrayList<Object>(hwsFilters);
                ArrayList<Object> lastFilters = new ArrayList<Object>(hwsLastqFilters);
                Long typeId = rptConfig.getLong("sbbthreetype.id");
                filters.add(new QFilter("templateid", "=", (Object)typeId));
                lastFilters.add(new QFilter("templateid", "=", (Object)typeId));
                DataSet valueRows = RptDataSetFacility.getValueRows((Long)rptConfig.getLong("id"), filters);
                if (valueRows == null || valueRows.isEmpty()) continue;
                result = result == null ? valueRows : result.union(valueRows);
                DataSet lastValueRows = RptDataSetFacility.getValueRows((Long)rptConfig.getLong("id"), lastFilters);
                if (lastValueRows == null || lastValueRows.isEmpty()) continue;
                if (lastresult == null) {
                    lastresult = lastValueRows;
                    continue;
                }
                lastresult = lastresult.union(lastValueRows);
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u67e5\u8be2\u5f02\u5e38:" + exceptionStackTraceMessage);
            return this.emptyResultDataSet();
        }
        return this.mergeOverseasDataset(result, lastresult);
    }

    private DataSet mergeOverseasDataset(DataSet dataSet, DataSet lastYearDataset) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        if (dataSet == null || dataSet.isEmpty()) {
            return this.emptyResultDataSet();
        }
        dataSet = dataSet.copy().orderBy(new String[]{"skssqq asc"});
        HashMap<String, BigDecimal> qntqSrMap = new HashMap<String, BigDecimal>(8);
        HashMap<String, BigDecimal> qntqSeMap = new HashMap<String, BigDecimal>(8);
        if (lastYearDataset != null) {
            for (Row row : lastYearDataset) {
                String org = row.getString("org");
                String taxsystem = row.getString("taxsystem");
                String taxtype = row.getString("taxtype");
                String taxareagroup = row.getString("taxareagroup");
                String skssqq = row.getString("skssqq");
                String skssqz = row.getString("skssqz");
                String key = org.concat("#").concat(taxsystem).concat("#").concat(taxtype).concat("#").concat(taxareagroup).concat("#").concat(skssqq).concat("#").concat(skssqz);
                BigDecimal ynse = row.getString("ynse") == null ? null : new BigDecimal(row.getString("ynse"));
                BigDecimal ynsr = row.getString("ynsr") == null ? null : new BigDecimal(row.getString("ynsr"));
                qntqSrMap.put(key, ynsr);
                qntqSeMap.put(key, ynse);
            }
        }
        QFilter filter = new QFilter("id", "!=", (Object)0L);
        DynamicObjectCollection tdmRefTaxrates = QueryServiceHelper.query((String)"tdm_ref_taxrate", (String)"taxationsys,taxareagroup,taxcategory,activedate,expdate,avgrate,minrate,maxrate,industrycode,industrycode.name", (QFilter[])filter.toArray());
        DataSet datasetnew = dataSet.copy();
        Map taxpayerMap = TctsaTaxOrgBusiness.getTaxpayerMap((DataSet)dataSet, (String)"org", (String)"taxsystem");
        for (Row row : datasetnew) {
            String taxsystemStr = row.getString("taxsystem");
            if (StringUtils.isEmpty((CharSequence)taxsystemStr) || "1".equals(taxsystemStr)) continue;
            String org = row.getString("org");
            String orgname = row.getString("orgname");
            long taxareagroup = Long.parseLong(row.getString("taxareagroup"));
            long taxsystem = Long.parseLong(row.getString("taxsystem"));
            String taxpayer = "";
            if (taxpayerMap.containsKey(org + "_" + taxsystem)) {
                taxpayer = (String)taxpayerMap.get(org + "_" + taxsystem);
            }
            long taxtype = Long.parseLong(row.getString("taxtype"));
            Date skssqq = DateUtils.stringToDate2((String)row.getString("skssqq"), (String)"yyyy-MM-dd");
            Date skssqz = DateUtils.stringToDate2((String)row.getString("skssqz"), (String)"yyyy-MM-dd");
            String skssqqz = DateUtils.format((Date)skssqq, (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)skssqz, (String)TctsaConstant.FORMAT);
            BigDecimal ynse = row.getString("ynse") == null ? null : new BigDecimal(row.getString("ynse"));
            BigDecimal ynsr = row.getString("ynsr") == null ? null : new BigDecimal(row.getString("ynsr"));
            BigDecimal jmse = null;
            BigDecimal sflRate = RptUtils.getSflRate((BigDecimal)ynse, (BigDecimal)ynsr, jmse, (int)4, (int)2);
            String sfl = sflRate == null ? null : sflRate + "%";
            String key = org.concat("#").concat(String.valueOf(taxsystem)).concat("#").concat(String.valueOf(taxtype)).concat("#").concat(String.valueOf(taxareagroup)).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqq, (int)-1), (String)"yyyy-MM-dd")).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqz, (int)-1), (String)"yyyy-MM-dd"));
            BigDecimal smtqynsr = (BigDecimal)qntqSrMap.get(key);
            BigDecimal qntqynse = (BigDecimal)qntqSeMap.get(key);
            BigDecimal sntqjmse = null;
            BigDecimal sntqsflRate = RptUtils.getSflRate((BigDecimal)qntqynse, (BigDecimal)smtqynsr, sntqjmse, (int)4, (int)2);
            String sntqsfl = sntqsflRate == null ? null : sntqsflRate + "%";
            BigDecimal tbbdlRate = RptUtils.getTbbdl((BigDecimal)ynse, (BigDecimal)ynsr, jmse, (BigDecimal)qntqynse, (BigDecimal)smtqynsr, sntqjmse);
            String tbbdl = tbbdlRate == null ? null : tbbdlRate + "%";
            String glqy = row.getString("glqy");
            String sshyName = row.getString("sshy");
            String templatetype = row.getString("templatetype");
            String id = row.getString("id");
            String billno = row.getString("billno");
            Triple<String, String, String> refRate = this.getRefRate(taxsystem, taxareagroup, taxtype, null, sshyName, skssqq, skssqz, sflRate, (List<DynamicObject>)tdmRefTaxrates);
            Object[] rowData = new Object[]{orgname, taxpayer, taxsystem, taxareagroup, taxtype, skssqqz, ynse, jmse, ynsr, sfl, qntqynse, sntqjmse, smtqynsr, sntqsfl, tbbdl, refRate.getLeft(), refRate.getMiddle(), refRate.getRight(), glqy, sshyName, billno, templatetype, id};
            result.add(rowData);
        }
        CollectionInput inputs = new CollectionInput(ROW_META, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private DataSet emptyResultDataSet() {
        CollectionInput inputs = new CollectionInput(ROW_META, new ArrayList());
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "emptyResultDataSet")).createDataSet(new Input[]{inputs});
    }

    private Map<Long, List<DynamicObject>> queryTaxMainInfo(List<Long> orgs) {
        List labels = TaxcMainServiceHelper.getTaxcMain(orgs, null);
        return labels.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid.id")));
    }

    private Map<String, List<QFilter>> getFilters(FilterInfo filterInfo, Map<String, String> map, String type) {
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        ArrayList<QFilter> lastqFilters = new ArrayList<QFilter>(8);
        for (FilterItemInfo filter : list) {
            if (null == filter || null == filter.getValue()) continue;
            QFilter qFilter = this.getSingleFilter(filter, map, 0, type);
            if (null != qFilter) {
                qFilters.add(qFilter);
            }
            QFilter lastqFilter = this.getSingleFilter(filter, map, 1, type);
            if (null == qFilter) continue;
            lastqFilters.add(lastqFilter);
        }
        HashMap<String, List<QFilter>> resultMap = new HashMap<String, List<QFilter>>(16);
        resultMap.put("year", qFilters);
        resultMap.put("lastyear", lastqFilters);
        return resultMap;
    }

    private QFilter getSingleFilter(FilterItemInfo filterItemInfo, Map<String, String> map, int year, String type) {
        String value;
        QFilter qFilter = null;
        String name = filterItemInfo.getPropName();
        if (map.containsKey(name)) {
            String valueKey = map.get(name);
            List ids = RptUtils.getFilterValueIds((FilterItemInfo)filterItemInfo);
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                qFilter = new QFilter(valueKey, "in", (Object)ids);
            }
        } else if ("startdate".equals(name)) {
            qFilter = new QFilter("skssqq", ">=", (Object)DateUtils.addYear((Date)DateUtils.getFirstDateOfMonth((Date)((Date)filterItemInfo.getValue())), (int)(-year)));
        } else if ("enddate".equals(name)) {
            qFilter = new QFilter("skssqz", "<=", (Object)DateUtils.addYear((Date)DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue())), (int)(-year)));
        } else if ("declaretype".equals(name)) {
            if (filterItemInfo.getValue() != null) {
                List declareType = Arrays.stream(filterItemInfo.getValue().toString().split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                String field = "tjsjb".equals(type) ? "type" : "templatetype";
                qFilter = new QFilter(field, "in", declareType);
            }
        } else if ("levytype".equals(name) && StringUtils.isNotEmpty((CharSequence)(value = (String)filterItemInfo.getValue()))) {
            List collect = Arrays.stream(value.split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            qFilter = new QFilter("levytype", "in", collect);
        }
        return qFilter;
    }
}

