/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.abstractrpt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.IReportView;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.taxc.tctsa.common.enums.TaxrateQueryContainerEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.CheckDateUtils;
import kd.taxc.tctsa.common.util.DateUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractTctsaRptPlugin
extends AbstractReportFormPlugin {
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        OrgServiceHelper.initOrgArrNew((IFormView)this.getView());
        CheckDateUtils.setDefaultDate((IReportView)this.getView());
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object orgs = this.getModel().getValue("orgs");
        if (ObjectUtils.isEmpty((Object)orgs)) {
            return false;
        }
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (ObjectUtils.isEmpty((Object)startDate) || ObjectUtils.isEmpty((Object)endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u5fc5\u987b\u540c\u65f6\u7ef4\u62a4\u3002", (String)"AbstractTctsaRptPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        boolean result = CheckDateUtils.validateDate((Date)startDate, (Date)endDate);
        if (!result) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\u3002", (String)"AbstractTctsaRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.clearUserSetting();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        super.beforeQuery(queryParam);
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)RequestContext.get().getCurrUserId(), (String)configKey);
    }

    public void registerListener(EventObject e) {
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(TaxrateQueryContainerEnum.ORG.getCode());
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        List orgIds = OrgServiceHelper.getOrgListHasPermissionAll();
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", (Object)orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("reset".equals(afterDoOperationEventArgs.getOperateKey())) {
            OrgServiceHelper.initOrgArrNew((IFormView)this.getView());
            CheckDateUtils.setDefaultDate((IReportView)this.getView());
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = this.formatShowFilter(showFieldList, iDataModel);
            evt.setFormatedFilterString(msg);
        }
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = this.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"AbstractTctsaRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AbstractTctsaRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }
}

