/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.jtsbsjcompare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.exchangerate.ExchangeRateDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tctsa.business.taxmain.TctsaTaxOrgBusiness;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.TjSbSjCompareColEnum;
import kd.taxc.tctsa.common.enums.TjSbSjEnum;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.report.jtsbsjcompare.TJSbSJCompareBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TjSbSjCompareRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(TjSbSjCompareRptQueryPlugin.class);
    private static final String ENDDATE = "endDate";
    private static final String STARTDATE = "startdate";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.getFilter(reportQueryParam);
    }

    private DataSet getFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfos = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"TjSbSjCompareRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        }
        return this.selectData(filterItemInfos);
    }

    public DataSet selectData(List<FilterItemInfo> filterItemInfos) {
        FilterItemInfo orgsItemInfo = null;
        FilterItemInfo startdateInfo = null;
        FilterItemInfo enddateInfo = null;
        FilterItemInfo taxtypeInfo = null;
        FilterItemInfo taxationsysInfo = null;
        FilterItemInfo taxareaInfo = null;
        FilterItemInfo convertcurrencyInfo = null;
        FilterItemInfo exratetableInfo = null;
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        List<Object> collect = new ArrayList(2);
        for (FilterItemInfo itemInfo : filterItemInfos) {
            String value;
            if ("orgs".equalsIgnoreCase(itemInfo.getPropName())) {
                orgsItemInfo = itemInfo;
                continue;
            }
            if ("taxtype".equalsIgnoreCase(itemInfo.getPropName())) {
                taxtypeInfo = itemInfo;
                continue;
            }
            if (STARTDATE.equalsIgnoreCase(itemInfo.getPropName())) {
                startdateInfo = itemInfo;
                continue;
            }
            if (ENDDATE.equalsIgnoreCase(itemInfo.getPropName())) {
                enddateInfo = itemInfo;
                continue;
            }
            if ("taxationsys".equalsIgnoreCase(itemInfo.getPropName())) {
                taxationsysInfo = itemInfo;
                continue;
            }
            if ("taxarea".equalsIgnoreCase(itemInfo.getPropName())) {
                taxareaInfo = itemInfo;
                continue;
            }
            if ("convertcurrency".equalsIgnoreCase(itemInfo.getPropName())) {
                convertcurrencyInfo = itemInfo;
                continue;
            }
            if ("exratetable".equalsIgnoreCase(itemInfo.getPropName())) {
                exratetableInfo = itemInfo;
                continue;
            }
            if ("dimension".equalsIgnoreCase(itemInfo.getPropName())) {
                dimensionInfo = itemInfo;
                continue;
            }
            if (!"levytype".equalsIgnoreCase(itemInfo.getPropName()) || !StringUtils.isNotEmpty((CharSequence)(value = (String)itemInfo.getValue()))) continue;
            collect = Arrays.stream(value.split(",")).filter(v -> StringUtils.isNotEmpty((CharSequence)v)).collect(Collectors.toList());
        }
        Date startDate = DateUtils.getFirstDateOfMonth((Date)(startdateInfo == null || startdateInfo.getValue() == null ? new Date() : (Date)startdateInfo.getValue()));
        QFilter qfilter = new QFilter("skssqq", ">=", (Object)startDate);
        Date endDate = DateUtils.getLastDateOfMonth((Date)(enddateInfo == null || enddateInfo.getValue() == null ? new Date() : (Date)enddateInfo.getValue()));
        qfilter.and(new QFilter("skssqz", "<=", (Object)endDate));
        this.getQFilter(orgsItemInfo, "org", qfilter);
        this.getQFilter(taxtypeInfo, "taxtype", qfilter);
        this.getQFilter(taxationsysInfo, "taxationsys", qfilter);
        this.getQFilter(taxareaInfo, "taxareagroup", qfilter);
        try {
            DataSet provisiondataSet = QueryServiceHelper.queryDataSet((String)TjSbSjCompareRptQueryPlugin.class.getName(), (String)"tctsa_provision_tjsjb", (String)"skssqq,skssqz,org.id,taxtype.id,taxationsys.id,taxareagroup.id,org.name,taxtype.name,taxationsys.name,taxareagroup.name,currency,sjtotal", (QFilter[])new QFilter[]{qfilter}, null);
            qfilter.and(new QFilter("levytype", "in", collect));
            DataSet sjbdataSet = QueryServiceHelper.queryDataSet((String)TjSbSjCompareRptQueryPlugin.class.getName(), (String)"tctb_tjsjb", (String)"skssqq,skssqz,org.id,taxtype.id,taxationsys.id,taxareagroup.id,org.name,taxtype.name,taxationsys.name,taxareagroup.name,bqybtse,sjsj", (QFilter[])new QFilter[]{qfilter}, null);
            HashMap<String, Object> jsonmap = new HashMap<String, Object>();
            jsonmap.put("skssqq", startDate);
            jsonmap.put("skssqz", endDate);
            DataSet provisiondataSumSet = provisiondataSet.groupBy("org.id,taxtype.id,taxationsys.id,taxareagroup.id,org.name,taxtype.name,taxationsys.name,taxareagroup.name,currency".split(",")).sum("sjtotal").finish();
            DataSet sjSumDataset = sjbdataSet.groupBy("org.id,taxtype.id,taxationsys.id,taxareagroup.id,org.name,taxtype.name,taxationsys.name,taxareagroup.name".split(",")).sum("bqybtse").sum("sjsj").finish();
            provisiondataSet.close();
            sjbdataSet.close();
            return this.createCol(provisiondataSumSet, sjSumDataset, convertcurrencyInfo, exratetableInfo, dimensionInfo, jsonmap);
        }
        catch (Exception e) {
            logger.info("TjSbSjCompareRptQueryPlugin.selectData=", (Object)e);
            List cols = TjSbSjCompareColEnum.createDynamicCol();
            return this.emptyResultDataSet(cols);
        }
    }

    private void getQFilter(FilterItemInfo iteminfo, String property, QFilter qfilter) {
        ArrayList iteminfoIds;
        List<Object> list = iteminfoIds = iteminfo == null || iteminfo.getValue() == null ? new ArrayList() : ((List)iteminfo.getValue()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(iteminfoIds)) {
            qfilter = ObjectUtils.isEmpty((Object)qfilter) ? new QFilter(property, "in", iteminfoIds) : qfilter.and(new QFilter(property, "in", iteminfoIds));
        }
    }

    private DataSet createCol(DataSet provisiondataSumSet, DataSet sjSumDataset, FilterItemInfo convertcurrencyInfo, FilterItemInfo exratetableInfo, FilterItemInfo dimensionInfo, Map<String, Object> jsonmap) {
        Object[] resRow;
        int index = TjSbSjEnum.getindexFiledByCode((String)dimensionInfo.getValue().toString());
        List cols = TjSbSjCompareColEnum.createDynamicCol();
        RowMeta rowMeta = BizCommomUtil.createRowMeta((List)cols);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(10);
        HashMap<String, Object> sjsumMap = new HashMap<String, Object>();
        DataSet sjSumDatasetnew = sjSumDataset.copy();
        Map taxpayerMap = TctsaTaxOrgBusiness.getTaxpayerMap((DataSet)sjSumDataset, (String)"org.id", (String)"taxationsys.id");
        for (Row sjSumRow : sjSumDatasetnew) {
            TJSbSJCompareBean bean = new TJSbSJCompareBean(sjSumRow.getString("org.id"), (String)taxpayerMap.get(sjSumRow.getString("org.id") + "_" + sjSumRow.getString("taxationsys.id")), sjSumRow.getString("taxationsys.id"), sjSumRow.getString("taxtype.id"), sjSumRow.getString("taxareagroup.id"), sjSumRow.getString("org.name"), sjSumRow.getString("taxtype.name"), sjSumRow.getString("taxationsys.name"), sjSumRow.getString("taxareagroup.name"), "0", BigDecimal.ZERO, sjSumRow.getBigDecimal("bqybtse"), sjSumRow.getBigDecimal("sjsj"), new Object[0]);
            sjsumMap.put(sjSumRow.getString("org.id") + "_" + sjSumRow.getString("taxtype.id") + "_" + sjSumRow.getString("taxationsys.id") + "_" + sjSumRow.getString("taxareagroup.id"), bean);
        }
        DataSet provisiondataSumSetnew = provisiondataSumSet.copy();
        Map jttaxpayerMap = TctsaTaxOrgBusiness.getTaxpayerMap((DataSet)provisiondataSumSet, (String)"org.id", (String)"taxationsys.id");
        for (Row provisiondatanodes : provisiondataSumSetnew) {
            String key = provisiondatanodes.getString("org.id") + "_" + provisiondatanodes.getString("taxtype.id") + "_" + provisiondatanodes.getString("taxationsys.id") + "_" + provisiondatanodes.getString("taxareagroup.id");
            resRow = sjsumMap.containsKey(key) ? this.createRow(jttaxpayerMap, provisiondatanodes, (TJSbSJCompareBean)sjsumMap.get(key), cols.size(), convertcurrencyInfo, exratetableInfo, jsonmap) : this.createRow(jttaxpayerMap, provisiondatanodes, new TJSbSJCompareBean(), cols.size(), convertcurrencyInfo, exratetableInfo, jsonmap);
            coll.add(resRow);
            sjsumMap.remove(key);
        }
        for (Map.Entry map : sjsumMap.entrySet()) {
            resRow = this.createRow(jttaxpayerMap, null, (TJSbSJCompareBean)map.getValue(), cols.size(), convertcurrencyInfo, exratetableInfo, jsonmap);
            coll.add(resRow);
        }
        provisiondataSumSet.close();
        sjSumDataset.close();
        if (CollectionUtils.isNotEmpty(coll)) {
            Map<String, List<TJSbSJCompareBean>> tjsbsjmap = TJSbSJCompareBean.changeToTJSbSJCompareBean(coll, dimensionInfo.getValue().toString());
            ArrayList<Object[]> collnew = new ArrayList<Object[]>();
            for (Map.Entry entry : tjsbsjmap.entrySet()) {
                List maplist = (List)entry.getValue();
                for (TJSbSJCompareBean tjSbSJCompareBean : maplist) {
                    collnew.add(tjSbSJCompareBean.getObj());
                }
                collnew.add(this.createTotalRow(cols.size(), collnew, convertcurrencyInfo, index, "1", (String)entry.getKey()));
            }
            collnew.add(this.createTotalRow(cols.size(), collnew, convertcurrencyInfo, index, "2", ""));
            CollectionInput inputs = new CollectionInput(rowMeta, collnew);
            return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "refundanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "refundanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
    }

    private DataSet emptyResultDataSet(List<RowMetaMsgInfo> cols) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "refundanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
    }

    private Object[] createRow(Map<String, String> jttaxpayerMap, Row nodes, TJSbSJCompareBean sjBean, int size, FilterItemInfo convertcurrencyInfo, FilterItemInfo exratetableInfo, Map<String, Object> jsonmap) {
        Long currency = nodes != null && nodes.get("currency") != null ? nodes.getLong("currency") : 0L;
        Object[] row = new Object[size];
        int index = 0;
        if (nodes != null && nodes.get("org.name") != null) {
            row[index++] = nodes.get("org.name");
            row[index++] = jttaxpayerMap.get(nodes.getString("org.id") + "_" + nodes.getString("taxationsys.id"));
            row[index++] = nodes.get("taxationsys.name");
            row[index++] = nodes.get("taxtype.name");
            row[index++] = nodes.get("taxareagroup.name");
            row[index++] = nodes.get("currency");
        } else {
            row[index++] = sjBean.getOrgName();
            row[index++] = sjBean.getTaxpayer();
            row[index++] = sjBean.getTaxationsysName();
            row[index++] = sjBean.getTaxtypeName();
            row[index++] = sjBean.getTaxareagroupName();
            if (sjBean.getTaxationsysId() != null && Long.parseLong(sjBean.getTaxationsysId()) == 1L) {
                row[index++] = 1L;
                currency = 1L;
            } else {
                row[index++] = 0L;
            }
        }
        BigDecimal sjtotalAmount = BigDecimal.ZERO;
        if (nodes != null && nodes.get("sjtotal") != null) {
            sjtotalAmount = nodes.getBigDecimal("sjtotal");
        }
        row[index++] = sjtotalAmount.setScale(2, 4);
        BigDecimal sbAmount = BigDecimal.ZERO;
        BigDecimal sjAmount = BigDecimal.ZERO;
        if (sjBean.getBqybtse() != null) {
            sbAmount = sjBean.getBqybtse();
        }
        if (sjBean.getSjsj() != null) {
            sjAmount = sjBean.getSjsj();
        }
        row[index++] = sbAmount.setScale(2, 4);
        row[index++] = sjAmount.setScale(2, 4);
        row[index++] = sbAmount.subtract(sjtotalAmount).setScale(2, 4);
        row[index++] = sjAmount.subtract(sbAmount).setScale(2, 4);
        if (!ObjectUtils.isEmpty((Object)convertcurrencyInfo.getValue())) {
            DynamicObject obj = (DynamicObject)convertcurrencyInfo.getValue();
            row[index++] = obj.getLong("id");
            DynamicObject exobj = (DynamicObject)exratetableInfo.getValue();
            TaxResult result = ExchangeRateDataServiceHelper.getExchangeRate((Long)exobj.getLong("id"), (Long)currency, (Long)obj.getLong("id"), (Date)DateUtils.trunc((Date)new Date(), (String)"yyyy-MM-dd"));
            if (result.isSuccess() && result.getData() != null) {
                BigDecimal indirectexrate = (BigDecimal)result.getData();
                row[index++] = indirectexrate.multiply(sjtotalAmount).setScale(2, 4);
                row[index++] = indirectexrate.multiply(sbAmount).setScale(2, 4);
                row[index++] = indirectexrate.multiply(sjAmount).setScale(2, 4);
            }
        }
        if (nodes != null) {
            jsonmap.put("org", nodes.get("org.id"));
            jsonmap.put("taxtype", nodes.get("taxtype.id"));
            jsonmap.put("taxationsys", nodes.get("taxationsys.id"));
            jsonmap.put("taxareagroup", nodes.get("taxareagroup.id"));
        } else {
            jsonmap.put("org", StringUtils.isNotEmpty((CharSequence)sjBean.getOrgId()) ? Long.parseLong(sjBean.getOrgId()) : 0L);
            jsonmap.put("taxtype", StringUtils.isNotEmpty((CharSequence)sjBean.getTaxtypeId()) ? Long.parseLong(sjBean.getTaxtypeId()) : 0L);
            jsonmap.put("taxationsys", StringUtils.isNotEmpty((CharSequence)sjBean.getTaxationsysId()) ? Long.parseLong(sjBean.getTaxationsysId()) : 0L);
            jsonmap.put("taxareagroup", StringUtils.isNotEmpty((CharSequence)sjBean.getTaxareagroupId()) ? Long.parseLong(sjBean.getTaxareagroupId()) : 0L);
        }
        jsonmap.put("currency", currency);
        row[15] = JsonUtil.toJson(jsonmap);
        return row;
    }

    public BigDecimal getTotal(List<Object[]> coll, int i) {
        BigDecimal number6 = BigDecimal.ZERO;
        List list6 = coll.stream().map(v -> v[i]).collect(Collectors.toList());
        for (Object o : list6) {
            number6 = BigDecimalUtil.addObject(o, (Object)number6);
        }
        return number6;
    }

    private Object[] createTotalRow(int size, List<Object[]> coll, FilterItemInfo convertcurrencyInfo, int indexSize, String totalName, String chinesscolname) {
        ArrayList<Object[]> insertcoll = new ArrayList<Object[]>();
        for (Object[] objects : coll) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)totalName)) {
                if ((!StringUtils.isEmpty((CharSequence)chinesscolname) || objects[indexSize] != null) && (objects[indexSize] == null || !StringUtils.equalsIgnoreCase((CharSequence)objects[indexSize].toString(), (CharSequence)chinesscolname))) continue;
                insertcoll.add(objects);
                continue;
            }
            if (objects[indexSize] == null || !StringUtils.equalsIgnoreCase((CharSequence)objects[indexSize].toString(), (CharSequence)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TjSbSjCompareRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]))) continue;
            insertcoll.add(objects);
        }
        Object[] row = new Object[size];
        for (int i = 0; i < 5; ++i) {
            row[i] = indexSize == i ? (StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)totalName) ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TjSbSjCompareRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TjSbSjCompareRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0])) : "";
        }
        int index = 5;
        row[index++] = null;
        row[index++] = this.getTotal(insertcoll, 6);
        row[index++] = this.getTotal(insertcoll, 7);
        row[index++] = this.getTotal(insertcoll, 8);
        row[index++] = this.getTotal(insertcoll, 9);
        row[index++] = this.getTotal(insertcoll, 10);
        if (!ObjectUtils.isEmpty((Object)convertcurrencyInfo.getValue())) {
            DynamicObject obj = (DynamicObject)convertcurrencyInfo.getValue();
            row[index++] = obj.getLong("id");
            row[index++] = this.getTotal(insertcoll, 12);
            row[index++] = this.getTotal(insertcoll, 13);
            row[index] = this.getTotal(insertcoll, 14);
        }
        row[15] = "0";
        return row;
    }
}

