/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.jtsbsjcompare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.KdToolUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctsa.common.enums.ShowDeclareEnum;
import kd.taxc.tctsa.common.enums.TjSbSjEnum;
import kd.taxc.tctsa.common.enums.TysbDeclareEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.report.abstractrpt.AbstractTctsaRptPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TjSbSjCompateRptPlugin
extends AbstractTctsaRptPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl("orgs");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object exratetable = this.getModel().getValue("exratetable");
        Object convertcurrency = this.getModel().getValue("convertcurrency");
        if (ObjectUtils.isNotEmpty((Object)convertcurrency) && ObjectUtils.isEmpty((Object)exratetable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u5fc5\u586b\u3002", (String)"TjSbSjCompateRptPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("dimension".equals(name)) {
            this.getView().refresh();
        }
    }

    @Override
    public void beforeQuery(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("dimension") || item.getPropName().equals("isChangeDimension"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("dimension");
        dimensionInfo.setValue(this.getModel().getValue("dimension"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        super.beforeQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List list = event.getColumns();
        String dimension = (String)this.getModel().getValue("dimension");
        String fieldCol = TjSbSjEnum.getConameByCode((String)dimension);
        for (int i = 0; i < list.size(); ++i) {
            ReportColumn reportColumn;
            if (!(list.get(i) instanceof ReportColumn) || !StringUtils.equalsIgnoreCase((CharSequence)(reportColumn = (ReportColumn)list.get(i)).getFieldKey(), (CharSequence)fieldCol)) continue;
            Collections.swap(list, 0, i);
        }
        DynamicObject dynamicObjects = (DynamicObject)this.getModel().getValue("convertcurrency");
        if (ObjectUtils.isEmpty((Object)dynamicObjects)) {
            for (AbstractReportColumn abstractReportColumn : list) {
                if (!(abstractReportColumn instanceof ReportColumn)) continue;
                ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
                String field = reportColumn.getFieldKey();
                List<String> hiddenList = Arrays.asList("convertcurrencycol,convertjtamount,convertsbamount,convertsjamount".split(","));
                if (!hiddenList.contains(field)) continue;
                reportColumn.setHide(true);
            }
        }
    }

    public void packageData(PackageDataEvent evt) {
        if (evt.getFormatValue() != null && StringUtils.equalsIgnoreCase((CharSequence)evt.getRowData().getString("filtejson"), (CharSequence)"0")) {
            evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        switch (hyperLinkClickEvent.getFieldName()) {
            case "jtamount": 
            case "sbamount": {
                this.openJtSb(hyperLinkClickEvent);
                break;
            }
            case "sjamount": {
                this.openSj(hyperLinkClickEvent);
                break;
            }
        }
    }

    private void openJtSb(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject type = hyperLinkClickEvent.getRowData();
        String filtejson = type.getString("filtejson");
        Map map = (Map)JsonUtil.fromJson((String)filtejson, Map.class);
        DynamicObjectCollection col = this.getList(hyperLinkClickEvent, map);
        if (CollectionUtils.isEmpty((Collection)col)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be6\u7ec6\u6570\u636e", (String)"TjSbSjCompateRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return;
        }
        boolean nullFlag = col.stream().anyMatch(v -> StringUtils.isEmpty((CharSequence)v.getString("sbbid")) || StringUtils.isEmpty((CharSequence)v.getString("metadataid")));
        if (nullFlag) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u56fa\u5b9a\u586b\u62a5\u4e8b\u9879\u8d85\u94fe\u63a5\u8df3\u8f6c\u3002", (String)"TjSbSjCompateRptPlugin_5", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return;
        }
        Map metadataidMap = col.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getString("sbbid")) && StringUtils.isNotEmpty((CharSequence)v.getString("metadataid"))).collect(Collectors.groupingBy(v -> v.getString("metadataid"), Collectors.toList()));
        for (Map.Entry<String, List<DynamicObject>> entry : metadataidMap.entrySet()) {
            LinkQueryPkIdCollection collection;
            ListFilterParameter listFilterParameter;
            List pkidList = entry.getValue().stream().map(v -> v.getLong("sbbid")).collect(Collectors.toList());
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId(entry.getKey());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Long taxtypeId = CollectionUtils.isNotEmpty((Collection)entry.getValue()) ? ((DynamicObject)entry.getValue().get(0)).getLong("taxtype") : 0L;
            if (StringUtils.equalsIgnoreCase((CharSequence)"tcvat_zzs_declare_list", (CharSequence)entry.getKey())) {
                listFilterParameter = new ListFilterParameter();
                collection = KdToolUtils.listToLinkQueryPkidColl(pkidList);
                param.setLinkQueryPkIdCollection(collection);
                param.setListFilterParameter(listFilterParameter);
                listFilterParameter.setFilter(new QFilter("entryentity.taxtypes", "=", (Object)ShowDeclareEnum.getzzsIdBytaxTypeId((Long)taxtypeId)));
                param.setListFilterParameter(listFilterParameter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"tcret_query_report", (CharSequence)entry.getKey()) || StringUtils.equalsIgnoreCase((CharSequence)"totf_tysb_declare_main", (CharSequence)entry.getKey())) {
                if (hyperLinkClickEvent.getFieldName().equals("sbamount")) {
                    this.setFilterCxxQtsf(entry, param, taxtypeId, map);
                }
            } else {
                listFilterParameter = new ListFilterParameter();
                collection = KdToolUtils.listToLinkQueryPkidColl(pkidList);
                param.setLinkQueryPkIdCollection(collection);
                param.setListFilterParameter(listFilterParameter);
            }
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private void setFilterCxxQtsf(Map.Entry<String, List<DynamicObject>> map1, ListShowParameter param, Long taxtypeId, Map<String, Object> map) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"tcret_query_report", (CharSequence)map1.getKey())) {
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(new QFilter("entryentity.taxtype", "=", (Object)ShowDeclareEnum.getccsIdBytaxTypeId((Long)taxtypeId)).and(new QFilter("entryentity.startdate", ">=", (Object)new Date((Long)map.get("skssqq")))).and(new QFilter("entryentity.enddate", "<=", (Object)new Date((Long)map.get("skssqz")))));
            List<Long> ccsIds = this.getccsIdList(map1.getValue());
            if (CollectionUtils.isEmpty(ccsIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7533\u62a5\u8868\u7f16\u53f7", (String)"TjSbSjCompateRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            }
            LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(ccsIds);
            param.setLinkQueryPkIdCollection(collection);
            param.setListFilterParameter(listFilterParameter);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"totf_tysb_declare_main", (CharSequence)map1.getKey())) {
            List<Long> qtsfIds = this.getqtsfIdList(map1.getValue());
            if (CollectionUtils.isEmpty(qtsfIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7533\u62a5\u8868\u7f16\u53f7", (String)"TjSbSjCompateRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            }
            LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(qtsfIds);
            param.setLinkQueryPkIdCollection(collection);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            List<String> zspmList = Arrays.asList(TysbDeclareEnum.getzspmNameByTaxId((Long)taxtypeId));
            listFilterParameter.setFilter(new QFilter("entryentity.zspm", "in", zspmList).and(new QFilter("entryentity.startdate", ">=", (Object)new Date((Long)map.get("skssqq")))).and(new QFilter("entryentity.enddate", "<=", (Object)new Date((Long)map.get("skssqz")))));
            param.setListFilterParameter(listFilterParameter);
        }
    }

    private List<Long> getccsIdList(List<DynamicObject> list) {
        List formnoList = list.stream().map(v -> v.getString("formno")).collect(Collectors.toList());
        DynamicObjectCollection object1 = QueryServiceHelper.query((String)"tcret_query_report", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", formnoList)});
        return object1.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
    }

    private List<Long> getqtsfIdList(List<DynamicObject> list) {
        List formnoList = list.stream().map(v -> v.getString("formno")).collect(Collectors.toList());
        DynamicObjectCollection object = QueryServiceHelper.query((String)"totf_tysb_declare_main", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", formnoList)});
        return object.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openSj(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject type = hyperLinkClickEvent.getRowData();
        String filtejson = type.getString("filtejson");
        Map map = (Map)JsonUtil.fromJson((String)filtejson, Map.class);
        if (Long.parseLong(map.get("taxationsys").toString()) == 1L) {
            DynamicObjectCollection col = this.getList(hyperLinkClickEvent, map);
            if (CollectionUtils.isEmpty((Collection)col)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be6\u7ec6\u6570\u636e", (String)"TjSbSjCompateRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
                return;
            }
            List<Object> sbbidList = col.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getString("sbbid")) && StringUtils.isNotEmpty((CharSequence)v.getString("metadataid"))).map(v -> v.getLong("sbbid")).collect(Collectors.toList());
            List metadataidList = col.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getString("sbbid")) && StringUtils.isNotEmpty((CharSequence)v.getString("metadataid"))).map(v -> v.getString("metadataid")).collect(Collectors.toList());
            if (metadataidList.contains("tcret_query_report")) {
                sbbidList = this.getccsIdList((List<DynamicObject>)col);
            }
            if (metadataidList.contains("totf_tysb_declare_main")) {
                sbbidList = this.getqtsfIdList((List<DynamicObject>)col);
            }
            List sbbisStringList = sbbidList.stream().map(v -> v.toString()).collect(Collectors.toList());
            QFilter sbbid1QFilter = new QFilter("sbbid", "in", sbbisStringList);
            String jbdId = ShowDeclareEnum.getjndIdBytaxTypeId((Long)((DynamicObject)col.get(0)).getLong("taxtype"));
            sbbid1QFilter.and(new QFilter("taxtype", "in", (Object)jbdId.split(",")));
            sbbid1QFilter.and(new QFilter("paystatus", "=", (Object)"1"));
            sbbid1QFilter.and(new QFilter("skssqq", ">=", (Object)new Date((Long)map.get("skssqq")))).and(new QFilter("skssqz", "<=", (Object)new Date((Long)map.get("skssqz"))));
            DynamicObjectCollection payCollection = QueryServiceHelper.query((String)"bdtaxr_pay_record", (String)"id", (QFilter[])new QFilter[]{sbbid1QFilter});
            List payIdList = payCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(payIdList)) {
                LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(payIdList);
                ListShowParameter param = new ListShowParameter();
                param.setLinkQueryPkIdCollection(collection);
                param.setBillFormId("bdtaxr_pay_record");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)param);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u7f34\u7eb3\u5355\u8be6\u7ec6\u6570\u636e", (String)"TjSbSjCompateRptPlugin_4", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return;
        }
        QFilter gtcpqfilter = this.getCommonQfilter(map);
        if (map.containsKey("taxtype")) {
            gtcpqfilter.and(new QFilter("taxcategory", "=", map.get("taxtype")));
        }
        gtcpqfilter.and(new QFilter("payrefstatus", "in", Arrays.asList("pay,refund".split(","))));
        DynamicObjectCollection gtcppayCollection = QueryServiceHelper.query((String)"gtcp_taxpay_refund_bill", (String)"id", (QFilter[])new QFilter[]{gtcpqfilter});
        List gtcppayIdList = gtcppayCollection.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(gtcppayIdList)) {
            LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(gtcppayIdList);
            ListShowParameter param = new ListShowParameter();
            param.setLinkQueryPkIdCollection(collection);
            param.setBillFormId("gtcp_taxpay_refund_bill");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be6\u7ec6\u6570\u636e", (String)"TjSbSjCompateRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
    }

    public DynamicObjectCollection getList(HyperLinkClickEvent hyperLinkClickEvent, Map<String, Object> map) {
        QFilter qfilter = this.getCommonQfilter(map);
        if (map.containsKey("taxtype")) {
            qfilter.and(new QFilter("taxtype", "=", map.get("taxtype")));
        } else {
            qfilter.and(new QFilter("taxtype", "=", (Object)0L));
        }
        if (hyperLinkClickEvent.getFieldName().equals("jtamount")) {
            return QueryServiceHelper.query((String)"tctsa_provision_tjsjb", (String)"taxtype,sbbid,metadataid", (QFilter[])new QFilter[]{qfilter});
        }
        qfilter.and(LevytypeHelper.getLevytype());
        return QueryServiceHelper.query((String)"tctb_tjsjb", (String)"taxtype,sbbid,metadataid,formno", (QFilter[])new QFilter[]{qfilter});
    }

    private QFilter getCommonQfilter(Map<String, Object> map) {
        QFilter qfilter = new QFilter("skssqq", ">=", (Object)new Date((Long)map.get("skssqq")));
        qfilter.and(new QFilter("skssqz", "<=", (Object)new Date((Long)map.get("skssqz"))));
        if (map.containsKey("org")) {
            qfilter.and(new QFilter("org", "=", map.get("org")));
        } else {
            qfilter.and(new QFilter("org", "=", (Object)0L));
        }
        if (map.containsKey("taxationsys")) {
            qfilter.and(new QFilter("taxationsys", "=", map.get("taxationsys")));
        } else {
            qfilter.and(new QFilter("taxationsys", "=", (Object)0L));
        }
        if (map.containsKey("taxareagroup")) {
            qfilter.and(new QFilter("taxareagroup", "=", map.get("taxareagroup")));
        } else {
            qfilter.and(new QFilter("taxareagroup", "=", (Object)0L));
        }
        return qfilter;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("orgs".equals(beforeF7SelectEvent.getProperty().getName())) {
            List<Long> taxOrgList = TjSbSjCompateRptPlugin.queryTaxOrgWithPerm(RequestContext.get().getCurrUserId());
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("id", "in", taxOrgList));
        }
    }

    public static List<Long> queryTaxOrgWithPerm(long userId) {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryOrgIdByViewWithPerm((Long)userId, (String)"40", (boolean)true);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }
}

