/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.sdsjt;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class SdsjtRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        MulBasedataEdit tablefield = (MulBasedataEdit)this.getControl("orgs");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List filterItemInfoList = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItemInfoList) {
            if (!"orgs".equalsIgnoreCase(filterItemInfo.getPropName()) || filterItemInfo.getValue() != null || !"67".equalsIgnoreCase(filterItemInfo.getCompareType())) continue;
            List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
            filterItemInfo.setValue((Object)taxOrgIdsWithPerm);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        this.getModel().setValue("enddate", (Object)DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1))));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxationsys".equals(name)) {
            this.getModel().setValue("orgs", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("orgs".equalsIgnoreCase(name)) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys == null) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"SdsjtRptPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
                return;
            }
            TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)taxationsys.getLong("id"));
            if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
                List taxOrgIdsWithPerm = (List)taxResult.getData();
                formShowParameter.setMultiSelect(true);
                QFilter qFilter = new QFilter("id", "in", (Object)taxOrgIdsWithPerm);
                evt.addCustomQFilter(qFilter);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (this.getModel().getValue("taxationsys") == null) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }
}

