/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.sdsjt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class SdsjtRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String COL_MAP = "colMap";
    private static final String SDSJT_JT = "sdsjt_jt";

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        columns.clear();
        LinkedHashMap colMap = (LinkedHashMap)this.getQueryParam().getCustomParam().get(COL_MAP);
        if (MapUtils.isEmpty((Map)colMap)) {
            return columns;
        }
        for (Map.Entry entry : colMap.entrySet()) {
            ReportColumn endRpt = new ReportColumn();
            endRpt.setCaption(new LocaleString((String)entry.getKey()));
            endRpt.setFieldKey((String)entry.getValue());
            endRpt.setFieldType("text");
            if (!"item".equals(entry.getValue())) {
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setTextAlign("right");
                endRpt.setStyle(columnStyle);
            }
            columns.add((AbstractReportColumn)endRpt);
        }
        return columns;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        String jeWd;
        String field = null;
        String accountsettype = null;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "field": {
                    field = (String)filterItemInfo.getValue();
                    break;
                }
                case "accountsettype": {
                    accountsettype = (String)filterItemInfo.getValue();
                    break;
                }
            }
        }
        LinkedHashMap<String, String> colMap = new LinkedHashMap<String, String>(8);
        DataSet dataSource = this.genDataset(reportQueryParam);
        if (dataSource == null) {
            this.getQueryParam().getCustomParam().put(COL_MAP, colMap);
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"field"}, (DataType[])new DataType[]{DataType.StringType});
            CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        ArrayList<String[]> result = new ArrayList<String[]>(12);
        DataSet orgDataset = dataSource.copy().select(new String[]{"orgid", "orgname", "orgnumber"}).distinct().orderBy(new String[]{"orgnumber asc"});
        String xm = ResManager.loadKDString((String)"\u9879\u76ee", (String)"SdsjtRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        colMap.put(xm, "item");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("item");
        DataSet copy1 = orgDataset.copy();
        for (Row row : copy1) {
            colMap.put(row.getString("orgname"), row.getString("orgid"));
            fields.add(row.getString("orgid"));
        }
        copy1.close();
        this.getQueryParam().getCustomParam().put(COL_MAP, colMap);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])((DataType[])fields.stream().map(m -> DataType.StringType).toArray(DataType[]::new)));
        DataSet mapDataset = dataSource.copy();
        HashMap<String, String> map = new HashMap<String, String>(1024);
        for (Row row : mapDataset) {
            String key = row.getString("orgid") + "#" + row.getString("cellnumber");
            String value = row.getString("value");
            map.put(key, value);
        }
        mapDataset.close();
        DataSet orgDatasetCopy = orgDataset.copy();
        ArrayList<String> orgList = new ArrayList<String>(8);
        for (Row row : orgDatasetCopy) {
            orgList.add(row.getString("orgid"));
        }
        orgDatasetCopy.close();
        String string = jeWd = "bnbd".equals(field) ? "zcycgl_bnbd_hj" : "zcycgl_qmye";
        if (SDSJT_JT.equals(accountsettype)) {
            result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u7a0e\u524d\u5229\u6da6\uff08\u96c6\u56e2\uff09", (String)"SdsjtRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]), "dqsds_sqlr_jt#dqsds_hj", map, orgList));
            result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"GAAP\u6c38\u4e45\u6027\u5dee\u5f02", (String)"SdsjtRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]), "zcycgl_gaap_yjxcy#" + jeWd, map, orgList));
            result.addAll(this.handleDynRows("zcycgl_gaap_yjxcy_cyxm", jeWd, dataSource, map, orgList));
            result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"GAAP\u6682\u65f6\u6027\u5dee\u5f02", (String)"SdsjtRptQueryPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]), "zcycgl_gaap_zsxcy#" + jeWd, map, orgList));
            result.addAll(this.handleDynRows("zcycgl_gaap_zsxcy_cyxm", jeWd, dataSource, map, orgList));
        }
        result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u7a0e\u524d\u5229\u6da6\uff08\u672c\u5730\uff09", (String)"SdsjtRptQueryPlugin_8", (String)"taxc-tctsa-report", (Object[])new Object[0]), "dqsds_sqlr_bd#dqsds_hj", map, orgList));
        result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u6c38\u4e45\u6027\u5dee\u5f02", (String)"SdsjtRptQueryPlugin_4", (String)"taxc-tctsa-report", (Object[])new Object[0]), "zcycgl_yjxcy#" + jeWd, map, orgList));
        result.addAll(this.handleDynRows("zcycgl_yjxcy_cyxm", jeWd, dataSource, map, orgList));
        result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u6682\u65f6\u6027\u5dee\u5f02", (String)"SdsjtRptQueryPlugin_5", (String)"taxc-tctsa-report", (Object[])new Object[0]), "zcycgl_zsxcy#" + jeWd, map, orgList));
        result.addAll(this.handleDynRows("zcycgl_zsxcy_cyxm", jeWd, dataSource, map, orgList));
        result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u5e94\u4ea4\u6240\u5f97\u7a0e", (String)"SdsjtRptQueryPlugin_9", (String)"taxc-tctsa-report", (Object[])new Object[0]), "dqsds_sjynsdse#dqsds_hj", map, orgList));
        String s = "bnbd".equals(field) ? "dysds_bnbd_hj" : "dysds_qmye";
        result.addAll(this.handleFixedRow(ResManager.loadKDString((String)"\u9012\u5ef6\u6240\u5f97\u7a0e", (String)"SdsjtRptQueryPlugin_10", (String)"taxc-tctsa-report", (Object[])new Object[0]), "dysds_dyshj#" + s, map, orgList));
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private List<String[]> handleDynRows(String hw, String jelw, DataSet dataSource, Map<String, String> map, List<String> orgIds) {
        ArrayList<String[]> calResult = new ArrayList<String[]>(8);
        DataSet copy2 = dataSource.copy();
        QFilter qFilter = new QFilter("cellnumber", "like", (Object)"%#zcycgl_bbxm").and("cellnumber", "like", (Object)(hw + "#%"));
        DataSet filter = copy2.filter(qFilter.toString());
        copy2.close();
        ArrayList<Triple> triples = new ArrayList<Triple>();
        for (Row row : filter) {
            String orgid = row.getString("orgid");
            String index = row.getString("index");
            Triple triple = Triple.of((Object)orgid, (Object)index, (Object)Long.parseLong(row.getString("value")));
            triples.add(triple);
        }
        filter.close();
        Set collect = triples.stream().map(Triple::getRight).collect(Collectors.toSet());
        QFilter filter1 = new QFilter("id", "in", collect);
        DynamicObjectCollection fetchItemList = QueryServiceHelper.query((String)"itp_fetchitem", (String)"id,name,number", (QFilter[])filter1.toArray(), (String)"number asc");
        for (DynamicObject dyo : fetchItemList) {
            ArrayList<String> dynRow = new ArrayList<String>(8);
            long fetchItemId = dyo.getLong("id");
            dynRow.add("     " + dyo.getString("name"));
            for (String orgId : orgIds) {
                Optional<Triple> first = triples.stream().filter(m -> (Long)m.getRight() == fetchItemId && ((String)m.getLeft()).equals(orgId)).findFirst();
                String s = "0.00";
                if (first.isPresent()) {
                    Triple triple = first.get();
                    String index = (String)triple.getMiddle();
                    String key = orgId + "#" + hw + "#" + index + "#" + jelw;
                    String value = map.get(key);
                    s = value == null ? "0.00" : DataFormatUtils.formatMicrometer((String)value);
                }
                dynRow.add(s);
            }
            calResult.add(dynRow.toArray(new String[0]));
        }
        return calResult;
    }

    private List<String[]> handleFixedRow(String itemName, String cellNuber, Map<String, String> map, List<String> orgIds) {
        ArrayList<String> row = new ArrayList<String>(8);
        row.add(itemName);
        for (String orgId : orgIds) {
            String key = orgId + "#" + cellNuber;
            String value = map.get(key);
            String s = value == null ? "0.00" : DataFormatUtils.formatMicrometer((String)value);
            row.add(s);
        }
        ArrayList<String[]> calResult = new ArrayList<String[]>();
        calResult.add(row.toArray(new String[0]));
        return calResult;
    }

    public DataSet genDataset(ReportQueryParam reportQueryParam) {
        DynamicObjectCollection declareMainTsd;
        List<Object> orgIds = new ArrayList(8);
        Date startDate = null;
        Date endDate = null;
        Long taxationsys = null;
        String accountsettype = null;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        block14: for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "taxationsys": {
                    taxationsys = ((DynamicObject)filterItemInfo.getValue()).getLong("id");
                    break;
                }
                case "orgs": {
                    Object value = filterItemInfo.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        orgIds = new ArrayList<Long>(groups.keySet());
                        break;
                    }
                    if (value instanceof DynamicObject) {
                        orgIds = Collections.singletonList(((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List orgs = (List)value;
                    if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue block14;
                    List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
                    orgIds = orgs.stream().filter(Objects::nonNull).filter(taxOrgIdsWithPerm::contains).map(m -> Long.parseLong(m.toString())).distinct().collect(Collectors.toList());
                    break;
                }
                case "startdate": {
                    startDate = DateUtils.trunc((Date)((Date)filterItemInfo.getValue()));
                    break;
                }
                case "enddate": {
                    endDate = DateUtils.trunc((Date)((Date)filterItemInfo.getValue()));
                    break;
                }
                case "accountsettype": {
                    accountsettype = (String)filterItemInfo.getValue();
                    break;
                }
            }
        }
        QFilter declareMainFilter = new QFilter("templatetype", "=", accountsettype).and(new QFilter("billstatus", "in", Arrays.asList("B", "C"))).and(new QFilter("skssqz", "=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxationsys));
        String format = DateUtils.format((Date)startDate, (String)"yyyy-MM-dd");
        String endFormat = DateUtils.format((Date)endDate, (String)"yyyy-MM-dd");
        if (StringUtils.isNotEmpty((CharSequence)format) && format.endsWith("12-31") && format.equals(endFormat)) {
            declareMainFilter.and(new QFilter("skssqq", "=", (Object)startDate));
        } else {
            QFilter isadjustperiodFilter = new QFilter("isadjustperiod", "!=", (Object)true);
            declareMainFilter.and(isadjustperiodFilter);
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            declareMainFilter.and("org", "in", orgIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(declareMainTsd = QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,org.id,org.number,isadjustperiod", (QFilter[])declareMainFilter.toArray(), (String)"org.number asc")))) {
            List ids = declareMainTsd.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", ids);
            DataSet mainTsdDataSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_main_tsd", (String)"id,org.id orgid,org.name orgname,org.number orgnumber", (QFilter[])idFilter.toArray(), null);
            List entryids = declareMainTsd.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
            QFilter entryidQ = new QFilter("entryid", "in", entryids);
            DataSet mainTsdDetailSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_detail_tsd", (String)"entryid,cellnumber,dynrowno,index,valuetype,value", (QFilter[])entryidQ.toArray(), (String)"cellnumber asc");
            return mainTsdDataSet.leftJoin(mainTsdDetailSet).on("id", "entryid").select(new String[]{"id", "orgid", "orgname", "orgnumber"}, new String[]{"cellnumber", "dynrowno", "index", "value"}).finish();
        }
        return null;
    }
}

