/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxanalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.enums.TaxTypeReportIdEnum;
import kd.taxc.tctsa.common.enums.TaxrateQueryContainerEnum;
import kd.taxc.tctsa.common.enums.TreeShowTypeEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;
import org.apache.commons.lang.StringUtils;

public class TaxAnalysisRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        if ("-".equals(event.getFormatValue()) || "null".equals(event.getFormatValue())) {
            event.setFormatValue((Object)"");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("reset".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.setDefaultDate();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object orgs = this.getModel().getValue("orgs");
        String showtype = this.getModel().getValue("showtype").toString();
        if (EmptyCheckUtils.isEmpty((Object)orgs) && showtype.equals(TreeShowTypeEnum.TILE.getCode())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55\u793a\u65b9\u5f0f\u4e3a\u5e73\u94fa\u65f6\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"TaxAnalysisRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        if (EmptyCheckUtils.isEmpty((Object)startDate) || EmptyCheckUtils.isEmpty((Object)endDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u6b62\u65e5\u671f\u5fc5\u987b\u540c\u65f6\u7ef4\u62a4\u3002", (String)"TaxAnalysisRptPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        Boolean result = this.validateDate(startDate, endDate);
        if (!result.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TaxAnalysisRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    private boolean validateDate(Date start, Date end) {
        Date startdate;
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        return null == enddate || !(startdate = DateUtils.getFirstDateOfMonth((Date)start)).after(enddate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("showtype".equals(name)) {
            Object orgs = this.getModel().getValue("orgs");
            String showtype = this.getModel().getValue("showtype").toString();
            if (EmptyCheckUtils.isEmpty((Object)orgs) && showtype.equals(TreeShowTypeEnum.TILE.getCode())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55\u793a\u65b9\u5f0f\u4e3a\u5e73\u94fa\u65f6\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"TaxAnalysisRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
                String oldValue = (String)e.getChangeSet()[0].getOldValue();
                this.getModel().setValue("showtype", (Object)oldValue);
            } else {
                this.getView().refresh();
            }
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        OrgServiceHelper.initOrgArr((IFormView)this.getView(), (Boolean)true);
        this.setDefaultDate();
    }

    private void setDefaultDate() {
        this.getView().getModel().setValue(START_DATE, (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getView().getModel().setValue(END_DATE, (Object)DateUtils.getLastDateOfMonth2((Date)new Date()));
    }

    public void afterCreateNewData(EventObject e) {
        OrgServiceHelper.initOrgArr((IFormView)this.getView(), (Boolean)true);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"showtype"});
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(TaxrateQueryContainerEnum.ORG.getCode());
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        List orgIds = OrgServiceHelper.getOrgListHasPermissionAll();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter orgIdsFilter = new QFilter("id", "in", (Object)orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    private void clearUserSetting() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        ReportQueryParam queryParam = this.getQueryParam();
        Map map = queryParam.getCustomParam();
        String isVisble = map != null ? (String)map.get("isVisble") : "1";
        Boolean isshow = (Boolean)this.getView().getModel().getValue("isshow");
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getView().getModel().getValue("taxtype");
        List finalTypeList = dynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).distinct().collect(Collectors.toList());
        ArrayList<String> nameList = new ArrayList<String>(16);
        if (finalTypeList.size() == 0) {
            finalTypeList = TaxTypeReportIdEnum.getAllPashTaxTypeIds();
        }
        Iterator iterator = finalTypeList.iterator();
        while (iterator.hasNext()) {
            long taxtype = (Long)iterator.next();
            String name = TaxTypeReportIdEnum.getTaxNameByType((long)taxtype);
            nameList.add(name);
        }
        List list = event.getColumns();
        for (AbstractReportColumn abstractReportColumn : list) {
            String field;
            ReportColumnGroup reportColumn;
            if (abstractReportColumn instanceof ReportColumnGroup) {
                reportColumn = (ReportColumnGroup)abstractReportColumn;
                List abstractReportColumnList = reportColumn.getChildren();
                block2: for (AbstractReportColumn column : abstractReportColumnList) {
                    if (!(column instanceof ReportColumn)) continue;
                    ReportColumn columnson = (ReportColumn)column;
                    columnson.setHide(true);
                    for (String name : nameList) {
                        String id;
                        String columnsonFieldKey;
                        if (isshow.booleanValue()) {
                            columnsonFieldKey = columnson.getFieldKey();
                            id = columnsonFieldKey.split("_")[1];
                            if (!name.equals(id)) continue;
                            columnson.setHide(false);
                            continue block2;
                        }
                        columnsonFieldKey = columnson.getFieldKey();
                        id = columnsonFieldKey.split("_")[1];
                        String prefix = columnsonFieldKey.split("_")[0];
                        if (!name.equals(id) || !"bq".equals(prefix)) continue;
                        columnson.setHide(false);
                        columnson.setWidth(new LocaleString("100px"));
                        continue block2;
                    }
                }
            }
            if (!(abstractReportColumn instanceof ReportColumn) || !"issumline".equals(field = (reportColumn = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        IDataModel iDataModel = this.getView().getModel();
        ReportFilter reportFilter = (ReportFilter)this.getView().getControl("reportfilterap");
        String showFields = reportFilter.getShowFilterFields();
        if (StringUtils.isNotBlank((String)showFields)) {
            List showFieldList = (List)JsonUtil.fromJson((String)showFields, List.class);
            String msg = this.formatShowFilter(showFieldList, iDataModel);
            evt.setFormatedFilterString(msg);
        }
    }

    private String formatShowFilter(List<String> fields, IDataModel model) {
        StringBuilder msg = new StringBuilder();
        BindingContext bindingContext = new BindingContext((Object)model.getDataEntity());
        for (String field : fields) {
            FieldEdit fieldEdit = (FieldEdit)this.getView().getControl(field);
            if (fieldEdit == null) {
                return null;
            }
            Object value = fieldEdit.getBindingValue(bindingContext);
            Object valDesc = this.getValueDesc(value, fieldEdit.getProperty());
            if (valDesc == null || !StringUtils.isNotEmpty((String)valDesc.toString())) continue;
            if (msg.length() > 0) {
                msg.append(";  ");
            }
            msg.append(fieldEdit.getProperty().getDisplayName()).append(':').append(' ').append(valDesc);
        }
        return msg.toString();
    }

    private Object getValueDesc(Object value, IDataEntityProperty prop) {
        Object valDesc = "";
        if (value == null) {
            return valDesc;
        }
        if (!(prop instanceof BasedataProp) && !(prop instanceof MulBasedataProp)) {
            valDesc = prop instanceof ComboProp ? ((ComboProp)prop).getItemByName(value.toString()) : (prop instanceof DateProp || prop instanceof DateTimeProp ? DateUtils.format((Date)DateUtils.stringToDate((String)((String)value)), (String)"yyyy-MM") : (prop instanceof BooleanProp ? (Boolean.parseBoolean(value.toString()) ? ResManager.loadKDString((String)"\u662f", (String)"TaxAnalysisRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TaxAnalysisRptPlugin_4", (String)"taxc-tctsa-report", (Object[])new Object[0])) : value));
        } else if (value instanceof ArrayList) {
            ArrayList<String> valueDescList = new ArrayList<String>();
            for (Object valueArray : (List)value) {
                Object[] valArray = (Object[])valueArray;
                String newValueDesc = null;
                if (valArray.length >= 2) {
                    String string = newValueDesc = valArray[1] == null ? "" : valArray[1].toString();
                }
                if (!kd.bos.util.StringUtils.isNotEmpty(newValueDesc)) continue;
                valueDescList.add(newValueDesc);
            }
            valDesc = String.join((CharSequence)";", valueDescList);
        } else {
            Object[] valArray = (Object[])value;
            if (valArray.length >= 2) {
                valDesc = valArray[1] == null ? "" : valArray[1].toString();
            }
        }
        return valDesc;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.clearUserSetting();
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
        this.createTrueQFilterList(queryParam);
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("showtype"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("showtype");
        dimensionInfo.setValue(this.getModel().getValue("showtype"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        itemInfos.removeIf(item -> item.getPropName().equals("orgs"));
        FilterItemInfo dimensionInfoorg = new FilterItemInfo();
        dimensionInfoorg.setPropName("orgs");
        dimensionInfoorg.setValue(((List)this.getModel().getValue("orgs")).stream().map(v -> v.getLong("fbasedataid.id")).distinct().collect(Collectors.toList()));
        queryParam.getFilter().getFilterItems().add(dimensionInfoorg);
        itemInfos.removeIf(item -> item.getPropName().equals("showFlag"));
        FilterItemInfo dimensionInfoShow = new FilterItemInfo();
        dimensionInfoShow.setPropName("showFlag");
        if (!CollectionUtils.isEmpty((Collection)((List)this.getModel().getValue("orgs"))) && this.getModel().getValue("showtype").equals(TreeShowTypeEnum.STEP.getCode())) {
            dimensionInfoShow.setValue((Object)false);
        } else {
            dimensionInfoShow.setValue((Object)true);
        }
        queryParam.getFilter().getFilterItems().add(dimensionInfoShow);
        super.beforeQuery(queryParam);
    }

    private void createTrueQFilterList(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        DynamicObjectCollection orgs = this.getOrgList();
        List<Object> orgsList = new ArrayList(16);
        if (orgs != null) {
            orgsList = orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList());
        }
        for (FilterItemInfo items : itemInfos) {
            Object value;
            if (TaxrateQueryContainerEnum.ORG.getCode().equals(items.getPropName())) {
                value = items.getValue();
                if (!(value instanceof DynamicObjectCollection)) continue;
                DynamicObjectCollection orgcolls = (DynamicObjectCollection)items.getValue();
                List selectedorgs = orgcolls.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                List ids = selectedorgs.stream().filter(orgsList::contains).collect(Collectors.toList());
                items.setValue(ids);
                continue;
            }
            if (!TaxrateQueryContainerEnum.TAX_TYPE.getCode().equals(items.getPropName()) || !EmptyCheckUtils.isEmpty((Object)(value = items.getValue()))) continue;
            items.setValue((Object)TaxTypeReportIdEnum.getAllPashTaxTypeIds());
        }
    }

    private DynamicObjectCollection getOrgList() {
        List orgIds = OrgServiceHelper.getOrgListHasPermission((IFormView)this.getView());
        if (CollectionUtils.isEmpty((Collection)orgIds)) {
            return null;
        }
        return OrgUtils.filterNonTaxPayerOrg((List)orgIds, null);
    }
}

