/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.TaxTypeReportIdEnum;
import kd.taxc.tctsa.common.enums.TaxanalysisColEnum;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.TctsaUtils;

@Deprecated
public class TaxAnalysisRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(TaxAnalysisRptQueryPlugin.class);
    private static List<String> defaultList = Arrays.asList("orgcol", "authoritycol", "subtotalcol", "managareascol", "industrynamecol", "bizsegmentnamecol", "issumline");

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.getFilter(reportQueryParam);
    }

    private DataSet getFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfos = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxAnalysisRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        }
        FilterItemInfo orgsItemInfo = null;
        FilterItemInfo periodtypeInfo = null;
        FilterItemInfo isshowInfo = null;
        FilterItemInfo taxtypeInfo = null;
        for (FilterItemInfo itemInfo : filterItemInfos) {
            if ("orgs".equalsIgnoreCase(itemInfo.getPropName())) {
                orgsItemInfo = itemInfo;
                continue;
            }
            if ("periodtype".equalsIgnoreCase(itemInfo.getPropName())) {
                periodtypeInfo = itemInfo;
                continue;
            }
            if ("isshow".equalsIgnoreCase(itemInfo.getPropName())) {
                isshowInfo = itemInfo;
                continue;
            }
            if (!"taxtype".equalsIgnoreCase(itemInfo.getPropName())) continue;
            taxtypeInfo = itemInfo;
        }
        List<Long> orgsList = new ArrayList(16);
        ArrayList<Long> taxtypeList = new ArrayList(16);
        if (orgsItemInfo != null && orgsItemInfo.getValue() instanceof List && ((List)orgsItemInfo.getValue()).size() != 0) {
            orgsList = (List)orgsItemInfo.getValue();
        }
        if (taxtypeInfo != null) {
            if (taxtypeInfo.getValue() instanceof DynamicObjectCollection) {
                if (((List)taxtypeInfo.getValue()).size() != 0) {
                    Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)taxtypeInfo.getValue()).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                    taxtypeList = new ArrayList<Long>(groups.keySet());
                }
            } else if (taxtypeInfo.getValue() instanceof List && ((List)taxtypeInfo.getValue()).size() != 0) {
                taxtypeList = (List)taxtypeInfo.getValue();
            }
        }
        ArrayList<RowMetaMsgInfo> cols = new ArrayList(16);
        ArrayList<String> nameList = new ArrayList<String>(16);
        Iterator iterator = taxtypeList.iterator();
        while (iterator.hasNext()) {
            long taxtype = (Long)iterator.next();
            String name = TaxTypeReportIdEnum.getTaxNameByType((long)taxtype);
            if (!EmptyCheckUtils.isNotEmpty((Object)name)) continue;
            nameList.add(name);
        }
        cols = TaxanalysisColEnum.createDynamicCol(defaultList, nameList);
        if (null != orgsList && orgsList.size() == 0) {
            return this.emptyResultDataSet(cols);
        }
        String periodtype = null;
        if (periodtypeInfo != null) {
            periodtype = periodtypeInfo.getValue().toString().replaceAll(",", "").trim();
        }
        Map<String, List<QFilter>> qFiltersMap = this.getFilter(filterInfo, periodtype);
        List<QFilter> qFilters = qFiltersMap.get("year");
        List<QFilter> lastqFilters = qFiltersMap.get("lastyear");
        DynamicObjectCollection collection = TjsjbBusiness.queryTjsjbData(qFilters, (String)"id,type,org,skssqq,skssqz,declarestatus,taxtype,apanage,yssr,bqybtse,jmse,fsl,datatype,ynse,sbbid,formno,sjsj,jkdate,taxoffice.name as taxofficename");
        Boolean isshow = false;
        if (isshowInfo != null) {
            isshow = (Boolean)isshowInfo.getValue();
        }
        DynamicObjectCollection lastcollection = null;
        if (isshow.booleanValue()) {
            lastcollection = TjsjbBusiness.queryTjsjbData(lastqFilters, (String)"id,type,org,skssqq,skssqz,declarestatus,taxtype,apanage,yssr,bqybtse,jmse,fsl,datatype,ynse,sbbid,formno,sjsj,jkdate,taxoffice.name as taxofficename");
        }
        if (null == collection || collection.size() == 0) {
            return this.emptyResultDataSet(cols);
        }
        Map<Long, List<DynamicObject>> taxinfos = this.queryTaxMainInfo(orgsList);
        TaxAnalysisRptQueryPlugin.setReportQueryParam(reportQueryParam);
        return this.matchResultAndFilter(collection, cols, lastcollection, taxinfos, periodtype, taxtypeList);
    }

    private static void setReportQueryParam(ReportQueryParam reportQueryParam) {
        HashMap<String, String> isVisble = new HashMap<String, String>();
        isVisble.put("isVisble", "0");
        reportQueryParam.setCustomParam(isVisble);
    }

    private DataSet emptyResultDataSet(List<RowMetaMsgInfo> cols) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "taxanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
    }

    private Map<Long, List<DynamicObject>> queryTaxMainInfo(List<Long> orgs) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("orgid", "in", orgs));
        DynamicObjectCollection labels = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id, orgid, registeraddress, orgattr.fbasedataid.id,orgattr.fbasedataid.name as name,orgattr.fbasedataid.group.number as number,codeandname.name as codename", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        Map<Long, List<DynamicObject>> orglabelmap = labels.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
        return orglabelmap;
    }

    private Map<String, List<QFilter>> getFilter(FilterInfo filterInfo, String periodtype) {
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        ArrayList<QFilter> lastqFilters = new ArrayList<QFilter>();
        for (FilterItemInfo filter : list) {
            if (null == filter || null == filter.getValue()) continue;
            QFilter qFilter = this.getFilterByName(filter, 0, periodtype);
            if (null != qFilter) {
                qFilters.add(qFilter);
            }
            QFilter lastqFilter = this.getFilterByName(filter, 1, periodtype);
            if (null == qFilter) continue;
            lastqFilters.add(lastqFilter);
        }
        HashMap<String, List<QFilter>> map = new HashMap<String, List<QFilter>>(16);
        map.put("year", qFilters);
        map.put("lastyear", lastqFilters);
        return map;
    }

    private QFilter getFilterByName(FilterItemInfo filterItemInfo, int i, String periodtype) {
        QFilter qFilter = null;
        String name = filterItemInfo.getPropName();
        Object value = filterItemInfo.getValue();
        switch (name) {
            case "orgs": {
                if (value instanceof DynamicObjectCollection) {
                    Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                    qFilter = new QFilter("org", "in", groups.keySet());
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter("org", "in", (Object)((List)value).toArray());
                break;
            }
            case "taxtype": {
                if (value instanceof DynamicObjectCollection) {
                    Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                    qFilter = new QFilter(name, "in", groups.keySet());
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter(name, "in", value);
                break;
            }
            case "ids": {
                if (value == null) break;
                List ids = (List)value;
                qFilter = new QFilter("id", "in", (Object)ids);
                break;
            }
            case "startdate": {
                qFilter = new QFilter("2".equals(periodtype) ? "skssqq" : "jkdate", ">=", (Object)DateUtils.addYear((Date)DateUtils.getFirstDateOfMonth((Date)((Date)filterItemInfo.getValue())), (int)(-i)));
                break;
            }
            case "enddate": {
                qFilter = new QFilter("2".equals(periodtype) ? "skssqz" : "jkdate", "<=", (Object)DateUtils.addYear((Date)("2".equals(periodtype) ? DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue())) : DateUtils.getLastDateOfMonth((Date)((Date)filterItemInfo.getValue()))), (int)(-i)));
                break;
            }
            default: {
                return null;
            }
        }
        return qFilter;
    }

    private DataSet matchResultAndFilter(DynamicObjectCollection collectionResults, List<RowMetaMsgInfo> cols, DynamicObjectCollection lastcollectionResults, Map<Long, List<DynamicObject>> taxinfos, String periodtype, List<Long> taxtypeList) {
        ArrayList<Map<String, Object>> colls = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> lastcolls = new ArrayList<Map<String, Object>>(10);
        this.setCollsData(colls, collectionResults, periodtype, taxinfos);
        this.setCollsData(lastcolls, lastcollectionResults, periodtype, taxinfos);
        Map<String, List<Map>> key2GroupListMap = colls.stream().collect(Collectors.groupingBy(k -> (String)k.get("orgid")));
        Map<String, List<Map>> lastkey2GroupListMap = lastcolls.stream().collect(Collectors.groupingBy(k -> (String)k.get("orgid")));
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        HashMap<Long, Object> hjtotalMap = new HashMap<Long, Object>(16);
        HashMap<Long, Object> sntqhjtotalMap = new HashMap<Long, Object>(16);
        for (Map.Entry<String, List<Map>> entry : key2GroupListMap.entrySet()) {
            List<Map> sameOrgidList = entry.getValue();
            List lastsameOrgidList = lastkey2GroupListMap.getOrDefault(entry.getKey(), new ArrayList(16));
            Map<String, List<Map>> authorityMap = sameOrgidList.stream().filter(s -> EmptyCheckUtils.isNotEmpty(s.get("authority"))).collect(Collectors.groupingBy(k -> (String)k.get("authority")));
            Map<String, List<Map>> lastauthorityMap = lastsameOrgidList.stream().filter(s -> EmptyCheckUtils.isNotEmpty(s.get("authority"))).collect(Collectors.groupingBy(k -> (String)k.get("authority")));
            for (Map.Entry<String, List<Map>> authorityEntry : authorityMap.entrySet()) {
                String managareascol = "";
                String industrynamecol = "";
                String bizsegmentnamecol = "";
                for (Map map : authorityEntry.getValue()) {
                    managareascol = (String)map.get("managareas");
                    industrynamecol = (String)map.get("industryname");
                    bizsegmentnamecol = (String)map.get("segment");
                }
                List lastauthorityList = lastauthorityMap.getOrDefault(authorityEntry.getKey(), new ArrayList(16));
                Object[] resRowData = this.createTotalRow(authorityEntry.getValue(), authorityEntry.getKey(), cols, entry.getKey(), managareascol, industrynamecol, bizsegmentnamecol, taxtypeList, lastauthorityList, hjtotalMap, sntqhjtotalMap, "notAllHjTotal");
                coll.add(resRowData);
            }
        }
        coll.add(this.createTotalRow(null, null, cols, null, null, null, null, taxtypeList, null, hjtotalMap, sntqhjtotalMap, "allHjTotal"));
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private void setCollsData(List<Map<String, Object>> colls, DynamicObjectCollection collectionResults, String periodtype, Map<Long, List<DynamicObject>> taxinfos) {
        HashMap<String, Object> resRow = null;
        if (collectionResults != null && collectionResults.size() > 0) {
            for (DynamicObject result : collectionResults) {
                resRow = new HashMap<String, Object>(16);
                Long orgid = result.getLong("org");
                String taxofficename = result.getString("taxofficename");
                String orgname = (String)TctsaUtils.getInfoByOrgIdFromErp((String)String.valueOf(orgid), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name");
                resRow.put("orgid", orgname);
                resRow.put("authority", taxofficename);
                resRow.put("taxtype", result.getLong("taxtype"));
                resRow.put("bqje", "2".equals(periodtype) ? result.getBigDecimal("bqybtse") : result.getBigDecimal("sjsj"));
                List<DynamicObject> taxinfoList = taxinfos.get(orgid);
                this.setManagareas(taxinfoList, resRow);
                colls.add(resRow);
            }
        }
    }

    private void setManagareas(List<DynamicObject> taxinfoList, Map<String, Object> resRow) {
        if (taxinfoList != null && taxinfoList.size() > 0) {
            resRow.put("industryname", taxinfoList.get(0).getString("codename"));
            for (DynamicObject dynamicObject : taxinfoList) {
                if ("regulated_areas".equalsIgnoreCase(dynamicObject.getString("number"))) {
                    resRow.put("managareas", dynamicObject.getString("name"));
                    resRow.put("industryname", dynamicObject.getString("codename"));
                }
                if (!"biz-segment001".equalsIgnoreCase(dynamicObject.getString("number"))) continue;
                resRow.put("segment", dynamicObject.getString("name"));
            }
        }
    }

    private Object[] createTotalRow(List<Map<String, Object>> tempMapList, String key, List<RowMetaMsgInfo> cols, String orgidname, String managareascol, String industrynamecol, String bizsegmentnamecol, List<Long> selectTaxtypeList, List<Map<String, Object>> lastauthorityList, Map<Long, Object> bqhjtotalMap, Map<Long, Object> sntqhjtotalMap, String countType) {
        Object[] row = new Object[cols.size()];
        for (int k2 = 0; k2 < cols.size(); ++k2) {
            row[k2] = "";
        }
        int size = cols.size();
        HashMap<Long, BigDecimal> taxtypeTemp = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> lasttaxtypeTemp = new HashMap<Long, BigDecimal>(16);
        if ("notAllHjTotal".equals(countType)) {
            Map<Long, List<Map>> taxtypeMap = tempMapList.stream().collect(Collectors.groupingBy(k -> (Long)k.get("taxtype")));
            Map<Long, List<Map>> lasttaxtypeMap = lastauthorityList.stream().collect(Collectors.groupingBy(k -> (Long)k.get("taxtype")));
            for (Map.Entry<Long, List<Map>> taxtypeEntry : taxtypeMap.entrySet()) {
                String hjbqtaxtypetotal = "0.0";
                String hjlasttaxtypetotal = "0.0";
                List<Map> taxtypeList = taxtypeEntry.getValue();
                List lasttaxtypeList = lasttaxtypeMap.getOrDefault(taxtypeEntry.getKey(), new ArrayList(16));
                BigDecimal currentBqTotal = taxtypeList.stream().map(s -> (BigDecimal)s.get("bqje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal lastcurrentBqTotal = lasttaxtypeList.stream().map(s -> (BigDecimal)s.get("bqje")).reduce(BigDecimal.ZERO, BigDecimal::add);
                taxtypeTemp.put(taxtypeEntry.getKey(), currentBqTotal.setScale(2, 4));
                lasttaxtypeTemp.put(taxtypeEntry.getKey(), lastcurrentBqTotal.setScale(2, 4));
                hjbqtaxtypetotal = BigDecimalUtil.addObject((Object)hjbqtaxtypetotal, (Object)currentBqTotal.setScale(2, 4)) + "";
                hjlasttaxtypetotal = BigDecimalUtil.addObject((Object)hjlasttaxtypetotal, (Object)lastcurrentBqTotal.setScale(2, 4)) + "";
                bqhjtotalMap.put(taxtypeEntry.getKey(), EmptyCheckUtils.isEmpty((Object)bqhjtotalMap.get(taxtypeEntry.getKey())) ? hjbqtaxtypetotal : BigDecimalUtil.addObject((Object)bqhjtotalMap.get(taxtypeEntry.getKey()), (Object)hjbqtaxtypetotal).setScale(2, 4));
                sntqhjtotalMap.put(taxtypeEntry.getKey(), EmptyCheckUtils.isEmpty((Object)sntqhjtotalMap.get(taxtypeEntry.getKey())) ? hjlasttaxtypetotal : BigDecimalUtil.addObject((Object)sntqhjtotalMap.get(taxtypeEntry.getKey()), (Object)hjlasttaxtypetotal).setScale(2, 4));
            }
        }
        String subtotal = "0.0";
        for (Long taxtype : selectTaxtypeList) {
            String taxtypesub;
            String lasttaxtypesub;
            String currenttaxtypebq;
            int index;
            if ("allHjTotal".equals(countType)) {
                index = TaxTypeReportIdEnum.getTaxIndexByType((long)taxtype);
                if (index == 0) continue;
                if (EmptyCheckUtils.isEmpty((Object)bqhjtotalMap.get(taxtype))) {
                    currenttaxtypebq = "";
                    lasttaxtypesub = "";
                    row[index] = currenttaxtypebq;
                    row[index + 1] = EmptyCheckUtils.isEmpty((Object)sntqhjtotalMap.get(taxtype)) ? lasttaxtypesub : ((lasttaxtypesub = sntqhjtotalMap.get(taxtype) + "").equals("0") ? "0.00" : lasttaxtypesub);
                    row[index + 2] = "";
                    continue;
                }
                taxtypesub = bqhjtotalMap.get(taxtype) + "";
                lasttaxtypesub = "";
                row[index] = taxtypesub;
                row[index + 1] = EmptyCheckUtils.isEmpty((Object)sntqhjtotalMap.get(taxtype)) ? lasttaxtypesub : ((lasttaxtypesub = sntqhjtotalMap.get(taxtype) + "").equals("0") ? "0.00" : lasttaxtypesub);
                row[index + 2] = "";
                continue;
            }
            index = TaxTypeReportIdEnum.getTaxIndexByType((long)taxtype);
            if (index == 0) continue;
            if (EmptyCheckUtils.isEmpty(taxtypeTemp.get(taxtype))) {
                currenttaxtypebq = "";
                lasttaxtypesub = "";
                row[index] = currenttaxtypebq;
                row[index + 1] = EmptyCheckUtils.isEmpty(lasttaxtypeTemp.get(taxtype)) ? lasttaxtypesub : ((lasttaxtypesub = lasttaxtypeTemp.get(taxtype) + "").equals("0") ? "0.00" : lasttaxtypesub);
                row[index + 2] = "";
                continue;
            }
            taxtypesub = taxtypeTemp.get(taxtype) + "";
            lasttaxtypesub = "";
            row[index] = taxtypesub;
            row[index + 1] = EmptyCheckUtils.isEmpty(lasttaxtypeTemp.get(taxtype)) ? lasttaxtypesub : ((lasttaxtypesub = lasttaxtypeTemp.get(taxtype) + "").equals("0") ? "0.00" : lasttaxtypesub);
            row[index + 2] = EmptyCheckUtils.isNotEmpty((Object)taxtypesub) && EmptyCheckUtils.isNotEmpty((Object)lasttaxtypesub) && BigDecimal.ZERO.compareTo(new BigDecimal(lasttaxtypesub)) != 0 ? BigDecimalUtil.divideObject((Object)BigDecimalUtil.subtractObject((Object)taxtypesub, (Object)lasttaxtypesub, (int)4), (Object)lasttaxtypesub, (int)4).multiply(new BigDecimal(100)).setScale(2, 4) + "%" : "";
            subtotal = BigDecimalUtil.addObject((Object)subtotal, (Object)taxtypesub) + "";
        }
        if ("allHjTotal".equals(countType)) {
            row[0] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxAnalysisRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]);
            row[1] = "";
            row[size - 5] = "";
            row[size - 4] = "";
            row[size - 3] = "";
            row[size - 2] = "";
            row[size - 1] = "1";
        } else {
            row[0] = orgidname;
            row[1] = key;
            row[size - 5] = subtotal;
            row[size - 4] = managareascol;
            row[size - 3] = industrynamecol;
            row[size - 2] = bizsegmentnamecol;
            row[size - 1] = "0";
        }
        return row;
    }
}

