/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxanalysis;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.business.taxmain.TctsaTaxMainBusiness;
import kd.taxc.tctsa.business.taxmain.TctsaTaxOrgBusiness;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.FilterItemEnum;
import kd.taxc.tctsa.common.enums.TaxTypeReportIdEnum;
import kd.taxc.tctsa.common.enums.TaxanalysisColEnum;
import kd.taxc.tctsa.common.helper.OrgTreeReportDataHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TaxAndFeeStatisticsRptQueryPlugin
extends AbstractReportListDataPlugin {
    private String periodType;
    private Boolean isShowLastYear;
    private List<Long> taxTypeIds;

    public DataSet query(ReportQueryParam reportQueryParam, Object selectedObj) {
        reportQueryParam = OrgTreeReportDataHelper.queryOrgTree((ReportQueryParam)reportQueryParam);
        List itemInfos = reportQueryParam.getFilter().getFilterItems();
        List orgs = itemInfos.stream().filter(item -> item.getPropName().equals("orgs")).collect(Collectors.toList());
        List<RowMetaMsgInfo> rowMetaMsgInfoList = this.getRowMetaMsgInfoList();
        if (CollectionUtils.isEmpty((Collection)((List)((FilterItemInfo)orgs.get(0)).getValue()))) {
            ArrayList coll = new ArrayList();
            RowMeta rowMeta = BizCommomUtil.createRowMeta(rowMetaMsgInfoList);
            CollectionInput inputs = new CollectionInput(rowMeta, coll);
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.initData(filterInfo);
        List<QFilter> filters = this.filterInfoTransToQFilter(filterInfo);
        TaxAndFeeStatisticsRptQueryPlugin.setReportEmptyColumnHide(reportQueryParam);
        DataSet dataset = this.getDataResult(rowMetaMsgInfoList, filters);
        List showtype = itemInfos.stream().filter(item -> item.getPropName().equals("showtype")).collect(Collectors.toList());
        HashMap<String, String> colorTotal = new HashMap<String, String>();
        colorTotal.put("issumline", "1");
        List showFlagList = itemInfos.stream().filter(item -> item.getPropName().equals("showFlag")).collect(Collectors.toList());
        Boolean showFlag = false;
        if (!CollectionUtils.isEmpty(showFlagList)) {
            showFlag = (Boolean)((FilterItemInfo)showFlagList.get(0)).getValue();
        }
        return OrgTreeReportDataHelper.getOrgDateSet((Boolean)showFlag, colorTotal, Arrays.asList("bq_zzs,sntq_zzs,bq_xfs,sntq_xfs,bq_qysds,sntq_qysds,bq_grsds,sntq_grsds,bq_zys,sntq_zys,bq_cswhjsf,sntq_cswhjsf,bq_fcs,sntq_fcs,bq_yhs,sntq_yhs,bq_cztdsys,sntq_cztdsys,bq_tdzzs,sntq_tdzzs,bq_ccsys,sntq_ccsys,bq_cpds,sntq_cpds,bq_clgzs,sntq_clgzs,bq_gs,sntq_gs,bq_gdzys,sntq_gdzys,bq_qs,sntq_qs,bq_yys,sntq_yys,bq_hbs,sntq_hbs,bq_jyffj,sntq_jyffj,bq_dfjyxffj,sntq_dfjyxffj,bq_fjsf,sntq_fjsf,bq_szys,sntq_szys,bq_gfjf,sntq_gfjf,bq_dfsljsjj,sntq_dfsljsjj,bq_zcljclf,sntq_zcljclf,bq_whsyjsf,sntq_whsyjsf,bq_gfcbj,sntq_gfcbj,bq_twfhf,sntq_twfhf,subtotalcol".split(",")), (List)((List)((FilterItemInfo)orgs.get(0)).getValue()), (String)((FilterItemInfo)showtype.get(0)).getValue().toString(), (String)((Object)((Object)this)).getClass().getName(), (DataSet)dataset);
    }

    public void initData(FilterInfo filterInfo) {
        FilterItemInfo periodTypeFilterItem = filterInfo.getFilterItems().stream().filter(p -> "periodtype".equalsIgnoreCase(p.getPropName())).findFirst().orElse(null);
        this.periodType = periodTypeFilterItem == null ? "" : periodTypeFilterItem.getValue().toString().replaceAll(",", "").trim();
        FilterItemInfo isShowFilterItem = filterInfo.getFilterItems().stream().filter(p -> "isshow".equalsIgnoreCase(p.getPropName())).findFirst().orElse(null);
        this.isShowLastYear = isShowFilterItem == null ? Boolean.valueOf(false) : (Boolean)isShowFilterItem.getValue();
        FilterItemInfo taxTypeFilterItem = filterInfo.getFilterItems().stream().filter(p -> "taxtype".equalsIgnoreCase(p.getPropName())).findFirst().orElse(null);
        this.taxTypeIds = taxTypeFilterItem == null ? new ArrayList<Long>(0) : (taxTypeFilterItem.getValue() instanceof DynamicObjectCollection ? ((DynamicObjectCollection)taxTypeFilterItem.getValue()).stream().map(p -> p.getLong("id")).collect(Collectors.toList()) : (taxTypeFilterItem.getValue() instanceof List ? (List<Object>)taxTypeFilterItem.getValue() : new ArrayList<Long>(0)));
    }

    public List<RowMetaMsgInfo> getRowMetaMsgInfoList() {
        return Arrays.stream(TaxanalysisColEnum.values()).map(TaxanalysisColEnum::getRowMetaMsgInfo).sorted(Comparator.comparing(RowMetaMsgInfo::getSort)).collect(Collectors.toList());
    }

    public List<QFilter> filterInfoTransToQFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            switch (filterItem.getPropName()) {
                case "orgs": {
                    filters.add(FilterItemEnum.collectionValueToQFilter((FilterItemInfo)filterItem, (String)"org"));
                    break;
                }
                case "taxtype": {
                    filters.add(FilterItemEnum.collectionValueToQFilter((FilterItemInfo)filterItem, (String)filterItem.getPropName()));
                    break;
                }
                case "ids": {
                    filters.add(FilterItemEnum.collectionValueToQFilter((FilterItemInfo)filterItem, (String)"id"));
                    break;
                }
                case "startdate": {
                    String dateQFilterProperty = this.getDateQFilterProperty(">=");
                    filters.add(FilterItemEnum.startDateValueToQFilter((FilterItemInfo)filterItem, (String)">=", (String)dateQFilterProperty));
                    break;
                }
                case "enddate": {
                    String dateQFilterProperty = this.getDateQFilterProperty("<=");
                    filters.add(FilterItemEnum.endDateValueToQFilter((FilterItemInfo)filterItem, (String)"<=", (String)dateQFilterProperty));
                    break;
                }
                case "levytype": {
                    String value = (String)filterItem.getValue();
                    if (!StringUtils.isNotEmpty((CharSequence)value)) break;
                    List collect = Arrays.stream(value.split(",")).filter(v -> StringUtils.isNotEmpty((CharSequence)v)).collect(Collectors.toList());
                    filters.add(new QFilter("levytype", "in", collect));
                }
            }
        }
        return filters;
    }

    public DataSet getDataResult(List<RowMetaMsgInfo> rowMetaMsgInfoList, List<QFilter> filters) {
        DynamicObjectCollection taxMainCollection = this.getTaxMainCollection(filters);
        Map<Long, List<DynamicObject>> orgIdTaxMainMap = taxMainCollection.stream().collect(Collectors.groupingBy(p -> p.getLong("orgid")));
        List<Long> orgIds = orgIdTaxMainMap.keySet().stream().collect(Collectors.toList());
        List<DynamicObject> curYearDataCollection = this.getStatisticTaxTableData(filters, orgIds);
        if (CollectionUtils.isEmpty(curYearDataCollection)) {
            return this.getDataSet(rowMetaMsgInfoList, new ArrayList<Object[]>(0));
        }
        List<DynamicObject> preYearDataCollection = this.isShowLastYear != false ? this.getPreYearData(filters, orgIds) : null;
        List<Map<String, Object>> curYearDataMapList = this.getMapListData(curYearDataCollection, orgIdTaxMainMap);
        List<Map<String, Object>> preYearDataMapList = this.getMapListData(preYearDataCollection, orgIdTaxMainMap);
        ArrayList<Object[]> dataSetRows = new ArrayList<Object[]>(16);
        Object[] dataSetTotalRow = this.initDataSetRowData(null, null, null, null, null, true, rowMetaMsgInfoList.size());
        Map<Object, List<Map>> curYearOrgKeyMapData = curYearDataMapList.stream().collect(Collectors.groupingBy(k -> k.get("orgidnew")));
        Map<Object, List<Map>> preYearOrgKeyMapData = preYearDataMapList.stream().collect(Collectors.groupingBy(k -> k.get("orgidnew")));
        Map taxOrgTaxpayerChina = TctsaTaxOrgBusiness.getTaxOrgTaxpayerChina(orgIds);
        for (Map.Entry<Object, List<Map>> curYearOrgKeyEntryData : curYearOrgKeyMapData.entrySet()) {
            Map<Object, List<Map>> curYearAuthorityKeyMapData = curYearOrgKeyEntryData.getValue().stream().filter(p -> EmptyCheckUtils.isNotEmpty(p.get("authority"))).collect(Collectors.groupingBy(p -> p.get("authority")));
            Map<Object, List<Map>> preYearAuthorityKeyMapData = ((List)preYearOrgKeyMapData.getOrDefault(curYearOrgKeyEntryData.getKey(), new ArrayList(0))).stream().filter(p -> EmptyCheckUtils.isNotEmpty(p.get("authority"))).collect(Collectors.groupingBy(p -> p.get("authority")));
            for (Map.Entry<Object, List<Map>> curYearAuthorityKeyEntryData : curYearAuthorityKeyMapData.entrySet()) {
                Object[] dataSetRow = this.initDataSetRowData((String)taxOrgTaxpayerChina.get(curYearOrgKeyEntryData.getKey() + "_1"), (Long)curYearOrgKeyEntryData.getKey(), curYearOrgKeyEntryData.getValue().get(0).get("orgid").toString(), curYearAuthorityKeyEntryData.getKey().toString(), curYearAuthorityKeyEntryData.getValue(), false, rowMetaMsgInfoList.size());
                List preYearAuthorityKeyEntryDataValue = preYearAuthorityKeyMapData.getOrDefault(curYearAuthorityKeyEntryData.getKey(), new ArrayList(0));
                this.setDataSetRowValue(curYearAuthorityKeyEntryData.getValue(), preYearAuthorityKeyEntryDataValue, dataSetRow, dataSetTotalRow, rowMetaMsgInfoList.size());
                dataSetRows.add(dataSetRow);
            }
        }
        dataSetRows.add(dataSetTotalRow);
        DataSet dataSet = this.getDataSet(rowMetaMsgInfoList, dataSetRows);
        return dataSet;
    }

    public DynamicObjectCollection getTaxMainCollection(List<QFilter> filters) {
        List orgIds = filters.stream().filter(p -> "org".equalsIgnoreCase(p.getProperty())).map(p -> (List)p.getValue()).findFirst().orElseGet(() -> new ArrayList(0));
        return TctsaTaxMainBusiness.getTaxMainCollection((List)orgIds, new ArrayList(0));
    }

    public List<DynamicObject> getStatisticTaxTableData(List<QFilter> filters, List<Long> orgIds) {
        filters.removeIf(p -> p.getProperty().equalsIgnoreCase("org"));
        filters.add(new QFilter("org", "in", orgIds));
        return TjsjbBusiness.getTaxesAndFeesStatistics(filters);
    }

    private List<DynamicObject> getPreYearData(List<QFilter> filters, List<Long> orgIds) {
        ArrayList<QFilter> preYearQFilters = new ArrayList<QFilter>(filters.size());
        for (QFilter filter : filters) {
            String dateQFilterProperty = this.getDateQFilterProperty(filter.getCP());
            if (filter.getProperty().equalsIgnoreCase(dateQFilterProperty)) {
                preYearQFilters.add(new QFilter(dateQFilterProperty, filter.getCP(), (Object)DateUtils.addYear((Date)((Date)filter.getValue()), (int)-1)));
                continue;
            }
            preYearQFilters.add(filter);
        }
        return this.getStatisticTaxTableData(preYearQFilters, orgIds);
    }

    private List<Map<String, Object>> getMapListData(List<DynamicObject> collectionData, Map<Long, List<DynamicObject>> orgIdTaxMainMap) {
        if (collectionData == null || collectionData.size() == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(collectionData.size());
        for (DynamicObject rowObject : collectionData) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>(16);
            rowMap.put("orgid", rowObject.getString("orgname"));
            rowMap.put("orgidnew", rowObject.getLong("org"));
            rowMap.put("authority", rowObject.getString("taxofficename"));
            rowMap.put("taxtype", rowObject.getLong("taxtype"));
            rowMap.put("bqje", "2".equals(this.periodType) ? rowObject.getBigDecimal("bqybtse") : rowObject.getBigDecimal("sjsj"));
            List<DynamicObject> taxMains = orgIdTaxMainMap.get(rowObject.getLong("org"));
            if (CollectionUtils.isEmpty(taxMains)) continue;
            rowMap.put("industryname", taxMains.get(0).getString("codename"));
            for (DynamicObject taxMain : taxMains) {
                if ("regulated_areas".equalsIgnoreCase(taxMain.getString("number"))) {
                    rowMap.put("managareas", taxMain.getString("name"));
                    continue;
                }
                if (!"biz-segment001".equalsIgnoreCase(taxMain.getString("number"))) continue;
                rowMap.put("segment", taxMain.getString("name"));
            }
            result.add(rowMap);
        }
        return result;
    }

    private String getDateQFilterProperty(String cp) {
        if (Stream.of(">", ">=").anyMatch(p -> p.equals(cp))) {
            return "2".equals(this.periodType) ? "skssqq" : "entryentity.djtjkdate";
        }
        return "2".equals(this.periodType) ? "skssqz" : "entryentity.djtjkdate";
    }

    private Object[] initDataSetRowData(String taxOrgTaxpayer, Long orgId, String orgName, String authority, List<Map<String, Object>> curYearAuthorityKeyEntryDataValue, Boolean isTotalRow, int rowDataSize) {
        Object[] rowData = new Object[rowDataSize];
        String defaultValue = "";
        for (int i = 0; i < rowDataSize; ++i) {
            rowData[i] = defaultValue;
        }
        if (isTotalRow.booleanValue()) {
            rowData[0] = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxAndFeeStatisticsRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]);
            rowData[rowDataSize - 2] = "1";
            return rowData;
        }
        rowData[0] = orgName;
        rowData[1] = taxOrgTaxpayer;
        rowData[2] = authority;
        Map<Object, Object> mapValue = curYearAuthorityKeyEntryDataValue == null || curYearAuthorityKeyEntryDataValue.isEmpty() ? new HashMap(0) : curYearAuthorityKeyEntryDataValue.get(0);
        rowData[rowDataSize - 5] = mapValue.get("managareas");
        rowData[rowDataSize - 4] = mapValue.get("industryname");
        rowData[rowDataSize - 3] = mapValue.get("segment");
        rowData[rowDataSize - 2] = "0";
        rowData[rowDataSize - 1] = orgId;
        return rowData;
    }

    private void setDataSetRowValue(List<Map<String, Object>> curYearAuthorityKeyEntryDataValue, List<Map<String, Object>> preYearAuthorityKeyEntryDataValue, Object[] dataSetRowData, Object[] dataSetTotalRowData, int rowDataSize) {
        Map<Long, List<Map>> curYearTaxTypeKeyMapDataValue = curYearAuthorityKeyEntryDataValue.stream().collect(Collectors.groupingBy(k -> (Long)k.get("taxtype")));
        Map<Long, List<Map>> preYearTaxTypeKeyMapDataValue = preYearAuthorityKeyEntryDataValue.stream().collect(Collectors.groupingBy(k -> (Long)k.get("taxtype")));
        BigDecimal subTotal = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        BigDecimal zero = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
        for (Map.Entry<Long, List<Map>> curYearTaxTypeKeyEntryData : curYearTaxTypeKeyMapDataValue.entrySet()) {
            int index;
            Long taxTypeId = curYearTaxTypeKeyEntryData.getKey();
            if (!this.taxTypeIds.contains(taxTypeId) || (index = TaxTypeReportIdEnum.getTaxIndexByType((long)taxTypeId)) == 0) continue;
            BigDecimal curYearAmount = curYearTaxTypeKeyEntryData.getValue().stream().map(s -> (BigDecimal)s.get("bqje")).reduce(zero, BigDecimal::add);
            dataSetRowData[index] = curYearAmount.setScale(2, RoundingMode.HALF_UP).toString();
            subTotal = subTotal.add(curYearAmount);
            dataSetTotalRowData[index] = BigDecimalUtil.addObject((Object)dataSetTotalRowData[index], (Object)curYearAmount).setScale(2, RoundingMode.HALF_UP);
            if (!this.isShowLastYear.booleanValue()) continue;
            List preYearTaxTypeKeyEntryDataValue = preYearTaxTypeKeyMapDataValue.getOrDefault(taxTypeId, new ArrayList(0));
            BigDecimal preYearAmount = preYearTaxTypeKeyEntryDataValue.stream().map(s -> (BigDecimal)s.get("bqje")).reduce(zero, BigDecimal::add);
            dataSetRowData[index + 1] = preYearAmount.setScale(2, RoundingMode.HALF_UP).toString();
            dataSetTotalRowData[index + 1] = BigDecimalUtil.addObject((Object)dataSetTotalRowData[index + 1], (Object)preYearAmount).setScale(2, RoundingMode.HALF_UP);
            if (preYearAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            dataSetRowData[index + 2] = BigDecimalUtil.divideObject((Object)BigDecimalUtil.subtractObject((Object)curYearAmount, (Object)preYearAmount, (int)4), (Object)preYearAmount, (int)4).multiply(new BigDecimal(100)).setScale(2, 4) + "%";
        }
        dataSetRowData[rowDataSize - 6] = subTotal.setScale(2, RoundingMode.HALF_UP).toString();
    }

    private DataSet getDataSet(List<RowMetaMsgInfo> rowMetaMsgInfoList, Collection<Object[]> rowValues) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(rowMetaMsgInfoList);
        CollectionInput inputs = new CollectionInput(rowMeta, rowValues);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private static void setReportEmptyColumnHide(ReportQueryParam reportQueryParam) {
        HashMap<String, String> isVisible = new HashMap<String, String>(1);
        isVisible.put("isVisble", "0");
        reportQueryParam.setCustomParam(isVisible);
    }
}

