/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxrefund;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.KdToolUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ExportTaxRefundRptPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String ORGS = "orgs";
    private static final String REPORTLISTAP = "reportlistap";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";

    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getControl(REPORTLISTAP);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        MulBasedataEdit orgField = (MulBasedataEdit)this.getControl(ORGS);
        orgField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List filterItemInfoList = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItemInfoList) {
            if (!ORGS.equalsIgnoreCase(filterItemInfo.getPropName()) || filterItemInfo.getValue() != null || !"67".equalsIgnoreCase(filterItemInfo.getCompareType())) continue;
            List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
            filterItemInfo.setValue((Object)taxOrgIdsWithPerm);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (ORGS.equalsIgnoreCase(name)) {
            List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
            formShowParameter.setMultiSelect(true);
            QFilter qFilter = new QFilter("id", "in", (Object)taxOrgIdsWithPerm);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        long org = RequestContext.get().getOrgId();
        List allPermOrgs = OrgServiceHelper.getOrgListHasPermissionAll();
        if (!ObjectUtils.isEmpty((Object)allPermOrgs)) {
            if (allPermOrgs.contains(org)) {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(org).toArray());
            } else {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(allPermOrgs.get(0)).toArray());
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        event.getColumns().stream().filter(m -> m instanceof ReportColumn && ("type".equals(((ReportColumn)m).getFieldKey()) || "org".equals(((ReportColumn)m).getFieldKey()))).forEach(m -> ((ReportColumn)m).setHide(true));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date startdate = (Date)this.getModel().getValue("startdate");
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (startdate == null || enddate == null) {
            return false;
        }
        if (startdate.compareTo(enddate) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"ExportTaxRefundRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        Object orgs = this.getModel().getValue(ORGS);
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        DynamicObject rowData = ((ReportList)evt.getSource()).getReportModel().getRowData(evt.getRowIndex());
        if ("skssqqz".equalsIgnoreCase(evt.getFieldName())) {
            String orgId = String.valueOf(rowData.get("org.id"));
            String type = String.valueOf(rowData.get("type"));
            String skssqqz = String.valueOf(rowData.get("skssqqz"));
            String[] split = skssqqz.split("~");
            Date startDate = DateUtils.stringToDate2((String)split[0], (String)TctsaConstant.FORMAT);
            Date endDate = DateUtils.stringToDate2((String)split[1], (String)TctsaConstant.FORMAT);
            QFilter mainFilter = this.getFilter(Long.parseLong(orgId), startDate, endDate, type);
            DynamicObjectCollection declareMainList = QueryServiceHelper.query((String)"tcetr_declare_main", (String)"id,billno", (QFilter[])new QFilter[]{mainFilter});
            if (CollectionUtils.isEmpty((Collection)declareMainList)) {
                return;
            }
            if (declareMainList.size() == 1) {
                DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)declareMainList.get(0)).getLong("id"), (String)"tcetr_declare_main");
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("sbbid", dyo.getString("id"));
                customParams.put(ORGID_KEY, dyo.getDynamicObject("org").getString("id"));
                customParams.put(ORGNAME_KEY, dyo.getDynamicObject("org").getString("name"));
                Date skssqq = dyo.getDate(SKSSQQ);
                Date skssqz = dyo.getDate(SKSSQZ);
                customParams.put("type", type);
                customParams.put("templatetype", type);
                customParams.put(SKSSQQ, DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
                customParams.put(SKSSQZ, DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
                customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
                customParams.put("taxperiod", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd").substring(0, 7));
                customParams.put("readonly", Boolean.TRUE);
                customParams.put("from", "history");
                customParams.put("modifytime", dyo.getDate("modifytime"));
                String declarestatus = dyo.getString("declarestatus");
                String dataType = dyo.getString("sourcetype");
                customParams.put("sourcetype", dataType);
                customParams.put("month", dyo.getString("month"));
                customParams.put("batchno", dyo.getString("batchno"));
                this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus, dyo);
            } else {
                HashMap<String, Object> customParams = new HashMap<String, Object>(4);
                customParams.put("orgId", orgId);
                customParams.put(SKSSQQ, split[0]);
                customParams.put(SKSSQZ, split[1]);
                customParams.put("templatetype", type);
                String title = ResManager.loadKDString((String)"\u9000\u7a0e\u7533\u62a5\u67e5\u8be2", (String)"ExportTaxRefundRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]);
                ExportTaxRefundRptPlugin.showBillList(ShowType.MainNewTabPage, "tcetr_declare_main", (IFormView)this.getView(), customParams, title, this.getFilter(Long.parseLong(orgId), startDate, endDate, type));
            }
        }
    }

    public static void showBillList(ShowType showType, String pageName, IFormView view, Map<String, Object> customParams, String title, QFilter filter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(pageName);
        listShowParameter.setFormId("bos_list");
        DynamicObjectCollection declareMainList = QueryServiceHelper.query((String)"tcetr_declare_main", (String)"id,billno", (QFilter[])new QFilter[]{filter});
        List pkidList = declareMainList.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl(pkidList);
        listShowParameter.setLinkQueryPkIdCollection(collection);
        if (customParams == null) {
            listShowParameter.setCustomParams(new HashMap());
        } else {
            listShowParameter.setCustomParams(customParams);
        }
        if (filter != null) {
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
        listShowParameter.getOpenStyle().setShowType(showType);
        if (title != null) {
            listShowParameter.setCaption(title);
        }
        view.showForm((FormShowParameter)listShowParameter);
    }

    private QFilter getFilter(Long orgId, Date startDate, Date endDate, String type) {
        QFilter mainFilter = new QFilter("org", "=", (Object)orgId);
        mainFilter.and(SKSSQQ, "=", (Object)startDate);
        mainFilter.and(SKSSQZ, "=", (Object)endDate);
        mainFilter.and("billstatus", "=", (Object)"C");
        mainFilter.and("declarestatus", "=", (Object)"declared");
        mainFilter.and("type", "=", (Object)type);
        return mainFilter;
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType(type);
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate(SKSSQQ)));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate(SKSSQZ)));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.FALSE);
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        customParams.put("declarenumber", object.getString("billno"));
        param.setCustomParams(customParams);
        String str = ResManager.loadKDString((String)"\u7533\u62a5", (String)"ExportTaxRefundRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + str);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

