/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxrefund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ExportTaxRefundRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String[] FIELDS = new String[]{"taxorg", "taxoffice", "skssqqz", "bqmdtse", "bqytse", "bqmdse", "sntqmdtse", "sntqytse", "sntqmdse", "ytsebds", "ckxsemybq", "ckxsemysntq", "ckxsemybds", "type", "org"};
    private static final DataType[] TYPES = new DataType[]{DataType.StringType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.LongType};
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final RowMeta ROW_META = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])TYPES);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        List<Long> orgIds = new ArrayList<Long>(8);
        Date startDate = null;
        Date endDate = null;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        block10: for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "orgs": {
                    Object value = filterItemInfo.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        orgIds = new ArrayList<Long>(groups.keySet());
                        break;
                    }
                    if (value instanceof DynamicObject) {
                        orgIds = Collections.singletonList(((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List orgs = (List)value;
                    if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue block10;
                    List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
                    orgIds = orgs.stream().filter(Objects::nonNull).filter(taxOrgIdsWithPerm::contains).map(m -> Long.parseLong(m.toString())).distinct().collect(Collectors.toList());
                    break;
                }
                case "startdate": {
                    startDate = DateUtils.getFirstDateOfMonth((Date)((Date)filterItemInfo.getValue()));
                    break;
                }
                case "enddate": {
                    endDate = DateUtils.getDayLast((Date)DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue())));
                    break;
                }
            }
        }
        QFilter mainFilter = this.getFilter(orgIds, startDate, endDate);
        DynamicObjectCollection declareMainList = QueryServiceHelper.query((String)"tcetr_declare_main", (String)"id,billno,org.name,org.number,org.id as orgid,skssqq,skssqz,zzsamount,type", (QFilter[])new QFilter[]{mainFilter}, (String)"org.number asc,skssqq asc,skssqz asc");
        List<Object[]> resultNuSum = this.handleData(orgIds, startDate, endDate, declareMainList);
        List<Object[]> resultAfterSum = this.handleSum(resultNuSum);
        CollectionInput inputs = new CollectionInput(ROW_META, resultAfterSum);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private List<Object[]> handleSum(List<Object[]> resultNuSum) {
        if (CollectionUtils.isEmpty(resultNuSum)) {
            return new ArrayList<Object[]>(8);
        }
        LinkedHashSet orgSet = new LinkedHashSet();
        resultNuSum.forEach(m -> orgSet.add(Long.parseLong(String.valueOf(m[14]))));
        ArrayList<Object[]> sumList = new ArrayList<Object[]>();
        for (Long orgId : orgSet) {
            List<Object[]> collect = resultNuSum.stream().filter(m -> orgId.equals(Long.parseLong(String.valueOf(m[14])))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) continue;
            Object[] rowFirst = (Object[])collect.get(0);
            String orgName = String.valueOf(rowFirst[0]);
            BigDecimal bqmdtse = this.sum(collect, 3);
            BigDecimal bqytse = this.sum(collect, 4);
            BigDecimal bqmdse = this.sum(collect, 5);
            BigDecimal sntqmdtse = this.sum(collect, 6);
            BigDecimal sntqytse = this.sum(collect, 7);
            BigDecimal sntqmdse = this.sum(collect, 8);
            BigDecimal ckxsemybq = this.sum(collect, 10);
            BigDecimal ckxsemysntq = this.sum(collect, 11);
            String ytsebds = this.getRate(bqytse, sntqytse);
            String ckxsemybds = this.getRate(ckxsemybq, ckxsemysntq);
            sumList.add(new Object[]{orgName, null, null, bqmdtse, bqytse, bqmdse, sntqmdtse, sntqytse, sntqmdse, ytsebds, ckxsemybq, ckxsemysntq, ckxsemybds, null, orgId});
        }
        BigDecimal bqmdtse = this.sum(resultNuSum, 3);
        BigDecimal bqytse = this.sum(resultNuSum, 4);
        BigDecimal bqmdse = this.sum(resultNuSum, 5);
        BigDecimal sntqmdtse = this.sum(resultNuSum, 6);
        BigDecimal sntqytse = this.sum(resultNuSum, 7);
        BigDecimal sntqmdse = this.sum(resultNuSum, 8);
        BigDecimal ckxsemybq = this.sum(resultNuSum, 10);
        BigDecimal ckxsemysntq = this.sum(resultNuSum, 11);
        String ytsebds = this.getRate(bqytse, sntqytse);
        String ckxsemybds = this.getRate(ckxsemybq, ckxsemysntq);
        Object[] total = new Object[]{ResManager.loadKDString((String)"\u5408\u8ba1", (String)"ExportTaxRefundRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]), null, null, bqmdtse, bqytse, bqmdse, sntqmdtse, sntqytse, sntqmdse, ytsebds, ckxsemybq, ckxsemysntq, ckxsemybds, null, null};
        ArrayList<Object[]> resultList = new ArrayList<Object[]>(8);
        for (Long orgId : orgSet) {
            List collect = resultNuSum.stream().filter(m -> orgId.equals(Long.parseLong(String.valueOf(m[14])))).collect(Collectors.toList());
            resultList.addAll(collect);
            resultList.addAll(sumList.stream().filter(m -> orgId.equals(Long.parseLong(String.valueOf(m[14])))).collect(Collectors.toList()));
        }
        resultList.add(total);
        return resultList;
    }

    private String getRate(BigDecimal numNow, BigDecimal numLastYear) {
        if (numNow != null && numLastYear != null && numLastYear.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal subtract = numNow.subtract(numLastYear);
            return subtract.divide(numLastYear, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        }
        return null;
    }

    private BigDecimal sum(List<Object[]> collect, Integer index) {
        BigDecimal result = BigDecimal.ZERO;
        for (Object[] objects : collect) {
            BigDecimal object = (BigDecimal)objects[index];
            if (object == null) continue;
            result = result.add(object);
        }
        return result;
    }

    private QFilter getFilter(List<Long> orgIds, Date startDate, Date endDate) {
        QFilter mainFilter = new QFilter("org", "in", orgIds);
        mainFilter.and("skssqq", ">=", (Object)startDate);
        mainFilter.and("skssqz", "<=", (Object)endDate);
        mainFilter.and("billstatus", "=", (Object)"C");
        mainFilter.and("declarestatus", "=", (Object)"declared");
        return mainFilter;
    }

    private List<Object[]> handleData(List<Long> orgIds, Date startDate, Date endDate, DynamicObjectCollection declareMainList) {
        ArrayList<Object[]> resultNuSum = new ArrayList<Object[]>(12);
        if (CollectionUtils.isEmpty((Collection)declareMainList)) {
            return new ArrayList<Object[]>();
        }
        TaxResult mainByOrgResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
        Map<Object, Object> taxOfficeMap = new HashMap(8);
        if (mainByOrgResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)mainByOrgResult.getData())) {
            taxOfficeMap = ((List)mainByOrgResult.getData()).stream().collect(Collectors.toMap(k -> k.getString("taxorg.id"), v -> v.getLong("taxoffice.id")));
        }
        Map<String, Map<String, Object>> wmqyMap = this.queryWmqy(orgIds, startDate, endDate);
        Map<String, Map<String, Object>> wmqyMapLastYear = this.queryWmqy(orgIds, DateUtils.addYear((Date)startDate, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        Map<String, Map<String, Object>> scqyMap = this.queryScqy(orgIds, startDate, endDate);
        Map<String, Map<String, Object>> scqyMapLastYear = this.queryScqy(orgIds, DateUtils.addYear((Date)startDate, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        declareMainList.forEach(declareMain -> {
            String key = declareMain.getString("orgid").concat("#").concat(declareMain.getString("org.name")).concat("#").concat(DateUtils.format((Date)declareMain.getDate("skssqq"))).concat("#").concat(DateUtils.format((Date)declareMain.getDate("skssqz"))).concat("#").concat(declareMain.getString("type"));
            linkedHashSet.add(key);
        });
        for (String itemKey : linkedHashSet) {
            BigDecimal ckxsemysntq;
            BigDecimal ckxsemybq;
            BigDecimal sntqytse;
            BigDecimal bqytse;
            String[] split = itemKey.split("#");
            String orgId = split[0];
            String orgName = split[1];
            Date skssqq = DateUtils.stringToDate2((String)split[2]);
            Date skssqz = DateUtils.stringToDate2((String)split[3]);
            String type = split[4];
            String key = orgId.concat("#").concat(split[2]).concat("#").concat(split[3]);
            String keyLastYear = orgId.concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqq, (int)-1))).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)skssqz, (int)-1)));
            long taxOffice = taxOfficeMap.get(orgId) == null ? 0L : (Long)taxOfficeMap.get(orgId);
            String timeStr = DateUtils.format((Date)skssqq, (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)skssqz, (String)TctsaConstant.FORMAT);
            BigDecimal bqmdtse = null;
            BigDecimal bqmdse = null;
            BigDecimal sntqmdtse = null;
            BigDecimal sntqmdse = null;
            if ("drawback".equals(type)) {
                Map wmqyData = wmqyMap.getOrDefault(key, new HashMap(8));
                Map wmqyListYearData = wmqyMapLastYear.getOrDefault(keyLastYear, new HashMap(8));
                bqytse = (BigDecimal)wmqyData.get("zzsamount");
                sntqytse = (BigDecimal)wmqyListYearData.get("zzsamount");
                ckxsemybq = (BigDecimal)wmqyData.get("fobusd");
                ckxsemysntq = (BigDecimal)wmqyListYearData.get("fobusd");
            } else {
                Map scqyData = scqyMap.getOrDefault(key, new HashMap(8));
                Map scqyDataLastYear = scqyMapLastYear.getOrDefault(keyLastYear, new HashMap(8));
                bqmdtse = (BigDecimal)scqyData.get("mdtse");
                bqytse = (BigDecimal)scqyData.get("ytse");
                bqmdse = (BigDecimal)scqyData.get("mdse");
                ckxsemybq = (BigDecimal)scqyData.get("ckxsemy");
                sntqmdtse = (BigDecimal)scqyDataLastYear.get("mdtse");
                sntqytse = (BigDecimal)scqyDataLastYear.get("ytse");
                sntqmdse = (BigDecimal)scqyDataLastYear.get("mdse");
                ckxsemysntq = (BigDecimal)scqyDataLastYear.get("ckxsemy");
            }
            String ytsebds = this.getRate(bqytse, sntqytse);
            String ckxsemybds = this.getRate(ckxsemybq, ckxsemysntq);
            resultNuSum.add(new Object[]{orgName, taxOffice, timeStr, bqmdtse, bqytse, bqmdse, sntqmdtse, sntqytse, sntqmdse, ytsebds, ckxsemybq, ckxsemysntq, ckxsemybds, type, Long.parseLong(orgId)});
        }
        return resultNuSum;
    }

    private Map<String, Map<String, Object>> queryWmqy(List<Long> orgIds, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(orgIds) || startDate == null || endDate == null) {
            return new HashMap<String, Map<String, Object>>(8);
        }
        QFilter mainFilter = this.getFilter(orgIds, startDate, endDate);
        mainFilter.and("type", "=", (Object)"drawback");
        DynamicObjectCollection declareMainList = QueryServiceHelper.query((String)"tcetr_declare_main", (String)"id,billno,org.name,org.number,org.id as orgid,skssqq,skssqz,zzsamount,type", (QFilter[])new QFilter[]{mainFilter});
        if (CollectionUtils.isEmpty((Collection)declareMainList)) {
            return new HashMap<String, Map<String, Object>>(8);
        }
        List sbbIds = declareMainList.stream().map(m -> m.getString("id")).distinct().collect(Collectors.toList());
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)"tcetr_drawback_out_detail", (String)"id,sbbid,fobusd", (QFilter[])new QFilter("sbbid", "in", sbbIds).toArray());
        Map<String, BigDecimal> fobusdMap = detailList.stream().collect(Collectors.groupingBy(m -> m.getString("sbbid"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().map(m -> m.getBigDecimal("fobusd")).reduce(BigDecimal.ZERO, BigDecimal::add)));
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(8);
        for (DynamicObject declareMain : declareMainList) {
            String key = this.getKey(declareMain);
            if (result.containsKey(key)) {
                BigDecimal fobusd = fobusdMap.getOrDefault(declareMain.getString("id"), BigDecimal.ZERO);
                BigDecimal zzsamount = declareMain.getBigDecimal("zzsamount") == null ? BigDecimal.ZERO : declareMain.getBigDecimal("zzsamount");
                BigDecimal newFobusd = fobusd.add(((Map)result.get(key)).getOrDefault("fobusd", BigDecimal.ZERO));
                BigDecimal newzzsamount = zzsamount.add(((Map)result.get(key)).getOrDefault("zzsamount", BigDecimal.ZERO));
                ((Map)result.get(key)).put("fobusd", newFobusd);
                ((Map)result.get(key)).put("zzsamount", newzzsamount);
                continue;
            }
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
            map.put("zzsamount", declareMain.getBigDecimal("zzsamount"));
            map.put("fobusd", fobusdMap.getOrDefault(declareMain.getString("id"), BigDecimal.ZERO));
            result.put(key, map);
        }
        return result;
    }

    private String getKey(DynamicObject declareMain) {
        return declareMain.getString("orgid").concat("#").concat(DateUtils.format((Date)declareMain.getDate("skssqq"))).concat("#").concat(DateUtils.format((Date)declareMain.getDate("skssqz")));
    }

    private Map<String, Map<String, Object>> queryScqy(List<Long> orgIds, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(orgIds) || startDate == null || endDate == null) {
            return new HashMap<String, Map<String, Object>>(8);
        }
        QFilter mainFilter = this.getFilter(orgIds, startDate, endDate);
        mainFilter.and("type", "=", (Object)"etrscsum");
        DynamicObjectCollection declareMainList = QueryServiceHelper.query((String)"tcetr_declare_main", (String)"id,billno,org.name,org.number,org.id as orgid,skssqq,skssqz,type", (QFilter[])new QFilter[]{mainFilter});
        if (CollectionUtils.isEmpty((Collection)declareMainList)) {
            return new HashMap<String, Map<String, Object>>(8);
        }
        List sbbIds = declareMainList.stream().map(m -> m.getString("id")).distinct().collect(Collectors.toList());
        QFilter detailFliter = new QFilter("sbbid", "in", sbbIds).and("ewblxh", "in", Arrays.asList("1", "15", "18", "19"));
        DynamicObjectCollection detailList = QueryServiceHelper.query((String)"tcetr_etrsc_out_sum", (String)"id,sbbid,ewblxh,current", (QFilter[])detailFliter.toArray());
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(8);
        for (DynamicObject declareMain : declareMainList) {
            String key = this.getKey(declareMain);
            BigDecimal mdtse = BigDecimal.ZERO;
            BigDecimal ytse = BigDecimal.ZERO;
            BigDecimal mdse = BigDecimal.ZERO;
            BigDecimal ckxsemy = BigDecimal.ZERO;
            if (result.containsKey(key)) {
                List objects = detailList.stream().filter(m -> declareMain.getString("id").equals(m.getString("sbbid"))).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(objects)) {
                    for (DynamicObject dyo : objects) {
                        if ("15".equals(dyo.getString("ewblxh"))) {
                            mdtse = dyo.getBigDecimal("current");
                            continue;
                        }
                        if ("18".equals(dyo.getString("ewblxh"))) {
                            ytse = dyo.getBigDecimal("current");
                            continue;
                        }
                        if ("19".equals(dyo.getString("ewblxh"))) {
                            mdse = dyo.getBigDecimal("current");
                            continue;
                        }
                        if (!"1".equals(dyo.getString("ewblxh"))) continue;
                        ckxsemy = dyo.getBigDecimal("current");
                    }
                }
                BigDecimal newmdtse = mdtse.add(((Map)result.get(key)).getOrDefault("mdtse", BigDecimal.ZERO));
                BigDecimal newytse = ytse.add(((Map)result.get(key)).getOrDefault("ytse", BigDecimal.ZERO));
                BigDecimal newmdse = mdse.add(((Map)result.get(key)).getOrDefault("mdse", BigDecimal.ZERO));
                BigDecimal newckxsemy = ckxsemy.add(((Map)result.get(key)).getOrDefault("ckxsemy", BigDecimal.ZERO));
                ((Map)result.get(key)).put("mdtse", newmdtse);
                ((Map)result.get(key)).put("ytse", newytse);
                ((Map)result.get(key)).put("mdse", newmdse);
                ((Map)result.get(key)).put("ckxsemy", newckxsemy);
                continue;
            }
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(8);
            List objects = detailList.stream().filter(m -> declareMain.getString("id").equals(m.getString("sbbid"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(objects)) {
                for (DynamicObject dyo : objects) {
                    if ("15".equals(dyo.getString("ewblxh"))) {
                        mdtse = dyo.getBigDecimal("current");
                        continue;
                    }
                    if ("18".equals(dyo.getString("ewblxh"))) {
                        ytse = dyo.getBigDecimal("current");
                        continue;
                    }
                    if ("19".equals(dyo.getString("ewblxh"))) {
                        mdse = dyo.getBigDecimal("current");
                        continue;
                    }
                    if (!"1".equals(dyo.getString("ewblxh"))) continue;
                    ckxsemy = dyo.getBigDecimal("current");
                }
            }
            map.put("mdtse", mdtse);
            map.put("ytse", ytse);
            map.put("mdse", mdse);
            map.put("ckxsemy", ckxsemy);
            result.put(key, map);
        }
        return result;
    }
}

