/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxrefund;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class TaxRefundRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final List<String> FILEDS = Arrays.asList("qmldse2019n3y", "zlldse");
    private static final String ORGS = "orgs";

    public void registerListener(EventObject e) {
        MulBasedataEdit orgField = (MulBasedataEdit)this.getControl(ORGS);
        orgField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List filterItemInfoList = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItemInfoList) {
            if (!ORGS.equalsIgnoreCase(filterItemInfo.getPropName()) || filterItemInfo.getValue() != null || !"67".equalsIgnoreCase(filterItemInfo.getCompareType())) continue;
            List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
            filterItemInfo.setValue((Object)taxOrgIdsWithPerm);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (ORGS.equalsIgnoreCase(name)) {
            List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
            formShowParameter.setMultiSelect(true);
            QFilter qFilter = new QFilter("id", "in", (Object)taxOrgIdsWithPerm);
            evt.addCustomQFilter(qFilter);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        boolean showzlldtse = (Boolean)this.getModel().getValue("showzlldtse");
        if (!showzlldtse) {
            event.getColumns().stream().filter(m -> m instanceof DecimalReportColumn).forEach(decimalReportColumn -> {
                String fieldKey = ((DecimalReportColumn)decimalReportColumn).getFieldKey();
                ((DecimalReportColumn)decimalReportColumn).setHide(FILEDS.contains(fieldKey));
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        long org = RequestContext.get().getOrgId();
        List allPermOrgs = OrgServiceHelper.getOrgListHasPermissionAll();
        if (!ObjectUtils.isEmpty((Object)allPermOrgs)) {
            if (allPermOrgs.contains(org)) {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(org).toArray());
            } else {
                this.getModel().setValue(ORGS, (Object)Collections.singletonList(allPermOrgs.get(0)).toArray());
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date startdate = (Date)this.getModel().getValue("startdate");
        if (startdate == null) {
            return false;
        }
        Date enddate = (Date)this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)enddate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxRefundRptPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        if (startdate.compareTo(enddate) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"TaxRefundRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        Object orgs = this.getModel().getValue(ORGS);
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }
}

