/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxrefund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class TaxRefundRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String[] FIELDS = new String[]{"taxorg", "taxoffice", "skssqqz", "qmldse", "sntqqmldse", "radio", "qmldse2019n3y", "zlldse"};
    private static final DataType[] TYPES = new DataType[]{DataType.StringType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType};
    private static final String ORGS = "orgs";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final RowMeta ROW_META = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])TYPES);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        List<Long> orgIds = new ArrayList<Long>(8);
        Date startDate = null;
        Date endDate = null;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        block10: for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "orgs": {
                    Object value = filterItemInfo.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        orgIds = new ArrayList<Long>(groups.keySet());
                        break;
                    }
                    if (value instanceof DynamicObject) {
                        orgIds = Collections.singletonList(((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List orgs = (List)value;
                    if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue block10;
                    List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
                    orgIds = orgs.stream().filter(Objects::nonNull).filter(taxOrgIdsWithPerm::contains).map(m -> Long.parseLong(m.toString())).distinct().collect(Collectors.toList());
                    break;
                }
                case "startdate": {
                    startDate = DateUtils.getFirstDateOfMonth((Date)((Date)filterItemInfo.getValue()));
                    break;
                }
                case "enddate": {
                    endDate = DateUtils.getDayLast((Date)DateUtils.getLastDateOfMonth2((Date)((Date)filterItemInfo.getValue())));
                    break;
                }
            }
        }
        DynamicObjectCollection taxRefundManageColl = this.queryTaxRefundManage(orgIds, startDate, endDate);
        if (CollectionUtils.isEmpty((Collection)taxRefundManageColl)) {
            CollectionInput inputs = new CollectionInput(ROW_META, result);
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        DynamicObjectCollection preYearTaxRefundManageColl = this.queryTaxRefundManage(orgIds, DateUtils.addYear(startDate, (int)-1), DateUtils.addYear(endDate, (int)-1));
        Map<String, BigDecimal> preYearValueMap = preYearTaxRefundManageColl.stream().collect(Collectors.toMap(k -> k.getString("orgid").concat("#").concat(DateUtils.format((Date)k.getDate("skssqq"), (String)TctsaConstant.FORMAT)).concat("#").concat(DateUtils.format((Date)k.getDate("skssqz"), (String)TctsaConstant.FORMAT)), v -> v.getBigDecimal("amount"), (k1, k2) -> k1));
        TaxResult mainByOrgResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIds(orgIds);
        Map<String, Long> taxOfficeMap = new HashMap<String, Long>(8);
        if (mainByOrgResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)mainByOrgResult.getData())) {
            taxOfficeMap = ((List)mainByOrgResult.getData()).stream().collect(Collectors.toMap(k -> k.getString("taxorg.id"), v -> v.getLong("taxoffice.id")));
        }
        for (DynamicObject taxRefundManage : taxRefundManageColl) {
            Object[] rowData = this.handleTaxRefundManage(preYearValueMap, taxOfficeMap, taxRefundManage);
            result.add(rowData);
        }
        CollectionInput inputs = new CollectionInput(ROW_META, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Object[] handleTaxRefundManage(Map<String, BigDecimal> preYearValueMap, Map<String, Long> taxOfficeMap, DynamicObject taxRefundManage) {
        String orgName = taxRefundManage.getString("org.name");
        BigDecimal amount = taxRefundManage.getBigDecimal("amount");
        BigDecimal bqksqthzlldse = taxRefundManage.getBigDecimal("bqksqthzlldse");
        long taxOffice = taxOfficeMap.get(taxRefundManage.getString("orgid")) == null ? 0L : taxOfficeMap.get(taxRefundManage.getString("orgid"));
        Date skssqq = taxRefundManage.getDate("skssqq");
        Date skssqz = taxRefundManage.getDate("skssqz");
        String timeStr = DateUtils.format((Date)skssqq, (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)skssqz, (String)TctsaConstant.FORMAT);
        String key = taxRefundManage.getString("orgid").concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)taxRefundManage.getDate("skssqq"), (int)-1), (String)TctsaConstant.FORMAT)).concat("#").concat(DateUtils.format((Date)DateUtils.addYear((Date)taxRefundManage.getDate("skssqz"), (int)-1), (String)TctsaConstant.FORMAT));
        BigDecimal preYearAmount = preYearValueMap.get(key);
        String radio = null;
        if (preYearAmount != null && preYearAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal subtract = amount.subtract(preYearAmount);
            radio = subtract.divide(preYearAmount, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP) + "%";
        }
        BigDecimal startqmldse = taxRefundManage.getBigDecimal("startqmldse");
        return new Object[]{orgName, taxOffice, timeStr, amount, preYearAmount, radio, startqmldse, bqksqthzlldse};
    }

    private DynamicObjectCollection queryTaxRefundManage(Collection<Long> orgIds, Date startDate, Date endDate) {
        QFilter mainFilter = new QFilter("org", "in", orgIds);
        if (startDate != null) {
            mainFilter.and("skssqq", ">=", (Object)startDate);
        }
        if (endDate != null) {
            mainFilter.and("skssqz", "<=", (Object)endDate);
        }
        return QueryServiceHelper.query((String)"tcvat_tax_refund_manage_a", (String)"id,billno,org.name,org.number,org.id as orgid,skssqq,skssqz,amount,bqksqthzlldse,startqmldse", (QFilter[])new QFilter[]{mainFilter}, (String)"org.number asc,skssqq asc,skssqz asc");
    }
}

