/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxrefundanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tpo.refund.TaxRefundServiceHelper;
import kd.taxc.tctsa.common.constant.TctsaConstant;
import kd.taxc.tctsa.common.entity.RowMetaMsgInfo;
import kd.taxc.tctsa.common.enums.DeclareTypeEnum;
import kd.taxc.tctsa.common.enums.TaxRefundAnalysisColEnum;
import kd.taxc.tctsa.common.util.BizCommomUtil;
import kd.taxc.tctsa.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class RefundAnalysisRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String ORGID = "org.id";
    private static final String REFUNDABLEAMOUNT = "refundableamount";
    private static final String ACTUALREFUNDAMOUNT = "actualrefundamount";
    private static final String ENDDATE = "endDate";
    private static final String DECLARETYPE = "declaretype";
    private static final String STARTDATE = "startdate";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        return this.getFilter(reportQueryParam);
    }

    private DataSet getFilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List filterItemInfos = filterInfo.getFilterItems();
        if (CollectionUtils.isEmpty((Collection)filterItemInfos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (String)"RefundAnalysisRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        }
        Map<String, DynamicObjectCollection> map = this.selectData(filterItemInfos);
        DynamicObjectCollection thisYearlist = map.get("thisYearlist");
        DynamicObjectCollection collection = map.get("collection");
        List cols = TaxRefundAnalysisColEnum.createDynamicCol();
        if (CollectionUtils.isEmpty((Collection)thisYearlist)) {
            return this.emptyResultDataSet(cols);
        }
        return this.createCol(cols, thisYearlist, collection);
    }

    public Map<String, DynamicObjectCollection> selectData(List<FilterItemInfo> filterItemInfos) {
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        FilterItemInfo orgsItemInfo = null;
        FilterItemInfo declaretypeInfo = null;
        FilterItemInfo startdateInfo = null;
        FilterItemInfo enddateInfo = null;
        FilterItemInfo taxtypeInfo = null;
        for (FilterItemInfo itemInfo : filterItemInfos) {
            if ("orgs".equalsIgnoreCase(itemInfo.getPropName())) {
                orgsItemInfo = itemInfo;
                continue;
            }
            if ("taxtype".equalsIgnoreCase(itemInfo.getPropName())) {
                taxtypeInfo = itemInfo;
                continue;
            }
            if (DECLARETYPE.equalsIgnoreCase(itemInfo.getPropName())) {
                declaretypeInfo = itemInfo;
                continue;
            }
            if (STARTDATE.equalsIgnoreCase(itemInfo.getPropName())) {
                startdateInfo = itemInfo;
                continue;
            }
            if (!ENDDATE.equalsIgnoreCase(itemInfo.getPropName())) continue;
            enddateInfo = itemInfo;
        }
        Date startDate = DateUtils.getFirstDateOfMonth((Date)(startdateInfo == null || startdateInfo.getValue() == null ? new Date() : (Date)startdateInfo.getValue()));
        Date endDate = DateUtils.getLastDateOfMonth((Date)(enddateInfo == null || enddateInfo.getValue() == null ? new Date() : (Date)enddateInfo.getValue()));
        HashMap<Date, Date> periods = new HashMap<Date, Date>();
        periods.put(startDate, endDate);
        periods.put(DateUtils.addYear((Date)startDate, (int)-1), DateUtils.addYear((Date)endDate, (int)-1));
        ArrayList orgIds = orgsItemInfo == null || orgsItemInfo.getValue() == null ? new ArrayList() : ((List)orgsItemInfo.getValue()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        ArrayList declareTypes = declaretypeInfo == null || declaretypeInfo.getValue() == null ? new ArrayList() : Arrays.asList(declaretypeInfo.getValue().toString().replaceFirst(",", "").split(","));
        ArrayList taxTypes = taxtypeInfo == null || taxtypeInfo.getValue() == null ? new ArrayList() : ((List)taxtypeInfo.getValue()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        TaxResult listTaxResult = TaxRefundServiceHelper.getTaxRefundInfo(orgIds, declareTypes, taxTypes, periods);
        if (listTaxResult != null && listTaxResult.isSuccess() && listTaxResult.getData() != null) {
            List resultList = (List)listTaxResult.getData();
            DynamicObjectCollection all = new DynamicObjectCollection();
            for (DynamicObject dynamicObject : resultList) {
                all.add((Object)dynamicObject);
            }
            DynamicObjectCollection thisYearlist = all.stream().filter(v -> v.getDate(STARTDATE).getTime() >= startDate.getTime() && v.getDate(ENDDATE).getTime() <= endDate.getTime()).collect(Collectors.toCollection(DynamicObjectCollection::new));
            thisYearlist = thisYearlist.stream().sorted(Comparator.comparing(x -> x.getString("org.name")).thenComparing(x -> x.getString("taxcategory.name")).thenComparing(x -> x.getString(STARTDATE))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            map.put("collection", all);
            map.put("thisYearlist", thisYearlist);
        } else {
            map.put("collection", new DynamicObjectCollection());
            map.put("thisYearlist", new DynamicObjectCollection());
        }
        return map;
    }

    private DataSet createCol(List<RowMetaMsgInfo> cols, DynamicObjectCollection thisYearlist, DynamicObjectCollection collection) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        Long orgid = 0L;
        int size = cols.size();
        DynamicObjectCollection lastyearAllList = new DynamicObjectCollection();
        for (int i = 0; i < thisYearlist.size(); ++i) {
            Object[] resRow;
            DynamicObject row = (DynamicObject)thisYearlist.get(i);
            Long nowOrgId = row.getLong(ORGID);
            if (orgid == 0L) {
                orgid = nowOrgId;
            }
            if (nowOrgId != null && !nowOrgId.equals(orgid)) {
                coll.add(this.createTotalRow(thisYearlist, lastyearAllList, size, orgid));
                orgid = nowOrgId;
            }
            Date lastStartDate = DateUtils.addYear((Date)row.getDate(STARTDATE), (int)-1);
            Date lastEndDate = DateUtils.addYear((Date)row.getDate(ENDDATE), (int)-1);
            Optional<DynamicObject> lastYearlist = collection.stream().filter(v -> v.getDate(STARTDATE).compareTo(lastStartDate) == 0 && v.getDate(ENDDATE).compareTo(lastEndDate) == 0 && v.getLong(ORGID) == row.getLong(ORGID) && StringUtils.equals((CharSequence)v.getString(DECLARETYPE), (CharSequence)row.getString(DECLARETYPE)) && StringUtils.equals((CharSequence)v.getString("taxcategory.name"), (CharSequence)row.getString("taxcategory.name")) && StringUtils.equals((CharSequence)v.getString("taxoffice.name"), (CharSequence)row.getString("taxoffice.name"))).findFirst();
            if (lastYearlist.isPresent()) {
                lastyearAllList.add((Object)lastYearlist.get());
                resRow = this.createRow(row, lastYearlist.get(), cols.size());
            } else {
                resRow = this.createRow(row, null, cols.size());
            }
            coll.add(resRow);
            if (i != thisYearlist.size() - 1) continue;
            coll.add(this.createTotalRow(thisYearlist, lastyearAllList, size, orgid));
        }
        coll.add(this.createTotalRow(thisYearlist, lastyearAllList, size, null));
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "refundanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
    }

    private DataSet emptyResultDataSet(List<RowMetaMsgInfo> cols) {
        RowMeta rowMeta = BizCommomUtil.createRowMeta(cols);
        CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "refundanalysisrptqueryplugin")).createDataSet(new Input[]{inputs});
    }

    private Object[] createRow(DynamicObject thisyear, DynamicObject lastyear, int size) {
        Object[] row = new Object[size];
        int index = 0;
        row[index++] = thisyear.get("id");
        row[index++] = thisyear.get("org.name");
        row[index++] = DeclareTypeEnum.gettaxtypeByCode((String)thisyear.getString(DECLARETYPE));
        row[index++] = thisyear.get("taxcategory.name");
        row[index++] = thisyear.get("taxoffice.name");
        row[index++] = DateUtils.format((Date)thisyear.getDate(STARTDATE), (String)TctsaConstant.FORMAT) + "~" + DateUtils.format((Date)thisyear.getDate(ENDDATE), (String)TctsaConstant.FORMAT);
        BigDecimal thisyearref = thisyear.getBigDecimal(REFUNDABLEAMOUNT);
        row[index++] = thisyearref.setScale(2, 4);
        row[index++] = thisyear.getBigDecimal(ACTUALREFUNDAMOUNT).setScale(2, 4);
        row[index++] = DateUtils.format((Date)thisyear.getDate("accountdate"), (String)"yyyy-MM-dd");
        if (lastyear == null) {
            return row;
        }
        BigDecimal lastyearref = lastyear.getBigDecimal(REFUNDABLEAMOUNT);
        row[index++] = lastyearref.setScale(2, 4);
        row[index++] = lastyear.getBigDecimal(ACTUALREFUNDAMOUNT).setScale(2, 4);
        row[index++] = DateUtils.format((Date)lastyear.getDate("accountdate"), (String)"yyyy-MM-dd");
        if (lastyearref.compareTo(BigDecimal.ZERO) != 0) {
            row[index] = thisyearref.subtract(lastyearref).multiply(new BigDecimal("100")).divide(lastyearref, 2, 4) + "%";
        }
        return row;
    }

    private Object[] createTotalRow(DynamicObjectCollection thisYearlist, DynamicObjectCollection allList, int size, Long orgid) {
        DynamicObjectCollection thisyear = thisYearlist;
        DynamicObjectCollection allyear = allList;
        if (orgid != null) {
            thisyear = thisYearlist.stream().filter(v -> orgid.equals(v.getLong(ORGID))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            allyear = allList.stream().filter(v -> orgid.equals(v.getLong(ORGID))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        }
        BigDecimal refundableamount = thisyear.stream().map(s -> s.getBigDecimal(REFUNDABLEAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualrefundamount = thisyear.stream().map(s -> s.getBigDecimal(ACTUALREFUNDAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal refundableaallmount = allyear.stream().map(s -> s.getBigDecimal(REFUNDABLEAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal actualrefundallamount = allyear.stream().map(s -> s.getBigDecimal(ACTUALREFUNDAMOUNT)).reduce(BigDecimal.ZERO, BigDecimal::add);
        Object[] row = new Object[size];
        int index = 0;
        row[index++] = "0";
        row[index++] = orgid != null ? ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"RefundAnalysisRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5408\u8ba1", (String)"RefundAnalysisRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        row[index++] = "";
        row[index++] = "";
        row[index++] = "";
        row[index++] = "";
        row[index++] = refundableamount.setScale(2, 4);
        row[index++] = actualrefundamount.setScale(2, 4);
        row[index++] = "";
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return row;
        }
        row[index++] = refundableaallmount.setScale(2, 4);
        row[index++] = actualrefundallamount.setScale(2, 4);
        row[index] = "";
        return row;
    }
}

