/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxyearlossanalysis;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.tctsa.common.enums.TaxrateQueryContainerEnum;
import kd.taxc.tctsa.common.enums.TreeShowTypeEnum;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;

public class TaxYearLossAnalysisRptPlugin
extends AbstractReportFormPlugin {
    private static final String STARTDATE = "startdate";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object querydate = this.getModel().getValue(STARTDATE);
        Object orgs = this.getModel().getValue("orgs");
        String showtype = this.getModel().getValue("showtype").toString();
        if (EmptyCheckUtils.isEmpty((Object)querydate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u67e5\u8be2\u671f\u95f4\u3002", (String)"TaxYearLossAnalysisRptPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyCheckUtils.isEmpty((Object)querydate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5e74\u9650\u3002", (String)"TaxYearLossAnalysisRptPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyCheckUtils.isEmpty((Object)orgs) && showtype.equals(TreeShowTypeEnum.TILE.getCode())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55\u793a\u65b9\u5f0f\u4e3a\u5e73\u94fa\u65f6\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"TaxYearLossAnalysisRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void registerListener(EventObject e) {
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(TaxrateQueryContainerEnum.ORG.getCode());
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"showtype"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("showtype".equals(name)) {
            Object orgs = this.getModel().getValue("orgs");
            String showtype = this.getModel().getValue("showtype").toString();
            if (EmptyCheckUtils.isEmpty((Object)orgs) && showtype.equals(TreeShowTypeEnum.TILE.getCode())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55\u793a\u65b9\u5f0f\u4e3a\u5e73\u94fa\u65f6\uff0c\u7a0e\u52a1\u7ec4\u7ec7\u5fc5\u586b\u3002", (String)"TaxYearLossAnalysisRptPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
                String oldValue = (String)e.getChangeSet()[0].getOldValue();
                this.getModel().setValue("showtype", (Object)oldValue);
            } else {
                this.getView().refresh();
            }
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List itemInfos = queryParam.getFilter().getFilterItems();
        itemInfos.removeIf(item -> item.getPropName().equals("showtype"));
        FilterItemInfo dimensionInfo = new FilterItemInfo();
        dimensionInfo.setPropName("showtype");
        dimensionInfo.setValue(this.getModel().getValue("showtype"));
        queryParam.getFilter().getFilterItems().add(dimensionInfo);
        itemInfos.removeIf(item -> item.getPropName().equals("orgs"));
        FilterItemInfo dimensionInfoorg = new FilterItemInfo();
        dimensionInfoorg.setPropName("orgs");
        dimensionInfoorg.setValue(((List)this.getModel().getValue("orgs")).stream().map(v -> v.getLong("fbasedataid.id")).distinct().collect(Collectors.toList()));
        queryParam.getFilter().getFilterItems().add(dimensionInfoorg);
        itemInfos.removeIf(item -> item.getPropName().equals("showFlag"));
        FilterItemInfo dimensionInfoShow = new FilterItemInfo();
        dimensionInfoShow.setPropName("showFlag");
        if (!CollectionUtils.isEmpty((Collection)((List)this.getModel().getValue("orgs"))) && this.getModel().getValue("showtype").equals(TreeShowTypeEnum.STEP.getCode())) {
            dimensionInfoShow.setValue((Object)false);
        } else {
            dimensionInfoShow.setValue((Object)true);
        }
        queryParam.getFilter().getFilterItems().add(dimensionInfoShow);
        super.beforeQuery(queryParam);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        List orgIds = OrgServiceHelper.getOrgListHasPermissionAll();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        QFilter orgIdsFilter = new QFilter("id", "in", (Object)orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }
}

