/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.taxyearlossanalysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.helper.OrgTreeReportDataHelper;
import org.apache.commons.lang3.ObjectUtils;

public class TaxYearLossAnalysisRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static Map<String, String> sbbToOrgMap = new HashMap<String, String>(512);
    private static Map<String, String> orgIdToOrgNameMap = new HashMap<String, String>(512);
    private static final String YEARLIMIT = "yearlimit";
    private static final String ENTITYNAME = "tccit_qysds_a106000";
    private static final String QUERYFIELD = "sbbid,ewblxh,qyndynbe,hj,sjnbe,kjz";
    private static int YEAR = 0;
    private static String yearlimit = "";
    private static final String[] FIELDS = new String[]{"orgcol", "pretenyear", "prenineyear", "preeightyear", "presevenyear", "presixyear", "prefiveyear", "prefouryear", "prethreeyear", "pretwoyear", "preoneyear", "thisyear", "nextyearloss", "currentyearloss", "issumline", "orgid"};
    private static String[] pretenyear = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11"};
    private static List<String> prefiveyear = new ArrayList<String>(12);
    private static final String NEXTYEARLOSS = "nextyearloss";
    private static final String CURRENTYEARLOSS = "currentyearloss";
    private static final DataType[] TYPES = new DataType[]{DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.LongType};
    private static final RowMeta ROW_META = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])TYPES);

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ArrayList<AbstractReportColumn> tempList = new ArrayList<AbstractReportColumn>(12);
        String year = ResManager.loadKDString((String)"\u5e74", (String)"TaxYearLossAnalysisRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        for (AbstractReportColumn column : columns) {
            String fieldKey;
            switch (fieldKey = ((ReportColumn)column).getFieldKey()) {
                case "pretenyear": {
                    column.setCaption(new LocaleString(YEAR - 10 + year));
                    if (!"1".equalsIgnoreCase(yearlimit)) break;
                    ((ReportColumn)column).setHide(true);
                    break;
                }
                case "prenineyear": {
                    column.setCaption(new LocaleString(YEAR - 9 + year));
                    if (!"1".equalsIgnoreCase(yearlimit)) break;
                    ((ReportColumn)column).setHide(true);
                    break;
                }
                case "preeightyear": {
                    column.setCaption(new LocaleString(YEAR - 8 + year));
                    if (!"1".equalsIgnoreCase(yearlimit)) break;
                    ((ReportColumn)column).setHide(true);
                    break;
                }
                case "presevenyear": {
                    column.setCaption(new LocaleString(YEAR - 7 + year));
                    if (!"1".equalsIgnoreCase(yearlimit)) break;
                    ((ReportColumn)column).setHide(true);
                    break;
                }
                case "presixyear": {
                    column.setCaption(new LocaleString(YEAR - 6 + year));
                    if (!"1".equalsIgnoreCase(yearlimit)) break;
                    ((ReportColumn)column).setHide(true);
                    break;
                }
                case "prefiveyear": {
                    column.setCaption(new LocaleString(YEAR - 5 + year));
                    break;
                }
                case "prefouryear": {
                    column.setCaption(new LocaleString(YEAR - 4 + year));
                    break;
                }
                case "prethreeyear": {
                    column.setCaption(new LocaleString(YEAR - 3 + year));
                    break;
                }
                case "pretwoyear": {
                    column.setCaption(new LocaleString(YEAR - 2 + year));
                    break;
                }
                case "preoneyear": {
                    column.setCaption(new LocaleString(YEAR - 1 + year));
                    break;
                }
                case "thisyear": {
                    column.setCaption(new LocaleString(YEAR + year));
                }
            }
            tempList.add(column);
        }
        return tempList;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        List itemInfos = (reportQueryParam = OrgTreeReportDataHelper.queryOrgTree((ReportQueryParam)reportQueryParam)).getFilter().getFilterItems();
        List orgs = itemInfos.stream().filter(item -> item.getPropName().equals("orgs")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)((List)((FilterItemInfo)orgs.get(0)).getValue()))) {
            return this.emptyResultDataSet();
        }
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> qFilters = this.filterInfoTransToQFilter(filterInfo);
        TaxYearLossAnalysisRptQueryPlugin.setReportEmptyColumnHide(reportQueryParam);
        DataSet dataset = this.getDataResult(qFilters);
        List showtype = itemInfos.stream().filter(item -> item.getPropName().equals("showtype")).collect(Collectors.toList());
        HashMap<String, String> colorTotal = new HashMap<String, String>();
        colorTotal.put("issumline", "1");
        List showFlagList = itemInfos.stream().filter(item -> item.getPropName().equals("showFlag")).collect(Collectors.toList());
        Boolean showFlag = false;
        if (!CollectionUtils.isEmpty(showFlagList)) {
            showFlag = (Boolean)((FilterItemInfo)showFlagList.get(0)).getValue();
        }
        return OrgTreeReportDataHelper.getOrgDateSet((Boolean)showFlag, colorTotal, Arrays.asList("pretenyear,prenineyear,preeightyear,presevenyear,presixyear,prefiveyear,prefouryear,prethreeyear,pretwoyear,preoneyear,thisyear,nextyearloss,currentyearloss".split(",")), (List)((List)((FilterItemInfo)orgs.get(0)).getValue()), (String)((FilterItemInfo)showtype.get(0)).getValue().toString(), (String)((Object)((Object)this)).getClass().getName(), (DataSet)dataset);
    }

    public List<QFilter> filterInfoTransToQFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(12);
        List<Object> org = new ArrayList();
        List orgs = new ArrayList();
        String skssqq = "";
        String skssqz = "";
        String taxlimit = "year";
        String type = "qysdsnb";
        for (FilterItemInfo filterItem : filterInfo.getFilterItems()) {
            switch (filterItem.getPropName()) {
                case "orgs": {
                    Object value = filterItem.getValue();
                    orgs = (List)value;
                    if (value instanceof DynamicObjectCollection) {
                        org = ((DynamicObjectCollection)value).stream().map(p -> p.getString("id")).collect(Collectors.toList());
                    }
                    if (!(value instanceof List)) break;
                    org = ((List)value).stream().map(Object::toString).collect(Collectors.toList());
                    break;
                }
                case "startdate": {
                    Date startdate = (Date)filterItem.getValue();
                    Date enddate = DateUtils.getLastDateOfYear((Date)startdate);
                    YEAR = DateUtils.getYearOfDate((Date)startdate);
                    skssqq = DateUtils.format((Date)startdate, (String)"yyyy-MM-dd");
                    skssqz = DateUtils.format((Date)enddate, (String)"yyyy-MM-dd");
                    break;
                }
                case "yearlimit": {
                    yearlimit = (String)filterItem.getValue();
                }
            }
        }
        List sbbDyos = YbnsrServiceHelper.querySbbs(org, (String)type, (String)taxlimit, (String)skssqq, (String)skssqz);
        ArrayList<String> sbbids = new ArrayList<String>(12);
        for (DynamicObject sbbDyo : sbbDyos) {
            sbbToOrgMap.put(sbbDyo.getString("id"), sbbDyo.getString("org"));
            sbbids.add(sbbDyo.getString("id"));
        }
        filters.add(new QFilter("sbbid", "in", sbbids));
        TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByIds(orgs, null);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            for (DynamicObject dyo : (List)listTaxResult.getData()) {
                orgIdToOrgNameMap.put(dyo.getString("id"), dyo.getString("org.name"));
            }
        }
        return filters;
    }

    private static void setReportEmptyColumnHide(ReportQueryParam reportQueryParam) {
        HashMap<String, String> isVisible = new HashMap<String, String>(16);
        isVisible.put("isVisble", "0");
        reportQueryParam.setCustomParam(isVisible);
    }

    private DataSet emptyResultDataSet() {
        CollectionInput inputs = new CollectionInput(ROW_META, new ArrayList());
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "emptyResultDataSet")).createDataSet(new Input[]{inputs});
    }

    public DataSet getDataResult(List<QFilter> qFilters) {
        DynamicObjectCollection datas = QueryServiceHelper.query((String)ENTITYNAME, (String)QUERYFIELD, (QFilter[])qFilters.toArray(new QFilter[0]));
        Map<String, Map<String, Map<String, BigDecimal>>> stringMapMap = this.detailDatas(datas);
        Collection<Object[]> result = this.getResultCollection(stringMapMap, sbbToOrgMap);
        CollectionInput inputs = new CollectionInput(ROW_META, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    public Map<String, Map<String, Map<String, BigDecimal>>> detailDatas(DynamicObjectCollection datas) {
        HashMap<String, Map<String, Map<String, BigDecimal>>> sbbidToDetailMessageMap = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
        for (DynamicObject data : datas) {
            String sbbid = data.getString("sbbid");
            String ewblxh = data.getString("ewblxh");
            BigDecimal qyndynbe = data.getBigDecimal("qyndynbe");
            BigDecimal hj = data.getBigDecimal("hj");
            BigDecimal sjnbe = data.getBigDecimal("sjnbe");
            BigDecimal kjz = data.getBigDecimal("kjz");
            BigDecimal currentyearloss = this.calCurrentYearLossAmount(qyndynbe, hj, sjnbe, kjz);
            if (sbbidToDetailMessageMap.containsKey(sbbid)) {
                Map stringMapMap = (Map)sbbidToDetailMessageMap.get(sbbid);
                HashMap<String, BigDecimal> stringBigDecimalMap = new HashMap<String, BigDecimal>();
                stringBigDecimalMap.put(NEXTYEARLOSS, kjz);
                stringBigDecimalMap.put(CURRENTYEARLOSS, currentyearloss);
                stringMapMap.put(ewblxh, stringBigDecimalMap);
                sbbidToDetailMessageMap.put(sbbid, stringMapMap);
                continue;
            }
            HashMap<String, BigDecimal> stringBigDecimalMap = new HashMap<String, BigDecimal>();
            HashMap<String, HashMap<String, BigDecimal>> stringMapMap = new HashMap<String, HashMap<String, BigDecimal>>();
            stringBigDecimalMap.put(NEXTYEARLOSS, kjz);
            stringBigDecimalMap.put(CURRENTYEARLOSS, currentyearloss);
            stringMapMap.put(ewblxh, stringBigDecimalMap);
            sbbidToDetailMessageMap.put(sbbid, stringMapMap);
        }
        return sbbidToDetailMessageMap;
    }

    public BigDecimal calCurrentYearLossAmount(BigDecimal qyndynbe, BigDecimal hj, BigDecimal sjnbe, BigDecimal kjz) {
        if (kjz.compareTo(BigDecimal.ZERO) != 0) {
            return BigDecimal.ZERO;
        }
        if (kjz.compareTo(BigDecimal.ZERO) == 0 && qyndynbe.compareTo(BigDecimal.ZERO) != 0) {
            return qyndynbe.abs().subtract(hj).subtract(sjnbe);
        }
        return BigDecimal.ZERO;
    }

    public Collection<Object[]> getResultCollection(Map<String, Map<String, Map<String, BigDecimal>>> map, Map<String, String> sbbToOrgMap) {
        int i;
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        for (Map.Entry<String, Map<String, Map<String, BigDecimal>>> stringMapEntry : map.entrySet()) {
            ArrayList<Object> dyoRow = new ArrayList<Object>(12);
            String sbbid = stringMapEntry.getKey();
            String org = sbbToOrgMap.get(sbbid);
            String orgName = orgIdToOrgNameMap.get(org);
            Map<String, Map<String, BigDecimal>> value = stringMapEntry.getValue();
            BigDecimal sumnextyearloss = BigDecimal.ZERO;
            BigDecimal sumcurrentyearloss = BigDecimal.ZERO;
            dyoRow.add(orgName);
            for (String s : pretenyear) {
                Map<String, BigDecimal> stringBigDecimalMap = value.get(s);
                BigDecimal nextyearloss = stringBigDecimalMap.get(NEXTYEARLOSS);
                BigDecimal currentyearloss = stringBigDecimalMap.get(CURRENTYEARLOSS);
                dyoRow.add(nextyearloss);
                if ("1".equalsIgnoreCase(yearlimit) && !prefiveyear.contains(s)) {
                    sumnextyearloss = sumnextyearloss.add(BigDecimal.ZERO);
                    sumcurrentyearloss = sumcurrentyearloss.add(BigDecimal.ZERO);
                    continue;
                }
                sumnextyearloss = sumnextyearloss.add(nextyearloss);
                sumcurrentyearloss = sumcurrentyearloss.add(currentyearloss);
            }
            dyoRow.add(sumnextyearloss);
            dyoRow.add(sumcurrentyearloss);
            dyoRow.add("0");
            dyoRow.add(org);
            result.add(dyoRow.toArray(new Object[0]));
        }
        ArrayList<Object> sumline = new ArrayList<Object>(12);
        for (i = 0; i < FIELDS.length; ++i) {
            sumline.add(null);
        }
        sumline.set(0, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TaxYearLossAnalysisRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        sumline.set(FIELDS.length - 2, "1");
        for (i = 1; i < FIELDS.length - 2; ++i) {
            BigDecimal sum = BigDecimal.ZERO;
            for (Object[] objects : result) {
                sum = sum.add(new BigDecimal(String.valueOf(objects[i])));
            }
            sumline.set(i, sum);
        }
        if (!result.isEmpty()) {
            result.add(sumline.toArray(new Object[0]));
        }
        return result;
    }

    static {
        prefiveyear.add("6");
        prefiveyear.add("7");
        prefiveyear.add("8");
        prefiveyear.add("9");
        prefiveyear.add("10");
        prefiveyear.add("11");
    }
}

