/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.yfjj;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;

public class YfjjRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        MulBasedataEdit tablefield = (MulBasedataEdit)this.getControl("orgs");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("date", (Object)DateUtils.addYear((Date)DateUtils.trunc((Date)DateUtils.getLastDateOfYear((Date)new Date())), (int)-1));
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List filterItemInfoList = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItemInfo : filterItemInfoList) {
            if (!"orgs".equalsIgnoreCase(filterItemInfo.getPropName()) || filterItemInfo.getValue() != null || !"67".equalsIgnoreCase(filterItemInfo.getCompareType())) continue;
            List<Long> taxOrgIdsWithPerm = this.getOrgIds();
            filterItemInfo.setValue(taxOrgIdsWithPerm);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("orgs".equalsIgnoreCase(name)) {
            formShowParameter.setMultiSelect(true);
            List<Long> taxOrgIds = this.getOrgIds();
            QFilter qFilter = new QFilter("id", "in", taxOrgIds);
            evt.addCustomQFilter(qFilter);
        }
    }

    private List<Long> getOrgIds() {
        return OrgServiceHelper.getOrgListHasPermissionAll();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date startdate = (Date)this.getModel().getValue("date");
        if (startdate == null) {
            return false;
        }
        return super.verifyQuery(queryParam);
    }
}

