/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.report.yfjj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.datatype.StringType;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.tctsa.common.helper.OrgServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class YfjjRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(YfjjRptQueryPlugin.class);
    private static final String ORGS = "orgs";
    private static final Map<String, String> totalmap = new LinkedHashMap<String, String>();

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        columns.clear();
        LinkedHashMap colMap = (LinkedHashMap)this.getQueryParam().getCustomParam().get("colMap");
        if (MapUtils.isEmpty((Map)colMap)) {
            return columns;
        }
        for (Map.Entry entry : colMap.entrySet()) {
            ReportColumn endRpt = new ReportColumn();
            endRpt.setCaption(new LocaleString((String)entry.getKey()));
            endRpt.setFieldKey((String)entry.getValue());
            endRpt.setFieldType("text");
            if (!"item".equals(entry.getValue())) {
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setTextAlign("right");
                endRpt.setStyle(columnStyle);
            }
            columns.add((AbstractReportColumn)endRpt);
        }
        return columns;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        LinkedHashMap<String, String> colMap = new LinkedHashMap<String, String>(8);
        DataSet dataSource = this.genDataset(reportQueryParam);
        if (dataSource == null) {
            this.getQueryParam().getCustomParam().put("colMap", colMap);
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"field"}, (DataType[])new DataType[]{DataType.StringType});
            CollectionInput inputs = new CollectionInput(rowMeta, new ArrayList());
            return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
        }
        DataSet orgDataset = dataSource.copy().select(new String[]{"orgid", "orgname", "orgnumber"}).distinct().orderBy(new String[]{"orgnumber asc"});
        String xm = ResManager.loadKDString((String)"\u9879\u76ee", (String)"YfjjRptQueryPlugin_56", (String)"taxc-tctsa-report", (Object[])new Object[0]);
        colMap.put(xm, "item");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("item");
        DataSet copy1 = orgDataset.copy();
        for (Row row : copy1) {
            colMap.put(row.getString("orgname"), row.getString("orgid"));
            fields.add(row.getString("orgid"));
        }
        copy1.close();
        this.getQueryParam().getCustomParam().put("colMap", colMap);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])((DataType[])fields.stream().map(m -> DataType.StringType).toArray(StringType[]::new)));
        DataSet mapDataset = dataSource.copy();
        HashMap<Object, String> map = new HashMap<Object, String>();
        for (Row row : mapDataset) {
            String s = row.getString("orgid") + "#" + row.getString("cellnumber");
            String value = row.getString("value");
            map.put(s, value);
        }
        ArrayList<String> orgList = new ArrayList<String>(8);
        DataSet orgDatasetCopy = orgDataset.copy();
        for (Row row : orgDatasetCopy) {
            orgList.add(row.getString("orgid"));
        }
        Map<String, String> rowMap = this.getFilterRowMap(reportQueryParam);
        ArrayList<String[]> result = new ArrayList<String[]>(12);
        for (Map.Entry<String, String> entry : rowMap.entrySet()) {
            ArrayList<String> row = new ArrayList<String>(8);
            String itemName = entry.getValue();
            String key = entry.getKey();
            row.add(itemName);
            for (String orgId : orgList) {
                String s = orgId + "#" + entry.getKey();
                String value = (String)map.get(s);
                if ("yhmxb_jjkcbljff#yhmxb_jczl".equals(key)) {
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        value = "";
                    } else {
                        long id = Long.parseLong(value);
                        QFilter filter = new QFilter("id", "=", (Object)id);
                        DynamicObject object = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdefen_tree", (String)"number,projectname", (QFilter[])filter.toArray());
                        if (object != null) {
                            value = object.getString("number").concat("||").concat(object.getString("projectname"));
                        }
                    }
                }
                if (!("yhmxb_bnkxsyffyjjkcxmsl#yhmxb_xmsl".equals(key) || "yhmxb_jjkcbl#yhmxb_je".equals(key) || "yhmxb_jjkcbljff#yhmxb_jczl".equals(key))) {
                    value = value == null ? "0.00" : DataFormatUtils.formatMicrometer((String)value);
                }
                row.add(value == null ? "0.00" : value);
            }
            result.add(row.toArray(new String[0]));
        }
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    public Map<String, String> getFilterRowMap(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        boolean isNdsb = false;
        for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue() || !"date".equals(name = filterItemInfo.getPropName())) continue;
            Date date = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)((Date)filterItemInfo.getValue())));
            isNdsb = DateUtils.format((Date)date, (String)"yyyy-MM-dd").endsWith("12-31");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        for (Map.Entry<String, String> entry : totalmap.entrySet()) {
            String key = entry.getKey();
            if (isNdsb && "yhmxb_jjkcbl#yhmxb_je".equals(key) || !isNdsb && "yhmxb_jjkcbljff#yhmxb_jczl".equals(key)) continue;
            map.put(key, entry.getValue());
        }
        return map;
    }

    public DataSet genDataset(ReportQueryParam reportQueryParam) {
        DynamicObjectCollection declareMainTsd;
        List<Object> orgIds = new ArrayList(8);
        Date date = null;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List list = filterInfo.getFilterItems();
        block8: for (FilterItemInfo filterItemInfo : list) {
            String name;
            if (null == filterItemInfo || null == filterItemInfo.getValue()) continue;
            switch (name = filterItemInfo.getPropName()) {
                case "orgs": {
                    Object value = filterItemInfo.getValue();
                    if (value instanceof DynamicObjectCollection) {
                        Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                        orgIds = new ArrayList<Long>(groups.keySet());
                        break;
                    }
                    if (value instanceof DynamicObject) {
                        orgIds = Collections.singletonList(((DynamicObject)filterItemInfo.getValue()).getLong("id"));
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List orgs = (List)value;
                    if (!CollectionUtils.isNotEmpty((Collection)orgs)) continue block8;
                    List taxOrgIdsWithPerm = OrgServiceHelper.getOrgListHasPermissionAll();
                    orgIds = orgs.stream().filter(Objects::nonNull).filter(taxOrgIdsWithPerm::contains).map(m -> Long.parseLong(m.toString())).distinct().collect(Collectors.toList());
                    break;
                }
                case "date": {
                    date = DateUtils.trunc((Date)DateUtils.getLastDateOfMonth((Date)((Date)filterItemInfo.getValue())));
                    break;
                }
            }
        }
        QFilter declareMainFilter = new QFilter("templatetype", "=", (Object)"rdesd_yhmx").and(new QFilter("billstatus", "in", Arrays.asList("B", "C"))).and(new QFilter("skssqz", "=", (Object)date));
        if (!CollectionUtils.isEmpty(orgIds)) {
            declareMainFilter.and("org", "in", orgIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)(declareMainTsd = QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"id,org.id,org.number", (QFilter[])declareMainFilter.toArray(), (String)"org.number asc")))) {
            DataSet mainTsdDataSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_main_tsd", (String)"id,org.id orgid,org.name orgname,org.number orgnumber", (QFilter[])declareMainFilter.toArray(), null);
            List entryids = declareMainTsd.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
            QFilter entryidQ = new QFilter("entryid", "in", entryids);
            DataSet mainTsdDetailSet = QueryServiceHelper.queryDataSet((String)String.valueOf(System.currentTimeMillis()), (String)"tpo_declare_detail_tsd", (String)"entryid,cellnumber,dynrowno,index,value", (QFilter[])entryidQ.toArray(), (String)"cellnumber asc");
            return mainTsdDataSet.leftJoin(mainTsdDetailSet).on("id", "entryid").select(new String[]{"id", "orgid", "orgname", "orgnumber"}, new String[]{"cellnumber", "dynrowno", "index", "value"}).finish();
        }
        return null;
    }

    static {
        totalmap.put("yhmxb_bnkxsyffyjjkcxmsl#yhmxb_xmsl", ResManager.loadKDString((String)"\u672c\u5e74\u53ef\u4eab\u53d7\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u9879\u76ee\u6570\u91cf", (String)"YfjjRptQueryPlugin_0", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zzyfhzyfjzyf#yhmxb_je", ResManager.loadKDString((String)"\u4e00\u3001\u81ea\u4e3b\u7814\u53d1\u3001\u5408\u4f5c\u7814\u53d1\u3001\u96c6\u4e2d\u7814\u53d1\uff083+7+16+19+23+34\uff09", (String)"YfjjRptQueryPlugin_1", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yrrgfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e00\uff09\u4eba\u5458\u4eba\u5de5\u8d39\u7528\uff084+5+6\uff09", (String)"YfjjRptQueryPlugin_2", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zjcsyfhdrygzxj#yhmxb_je", ResManager.loadKDString((String)"1.\u76f4\u63a5\u4ece\u4e8b\u7814\u53d1\u6d3b\u52a8\u4eba\u5458\u5de5\u8d44\u85aa\u91d1", (String)"YfjjRptQueryPlugin_3", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zjcsyfhdrywxyj#yhmxb_je", ResManager.loadKDString((String)"2.\u76f4\u63a5\u4ece\u4e8b\u7814\u53d1\u6d3b\u52a8\u4eba\u5458\u4e94\u9669\u4e00\u91d1", (String)"YfjjRptQueryPlugin_4", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wpyfrydlwfy#yhmxb_je", ResManager.loadKDString((String)"3.\u5916\u8058\u7814\u53d1\u4eba\u5458\u7684\u52b3\u52a1\u8d39\u7528", (String)"YfjjRptQueryPlugin_5", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zjtrfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e8c\uff09\u76f4\u63a5\u6295\u5165\u8d39\u7528\uff088+9+10+11+12+13+14+15\uff09", (String)"YfjjRptQueryPlugin_6", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yfhdzjxhclfy#yhmxb_je", ResManager.loadKDString((String)"1.\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u6d88\u8017\u6750\u6599\u8d39\u7528", (String)"YfjjRptQueryPlugin_7", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yfhdzjxhrlfy#yhmxb_je", ResManager.loadKDString((String)"2.\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u6d88\u8017\u71c3\u6599\u8d39\u7528", (String)"YfjjRptQueryPlugin_8", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yfhdzjxhdlfy#yhmxb_je", ResManager.loadKDString((String)"3.\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u6d88\u8017\u52a8\u529b\u8d39\u7528", (String)"YfjjRptQueryPlugin_9", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyzjsyhcpszdmjgyzb#yhmxb_je", ResManager.loadKDString((String)"4.\u7528\u4e8e\u4e2d\u95f4\u8bd5\u9a8c\u548c\u4ea7\u54c1\u8bd5\u5236\u7684\u6a21\u5177\u3001\u5de5\u827a\u88c5\u5907\u5f00\u53d1\u53ca\u5236\u9020\u8d39", (String)"YfjjRptQueryPlugin_10", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yybgcgdzcdypyj#yhmxb_je", ResManager.loadKDString((String)"5.\u7528\u4e8e\u4e0d\u6784\u6210\u56fa\u5b9a\u8d44\u4ea7\u7684\u6837\u54c1\u3001\u6837\u673a\u53ca\u4e00\u822c\u6d4b\u8bd5\u624b\u6bb5\u8d2d\u7f6e\u8d39", (String)"YfjjRptQueryPlugin_11", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyszcpdjyf#yhmxb_je", ResManager.loadKDString((String)"6.\u7528\u4e8e\u8bd5\u5236\u4ea7\u54c1\u7684\u68c0\u9a8c\u8d39", (String)"YfjjRptQueryPlugin_12", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddyqsbdyxwh#yhmxb_je", ResManager.loadKDString((String)"7.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u4eea\u5668\u3001\u8bbe\u5907\u7684\u8fd0\u884c\u7ef4\u62a4\u3001\u8c03\u6574\u3001\u68c0\u9a8c\u3001\u7ef4\u4fee\u7b49\u8d39\u7528", (String)"YfjjRptQueryPlugin_13", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_tgjyzlfszrdyyyfhddyq#yhmxb_je", ResManager.loadKDString((String)"8.\u901a\u8fc7\u7ecf\u8425\u79df\u8d41\u65b9\u5f0f\u79df\u5165\u7684\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u4eea\u5668\u3001\u8bbe\u5907\u79df\u8d41\u8d39", (String)"YfjjRptQueryPlugin_14", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zzfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e09\uff09\u6298\u65e7\u8d39\u7528\uff0817+18\uff09", (String)"YfjjRptQueryPlugin_15", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddyqdzjf#yhmxb_je", ResManager.loadKDString((String)"1.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u4eea\u5668\u7684\u6298\u65e7\u8d39", (String)"YfjjRptQueryPlugin_16", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddsbdzjf#yhmxb_je", ResManager.loadKDString((String)"2.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u8bbe\u5907\u7684\u6298\u65e7\u8d39", (String)"YfjjRptQueryPlugin_17", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wxzccx#yhmxb_je", ResManager.loadKDString((String)"\uff08\u56db\uff09\u65e0\u5f62\u8d44\u4ea7\u644a\u9500\uff0820+21+22\uff09", (String)"YfjjRptQueryPlugin_18", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddrjdtxfy#yhmxb_je", ResManager.loadKDString((String)"1.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u8f6f\u4ef6\u7684\u644a\u9500\u8d39\u7528", (String)"YfjjRptQueryPlugin_19", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddzlqdtxfy#yhmxb_je", ResManager.loadKDString((String)"2.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u4e13\u5229\u6743\u7684\u644a\u9500\u8d39\u7528", (String)"YfjjRptQueryPlugin_20", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yyyfhddfzljs#yhmxb_je", ResManager.loadKDString((String)"3.\u7528\u4e8e\u7814\u53d1\u6d3b\u52a8\u7684\u975e\u4e13\u5229\u6280\u672f\uff08\u5305\u62ec\u8bb8\u53ef\u8bc1\u3001\u4e13\u6709\u6280\u672f\u3001\u8bbe\u8ba1\u548c\u8ba1\u7b97\u65b9\u6cd5\u7b49\uff09\u7684\u644a\u9500\u8d39\u7528", (String)"YfjjRptQueryPlugin_21", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_xcpsjfd#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e94\uff09\u65b0\u4ea7\u54c1\u8bbe\u8ba1\u8d39\u7b49\uff0824+25+26+27\uff09", (String)"YfjjRptQueryPlugin_22", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_xcpsjf#yhmxb_je", ResManager.loadKDString((String)"1.\u65b0\u4ea7\u54c1\u8bbe\u8ba1\u8d39", (String)"YfjjRptQueryPlugin_23", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_xgygczdf#yhmxb_je", ResManager.loadKDString((String)"2.\u65b0\u5de5\u827a\u89c4\u7a0b\u5236\u5b9a\u8d39", (String)"YfjjRptQueryPlugin_24", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_xyyzdlcsyf#yhmxb_je", ResManager.loadKDString((String)"3.\u65b0\u836f\u7814\u5236\u7684\u4e34\u5e8a\u8bd5\u9a8c\u8d39", (String)"YfjjRptQueryPlugin_25", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_ktkfjsdxcsyf#yhmxb_je", ResManager.loadKDString((String)"4.\u52d8\u63a2\u5f00\u53d1\u6280\u672f\u7684\u73b0\u573a\u8bd5\u9a8c\u8d39", (String)"YfjjRptQueryPlugin_26", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_qtxgfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u516d\uff09\u5176\u4ed6\u76f8\u5173\u8d39\u7528(29+30+31+32+33)", (String)"YfjjRptQueryPlugin_27", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jstszlfzlfyfgxkjyff#yhmxb_je", ResManager.loadKDString((String)"1.\u6280\u672f\u56fe\u4e66\u8d44\u6599\u8d39\u3001\u8d44\u6599\u7ffb\u8bd1\u8d39\u3001\u4e13\u5bb6\u54a8\u8be2\u8d39\u3001\u9ad8\u65b0\u79d1\u6280\u7814\u53d1\u4fdd\u9669\u8d39", (String)"YfjjRptQueryPlugin_28", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yfcgdjsfxpylz#yhmxb_je", ResManager.loadKDString((String)"2.\u7814\u53d1\u6210\u679c\u7684\u68c0\u7d22\u3001\u5206\u6790\u3001\u8bc4\u8bae\u3001\u8bba\u8bc1\u3001\u9274\u5b9a\u3001\u8bc4\u5ba1\u3001\u8bc4\u4f30\u3001\u9a8c\u6536\u8d39\u7528", (String)"YfjjRptQueryPlugin_29", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zscqdsqfzcfdlf#yhmxb_je", ResManager.loadKDString((String)"3.\u77e5\u8bc6\u4ea7\u6743\u7684\u7533\u8bf7\u8d39\u3001\u6ce8\u518c\u8d39\u3001\u4ee3\u7406\u8d39", (String)"YfjjRptQueryPlugin_30", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_zgflfbcylbxfbcylbxf#yhmxb_je", ResManager.loadKDString((String)"4.\u804c\u5de5\u798f\u5229\u8d39\u3001\u8865\u5145\u517b\u8001\u4fdd\u9669\u8d39\u3001\u8865\u5145\u533b\u7597\u4fdd\u9669\u8d39", (String)"YfjjRptQueryPlugin_31", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_clfhyf#yhmxb_je", ResManager.loadKDString((String)"5.\u5dee\u65c5\u8d39\u3001\u4f1a\u8bae\u8d39", (String)"YfjjRptQueryPlugin_32", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jxetzhdqtxgfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e03\uff09\u7ecf\u9650\u989d\u8c03\u6574\u540e\u7684\u5176\u4ed6\u76f8\u5173\u8d39\u7528", (String)"YfjjRptQueryPlugin_33", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wtyf#yhmxb_je", ResManager.loadKDString((String)"\u4e8c\u3001\u59d4\u6258\u7814\u53d1\uff0836+37+39\uff09", (String)"YfjjRptQueryPlugin_34", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wtjnjghgrjxyfhdsfsdfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e00\uff09\u59d4\u6258\u5883\u5185\u673a\u6784\u6216\u4e2a\u4eba\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u6240\u53d1\u751f\u7684\u8d39\u7528", (String)"YfjjRptQueryPlugin_35", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wtjwjgjxyfhdfsdfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e8c\uff09\u59d4\u6258\u5883\u5916\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u6240\u53d1\u751f\u7684\u8d39\u7528", (String)"YfjjRptQueryPlugin_36", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_qzyxjjkcdwtjwjg#yhmxb_je", ResManager.loadKDString((String)"    \u5176\u4e2d\uff1a\u5141\u8bb8\u52a0\u8ba1\u6263\u9664\u7684\u59d4\u6258\u5883\u5916\u673a\u6784\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u53d1\u751f\u7684\u8d39\u7528", (String)"YfjjRptQueryPlugin_37", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_wtjwgrjxyfhdfsdfy#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e09\uff09\u59d4\u6258\u5883\u5916\u4e2a\u4eba\u8fdb\u884c\u7814\u53d1\u6d3b\u52a8\u53d1\u751f\u7684\u8d39\u7528", (String)"YfjjRptQueryPlugin_38", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_ndyffyxj#yhmxb_je", ResManager.loadKDString((String)"\u4e09\u3001\u5e74\u5ea6\u7814\u53d1\u8d39\u7528\u5c0f\u8ba1(2+36\u00d780%+38)", (String)"YfjjRptQueryPlugin_39", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_bnfyhje#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e00\uff09\u672c\u5e74\u8d39\u7528\u5316\u91d1\u989d", (String)"YfjjRptQueryPlugin_40", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_bnzbhje#yhmxb_je", ResManager.loadKDString((String)"\uff08\u4e8c\uff09\u672c\u5e74\u8d44\u672c\u5316\u91d1\u989d", (String)"YfjjRptQueryPlugin_41", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_bnxcwxzctxe#yhmxb_je", ResManager.loadKDString((String)"\u56db\u3001\u672c\u5e74\u5f62\u6210\u65e0\u5f62\u8d44\u4ea7\u644a\u9500\u989d", (String)"YfjjRptQueryPlugin_42", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yqndxcwxzcbntxe#yhmxb_je", ResManager.loadKDString((String)"\u4e94\u3001\u4ee5\u524d\u5e74\u5ea6\u5f62\u6210\u65e0\u5f62\u8d44\u4ea7\u672c\u5e74\u644a\u9500\u989d", (String)"YfjjRptQueryPlugin_43", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yxkcdyffyhj#yhmxb_je", ResManager.loadKDString((String)"\u516d\u3001\u5141\u8bb8\u6263\u9664\u7684\u7814\u53d1\u8d39\u7528\u5408\u8ba1\uff0841+43+44\uff09", (String)"YfjjRptQueryPlugin_44", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jtssrbf#yhmxb_je", ResManager.loadKDString((String)"\u51cf\uff1a\u7279\u6b8a\u6536\u5165\u90e8\u5206", (String)"YfjjRptQueryPlugin_45", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_yxkcdyffydjtssrhdje#yhmxb_je", ResManager.loadKDString((String)"\u4e03\u3001\u5141\u8bb8\u6263\u9664\u7684\u7814\u53d1\u8d39\u7528\u62b5\u51cf\u7279\u6b8a\u6536\u5165\u540e\u7684\u91d1\u989d(45-46)", (String)"YfjjRptQueryPlugin_46", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jdnxsyfhdzjxccp#yhmxb_je", ResManager.loadKDString((String)"\u51cf\uff1a\u5f53\u5e74\u9500\u552e\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u5f62\u6210\u4ea7\u54c1\uff08\u5305\u62ec\u7ec4\u6210\u90e8\u5206\uff09\u5bf9\u5e94\u7684\u6750\u6599\u90e8\u5206", (String)"YfjjRptQueryPlugin_47", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jyqndxsyfhdzjxccp#yhmxb_je", ResManager.loadKDString((String)"\u51cf\uff1a\u4ee5\u524d\u5e74\u5ea6\u9500\u552e\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u5f62\u6210\u4ea7\u54c1\uff08\u5305\u62ec\u7ec4\u6210\u90e8\u5206\uff09\u5bf9\u5e94\u6750\u6599\u90e8\u5206\u7ed3\u8f6c\u91d1\u989d", (String)"YfjjRptQueryPlugin_48", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jjkcbl#yhmxb_je", ResManager.loadKDString((String)"\u516b\u3001\u52a0\u8ba1\u6263\u9664\u6bd4\u4f8b\uff08%\uff09", (String)"YfjjRptQueryPlugin_49", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_jjkcbljff#yhmxb_jczl", ResManager.loadKDString((String)"\u516b\u3001\u52a0\u8ba1\u6263\u9664\u6bd4\u4f8b\u53ca\u8ba1\u7b97\u65b9\u6cd5\uff08%\uff09", (String)"YfjjRptQueryPlugin_58", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_bnyxjjkcdyffyze#yhmxb_je", ResManager.loadKDString((String)"   \u672c\u5e74\u5141\u8bb8\u52a0\u8ba1\u6263\u9664\u7684\u7814\u53d1\u8d39\u7528\u603b\u989d\uff0847-48-49\uff09", (String)"YfjjRptQueryPlugin_50", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_qzdsjdyxjjkcdyffyje#yhmxb_je", ResManager.loadKDString((String)"       \u5176\u4e2d\uff1a\u7b2c\u56db\u5b63\u5ea6\u5141\u8bb8\u52a0\u8ba1\u6263\u9664\u7684\u7814\u53d1\u8d39\u7528\u91d1\u989d", (String)"YfjjRptQueryPlugin_51", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_qzqsjdyxjjkcdyffyje#yhmxb_je", ResManager.loadKDString((String)"       \u524d\u4e09\u5b63\u5ea6\u5141\u8bb8\u52a0\u8ba1\u6263\u9664\u7684\u7814\u53d1\u8d39\u7528\u91d1\u989d\uff08L1-L1.1\uff09", (String)"YfjjRptQueryPlugin_52", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_bnyffyjjkcze#yhmxb_je", ResManager.loadKDString((String)"\u4e5d\u3001\u672c\u5e74\u7814\u53d1\u8d39\u7528\u52a0\u8ba1\u6263\u9664\u603b\u989d\uff0847-48-49\uff09\u00d750", (String)"YfjjRptQueryPlugin_53", (String)"taxc-tctsa-report", (Object[])new Object[0]));
        totalmap.put("yhmxb_xsyfhdzjxccp#yhmxb_je", ResManager.loadKDString((String)"\u5341\u3001\u9500\u552e\u7814\u53d1\u6d3b\u52a8\u76f4\u63a5\u5f62\u6210\u4ea7\u54c1\uff08\u5305\u62ec\u7ec4\u6210\u90e8\u5206\uff09\u5bf9\u5e94\u6750\u6599\u90e8\u5206\u7ed3\u8f6c\u4ee5\u540e\u5e74\u5ea6\u6263\u51cf\u91d1\u989d\uff08\u5f5347-48-49\u22650\uff0c\u672c\u884c=0\uff1b\u5f5347-48-49<0\uff0c\u672c\u884c=47-48-49\u7684\u7edd\u5bf9\u503c)", (String)"YfjjRptQueryPlugin_57", (String)"taxc-tctsa-report", (Object[])new Object[0]));
    }
}

