/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.creditquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.taxc.tctsa.common.enums.CreditLevelEnum;
import kd.taxc.tctsa.common.enums.RangeLevelEnum;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.DateUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class CreditQueryRptQueryHelper {
    private static final String[] FIELDS = new String[]{"demoterange1", "creditlevel", "maincompany", "year", "ratingscore", "rangeyear", "rangelevel", "rangescore", "remark", "issumline", "levelmapp", "demotemapp"};
    private static final DataType[] DATATYPES = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType};
    private static RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATATYPES);

    public static DataSet collectDateSet(ReportQueryParam reportQueryParam, List<QFilter[]> qFiltersList, String rangeLevel, Boolean isDemote, String isOneOrg, Date queryYear, String className) {
        DynamicObjectCollection queryCollection = TaxcMainServiceHelper.queryDiy((QFilter[])qFiltersList.get(0), (String)TaxcMainServiceHelper.selectFields1);
        if (!(isDemote.booleanValue() || null != queryCollection && queryCollection.size() != 0)) {
            CreditQueryRptQueryHelper.setReportQueryParam(reportQueryParam);
            return CreditQueryRptQueryHelper.createEmptyDateSet(className);
        }
        DynamicObjectCollection compareCollection = new DynamicObjectCollection();
        if (isDemote.booleanValue()) {
            compareCollection = TaxcMainServiceHelper.queryDiy((QFilter[])qFiltersList.get(1), (String)TaxcMainServiceHelper.selectFields1);
        }
        List<Object[]> result = CreditQueryRptQueryHelper.getAllData(queryCollection, compareCollection, rangeLevel, isDemote, queryYear);
        CollectionInput inputs = new CollectionInput(rowMeta, result);
        DataSet dataSet = Algo.create((String)className).createDataSet(new Input[]{inputs});
        if (null != result && result.size() != 0 && !ResManager.loadKDString((String)"\u5168\u90e8\u5e74\u5ea6", (String)"CreditQueryRptQueryHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]).equals(isOneOrg)) {
            DataSet sumLine = CreditQueryRptQueryHelper.getSumLines(dataSet, isDemote != false ? "demotemapp" : "levelmapp", isDemote, className);
            dataSet = dataSet.union(sumLine);
        }
        if (ResManager.loadKDString((String)"\u5168\u90e8\u5e74\u5ea6", (String)"CreditQueryRptQueryHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]).equals(isOneOrg)) {
            return dataSet.orderBy(new String[]{"year desc", "issumline"});
        }
        return dataSet.orderBy(new String[]{isDemote != false ? "demotemapp" : "levelmapp", "issumline"});
    }

    private static void setReportQueryParam(ReportQueryParam reportQueryParam) {
        HashMap<String, String> isVisble = new HashMap<String, String>();
        isVisble.put("isVisble", "0");
        reportQueryParam.setCustomParam(isVisble);
    }

    private static DataSet getSumLines(DataSet dateSet, String dimension, Boolean isDemote, String className) {
        dateSet = dateSet.copy().orderBy(new String[]{dimension});
        ArrayList<Object[]> coll = new ArrayList<Object[]>();
        String currentDimension = null;
        int count = 0;
        for (Row row : dateSet) {
            if (CreditQueryRptQueryHelper.isSame(currentDimension, row, isDemote)) {
                currentDimension = row.getString(dimension);
                ++count;
                continue;
            }
            coll.add(CreditQueryRptQueryHelper.getSumLine(currentDimension, count, isDemote));
            count = 1;
            currentDimension = row.getString(dimension);
        }
        coll.add(CreditQueryRptQueryHelper.getSumLine(currentDimension, count, isDemote));
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }

    private static boolean isSame(String currentDimension, Row row, Boolean isDemote) {
        return isDemote.booleanValue() ? null == currentDimension || row.getString("demotemapp").equals(currentDimension) : null == currentDimension || row.getString("levelmapp").equals(currentDimension);
    }

    private static Object[] getSumLine(String dimension, int total, Boolean isDemote) {
        Object[] objectArray;
        if (isDemote.booleanValue()) {
            Object[] objectArray2 = new Object[12];
            objectArray2[0] = dimension;
            objectArray2[1] = total;
            objectArray2[2] = "";
            objectArray2[3] = "";
            objectArray2[4] = "";
            objectArray2[5] = "";
            objectArray2[6] = "";
            objectArray2[7] = "";
            objectArray2[8] = "";
            objectArray2[9] = "1";
            objectArray2[10] = dimension;
            objectArray = objectArray2;
            objectArray2[11] = dimension;
        } else {
            Object[] objectArray3 = new Object[12];
            objectArray3[0] = "";
            objectArray3[1] = CreditLevelEnum.getTaxNameByType((String)dimension);
            objectArray3[2] = total;
            objectArray3[3] = "";
            objectArray3[4] = "";
            objectArray3[5] = "";
            objectArray3[6] = "";
            objectArray3[7] = "";
            objectArray3[8] = "";
            objectArray3[9] = "1";
            objectArray3[10] = dimension;
            objectArray = objectArray3;
            objectArray3[11] = dimension;
        }
        return objectArray;
    }

    public static FilterInfo getCorrectFilterInfo(FilterInfo filterInfo) {
        if (ResManager.loadKDString((String)"\u5168\u90e8\u5e74\u5ea6", (String)"CreditQueryRptQueryHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]).equals(filterInfo.getFilterItem("yearfield1").getValue())) {
            filterInfo.getFilterItem("yearfield").setValue(null);
        }
        return filterInfo;
    }

    private static DataSet createEmptyDateSet(String className) {
        ArrayList coll = new ArrayList();
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)className).createDataSet(new Input[]{inputs});
    }

    private static List<Object[]> getAllData(DynamicObjectCollection queryCollection, DynamicObjectCollection compareCollection, String rangeLevel, Boolean isDemote, Date queryYear) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        if (queryCollection.size() == 0 && compareCollection.size() == 0) {
            return result;
        }
        if (isDemote.booleanValue()) {
            queryCollection.addAll((Collection)compareCollection);
        }
        Map<Long, List<DynamicObject>> queryGroups = queryCollection.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
        if (isDemote.booleanValue()) {
            for (Map.Entry<Long, List<DynamicObject>> entry : queryGroups.entrySet()) {
                String needCreditlevel;
                List<DynamicObject> dynamicObjects = entry.getValue();
                if (dynamicObjects != null && dynamicObjects.size() <= 1) {
                    if (dynamicObjects.get(0) == null) continue;
                    String isQueryData = "0";
                    if (DateUtils.getYearOfDate((Date)queryYear) == DateUtils.getYearOfDate((Date)dynamicObjects.get(0).getDate("taxcreditrating.year"))) {
                        isQueryData = "1";
                    }
                    Object[] objectArray = new Object[12];
                    objectArray[0] = "\u2014";
                    objectArray[1] = "1".equals(isQueryData) ? (StringUtil.isNotEmpty((CharSequence)dynamicObjects.get(0).getString("taxcreditrating.creditlevel")) ? dynamicObjects.get(0).getString("taxcreditrating.creditlevel") : "\u2014") : "\u2014";
                    objectArray[2] = dynamicObjects.get(0).getString("orgid.name");
                    objectArray[3] = DateUtils.getYearOfDate((Date)queryYear);
                    Object object = "1".equals(isQueryData) ? (dynamicObjects.get(0).getString("taxcreditrating.ratingscore") != null ? dynamicObjects.get(0).getString("taxcreditrating.ratingscore") : "\u2014") : (objectArray[4] = "\u2014");
                    Object object2 = "1".equals(isQueryData) ? Integer.valueOf(DateUtils.getYearOfDate((Date)DateUtils.addYear((Date)queryYear, (int)-1))) : (objectArray[5] = dynamicObjects.get(0).getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate((Date)dynamicObjects.get(0).getDate("taxcreditrating.year"))) : null);
                    Object object3 = "1".equals(isQueryData) ? "\u2014" : (objectArray[6] = StringUtil.isNotEmpty((CharSequence)dynamicObjects.get(0).getString("taxcreditrating.creditlevel")) ? dynamicObjects.get(0).getString("taxcreditrating.creditlevel") : "\u2014");
                    objectArray[7] = "1".equals(isQueryData) ? "\u2014" : (dynamicObjects.get(0).getString("taxcreditrating.ratingscore") != null ? dynamicObjects.get(0).getString("taxcreditrating.ratingscore") : "\u2014");
                    objectArray[8] = dynamicObjects.get(0).getString("taxcreditrating.remark");
                    objectArray[9] = "0";
                    objectArray[10] = StringUtil.isEmpty((CharSequence)dynamicObjects.get(0).getString("taxcreditrating.creditlevel")) ? "6" : CreditLevelEnum.getTaxNameByType((String)dynamicObjects.get(0).getString("taxcreditrating.creditlevel"));
                    objectArray[11] = "\u2014";
                    result.add(objectArray);
                    continue;
                }
                if (dynamicObjects == null || dynamicObjects.size() != 2 || !CreditQueryRptQueryHelper.matchRangeLevel(dynamicObjects.get(0).getString("taxcreditrating.creditlevel"), rangeLevel, dynamicObjects.get(1)) || !StringUtil.isNotEmpty((CharSequence)(needCreditlevel = CreditQueryRptQueryHelper.getRangeLevel(dynamicObjects.get(0).getString("taxcreditrating.creditlevel"), rangeLevel)))) continue;
                String[] levels = needCreditlevel.split("\\|");
                String creditlevels = levels[0];
                String[] creditlevels1 = creditlevels.split(",");
                String showlevels = levels[1];
                String[] showlevels1 = showlevels.split(",");
                int i = 0;
                String showLevel = "";
                for (String creditLevel : creditlevels1) {
                    if (creditLevel.equals(dynamicObjects.get(1).getString("taxcreditrating.creditlevel"))) {
                        showLevel = showlevels1[i];
                        break;
                    }
                    ++i;
                }
                result.add(new Object[]{StringUtil.isNotEmpty((CharSequence)showLevel) ? showLevel : "\u2014", StringUtil.isNotEmpty((CharSequence)dynamicObjects.get(0).getString("taxcreditrating.creditlevel")) ? dynamicObjects.get(0).getString("taxcreditrating.creditlevel") : "\u2014", dynamicObjects.get(0).getString("orgid.name"), dynamicObjects.get(0).getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate((Date)dynamicObjects.get(0).getDate("taxcreditrating.year"))) : null, dynamicObjects.get(0).getString("taxcreditrating.ratingscore") != null ? dynamicObjects.get(0).getString("taxcreditrating.ratingscore") : "\u2014", dynamicObjects.get(1).getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate((Date)dynamicObjects.get(1).getDate("taxcreditrating.year"))) : null, StringUtil.isNotEmpty((CharSequence)dynamicObjects.get(1).getString("taxcreditrating.creditlevel")) ? dynamicObjects.get(1).getString("taxcreditrating.creditlevel") : "\u2014", dynamicObjects.get(1).getString("taxcreditrating.ratingscore") != null ? dynamicObjects.get(1).getString("taxcreditrating.ratingscore") : "\u2014", dynamicObjects.get(1).getString("taxcreditrating.remark"), "0", StringUtil.isEmpty((CharSequence)dynamicObjects.get(1).getString("taxcreditrating.creditlevel")) ? "6" : CreditLevelEnum.getTaxNameByType((String)dynamicObjects.get(1).getString("taxcreditrating.creditlevel")), StringUtil.isNotEmpty((CharSequence)showLevel) ? showLevel : "\u2014"});
            }
        } else {
            for (DynamicObject obj : queryCollection) {
                if (obj.getDate("taxcreditrating.year") == null && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.ratingscore")) && StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.remark"))) continue;
                result.add(new Object[]{"", StringUtil.isNotEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? obj.getString("taxcreditrating.creditlevel") : "\u2014", obj.getString("orgid.name"), obj.getDate("taxcreditrating.year") != null ? Integer.valueOf(DateUtils.getYearOfDate((Date)obj.getDate("taxcreditrating.year"))) : null, obj.getString("taxcreditrating.ratingscore"), "", "", "", obj.getString("taxcreditrating.remark"), "0", StringUtil.isEmpty((CharSequence)obj.getString("taxcreditrating.creditlevel")) ? "6" : CreditLevelEnum.getTaxNameByType((String)obj.getString("taxcreditrating.creditlevel")), ""});
            }
        }
        return result;
    }

    private static boolean matchRangeLevel(String creditlevel, String rangeLevel, DynamicObject dynamicObject) {
        String needCreditlevel = CreditQueryRptQueryHelper.getRangeLevel(creditlevel, rangeLevel);
        if (StringUtil.isNotEmpty((CharSequence)needCreditlevel)) {
            String[] levels = needCreditlevel.split("\\|");
            String creditlevels = levels[0];
            if (StringUtil.isEmpty((CharSequence)creditlevel)) {
                return StringUtil.isNotEmpty((CharSequence)dynamicObject.getString("taxcreditrating.creditlevel")) && creditlevels.contains(dynamicObject.getString("taxcreditrating.creditlevel"));
            }
            return StringUtil.isEmpty((CharSequence)dynamicObject.getString("taxcreditrating.creditlevel")) || creditlevels.contains(dynamicObject.getString("taxcreditrating.creditlevel"));
        }
        return false;
    }

    private static String getRangeLevel(String creditlevel, String rangeLevel) {
        return RangeLevelEnum.getlevelsByRangeLevel((String)creditlevel, (String)rangeLevel);
    }

    public static List<QFilter[]> getFilter(FilterInfo filterInfo) {
        List list = filterInfo.getFilterItems();
        ArrayList<QFilter[]> qFilter1List = new ArrayList<QFilter[]>(8);
        Boolean isDEMOTEQUERY = false;
        ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>();
        ArrayList<QFilter> qFilters2 = new ArrayList<QFilter>();
        if (((Boolean)filterInfo.getFilterItem("demotequery").getValue()).booleanValue()) {
            isDEMOTEQUERY = true;
        }
        if (isDEMOTEQUERY.booleanValue()) {
            for (FilterItemInfo filter : list) {
                QFilter qFilter2;
                if (null == filter || null == filter.getValue()) continue;
                QFilter qFilter1 = CreditQueryRptQueryHelper.getFilterByName(filter, "yearfield");
                if (null != qFilter1) {
                    qFilters1.add(qFilter1);
                }
                if (null == (qFilter2 = CreditQueryRptQueryHelper.getFilterByName(filter, "compareyear"))) continue;
                qFilters2.add(qFilter2);
            }
        } else {
            for (FilterItemInfo filter : list) {
                QFilter qFilter1;
                if (null == filter || null == filter.getValue() || null == (qFilter1 = CreditQueryRptQueryHelper.getFilterByName(filter, "yearfield"))) continue;
                qFilters1.add(qFilter1);
            }
        }
        qFilter1List.add(qFilters1.toArray(new QFilter[qFilters1.size()]));
        qFilter1List.add(qFilters2.toArray(new QFilter[qFilters2.size()]));
        return qFilter1List;
    }

    private static QFilter getFilterByName(FilterItemInfo filterItemInfo, String changeDimension) {
        String name;
        QFilter qFilter = null;
        switch (name = filterItemInfo.getPropName()) {
            case "orgs": {
                Object value = filterItemInfo.getValue();
                if (value instanceof DynamicObjectCollection) {
                    Map<Long, List<DynamicObject>> groups = ((DynamicObjectCollection)value).stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
                    qFilter = new QFilter("orgid", "in", groups.keySet());
                    break;
                }
                if (!(value instanceof List) || ((List)value).size() == 0) break;
                qFilter = new QFilter("orgid", "in", (Object)((List)value).toArray());
                break;
            }
            case "yearfield": 
            case "compareyear": {
                if (!name.equals(changeDimension)) break;
                qFilter = new QFilter("taxcreditrating.year", ">=", (Object)DateUtils.getFirstDateOfYear((Date)((Date)filterItemInfo.getValue())));
                qFilter.and(new QFilter("taxcreditrating.year", "<=", (Object)DateUtils.getLastDateOfYear((Date)((Date)filterItemInfo.getValue()))));
                break;
            }
            case "creditlevel1": {
                String[] creditleveltypes = filterItemInfo.getString().split(",");
                qFilter = new QFilter("taxcreditrating.creditlevel", "in", Arrays.asList(creditleveltypes));
                break;
            }
            default: {
                return null;
            }
        }
        return qFilter;
    }
}

