/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.mq.consumer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessage;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.ProvistonTaxesMessage;
import kd.taxc.bdtaxr.common.mq.ProvistonTaxesMessageInfo;
import kd.taxc.bdtaxr.common.mq.oversea.MessageSceneType;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessage;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessageData;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaPayRefundMQMessage;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaPayRefundMQMessageData;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctsa.business.enums.TaxRefundMQEvent;
import kd.taxc.tctsa.common.entity.DeclareMQType;
import kd.taxc.tctsa.common.entity.LdtsWriteBackBean;
import kd.taxc.tctsa.common.entity.TjsjhwsWriteBackBean;
import kd.taxc.tctsa.common.entity.TjsjjtzjbWriteBackBean;
import kd.taxc.tctsa.common.entity.TsjsbWriteBackBean;
import kd.taxc.tctsa.common.json.JsonUtil;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.StringUtil;

public class TjsjbWriteBackConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(TjsjbWriteBackConsumer.class);
    private static final DeclareMQEvent[] NEED_WRITEBACK_EVENTS = new DeclareMQEvent[]{DeclareMQEvent.AUDIT, DeclareMQEvent.UNAUDIT, DeclareMQEvent.IMPORT, DeclareMQEvent.SAVE};
    private static final TaxRefundMQEvent[] LDTS_WRITEBACK_EVENTS = new TaxRefundMQEvent[]{TaxRefundMQEvent.DELETE, TaxRefundMQEvent.NEW, TaxRefundMQEvent.UPDATE};
    private static final String SJJT = "SJJT";

    public void onMessage(Object body, String messageId, boolean b, MessageAcker acker) {
        try {
            String topic = null;
            String msgBody = (String)body;
            logger.info("MQ message:" + msgBody);
            if (msgBody.contains(DeclareMQType.TAX_REFUND.name())) {
                LdtsWriteBackBean ldtsWriteBackBean = (LdtsWriteBackBean)SerializationUtils.fromJsonString((String)msgBody, LdtsWriteBackBean.class);
                String event = ldtsWriteBackBean.getEvent();
                topic = ldtsWriteBackBean.getTopic();
                if (StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.TAX_REFUND.name()) && Arrays.stream(LDTS_WRITEBACK_EVENTS).anyMatch(v -> StringUtil.equals((CharSequence)v.name(), (CharSequence)event))) {
                    TjsjbWriteBackConsumer.executeLdts(ldtsWriteBackBean);
                }
            } else if (msgBody.contains(MessageSceneType.OVERSEADRAFT.name()) || msgBody.contains(MessageSceneType.ACCRUALDRAFT.name())) {
                OverSeaDraftMQMessage mqMessage = (OverSeaDraftMQMessage)SerializationUtils.fromJsonString((String)msgBody, OverSeaDraftMQMessage.class);
                topic = mqMessage.getTopic();
                if (StringUtil.equals((CharSequence)topic, (CharSequence)MessageSceneType.OVERSEADRAFT.name())) {
                    if (EmptyCheckUtils.isNotEmpty((Object)mqMessage.getOverSeaDraftMQMessageData())) {
                        List collect = mqMessage.getOverSeaDraftMQMessageData().stream().map(this::buildTjsjhwsWriteBackBean).collect(Collectors.toList());
                        this.executeTjsjhws(JsonUtil.toJson(collect));
                    }
                } else if (StringUtil.equals((CharSequence)topic, (CharSequence)MessageSceneType.ACCRUALDRAFT.name()) && EmptyCheckUtils.isNotEmpty((Object)mqMessage.getOverSeaDraftMQMessageData())) {
                    List collect = mqMessage.getOverSeaDraftMQMessageData().stream().map(this::buildTjsjjtzjbWriteBackBean).collect(Collectors.toList());
                    this.executeTjsjjtzjb(JsonUtil.toJson(collect));
                }
            } else if (msgBody.contains(SJJT)) {
                ProvistonTaxesMessage mqMessage = (ProvistonTaxesMessage)SerializationUtils.fromJsonString((String)msgBody, ProvistonTaxesMessage.class);
                topic = mqMessage.getTopic();
                if (StringUtil.equals((CharSequence)topic, (CharSequence)SJJT) && EmptyCheckUtils.isNotEmpty((Object)mqMessage.getMessageInfos())) {
                    List collect = mqMessage.getMessageInfos().stream().map(this::buildTjsjjtzjbWriteBackBean).collect(Collectors.toList());
                    this.executeTjsjjtzjb(JsonUtil.toJson(collect));
                }
            } else if (msgBody.contains(MessageSceneType.OVERSEAPAYFUND.name())) {
                OverSeaPayRefundMQMessage mqMessage = (OverSeaPayRefundMQMessage)SerializationUtils.fromJsonString((String)msgBody, OverSeaPayRefundMQMessage.class);
                topic = mqMessage.getTopic();
                if (StringUtil.equals((CharSequence)topic, (CharSequence)MessageSceneType.OVERSEAPAYFUND.name()) && EmptyCheckUtils.isNotEmpty((Object)mqMessage.getOverSeaPayRefundMQMessageData())) {
                    List collect = mqMessage.getOverSeaPayRefundMQMessageData().stream().map(this::buildTjsjhwsWriteBackBean).collect(Collectors.toList());
                    this.executeTjsjhws(JsonUtil.toJson(collect));
                }
            } else {
                DeclareMQMessage declareMQMessage = (DeclareMQMessage)SerializationUtils.fromJsonString((String)msgBody, DeclareMQMessage.class);
                String event = declareMQMessage.getEvent();
                topic = declareMQMessage.getTopic();
                if ((StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.DECLARE.name()) && Arrays.stream(NEED_WRITEBACK_EVENTS).anyMatch(v -> StringUtil.equals((CharSequence)v.name(), (CharSequence)event)) || StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.PAY.name()) || "CANCELPAY".equalsIgnoreCase(event) || "PAY".equalsIgnoreCase(event)) && EmptyCheckUtils.isNotEmpty((Object)declareMQMessage.getData())) {
                    List collect = declareMQMessage.getData().stream().map(StringUtil.equals((CharSequence)topic, (CharSequence)DeclareMQType.PAY.name()) ? this::buildPayTsjsbWriteBackBean : this::buildTsjsbWriteBackBean).collect(Collectors.toList());
                    TjsjbWriteBackConsumer.execute(JsonUtil.toJson(collect), msgBody);
                }
            }
            acker.ack(messageId);
        }
        catch (Throwable e) {
            boolean discard = e instanceof IOException;
            if (discard) {
                acker.discard(messageId);
            }
            acker.deny(messageId);
        }
    }

    private TjsjjtzjbWriteBackBean buildTjsjjtzjbWriteBackBean(Object v) {
        if (v instanceof OverSeaDraftMQMessageData) {
            return new TjsjjtzjbWriteBackBean(((OverSeaDraftMQMessageData)v).getBillNo(), ((OverSeaDraftMQMessageData)v).getOrg(), ((OverSeaDraftMQMessageData)v).getOrg(), ((OverSeaDraftMQMessageData)v).getTaxationsys(), ((OverSeaDraftMQMessageData)v).getTaxType(), ((OverSeaDraftMQMessageData)v).getTaxareagroup(), ((OverSeaDraftMQMessageData)v).getTaxationsys(), ((OverSeaDraftMQMessageData)v).getSkssqq(), ((OverSeaDraftMQMessageData)v).getSkssqz(), ((OverSeaDraftMQMessageData)v).getCurrency(), null, null, "2", null, ((OverSeaDraftMQMessageData)v).getId(), ((OverSeaDraftMQMessageData)v).getBillStatus(), ((OverSeaDraftMQMessageData)v).getDataType(), ((OverSeaDraftMQMessageData)v).getEntityName());
        }
        if (v instanceof ProvistonTaxesMessageInfo) {
            return new TjsjjtzjbWriteBackBean(((ProvistonTaxesMessageInfo)v).getBillno(), ((ProvistonTaxesMessageInfo)v).getTaxorg(), ((ProvistonTaxesMessageInfo)v).getAccountorg(), ((ProvistonTaxesMessageInfo)v).getTaxsystem(), ((ProvistonTaxesMessageInfo)v).getTaxtype(), ((ProvistonTaxesMessageInfo)v).getTaxarea(), ((ProvistonTaxesMessageInfo)v).getProvistonitem(), ((ProvistonTaxesMessageInfo)v).getStartdate(), ((ProvistonTaxesMessageInfo)v).getEnddate(), ((ProvistonTaxesMessageInfo)v).getCoins(), ((ProvistonTaxesMessageInfo)v).getTotal(), ((ProvistonTaxesMessageInfo)v).getAccountsettype(), "3", null, ((ProvistonTaxesMessageInfo)v).getId(), ((ProvistonTaxesMessageInfo)v).getBillstatus(), ((ProvistonTaxesMessageInfo)v).getSourcedrafttype(), "itp_proviston_taxes");
        }
        return null;
    }

    private TjsjhwsWriteBackBean buildTjsjhwsWriteBackBean(Object v) {
        if (v instanceof OverSeaDraftMQMessageData) {
            return new TjsjhwsWriteBackBean(((OverSeaDraftMQMessageData)v).getBillNo(), ((OverSeaDraftMQMessageData)v).getOrg(), ((OverSeaDraftMQMessageData)v).getTaxationsys(), ((OverSeaDraftMQMessageData)v).getTaxType(), ((OverSeaDraftMQMessageData)v).getTaxareagroup(), ((OverSeaDraftMQMessageData)v).getSkssqq(), ((OverSeaDraftMQMessageData)v).getSkssqz(), "4", ((OverSeaDraftMQMessageData)v).getType(), ((OverSeaDraftMQMessageData)v).getId(), ((OverSeaDraftMQMessageData)v).getBillStatus(), ((OverSeaDraftMQMessageData)v).getDataType());
        }
        if (v instanceof OverSeaPayRefundMQMessageData) {
            return new TjsjhwsWriteBackBean(((OverSeaPayRefundMQMessageData)v).getBillNo(), ((OverSeaPayRefundMQMessageData)v).getOrg(), ((OverSeaPayRefundMQMessageData)v).getTaxationsys(), ((OverSeaPayRefundMQMessageData)v).getTaxType(), ((OverSeaPayRefundMQMessageData)v).getTaxareagroup(), ((OverSeaPayRefundMQMessageData)v).getSkssqq(), ((OverSeaPayRefundMQMessageData)v).getSkssqz(), "4", null, ((OverSeaPayRefundMQMessageData)v).getId(), ((OverSeaPayRefundMQMessageData)v).getBillStatus(), ((OverSeaPayRefundMQMessageData)v).getDataType());
        }
        return null;
    }

    public String getRouteKey() {
        return null;
    }

    private TsjsbWriteBackBean buildTsjsbWriteBackBean(DeclareMQMessageData v) {
        return new TsjsbWriteBackBean(DateUtils.getDayFirst((Date)DateUtils.stringToDate2((String)v.getSkssqq())), DateUtils.getDayFirst((Date)DateUtils.stringToDate2((String)v.getSkssqz())), v.getBusinessSource(), v.getDeclareType(), v.getOrg(), v.getTaxType(), Long.valueOf(Long.parseLong(v.getSbbid())), v.getBillStatus(), v.getDataType(), v.getBillNo(), v.getSjje(), v.getPaydate(), v.getSerialno(), v.getEntityName());
    }

    private static void execute(String data, String msgBody) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)"TjsjbWriteBack", (String)"executorTjsjbWriteBack", (Object[])new Object[]{data, msgBody});
    }

    private static void executeLdts(LdtsWriteBackBean ldtsWriteBackBean) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)"LdtsWriteBack", (String)"executorLdtsWriteBack", (Object[])new Object[]{ldtsWriteBackBean});
    }

    private void executeTjsjhws(String data) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)"TjsjbWriteBack", (String)"executorTjsjhwsWriteBack", (Object[])new Object[]{data});
    }

    private void executeTjsjjtzjb(String data) {
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)"TjsjbWriteBack", (String)"executorTjsjjtzjbWriteBack", (Object[])new Object[]{data});
    }

    private TsjsbWriteBackBean buildPayTsjsbWriteBackBean(DeclareMQMessageData v) {
        return new TsjsbWriteBackBean(DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)v.getStartDate())), DateUtils.getDayFirst((Date)DateUtils.stringToDate((String)v.getEndDate())), v.getBusinessSource(), v.getDeclareType(), v.getOrg(), v.getTaxType(), Long.valueOf(Long.parseLong(v.getSbbid())), v.getBillStatus(), v.getDataType(), v.getBillNo(), v.getSjje(), v.getPaydate(), v.getSerialno(), v.getEntityName());
    }
}

