/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.reportitems;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.taxc.tctsa.common.enums.FillingTypeEnum;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.DateUtils;

public class EnterpriseFillQueryImportHelper {
    private static Log logger = LogFactory.getLog(EnterpriseFillQueryImportHelper.class);
    private static final List<Integer> SKSSQQMONTHS = Arrays.asList(1, 4, 7, 10);
    private static final List<Integer> HALFMONTHS = Arrays.asList(1, 7);
    private static final String NUMBER = "number";
    private static final String AMOUNT = "amount";
    private static final String SXCONTENT = "sxcontent";
    private static final String SYSTEMNAME = "taxc-tctsa-business";

    public static void setFilter(JSONObject obj, DynamicObject resultObj) {
        obj.put("billstatus", (Object)"B");
        obj.put("datasource", (Object)"0");
        obj.put("name", resultObj.get("name"));
        HashMap<String, Object> taxtypeMap = new HashMap<String, Object>();
        taxtypeMap.put("importprop", NUMBER);
        taxtypeMap.put(NUMBER, resultObj.get("taxtype.number"));
        taxtypeMap.put("name", resultObj.get("taxtype.name"));
        obj.put("taxtype", taxtypeMap);
        obj.put("description", resultObj.get("description"));
    }

    public static boolean checkTianbao(JSONObject obj, ImportBillData data, ImportLogger logger, String fillingtype) {
        ArrayList<String> tianbaoList = new ArrayList<String>(3);
        tianbaoList.add(obj.getString(AMOUNT));
        tianbaoList.add(obj.getString("decimal"));
        tianbaoList.add(obj.getString(SXCONTENT));
        Long count = tianbaoList.stream().filter(v -> !StringUtils.isEmpty((Object)v)).count();
        if (count == 0L) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u586b\u62a5\u4e8b\u9879\u5fc5\u987b\u7ef4\u62a4\u586b\u62a5\u91d1\u989d\u3001\u586b\u62a5\u6570\u503c\u3001\u586b\u62a5\u6587\u672c\u5176\u4e2d\u4e00\u9879\u3002", (String)"EnterpriseFillQueryImportHelper_0", (String)SYSTEMNAME, (Object[])new Object[0])).fail();
            return false;
        }
        if (count > 1L || !FillingTypeEnum.checkFillingType((String)fillingtype, (JSONObject)obj)) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u586b\u62a5\u4e8b\u9879%s\uff0c\u586b\u62a5\u7c7b\u578b\u7ef4\u62a4\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"EnterpriseFillQueryImportHelper_1", (String)SYSTEMNAME, (Object[])new Object[]{obj.get((Object)NUMBER)})).fail();
            return false;
        }
        return true;
    }

    public static boolean checkOrgAndExist(JSONObject obj, ImportBillData data, ImportLogger logger, Map<String, List<DynamicObject>> assignMap, Set<String> orgSet) {
        JSONObject json = (JSONObject)obj.get((Object)"org");
        StringBuilder mapkey = new StringBuilder();
        mapkey.append(obj.get((Object)NUMBER));
        mapkey.append("_");
        mapkey.append(json.get((Object)NUMBER));
        if (json.get((Object)NUMBER) != null && !orgSet.contains(json.get((Object)NUMBER))) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5%s\u7ec4\u7ec7\u4fe1\u606f\uff0c\u7ec4\u7ec7\u662f\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u7eb3\u7a0e\u4e3b\u4f53\u53ef\u7528\u4e14\u5ba1\u6838\uff0c\u4e14\u8be5\u7528\u6237\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"EnterpriseFillQueryImportHelper_2", (String)SYSTEMNAME, (Object[])new Object[]{json.get((Object)NUMBER)})).fail();
            return false;
        }
        boolean riskNumberFlag = false;
        if (!assignMap.containsKey(mapkey.toString())) {
            logger.log(Integer.valueOf(data.getStartIndex()), String.format(ResManager.loadKDString((String)"%1$s\u7a0e\u52a1\u7ec4\u7ec7\u6ca1\u6709%2$s\u586b\u62a5\u4e8b\u9879\uff0c\u8bf7\u5148\u5206\u914d\u56fa\u5b9a\u586b\u62a5\u9879\u3002", (String)"EnterpriseFillQueryImportHelper_3", (String)SYSTEMNAME, (Object[])new Object[0]), json.get((Object)NUMBER), obj.get((Object)NUMBER))).fail();
            return false;
        }
        for (DynamicObject dynamicObject : assignMap.get(mapkey.toString())) {
            if (!"1".equals(dynamicObject.get("planentity.status"))) continue;
            riskNumberFlag = true;
            break;
        }
        if (!riskNumberFlag) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u56fa\u5b9a\u4e8b\u9879\u586b\u62a5\u5206\u914d\u65b9\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u518d\u5f15\u5165\u3002", (String)"EnterpriseFillQueryImportHelper_4", (String)SYSTEMNAME, (Object[])new Object[0])).fail();
            return false;
        }
        return true;
    }

    public static boolean checkPeriodAndItem(JSONObject obj, ImportBillData data, ImportLogger logger, Map<String, List<DynamicObject>> moreObjMap) {
        List<DynamicObject> resultObjcol = moreObjMap.get(obj.getString(NUMBER));
        if (CollectionUtils.isEmpty(resultObjcol)) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u6ca1\u6709\u586b\u62a5\u4e8b\u9879%s\uff0c\u8bf7\u5148\u8bbe\u7f6e\u56fa\u5b9a\u586b\u62a5\u9879\u3002", (String)"EnterpriseFillQueryImportHelper_5", (String)SYSTEMNAME, (Object[])new Object[]{obj.get((Object)NUMBER)})).fail();
            return false;
        }
        DynamicObject resultObj = resultObjcol.get(0);
        if ("0".equals(resultObj.get("enable"))) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u586b\u62a5\u4e8b\u9879%s\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5f15\u5165\u586b\u62a5\u3002", (String)"EnterpriseFillQueryImportHelper_6", (String)SYSTEMNAME, (Object[])new Object[]{obj.get((Object)NUMBER)})).fail();
            return false;
        }
        if (!resultObj.get("period").equals(obj.get((Object)"fillperiod"))) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u586b\u62a5\u4e8b\u9879\u201c%s\u201d\u5f55\u5165\u7684\u586b\u62a5\u5468\u671f\u4e0e\u8bbe\u7f6e\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"EnterpriseFillQueryImportHelper_7", (String)SYSTEMNAME, (Object[])new Object[]{obj.get((Object)NUMBER)})).fail();
            return false;
        }
        boolean dataFlag = EnterpriseFillQueryImportHelper.checkData(obj);
        if (!dataFlag) {
            logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u586b\u62a5\u6240\u5c5e\u671f\u8d77\u3001\u6b62\u4e0e\u586b\u62a5\u5468\u671f\u4e0d\u7b26\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"EnterpriseFillQueryImportHelper_8", (String)SYSTEMNAME, (Object[])new Object[0])).fail();
            return false;
        }
        if (!EnterpriseFillQueryImportHelper.checkTianbao(obj, data, logger, resultObj.getString("fillingtype"))) {
            return false;
        }
        EnterpriseFillQueryImportHelper.setFilter(obj, resultObj);
        return true;
    }

    public static String checkField(JSONObject obj) {
        try {
            if (obj.get((Object)AMOUNT) != null) {
                BigDecimalUtil.checkPrecision((BigDecimal)obj.getBigDecimal(AMOUNT), (Integer)13, (Integer)2);
            }
        }
        catch (Exception e) {
            logger.error("\u586b\u62a5\u91d1\u989d\u7cbe\u5ea6\u9519\u8bef\uff0815\uff0c2\uff09", (Throwable)e);
            return ResManager.loadKDString((String)"\u201c\u5b57\u6bb5\u201d\u586b\u62a5\u91d1\u989d\u7684\u503c%s\u683c\u5f0f\u4e0d\u6b63\u786e,\u8981\u6c42\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e13\u4f4d,\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u5927\u4e8e2\u4f4d", (String)"EnterpriseFillQueryImportHelper_9", (String)SYSTEMNAME, (Object[])new Object[]{obj.get((Object)AMOUNT)});
        }
        return null;
    }

    private static boolean checkData(JSONObject obj) {
        Date skssqz = DateUtils.stringToDate((String)obj.getString("skssqz"));
        Date skssqq = DateUtils.stringToDate((String)obj.getString("skssqq"));
        if (null != obj.get((Object)"skssqq") && null != obj.get((Object)"skssqz")) {
            int day2;
            int day = DateUtils.getDayOfDate((Date)skssqq);
            if (day != 1) {
                return false;
            }
            Date lastDate = DateUtils.getLastDateOfMonth((Date)skssqz);
            int day1 = DateUtils.getDayOfDate((Date)skssqz);
            if (day1 != (day2 = DateUtils.getDayOfDate((Date)lastDate))) {
                return false;
            }
        }
        return EnterpriseFillQueryImportHelper.checkSSQ((String)obj.get((Object)"fillperiod"), skssqz, skssqq);
    }

    private static boolean checkSSQ(String fillperiod, Date skssqz, Date skssqq) {
        int month = DateUtils.getMonthDiff((Date)skssqz, (Date)skssqq);
        int startMonth = DateUtils.getMonthOfDate((Date)skssqq);
        switch (fillperiod) {
            case "1": {
                if (month == 0) break;
                return false;
            }
            case "2": {
                if (month != 2) {
                    return false;
                }
                if (SKSSQQMONTHS.contains(startMonth)) break;
                return false;
            }
            case "3": {
                if (month != 5) {
                    return false;
                }
                if (HALFMONTHS.contains(startMonth)) break;
                return false;
            }
            case "4": {
                if (month != 11) {
                    return false;
                }
                if (startMonth == 1) break;
                return false;
            }
        }
        return true;
    }
}

