/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctsa.business.singleorg;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.tctsa.business.tjsjb.TjsjbBusiness;
import kd.taxc.tctsa.common.entity.CockpitTaxData;
import kd.taxc.tctsa.common.enums.TctsaSysTaxTypeEnum;
import kd.taxc.tctsa.common.helper.LevytypeHelper;
import kd.taxc.tctsa.common.helper.TaxcMainServiceHelper;
import kd.taxc.tctsa.common.util.BigDecimalUtil;
import kd.taxc.tctsa.common.util.EmptyCheckUtils;
import kd.taxc.tctsa.common.util.OrgUtils;

public class SingleOrgTaxstatiticsHelper {
    private static String CUSTOM_CONTROL = "customcontrolap";

    public static List<Long> getSubOrgIds(Long orgid) {
        List<Long> orgList = Collections.singletonList(orgid);
        return OrgUnitServiceHelper.getAllSubordinateOrgs((String)OrgFuncEnum.TAX.getNumber(), orgList, (boolean)true);
    }

    public static Map getEntity(Long orgid, IFormView view) {
        HashMap<String, Boolean> noticeMap = new HashMap<String, Boolean>();
        DynamicObject taxmain = TaxcMainServiceHelper.getTaxcMainByMore((Long)orgid);
        if (taxmain == null) {
            String orgname = OrgUtils.getOrgNameById((String)String.valueOf(orgid));
            noticeMap.put("notice", false);
            view.setVisible(Boolean.FALSE, new String[]{"pointlinechartap", "histogramchartap", "querydetails", "flexpanelap1"});
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u57fa\u7840\u8d44\u6599-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7a0e\u52a1\u4fe1\u606f\u7ef4\u62a4\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011\u4fe1\u606f", (String)"SingleOrgTaxstatiticsHelper_0", (String)"taxc-tctsa-business", (Object[])new Object[0]), orgname));
            return noticeMap;
        }
        Boolean isentity = taxmain.getBoolean("taxorg.istaxpayer");
        isentity = EmptyCheckUtils.isEmpty((Object)isentity) ? Boolean.TRUE : isentity;
        noticeMap.put("isentity", isentity);
        return noticeMap;
    }

    public static void initCustomControlap(Date startDate, Date endDate, List<Long> finalTypeList, List<Long> orgs, IPageCache pagecacheInput, IFormView view) {
        QFilter qFilter = SingleOrgTaxstatiticsHelper.getQFilter(startDate, endDate);
        QFilter typeFilter = new QFilter("taxtype", "in", finalTypeList);
        QFilter orgsFilter = new QFilter("org", "in", orgs);
        qFilter = qFilter.and(typeFilter);
        qFilter.and(orgsFilter);
        qFilter.and("taxationsys", "=", (Object)1L).and(LevytypeHelper.getLevytype());
        DynamicObjectCollection resultCollection = TjsjbBusiness.queryTjsjbData(Collections.singletonList(qFilter), "id,org,skssqq,skssqz,taxtype,bqybtse,jmse");
        Map<Long, List<DynamicObject>> typeGroups = resultCollection.stream().collect(Collectors.groupingBy(s -> s.getLong("taxtype")));
        BigDecimal tempTaxTypeNsTotal = BigDecimal.ZERO;
        BigDecimal tempTaxTypeJMTotal = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        BigDecimal jmtaxTotal = BigDecimal.ZERO;
        ArrayList<CockpitTaxData> allTaxDataList = new ArrayList<CockpitTaxData>(32);
        for (long type : finalTypeList) {
            tempTaxTypeNsTotal = ((List)typeGroups.getOrDefault(type, new ArrayList())).stream().map(s -> s.getBigDecimal("bqybtse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            tempTaxTypeJMTotal = ((List)typeGroups.getOrDefault(type, new ArrayList())).stream().map(s -> s.getBigDecimal("jmse")).reduce(BigDecimal.ZERO, BigDecimal::add);
            allTaxDataList.add(new CockpitTaxData(type, TctsaSysTaxTypeEnum.getTaxNameByType((long)type), tempTaxTypeNsTotal, tempTaxTypeJMTotal));
            taxTotal = BigDecimalUtil.addObject((Object)tempTaxTypeNsTotal, (Object)taxTotal);
            jmtaxTotal = BigDecimalUtil.addObject((Object)tempTaxTypeJMTotal, (Object)jmtaxTotal);
            tempTaxTypeNsTotal = BigDecimal.ZERO;
            tempTaxTypeJMTotal = BigDecimal.ZERO;
        }
        Map<Long, BigDecimal> nsCollectMap = allTaxDataList.stream().collect(Collectors.groupingBy(v -> v.getTypeId(), Collectors.reducing(BigDecimal.ZERO, CockpitTaxData::getAmount, BigDecimal::add)));
        Map<Long, BigDecimal> jmCollectMap = allTaxDataList.stream().collect(Collectors.groupingBy(v -> v.getTypeId(), Collectors.reducing(BigDecimal.ZERO, CockpitTaxData::getJmAmount, BigDecimal::add)));
        ArrayList<HashMap> objList = new ArrayList<HashMap>();
        HashMap pkids = new HashMap(64);
        for (Map.Entry<Long, BigDecimal> entry : nsCollectMap.entrySet()) {
            if (entry.getValue().compareTo(BigDecimal.ZERO) == 0 && jmCollectMap.get(entry.getKey()).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal nsratio = BigDecimalUtil.divideObject((Object)entry.getValue(), (Object)taxTotal, (int)4, (int)4);
            if (nsratio == null) {
                nsratio = BigDecimal.ZERO;
            }
            nsratio = nsratio.multiply(new BigDecimal(100));
            BigDecimal jmratio = BigDecimalUtil.divideObject((Object)jmCollectMap.get(entry.getKey()), (Object)jmtaxTotal, (int)4, (int)4);
            if (jmratio == null) {
                jmratio = BigDecimal.ZERO;
            }
            jmratio = jmratio.multiply(new BigDecimal(100));
            objList.add(SingleOrgTaxstatiticsHelper.setDatatoCustom(entry.getValue(), jmCollectMap.get(entry.getKey()), TctsaSysTaxTypeEnum.getTaxNameByType((long)entry.getKey()), entry.getKey(), "#FFC53D", "#40A9FF", nsratio, jmratio));
            List typeList = ((List)typeGroups.getOrDefault(entry.getKey(), new ArrayList())).stream().map(s -> s.getLong("id")).collect(Collectors.toList());
            pkids.put(entry.getKey(), typeList);
        }
        Label taxTotal1 = (Label)view.getControl("labelap2");
        taxTotal1.setText(String.valueOf(taxTotal.divide(BigDecimal.valueOf(10000L), 2, RoundingMode.HALF_UP)));
        pagecacheInput.put("pkidscache", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
        CustomControl control = (CustomControl)view.getControl(CUSTOM_CONTROL);
        control.release();
        HashMap<String, ArrayList<HashMap>> map = new HashMap<String, ArrayList<HashMap>>(16);
        map.put("data", objList);
        control.setData(map);
    }

    private static HashMap setDatatoCustom(BigDecimal zzsTaxTotal, BigDecimal zzsReductTotal, String taxname, long taxtype, String nszecolor, String jmsecolor, BigDecimal nsratio, BigDecimal jmratio) {
        HashMap<String, Object> sbData = new HashMap<String, Object>();
        HashMap<String, String> colorData = new HashMap<String, String>();
        colorData.put("nszecolor", nszecolor);
        colorData.put("jmsecolor", jmsecolor);
        sbData.put("nsze", zzsTaxTotal.divide(new BigDecimal(10000)).setScale(2, 4));
        sbData.put("jmse", zzsReductTotal.divide(new BigDecimal(10000)).setScale(2, 4));
        sbData.put("taxname", taxname);
        sbData.put("taxtype", taxtype + "");
        sbData.put("nsratio", BigDecimalUtil.format((Object)nsratio, (String)"0.00#") + "%");
        sbData.put("jmratio", BigDecimalUtil.format((Object)jmratio, (String)"0.00#") + "%");
        sbData.put("itemStyle", colorData);
        return sbData;
    }

    private static QFilter getQFilter(Date startdate, Date enddate) {
        QFilter qFilter = new QFilter("skssqq", ">=", (Object)startdate);
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u4e0d\u6b63\u786e\u3002", (String)"SingleOrgTaxstatiticsHelper_1", (String)"taxc-tctsa-business", (Object[])new Object[0]));
        }
        QFilter endFilter = new QFilter("skssqz", "<=", (Object)enddate);
        qFilter.and(endFilter);
        return qFilter;
    }

    public static void openTjsjReport(List<Long> pkids, IFormView view) {
        if (EmptyCheckUtils.isEmpty(pkids)) {
            return;
        }
        ReportShowParameter reportShowParameter = new ReportShowParameter();
        reportShowParameter.setPageId(view.getPageId() + "abcd");
        reportShowParameter.setFormId("tctsa_statistics_detail");
        reportShowParameter.setCustomParam("ids", pkids);
        reportShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)reportShowParameter);
    }
}

